/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.nimbus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.storm.Config;
import org.apache.storm.generated.ExecutorInfo;
import org.apache.storm.generated.SupervisorWorkerHeartbeat;
import org.apache.storm.generated.SupervisorWorkerHeartbeats;
import org.apache.storm.thrift.TException;
import org.apache.storm.thrift.transport.TTransportException;
import org.apache.storm.utils.NimbusClient;
import org.apache.storm.utils.Utils;

public class NimbusHeartbeatsPressureTest {
    private static String NIMBUS_HOST = "localhost";
    private static int NIMBUS_PORT = 6627;
    private static int THREADS_NUM = 50;
    private static int THREAD_SUBMIT_NUM = 1;
    private static int MOCKED_STORM_NUM = 5000;
    private static volatile boolean[] readyFlags = new boolean[THREADS_NUM];
    private static Random rand = new Random(47L);
    private static List<double[]> totalCostTimesBook = new ArrayList<double[]>();

    private static Config initializedConfig() {
        Config conf = new Config();
        conf.putAll(Utils.readDefaultConfig());
        ArrayList<String> nimbusSeeds = new ArrayList<String>();
        nimbusSeeds.add(NIMBUS_HOST);
        conf.put((Object)"nimbus.seeds", nimbusSeeds);
        conf.put((Object)"nimbus.thrift.port", (Object)NIMBUS_PORT);
        return conf;
    }

    public static void testMaxThroughput() {
        ExecutorService service = Executors.newFixedThreadPool(THREADS_NUM);
        long submitStart = System.currentTimeMillis();
        for (int i = 0; i < THREADS_NUM; ++i) {
            service.submit(new HeartbeatSendTask(i, THREAD_SUBMIT_NUM));
        }
        long submitEnd = System.currentTimeMillis();
        NimbusHeartbeatsPressureTest.println(THREADS_NUM + " tasks, " + THREAD_SUBMIT_NUM * THREADS_NUM + " submit cost " + (double)(submitEnd - submitStart) / 1000.0 + "seconds");
        long totalStart = System.currentTimeMillis();
        while (!NimbusHeartbeatsPressureTest.allTasksReady()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        long totalEnd = System.currentTimeMillis();
        NimbusHeartbeatsPressureTest.println(THREADS_NUM + " tasks, " + THREAD_SUBMIT_NUM * THREADS_NUM + " requests cost " + (double)(totalEnd - totalStart) / 1000.0 + "seconds");
        NimbusHeartbeatsPressureTest.printStatistics(totalCostTimesBook);
        try {
            service.shutdownNow();
            service.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static boolean allTasksReady() {
        for (boolean ready : readyFlags) {
            if (ready) continue;
            return false;
        }
        return true;
    }

    private static void println(Object msg) {
        if (msg instanceof Collection) {
            Iterator itr = ((Collection)msg).iterator();
            while (itr.hasNext()) {
                System.out.println(itr.next());
            }
        } else {
            System.out.println(msg);
        }
    }

    private static void printTimeCostArray(Double[] array) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (int i = 0; i < array.length; ++i) {
            if (i != array.length - 1) {
                builder.append(array[i] + ",");
                continue;
            }
            builder.append("" + array[i]);
        }
        builder.append("]");
        System.out.println(builder.toString());
    }

    private static void printStatistics(List<double[]> data) {
        ArrayList<Double> totalPoints = new ArrayList<Double>();
        double total = 0.0;
        Iterator<double[]> iterator = data.iterator();
        while (iterator.hasNext()) {
            double[] item;
            double[] dArray = item = iterator.next();
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                Double point = dArray[i];
                if (point == null) continue;
                totalPoints.add(point);
                total += point.doubleValue();
            }
        }
        Object[] totalPointsArray = new Double[totalPoints.size()];
        totalPoints.toArray(totalPointsArray);
        Arrays.sort(totalPointsArray);
        NimbusHeartbeatsPressureTest.println("===== statistics ================");
        NimbusHeartbeatsPressureTest.println("===== min time cost: " + (Double)totalPointsArray[0] + " =====");
        NimbusHeartbeatsPressureTest.println("===== max time cost: " + (Double)totalPointsArray[totalPointsArray.length - 2] + " =====");
        double meanVal = total / (double)totalPointsArray.length;
        NimbusHeartbeatsPressureTest.println("===== mean time cost: " + meanVal + " =====");
        int middleIndex = (int)((double)totalPointsArray.length * 0.5);
        NimbusHeartbeatsPressureTest.println("===== median time cost: " + (Double)totalPointsArray[middleIndex] + " =====");
        int top90Index = (int)((double)totalPointsArray.length * 0.9);
        NimbusHeartbeatsPressureTest.println("===== top90 time cost: " + (Double)totalPointsArray[top90Index] + " =====");
    }

    public static void main(String[] args) {
        NimbusHeartbeatsPressureTest.testMaxThroughput();
    }

    static {
        for (int i = 0; i < THREADS_NUM; ++i) {
            NimbusHeartbeatsPressureTest.readyFlags[i] = false;
        }
    }

    static class HeartbeatSendTask
    implements Runnable {
        private double[] runtimesBook;
        private int taskId;
        private int tryTimes;
        private NimbusClient client;

        HeartbeatSendTask(int taskId, int tryTimes) {
            this.taskId = taskId;
            this.tryTimes = tryTimes;
            this.runtimesBook = new double[tryTimes];
            try {
                this.client = NimbusClient.Builder.withConf((Map)NimbusHeartbeatsPressureTest.initializedConfig()).buildWithNimbusHostPort(NIMBUS_HOST, Integer.valueOf(NIMBUS_PORT));
            }
            catch (TTransportException e) {
                e.printStackTrace();
            }
        }

        private static SupervisorWorkerHeartbeat nextMockedWorkerbeat() {
            ArrayList<ExecutorInfo> executorInfos = new ArrayList<ExecutorInfo>();
            executorInfos.add(new ExecutorInfo(1, 1));
            executorInfos.add(new ExecutorInfo(2, 2));
            executorInfos.add(new ExecutorInfo(3, 3));
            executorInfos.add(new ExecutorInfo(4, 4));
            SupervisorWorkerHeartbeat heartbeat = new SupervisorWorkerHeartbeat();
            heartbeat.set_executors(executorInfos);
            heartbeat.set_storm_id("storm_name_example_" + rand.nextInt(MOCKED_STORM_NUM));
            heartbeat.set_time_secs(1221212121);
            return heartbeat;
        }

        private static SupervisorWorkerHeartbeats mockedHeartbeats() {
            SupervisorWorkerHeartbeats heartbeats = new SupervisorWorkerHeartbeats();
            heartbeats.set_supervisor_id("123124134123413412341351234143");
            ArrayList<SupervisorWorkerHeartbeat> workers = new ArrayList<SupervisorWorkerHeartbeat>();
            for (int i = 0; i < 25; ++i) {
                workers.add(HeartbeatSendTask.nextMockedWorkerbeat());
            }
            heartbeats.set_worker_heartbeats(workers);
            return heartbeats;
        }

        @Override
        public void run() {
            try {
                for (int i = 0; i < this.tryTimes; ++i) {
                    long thisBegin = System.currentTimeMillis();
                    this.client.getClient().sendSupervisorWorkerHeartbeats(HeartbeatSendTask.mockedHeartbeats());
                    long thisEnd = System.currentTimeMillis();
                    this.runtimesBook[i] = (double)(thisEnd - thisBegin) / 1000.0;
                }
                totalCostTimesBook.add(this.runtimesBook);
                NimbusHeartbeatsPressureTest.readyFlags[this.taskId] = true;
                Thread.currentThread().interrupt();
            }
            catch (TException e) {
                e.printStackTrace();
            }
        }
    }
}

