/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.factory.InvalidAdaptableException;
import org.apache.sling.models.factory.ModelClassException;
import org.apache.sling.models.impl.AdapterFactoryTest;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.impl.injectors.ChildResourceInjector;
import org.apache.sling.models.impl.injectors.ValueMapInjector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class InvalidAdaptationsTest {
    private ModelAdapterFactory factory;

    InvalidAdaptationsTest() {
    }

    @BeforeEach
    void setup() {
        this.factory = AdapterFactoryTest.createModelAdapterFactory();
        this.factory.injectors = Arrays.asList(new ValueMapInjector(), new ChildResourceInjector());
        this.factory.adapterImplementations.addClassesAsAdapterAndImplementation(new Class[]{NonModel.class, RequestModel.class});
    }

    @Test
    void testNonModelClass() {
        Map emptyMap = Collections.emptyMap();
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)new ValueMapDecorator(emptyMap));
        Assertions.assertNull((Object)this.factory.getAdapter((Object)res, NonModel.class));
    }

    @Test
    void testNonModelClassException() {
        Map emptyMap = Collections.emptyMap();
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)new ValueMapDecorator(emptyMap));
        Assertions.assertThrows(ModelClassException.class, () -> this.factory.createModel((Object)res, NonModel.class));
    }

    @Test
    void testWrongAdaptableClass() {
        Map emptyMap = Collections.emptyMap();
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)new ValueMapDecorator(emptyMap));
        Assertions.assertNull((Object)this.factory.getAdapter((Object)res, RequestModel.class));
    }

    @Test
    void testWrongAdaptableClassException() {
        Map emptyMap = Collections.emptyMap();
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)new ValueMapDecorator(emptyMap));
        Assertions.assertThrows(InvalidAdaptableException.class, () -> this.factory.createModel((Object)res, RequestModel.class));
    }

    private class NonModel {
        private NonModel() {
        }
    }

    @Model(adaptables={SlingJakartaHttpServletRequest.class})
    private class RequestModel {
        private RequestModel() {
        }
    }
}

