/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.test.ant.tasks;

import com.microsoft.playwright.Playwright;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.royale.test.ant.IRoyaleUnitServer;
import org.apache.royale.test.ant.LoggingUtil;
import org.apache.royale.test.ant.RoyaleUnitSocketServer;
import org.apache.royale.test.ant.RoyaleUnitSocketThread;
import org.apache.royale.test.ant.RoyaleUnitWebSocketServer;
import org.apache.royale.test.ant.launcher.commands.TestRunCommand;
import org.apache.royale.test.ant.launcher.commands.TestRunCommandFactory;
import org.apache.royale.test.ant.launcher.commands.player.AdlCommand;
import org.apache.royale.test.ant.launcher.commands.player.PlayerCommandFactory;
import org.apache.royale.test.ant.launcher.commands.playwright.PlaywrightCommand;
import org.apache.royale.test.ant.launcher.commands.process.ProcessCommand;
import org.apache.royale.test.ant.launcher.contexts.ExecutionContext;
import org.apache.royale.test.ant.launcher.contexts.ExecutionContextFactory;
import org.apache.royale.test.ant.launcher.contexts.PlaywrightExecutionContext;
import org.apache.royale.test.ant.launcher.contexts.ProcessExecutionContext;
import org.apache.royale.test.ant.report.Reports;
import org.apache.royale.test.ant.tasks.configuration.TestRunConfiguration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class TestRun {
    private final String TRUE = "true";
    private TestRunConfiguration configuration;
    private Project project;
    private Reports reports;

    public TestRun(Project project, TestRunConfiguration configuration) {
        this.project = project;
        this.configuration = configuration;
        this.reports = new Reports();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws BuildException {
        this.configuration.log();
        try {
            TestRunCommand command = this.obtainTestRunCommand();
            ExecutionContext context = this.obtainContext(command);
            context.start();
            Future<Object> daemon = this.setupSocketThread();
            Process process = null;
            Playwright playwright = null;
            if (command instanceof ProcessCommand) {
                process = ((ProcessCommand)command).launch();
            } else if (command instanceof PlaywrightCommand) {
                playwright = ((PlaywrightCommand)command).launch();
            }
            try {
                daemon.get();
            }
            finally {
                if (context instanceof ProcessExecutionContext) {
                    ((ProcessExecutionContext)context).stop(process);
                } else if (context instanceof PlaywrightExecutionContext) {
                    ((PlaywrightExecutionContext)context).stop(playwright);
                }
            }
            this.analyzeReports();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected ProcessCommand obtainPlayer() {
        ProcessCommand command = PlayerCommandFactory.createPlayer(this.configuration.getOs(), this.configuration.getPlayer(), this.configuration.getCommand(), this.configuration.getCommandArgs(), this.configuration.isLocalTrusted());
        command.setProject(this.project);
        command.setSwf(this.configuration.getSwf());
        command.setUrl(this.configuration.getUrl());
        if (command instanceof AdlCommand) {
            ((AdlCommand)command).setPrecompiledAppDescriptor(this.configuration.getPrecompiledAppDescriptor());
        }
        return command;
    }

    protected TestRunCommand obtainTestRunCommand() {
        TestRunCommand command = TestRunCommandFactory.createCommand(this.configuration.getOs(), this.configuration.getPlayer(), this.configuration.getCommand(), this.configuration.getCommandArgs(), this.configuration.isLocalTrusted());
        command.setProject(this.project);
        command.setSwf(this.configuration.getSwf());
        command.setUrl(this.configuration.getUrl());
        if (command instanceof AdlCommand) {
            ((AdlCommand)command).setPrecompiledAppDescriptor(this.configuration.getPrecompiledAppDescriptor());
        }
        return command;
    }

    protected ExecutionContext obtainContext(TestRunCommand command) {
        ExecutionContext context = ExecutionContextFactory.createContext(command, this.configuration.getOs(), this.configuration.isHeadless(), this.configuration.getDisplay());
        context.setProject(this.project);
        return context;
    }

    protected Future<Object> setupSocketThread() {
        LoggingUtil.log("Setting up server process ...");
        IRoyaleUnitServer server = null;
        server = !"air".equals(this.configuration.getPlayer()) && !"flash".equals(this.configuration.getPlayer()) ? new RoyaleUnitWebSocketServer(this.configuration.getPort(), this.configuration.getSocketTimeout()) : new RoyaleUnitSocketServer(this.configuration.getPort(), this.configuration.getSocketTimeout(), this.configuration.getServerBufferSize(), this.configuration.usePolicyFile());
        RoyaleUnitSocketThread operation = new RoyaleUnitSocketThread(server, this.configuration.getReportDir(), this.reports);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        return executor.submit(operation);
    }

    protected void analyzeReports() {
        LoggingUtil.log("Analyzing reports ...");
        LoggingUtil.log("\n" + this.reports.getSummary(), true);
        if (this.reports.hasFailures()) {
            this.project.setNewProperty(this.configuration.getFailureProperty(), "true");
            if (this.configuration.isFailOnTestFailure()) {
                throw new BuildException("RoyaleUnit tests failed during the test run.");
            }
        }
    }
}

