/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.scopes;

import com.google.common.base.Strings;
import org.apache.royale.compiler.asdoc.IASDocComment;
import org.apache.royale.compiler.definitions.IDocumentableDefinition;
import org.apache.royale.compiler.internal.projects.ASProject;
import org.apache.royale.compiler.internal.projects.LibraryPathManager;
import org.apache.royale.compiler.internal.scopes.ASFileScope;
import org.apache.royale.compiler.internal.units.SWCCompilationUnit;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.scopes.IFileScopeProvider;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.compiler.workspaces.IWorkspace;

public final class SWCFileScopeProvider
implements IFileScopeProvider {
    private static final SWCFileScopeProvider instance = new SWCFileScopeProvider();

    public static SWCFileScopeProvider getInstance() {
        return instance;
    }

    private SWCFileScopeProvider() {
    }

    @Override
    public ASFileScope createFileScope(IWorkspace workspace, String filePath) {
        return new SWCFileScope(workspace, filePath);
    }

    public static final class SWCFileScope
    extends ASFileScope {
        public SWCFileScope(IWorkspace workspace, String filePath) {
            super(workspace, filePath);
        }

        @Override
        public String getContainingSourcePath(String qName, ICompilerProject project) {
            assert (!Strings.isNullOrEmpty((String)qName)) : "Expected QName.";
            assert (project != null);
            if (!(project instanceof ASProject)) {
                return null;
            }
            ASProject flashProject = (ASProject)project;
            String swcFilePath = this.filePath;
            String attachedSourceDirectory = flashProject.getAttachedSourceDirectory(swcFilePath);
            if (attachedSourceDirectory == null) {
                return null;
            }
            return LibraryPathManager.getAttachedSourceFilename(attachedSourceDirectory, qName);
        }

        public IASDocComment getComment(ICompilerProject project, IDocumentableDefinition def) {
            if (!(project instanceof ASProject)) {
                return null;
            }
            ASProject flashProject = (ASProject)project;
            return flashProject.getASDocBundleDelegate().getComment(def, this.getContainingPath());
        }

        @Override
        public boolean isSWC() {
            return true;
        }

        @Override
        public boolean setCompilationUnit(ICompilationUnit compilationUnit) {
            assert (compilationUnit == null || compilationUnit instanceof SWCCompilationUnit) : "non SWCCompilationUnit passed to SWCFileScopeProvider";
            return false;
        }

        @Override
        public ICompilationUnit getCompilationUnit() {
            return null;
        }
    }
}

