/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.codegen.js.goog.IJSGoogDocEmitter;
import org.apache.royale.compiler.common.ASModifier;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.common.ModifiersSet;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.IVariableDefinition;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSessionModel;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitter;
import org.apache.royale.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.tree.as.ChainedVariableNode;
import org.apache.royale.compiler.internal.tree.as.FunctionCallNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.VariableNode;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.INamespaceDecorationNode;
import org.apache.royale.compiler.tree.as.IVariableNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagsNode;
import org.apache.royale.compiler.utils.NativeUtils;

public class FieldEmitter
extends JSSubEmitter
implements ISubEmitter<IVariableNode> {
    public boolean hasComplexStaticInitializers = false;

    public FieldEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    private boolean isComplex(IExpressionNode vnode, IDefinition definition) {
        if (EmitterUtils.isScalar(vnode)) {
            return false;
        }
        IClassDefinition cdef = (IClassDefinition)definition;
        return this.isExternalReference(vnode, cdef);
    }

    private boolean isExternalReference(IExpressionNode vnode, IClassDefinition cdef) {
        if (vnode.getNodeID() == ASTNodeID.IdentifierID) {
            IDefinition def = vnode.resolve(this.getProject());
            if (def == null) {
                return false;
            }
            String qname = def.getQualifiedName();
            if (NativeUtils.isJSNative(qname)) {
                return false;
            }
            if (def instanceof IClassDefinition) {
                return !qname.contentEquals(cdef.getQualifiedName());
            }
            if ((def = def.getParent()) != null) {
                qname = def.getQualifiedName();
                if (NativeUtils.isJSNative(qname)) {
                    return false;
                }
                return !qname.contentEquals(cdef.getQualifiedName());
            }
        }
        int n = vnode.getChildCount();
        for (int i = 0; i < n; ++i) {
            IASNode childNode = vnode.getChild(i);
            if (!(childNode instanceof IExpressionNode) || !this.isExternalReference((IExpressionNode)childNode, cdef)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void emit(IVariableNode node) {
        boolean isPackageOrFileMember;
        IExpressionNode vnode = node.getAssignedValueNode();
        boolean isBindable = node.getNodeID() == ASTNodeID.BindableVariableID && !node.isConst();
        IDefinition ndef = node.getDefinition();
        IClassDefinition definition = EmitterUtils.getClassDefinition((IDefinitionNode)node);
        if (definition == null && ndef != null) {
            definition = ndef.getParent();
        }
        boolean isComplexInitializedStatic = vnode != null && ndef.isStatic() && !isBindable && this.isComplex(vnode, (IDefinition)definition);
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        ITypeDefinition def = null;
        IExpressionNode enode = node.getVariableTypeNode();
        if (enode != null) {
            def = enode.resolveType(this.getProject());
        }
        if (this.getEmitter().getDocEmitter() instanceof IJSGoogDocEmitter && !isComplexInitializedStatic) {
            ((IJSGoogDocEmitter)this.getEmitter().getDocEmitter()).emitFieldDoc(node, (IDefinition)def, this.getProject());
        }
        String className = null;
        String root = "";
        IVariableDefinition.VariableClassification classification = node.getVariableClassification();
        boolean bl = isPackageOrFileMember = classification == IVariableDefinition.VariableClassification.PACKAGE_MEMBER || classification == IVariableDefinition.VariableClassification.FILE_MEMBER;
        if (isPackageOrFileMember) {
            String qualifiedName = node.getQualifiedName();
            if (fjs.getModel().isExterns && node.getName().equals(qualifiedName)) {
                this.writeToken(ASEmitterTokens.VAR);
            }
            this.write(fjs.formatQualifiedName(qualifiedName));
        } else {
            ModifiersSet modifierSet = ndef.getModifiers();
            if (modifierSet != null && !modifierSet.hasModifier(ASModifier.STATIC)) {
                root = JSEmitterTokens.PROTOTYPE.getToken();
                root = root + ASEmitterTokens.MEMBER_ACCESS.getToken();
            }
            if (definition == null) {
                definition = ndef.getContainingScope().getDefinition();
            }
            this.startMapping((ISourceLocation)node.getNameExpressionNode());
            className = this.getEmitter().formatQualifiedName(definition.getQualifiedName());
            if (isComplexInitializedStatic) {
                this.write(className);
                this.write(ASEmitterTokens.MEMBER_ACCESS.getToken());
                this.write(fjs.formatGetter(this.getFieldName(node, fjs)));
                this.endMapping((ISourceLocation)node.getNameExpressionNode());
                this.write(ASEmitterTokens.SPACE);
                this.writeToken(ASEmitterTokens.EQUAL);
                this.write(ASEmitterTokens.FUNCTION);
                this.write(ASEmitterTokens.PAREN_OPEN);
                this.writeToken(ASEmitterTokens.PAREN_CLOSE);
                this.writeNewline(ASEmitterTokens.BLOCK_OPEN, true);
                String vnodeString = this.getEmitter().stringifyNode((IASNode)vnode);
                this.writeToken(ASEmitterTokens.VAR);
                this.writeToken("value");
                this.writeToken(ASEmitterTokens.EQUAL);
                this.write(vnodeString);
                this.writeNewline(ASEmitterTokens.SEMICOLON);
                this.write("Object");
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write(JSEmitterTokens.DEFINE_PROPERTIES);
                this.write(ASEmitterTokens.PAREN_OPEN);
                this.write(className);
                this.writeToken(ASEmitterTokens.COMMA);
                this.writeToken(ASEmitterTokens.BLOCK_OPEN);
                this.write(this.getFieldName(node, fjs));
                this.writeToken(ASEmitterTokens.COLON);
                if (node.isConst()) {
                    this.write("{ value: value, writable: false }");
                } else {
                    this.write("{ value: value, writable: true }");
                }
                this.write(ASEmitterTokens.BLOCK_CLOSE);
                this.write(ASEmitterTokens.PAREN_CLOSE);
                this.writeNewline(ASEmitterTokens.SEMICOLON);
                this.writeToken(ASEmitterTokens.RETURN);
                this.write("value");
                this.indentPop();
                this.writeNewline(ASEmitterTokens.SEMICOLON);
                this.write(ASEmitterTokens.BLOCK_CLOSE);
                this.writeNewline(ASEmitterTokens.SEMICOLON);
                if (!node.isConst()) {
                    this.write(className);
                    this.write(ASEmitterTokens.MEMBER_ACCESS.getToken());
                    this.write(fjs.formatSetter(this.getFieldName(node, fjs)));
                    this.write(ASEmitterTokens.SPACE);
                    this.writeToken(ASEmitterTokens.EQUAL);
                    this.write(ASEmitterTokens.FUNCTION);
                    this.write(ASEmitterTokens.PAREN_OPEN);
                    this.write("value");
                    this.writeToken(ASEmitterTokens.PAREN_CLOSE);
                    this.writeNewline(ASEmitterTokens.BLOCK_OPEN, true);
                    this.write("Object");
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    this.write(JSEmitterTokens.DEFINE_PROPERTIES);
                    this.write(ASEmitterTokens.PAREN_OPEN);
                    this.write(className);
                    this.writeToken(ASEmitterTokens.COMMA);
                    this.writeToken(ASEmitterTokens.BLOCK_OPEN);
                    this.write(this.getFieldName(node, fjs));
                    this.writeToken(ASEmitterTokens.COLON);
                    this.write("{ value: value, writable: true }");
                    this.write(ASEmitterTokens.BLOCK_CLOSE);
                    this.write(ASEmitterTokens.PAREN_CLOSE);
                    this.indentPop();
                    this.writeNewline(ASEmitterTokens.SEMICOLON);
                    this.write(ASEmitterTokens.BLOCK_CLOSE);
                    this.writeNewline(ASEmitterTokens.SEMICOLON);
                }
                if (this.getEmitter().getDocEmitter() instanceof IJSGoogDocEmitter) {
                    ((IJSGoogDocEmitter)this.getEmitter().getDocEmitter()).emitFieldDoc(node, (IDefinition)def, this.getProject());
                }
                this.write(className);
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write(this.getFieldName(node, fjs));
                this.write(ASEmitterTokens.SEMICOLON);
                this.writeNewline();
                this.writeNewline();
                this.write("Object");
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write(JSEmitterTokens.DEFINE_PROPERTIES);
                this.write(ASEmitterTokens.PAREN_OPEN);
                this.write(className);
                this.writeToken(ASEmitterTokens.COMMA);
                this.write("/** @lends {" + className + "} */ ");
                this.writeNewline(ASEmitterTokens.BLOCK_OPEN);
                if (this.getEmitter().getDocEmitter() instanceof IJSGoogDocEmitter) {
                    ((IJSGoogDocEmitter)this.getEmitter().getDocEmitter()).emitFieldDoc(node, (IDefinition)def, this.getProject());
                }
                this.write(this.getFieldName(node, fjs));
                this.writeToken(ASEmitterTokens.COLON);
                this.writeNewline(ASEmitterTokens.BLOCK_OPEN, true);
                this.write(ASEmitterTokens.GET);
                this.write(ASEmitterTokens.COLON);
                this.write(ASEmitterTokens.SPACE);
                this.write(className);
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write(fjs.formatGetter(this.getFieldName(node, fjs)));
                if (!node.isConst()) {
                    this.writeNewline(ASEmitterTokens.COMMA);
                    this.write(ASEmitterTokens.SET);
                    this.write(ASEmitterTokens.COLON);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(className);
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    this.write(fjs.formatSetter(this.getFieldName(node, fjs)));
                }
                this.writeNewline(ASEmitterTokens.COMMA);
                this.write("configurable: true");
                this.write(ASEmitterTokens.BLOCK_CLOSE);
                this.write(ASEmitterTokens.BLOCK_CLOSE);
                this.write(ASEmitterTokens.PAREN_CLOSE);
                this.indentPop();
            } else {
                this.write(className + ASEmitterTokens.MEMBER_ACCESS.getToken() + root);
                String qname = node.getName();
                IDefinition nodeDef = node.getDefinition();
                if (nodeDef != null && !nodeDef.isStatic() && nodeDef.isPrivate() && this.getProject().getAllowPrivateNameConflicts()) {
                    qname = this.getEmitter().formatPrivateName(nodeDef.getParent().getQualifiedName(), qname);
                }
                if (EmitterUtils.isCustomNamespace(node.getNamespace())) {
                    INamespaceDecorationNode ns = ((VariableNode)node).getNamespaceNode();
                    INamespaceDefinition nsDef = (INamespaceDefinition)ns.resolve(this.getProject());
                    fjs.formatQualifiedName(nsDef.getQualifiedName());
                    String s = nsDef.getURI();
                    this.write(JSRoyaleEmitter.formatNamespacedProperty(s, qname, false));
                } else {
                    this.write(qname);
                }
                this.endMapping((ISourceLocation)node.getNameExpressionNode());
            }
        }
        if (isBindable) {
            this.write("_");
        }
        if (vnode != null && !isComplexInitializedStatic) {
            FunctionCallNode fcn;
            this.getModel().inStaticInitializer = ndef.isStatic() || isPackageOrFileMember;
            String vnodeString = this.getEmitter().stringifyNode((IASNode)vnode);
            if (ndef.isStatic() && vnode instanceof FunctionCallNode && (fcn = (FunctionCallNode)vnode).getNameNode() instanceof IdentifierNode) {
                IDefinitionNode m;
                IClassDefinition classDef;
                IFunctionDefinition constructorDef;
                IDefinition d = fcn.getNameNode().resolve(this.getProject());
                if (d instanceof FunctionDefinition) {
                    FunctionDefinition fd = (FunctionDefinition)d;
                    IDefinitionNode m2 = fd.getNode();
                    if (m2 != null) {
                        this.getEmitter().stringifyNode((IASNode)m2);
                    }
                } else if (d instanceof IClassDefinition && (constructorDef = (classDef = (IClassDefinition)d).getConstructor()) != null && (m = constructorDef.getNode()) != null) {
                    this.getEmitter().stringifyNode((IASNode)m);
                }
            }
            this.getModel().inStaticInitializer = false;
            if (ndef.isStatic() && !EmitterUtils.needsStaticInitializer(vnodeString, className) || !ndef.isStatic() && EmitterUtils.isScalar(vnode) || isPackageOrFileMember) {
                IExpressionNode beforeNode = node.getVariableTypeNode();
                if (beforeNode.getAbsoluteStart() == -1) {
                    beforeNode = node.getNameExpressionNode();
                }
                this.startMapping((ISourceLocation)node, (ISourceLocation)beforeNode);
                this.write(ASEmitterTokens.SPACE);
                this.writeToken(ASEmitterTokens.EQUAL);
                this.endMapping((ISourceLocation)node);
                this.getEmitter().emitAssignmentCoercion(vnode, node.getVariableTypeNode().resolve(this.getProject()));
            } else if (ndef.isStatic() && EmitterUtils.needsStaticInitializer(vnodeString, className)) {
                this.hasComplexStaticInitializers = true;
            }
            if (!isPackageOrFileMember && !ndef.isStatic() && !EmitterUtils.isScalar(vnode) && this.getProject() instanceof RoyaleJSProject && ((RoyaleJSProject)this.getProject()).config != null && ((RoyaleJSProject)this.getProject()).config.getJsDefaultInitializers()) {
                this.write(ASEmitterTokens.SPACE);
                this.writeToken(ASEmitterTokens.EQUAL);
                this.write(ASEmitterTokens.NULL);
            }
        }
        if (vnode == null && def != null) {
            String defName = def.getQualifiedName();
            if (defName.equals("int") || defName.equals("uint")) {
                this.write(ASEmitterTokens.SPACE);
                this.writeToken(ASEmitterTokens.EQUAL);
                this.write("0");
            } else {
                boolean defaultInitializers = false;
                ICompilerProject project = this.getProject();
                if (project instanceof RoyaleJSProject) {
                    RoyaleJSProject fjsProject = (RoyaleJSProject)project;
                    if (fjsProject.config != null) {
                        defaultInitializers = fjsProject.config.getJsDefaultInitializers();
                    }
                }
                if (defaultInitializers) {
                    if (defName.equals("Number")) {
                        this.write(ASEmitterTokens.SPACE);
                        this.writeToken(ASEmitterTokens.EQUAL);
                        this.write("NaN");
                    } else if (defName.equals("Boolean")) {
                        this.write(ASEmitterTokens.SPACE);
                        this.writeToken(ASEmitterTokens.EQUAL);
                        this.write("false");
                    } else if (defName.equals("*")) {
                        this.write(ASEmitterTokens.SPACE);
                        this.writeToken(ASEmitterTokens.EQUAL);
                        this.write(ASEmitterTokens.UNDEFINED);
                    } else {
                        this.write(ASEmitterTokens.SPACE);
                        this.writeToken(ASEmitterTokens.EQUAL);
                        this.write("null");
                    }
                }
            }
        }
        if (!(node instanceof ChainedVariableNode)) {
            int len = node.getChildCount();
            for (int i = 0; i < len; ++i) {
                IASNode child = node.getChild(i);
                if (!(child instanceof ChainedVariableNode)) continue;
                this.writeNewline(ASEmitterTokens.SEMICOLON);
                this.writeNewline();
                this.getEmitter().emitField((IVariableNode)child);
            }
        }
        if (node.getNodeID() == ASTNodeID.BindableVariableID && !node.isConst() && this.getModel().getBindableVars().get(node.getName()) == null) {
            IMetaTagNode[] tags;
            JSSessionModel.BindableVarInfo bindableVarInfo = new JSSessionModel.BindableVarInfo();
            bindableVarInfo.isStatic = node.hasModifier(ASModifier.STATIC);
            bindableVarInfo.namespace = node.getNamespace();
            bindableVarInfo.type = def.getQualifiedName();
            this.getModel().getBindableVars().put(node.getName(), bindableVarInfo);
            IMetaTagsNode metaTags = node.getMetaTags();
            if (metaTags != null && (tags = metaTags.getAllTags()).length > 0) {
                bindableVarInfo.metaTags = tags;
            }
        }
    }

    private String getFieldName(IVariableNode node, JSRoyaleEmitter fjs) {
        String qname = node.getName();
        IDefinition nodeDef = node.getDefinition();
        if (nodeDef != null && !nodeDef.isStatic() && nodeDef.isPrivate() && this.getProject().getAllowPrivateNameConflicts()) {
            qname = this.getEmitter().formatPrivateName(nodeDef.getParent().getQualifiedName(), qname);
        }
        if (EmitterUtils.isCustomNamespace(node.getNamespace())) {
            INamespaceDecorationNode ns = ((VariableNode)node).getNamespaceNode();
            INamespaceDefinition nsDef = (INamespaceDefinition)ns.resolve(this.getProject());
            fjs.formatQualifiedName(nsDef.getQualifiedName());
            String s = nsDef.getURI();
            return JSRoyaleEmitter.formatNamespacedProperty(s, qname, false);
        }
        return qname;
    }

    public boolean emitFieldInitializer(IVariableNode node) {
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        IClassDefinition definition = EmitterUtils.getClassDefinition((IDefinitionNode)node);
        IDefinition ndef = node.getDefinition();
        String className = null;
        IVariableDefinition.VariableClassification classification = node.getVariableClassification();
        boolean isPackageOrFileMember = classification == IVariableDefinition.VariableClassification.PACKAGE_MEMBER || classification == IVariableDefinition.VariableClassification.FILE_MEMBER;
        IExpressionNode vnode = node.getAssignedValueNode();
        if (vnode != null) {
            String vnodeString = this.getEmitter().stringifyNode((IASNode)vnode);
            if (definition == null) {
                definition = ndef.getContainingScope().getDefinition();
            }
            className = this.getEmitter().formatQualifiedName(definition.getQualifiedName());
            if (ndef.isStatic() && EmitterUtils.needsStaticInitializer(vnodeString, className) && !isPackageOrFileMember) {
                this.writeNewline();
                this.write(className);
                this.write(ASEmitterTokens.MEMBER_ACCESS.getToken());
                if (EmitterUtils.isCustomNamespace(node.getNamespace())) {
                    INamespaceDecorationNode ns = ((VariableNode)node).getNamespaceNode();
                    INamespaceDefinition nsDef = (INamespaceDefinition)ns.resolve(this.getProject());
                    fjs.formatQualifiedName(nsDef.getQualifiedName());
                    String s = nsDef.getURI();
                    this.write(JSRoyaleEmitter.formatNamespacedProperty(s, node.getName(), false));
                } else {
                    this.write(node.getName());
                }
                if (node.getNodeID() == ASTNodeID.BindableVariableID && !node.isConst()) {
                    this.write("_");
                }
                this.write(ASEmitterTokens.SPACE);
                this.writeToken(ASEmitterTokens.EQUAL);
                this.write(vnodeString);
                this.write(ASEmitterTokens.SEMICOLON);
                return true;
            }
        }
        return false;
    }
}

