/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.impl.producer;

import java.util.ArrayList;
import java.util.List;
import org.apache.rocketmq.client.common.ThreadLocalIndex;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.remoting.protocol.route.QueueData;
import org.apache.rocketmq.remoting.protocol.route.TopicRouteData;

public class TopicPublishInfo {
    private boolean orderTopic = false;
    private boolean haveTopicRouterInfo = false;
    private List<MessageQueue> messageQueueList = new ArrayList<MessageQueue>();
    private volatile ThreadLocalIndex sendWhichQueue = new ThreadLocalIndex();
    private TopicRouteData topicRouteData;

    public boolean isOrderTopic() {
        return this.orderTopic;
    }

    public void setOrderTopic(boolean orderTopic) {
        this.orderTopic = orderTopic;
    }

    public boolean ok() {
        return null != this.messageQueueList && !this.messageQueueList.isEmpty();
    }

    public List<MessageQueue> getMessageQueueList() {
        return this.messageQueueList;
    }

    public void setMessageQueueList(List<MessageQueue> messageQueueList) {
        this.messageQueueList = messageQueueList;
    }

    public ThreadLocalIndex getSendWhichQueue() {
        return this.sendWhichQueue;
    }

    public void setSendWhichQueue(ThreadLocalIndex sendWhichQueue) {
        this.sendWhichQueue = sendWhichQueue;
    }

    public boolean isHaveTopicRouterInfo() {
        return this.haveTopicRouterInfo;
    }

    public void setHaveTopicRouterInfo(boolean haveTopicRouterInfo) {
        this.haveTopicRouterInfo = haveTopicRouterInfo;
    }

    public MessageQueue selectOneMessageQueue(String lastBrokerName) {
        if (lastBrokerName == null) {
            return this.selectOneMessageQueue();
        }
        for (int i = 0; i < this.messageQueueList.size(); ++i) {
            int index = this.sendWhichQueue.incrementAndGet();
            int pos = index % this.messageQueueList.size();
            MessageQueue mq = this.messageQueueList.get(pos);
            if (mq.getBrokerName().equals(lastBrokerName)) continue;
            return mq;
        }
        return this.selectOneMessageQueue();
    }

    public MessageQueue selectOneMessageQueue() {
        int index = this.sendWhichQueue.incrementAndGet();
        int pos = index % this.messageQueueList.size();
        return this.messageQueueList.get(pos);
    }

    public int getWriteQueueIdByBroker(String brokerName) {
        for (int i = 0; i < this.topicRouteData.getQueueDatas().size(); ++i) {
            QueueData queueData = (QueueData)this.topicRouteData.getQueueDatas().get(i);
            if (!queueData.getBrokerName().equals(brokerName)) continue;
            return queueData.getWriteQueueNums();
        }
        return -1;
    }

    public String toString() {
        return "TopicPublishInfo [orderTopic=" + this.orderTopic + ", messageQueueList=" + this.messageQueueList + ", sendWhichQueue=" + this.sendWhichQueue + ", haveTopicRouterInfo=" + this.haveTopicRouterInfo + "]";
    }

    public TopicRouteData getTopicRouteData() {
        return this.topicRouteData;
    }

    public void setTopicRouteData(TopicRouteData topicRouteData) {
        this.topicRouteData = topicRouteData;
    }
}

