/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.message.mimecontentconverter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.qpid.server.message.mimecontentconverter.ObjectToMimeContentConverter;
import org.apache.qpid.server.plugin.PluggableService;

@PluggableService
public class SerializableToJavaObjectStream
implements ObjectToMimeContentConverter<Serializable> {
    @Override
    public String getType() {
        return this.getMimeType();
    }

    @Override
    public String getMimeType() {
        return "application/java-object-stream";
    }

    @Override
    public Class<Serializable> getObjectClass() {
        return Serializable.class;
    }

    @Override
    public int getRank() {
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean isAcceptable(Serializable object) {
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] toMimeContent(Serializable object) {
        try (ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream os = new ObjectOutputStream(bytesOut);){
                os.writeObject(object);
                byArray = bytesOut.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

