/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.formats.Conll03NameSampleStream;
import opennlp.tools.formats.LanguageSampleStreamFactory;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.ObjectStream;

public class Conll03NameSampleStreamFactory
extends LanguageSampleStreamFactory<NameSample, Parameters> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(NameSample.class, "conll03", new Conll03NameSampleStreamFactory(Parameters.class));
    }

    protected Conll03NameSampleStreamFactory(Class<Parameters> params) {
        super(params);
    }

    @Override
    public ObjectStream<NameSample> create(String[] args) {
        Conll03NameSampleStream.LANGUAGE lang;
        Parameters params = this.validateBasicFormatParameters(args, Parameters.class);
        if ("eng".equals(params.getLang())) {
            lang = Conll03NameSampleStream.LANGUAGE.EN;
            this.language = params.getLang();
        } else if ("deu".equals(params.getLang())) {
            lang = Conll03NameSampleStream.LANGUAGE.DE;
            this.language = params.getLang();
        } else {
            throw new TerminateToolException(1, "Unsupported language: " + params.getLang());
        }
        int typesToGenerate = 0;
        if (params.getTypes().contains("per")) {
            typesToGenerate |= 1;
        }
        if (params.getTypes().contains("org")) {
            typesToGenerate |= 2;
        }
        if (params.getTypes().contains("loc")) {
            typesToGenerate |= 4;
        }
        if (params.getTypes().contains("misc")) {
            typesToGenerate |= 8;
        }
        try {
            return new Conll03NameSampleStream(lang, CmdLineUtil.createInputStreamFactory(params.getData()), typesToGenerate);
        }
        catch (IOException e) {
            throw CmdLineUtil.createObjectStreamError(e);
        }
    }

    public static interface Parameters
    extends BasicFormatParams {
        @ArgumentParser.ParameterDescription(valueName="eng|deu")
        public String getLang();

        @ArgumentParser.ParameterDescription(valueName="per,loc,org,misc")
        public String getTypes();
    }
}

