/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web;

import java.util.Map;

public class ComponentDescriptor {
    private final String name;
    private final String displayName;
    private final String description;
    private final String defaultValue;
    private final Map<String, String> allowableValues;

    private ComponentDescriptor(Builder builder) {
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.defaultValue = builder.defaultValue;
        this.allowableValues = builder.allowableValues;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Map<String, String> getAllowableValues() {
        return this.allowableValues;
    }

    public static final class Builder {
        private String name;
        private String displayName;
        private String description;
        private String defaultValue;
        private Map<String, String> allowableValues;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder allowableValues(Map<String, String> allowableValues) {
            this.allowableValues = allowableValues;
            return this;
        }

        public ComponentDescriptor build() {
            return new ComponentDescriptor(this);
        }
    }
}

