/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.extensibility;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.flywaydb.core.api.configuration.Configuration;

public interface Plugin
extends Comparable<Plugin> {
    @JsonIgnore
    default public boolean isLicensed(Configuration configuration) {
        return true;
    }

    @JsonIgnore
    default public boolean isEnabled() {
        return true;
    }

    @JsonIgnore
    default public String getName() {
        return this.getClass().getSimpleName();
    }

    @JsonIgnore
    default public String getPluginVersion(Configuration config) {
        return null;
    }

    @JsonIgnore
    default public int getPriority() {
        return 0;
    }

    @Override
    default public int compareTo(Plugin o) {
        return Integer.compare(o.getPriority(), this.getPriority());
    }

    default public Plugin copy() {
        return this;
    }
}

