/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.util;

import java.util.concurrent.TimeUnit;
import org.apache.nifi.registry.util.DataUnit;
import org.apache.nifi.registry.util.FormatUtils;
import org.apache.nifi.registry.util.PropertyValue;

public class StandardPropertyValue
implements PropertyValue {
    private final String rawValue;

    public StandardPropertyValue(String rawValue) {
        this.rawValue = rawValue;
    }

    @Override
    public String getValue() {
        return this.rawValue;
    }

    @Override
    public Integer asInteger() {
        return this.rawValue == null ? null : Integer.valueOf(Integer.parseInt(this.rawValue.trim()));
    }

    @Override
    public Long asLong() {
        return this.rawValue == null ? null : Long.valueOf(Long.parseLong(this.rawValue.trim()));
    }

    @Override
    public Boolean asBoolean() {
        return this.rawValue == null ? null : Boolean.valueOf(Boolean.parseBoolean(this.rawValue.trim()));
    }

    @Override
    public Float asFloat() {
        return this.rawValue == null ? null : Float.valueOf(Float.parseFloat(this.rawValue.trim()));
    }

    @Override
    public Double asDouble() {
        return this.rawValue == null ? null : Double.valueOf(Double.parseDouble(this.rawValue.trim()));
    }

    @Override
    public Long asTimePeriod(TimeUnit timeUnit) {
        return this.rawValue == null ? null : Long.valueOf(FormatUtils.getTimeDuration(this.rawValue.trim(), timeUnit));
    }

    @Override
    public Double asDataSize(DataUnit dataUnit) {
        return this.rawValue == null ? null : DataUnit.parseDataSize(this.rawValue.trim(), dataUnit);
    }

    @Override
    public boolean isSet() {
        return this.rawValue != null;
    }

    public String toString() {
        return this.rawValue;
    }
}

