/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.nifi.record.path.paths;

import org.apache.nifi.record.path.FieldValue;
import org.apache.nifi.record.path.RecordPathEvaluationContext;
import org.apache.nifi.record.path.util.Filters;

import java.util.stream.Stream;

public class ParentPath extends RecordPathSegment {

    ParentPath(final RecordPathSegment parent, final boolean absolute) {
        super("..", parent, absolute);
    }

    @Override
    public Stream<FieldValue> evaluate(final RecordPathEvaluationContext context) {
        final Stream<FieldValue> stream;
        final RecordPathSegment parentPath = getParentPath();
        if (parentPath == null) {
            stream = Stream.of(context.getContextNode());
        } else {
            stream = parentPath.evaluate(context);
        }

        return Filters.presentValues(stream.map(fieldVal -> fieldVal.getParent()));
    }

}
