/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.configuration;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.nifi.minifi.bootstrap.RunMiNiFi;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeException;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeListener;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeNotifier;
import org.apache.nifi.minifi.bootstrap.configuration.ListenerHandleResult;
import org.apache.nifi.minifi.bootstrap.configuration.ingestors.interfaces.ChangeIngestor;
import org.apache.nifi.minifi.bootstrap.service.BootstrapFileProvider;
import org.apache.nifi.minifi.bootstrap.util.ByteBufferInputStream;
import org.apache.nifi.minifi.properties.BootstrapProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationChangeCoordinator
implements Closeable,
ConfigurationChangeNotifier {
    public static final String NOTIFIER_INGESTORS_KEY = "nifi.minifi.notifier.ingestors";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationChangeCoordinator.class);
    private static final String COMMA = ",";
    private final BootstrapFileProvider bootstrapFileProvider;
    private final RunMiNiFi runMiNiFi;
    private final Set<ConfigurationChangeListener> configurationChangeListeners;
    private final Set<ChangeIngestor> changeIngestors;

    public ConfigurationChangeCoordinator(BootstrapFileProvider bootstrapFileProvider, RunMiNiFi runMiNiFi, Set<ConfigurationChangeListener> miNiFiConfigurationChangeListeners) {
        this.bootstrapFileProvider = bootstrapFileProvider;
        this.runMiNiFi = runMiNiFi;
        this.configurationChangeListeners = Optional.ofNullable(miNiFiConfigurationChangeListeners).map(Collections::unmodifiableSet).orElse(Collections.emptySet());
        this.changeIngestors = new HashSet<ChangeIngestor>();
    }

    @Override
    public Collection<ListenerHandleResult> notifyListeners(ByteBuffer newFlowConfig) {
        LOGGER.info("Notifying Listeners of a change");
        return this.configurationChangeListeners.stream().map(listener -> this.notifyListener(newFlowConfig, (ConfigurationChangeListener)listener)).collect(Collectors.toList());
    }

    @Override
    public void close() {
        this.closeIngestors();
    }

    public void start() throws IOException {
        this.initialize();
        this.changeIngestors.forEach(ChangeIngestor::start);
    }

    private ListenerHandleResult notifyListener(ByteBuffer newFlowConfig, ConfigurationChangeListener listener) {
        try {
            listener.handleChange(new ByteBufferInputStream(newFlowConfig.duplicate()));
            ListenerHandleResult listenerHandleResult = new ListenerHandleResult(listener);
            LOGGER.info("Listener notification result {}", (Object)listenerHandleResult);
            return listenerHandleResult;
        }
        catch (ConfigurationChangeException ex) {
            ListenerHandleResult listenerHandleResult = new ListenerHandleResult(listener, ex);
            LOGGER.error("Listener notification result {} with failure {}", (Object)listenerHandleResult, (Object)ex);
            return listenerHandleResult;
        }
    }

    private void initialize() throws IOException {
        this.closeIngestors();
        BootstrapProperties bootstrapProperties = this.bootstrapFileProvider.getBootstrapProperties();
        Optional.ofNullable(bootstrapProperties.getProperty(NOTIFIER_INGESTORS_KEY)).filter(Predicate.not(String::isBlank)).map(ingestors -> ingestors.split(COMMA)).stream().flatMap(Stream::of).map(String::trim).forEach(ingestorClassname -> this.instantiateIngestor(bootstrapProperties, (String)ingestorClassname));
    }

    private void closeIngestors() {
        try {
            for (ChangeIngestor changeIngestor : this.changeIngestors) {
                changeIngestor.close();
            }
            this.changeIngestors.clear();
        }
        catch (IOException e) {
            LOGGER.warn("Could not successfully stop notifiers", (Throwable)e);
        }
    }

    private void instantiateIngestor(BootstrapProperties bootstrapProperties, String ingestorClassname) {
        try {
            Class<?> ingestorClass = Class.forName(ingestorClassname);
            ChangeIngestor changeIngestor = (ChangeIngestor)ingestorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            changeIngestor.initialize(bootstrapProperties, this.runMiNiFi, this);
            this.changeIngestors.add(changeIngestor);
            LOGGER.info("Initialized ingestor: {}", (Object)ingestorClassname);
        }
        catch (Exception e) {
            LOGGER.error("Instantiating [{}] ingestor failed", (Object)ingestorClassname, (Object)e);
        }
    }
}

