/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.secdispatcher.internal.sources;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.components.secdispatcher.MasterSourceMeta;
import org.codehaus.plexus.components.secdispatcher.SecDispatcher;
import org.codehaus.plexus.components.secdispatcher.SecDispatcherException;
import org.codehaus.plexus.components.secdispatcher.internal.sources.PrefixMasterSourceSupport;

@Singleton
@Named(value="onepassword")
public final class OnePasswordCliMasterSource
extends PrefixMasterSourceSupport
implements MasterSourceMeta {
    public static final String NAME = "onepassword";
    private static final String OP_CLI_EXECUTABLE = "op";

    public OnePasswordCliMasterSource() {
        super("onepassword:");
    }

    @Override
    public String description() {
        return "1Password CLI (secret reference URI should be edited)";
    }

    @Override
    public Optional<String> configTemplate() {
        return Optional.of("onepassword:$SECRET_REFERENCE_URI");
    }

    @Override
    protected String doHandle(String transformed) throws SecDispatcherException {
        try {
            return this.execute1PasswordCli(Arrays.asList("read", transformed, "--no-newline"), 30);
        }
        catch (Exception e) {
            throw new SecDispatcherException(String.format("1Password CLI reported an error reading %s: %s", transformed, e.getMessage()), e);
        }
    }

    @Override
    protected SecDispatcher.ValidationResponse doValidateConfiguration(String transformed) {
        HashMap<SecDispatcher.ValidationResponse.Level, List<String>> report = new HashMap<SecDispatcher.ValidationResponse.Level, List<String>>();
        boolean isValid = false;
        try {
            this.execute1PasswordCli(Collections.singleton("--version"), 2);
            try {
                this.execute1PasswordCli(Arrays.asList("read", transformed, "--no-newline"), 30);
                report.put(SecDispatcher.ValidationResponse.Level.INFO, List.of("Configured 1Password secret reference exists and is accessible!"));
                isValid = true;
            }
            catch (IllegalStateException e) {
                report.put(SecDispatcher.ValidationResponse.Level.ERROR, List.of(String.format("1Password CLI reported an error reading secret item %s: %s", transformed, e.getMessage())));
            }
            catch (IOException e) {
                report.put(SecDispatcher.ValidationResponse.Level.ERROR, List.of(String.format("General issue executing 1Password CLI: %s", e.getMessage())));
            }
        }
        catch (IllegalStateException e) {
            report.put(SecDispatcher.ValidationResponse.Level.ERROR, List.of(String.format("1Password CLI reported an error exposing the version: %s", e.getMessage())));
        }
        catch (IOException e) {
            report.put(SecDispatcher.ValidationResponse.Level.ERROR, List.of(String.format("Seems 1Password CLI is not installed: %s", e.getMessage())));
        }
        return new SecDispatcher.ValidationResponse(this.getClass().getSimpleName(), isValid, report, List.of());
    }

    public String execute1PasswordCli(Collection<String> arguments, int timeoutSeconds) throws IOException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(OP_CLI_EXECUTABLE);
        cmd.addAll(arguments);
        StringWriter output = new StringWriter();
        Process process = new ProcessBuilder(cmd.toArray(new String[0])).start();
        try (BufferedReader reader = process.inputReader();){
            reader.transferTo(output);
        }
        try {
            process.waitFor(timeoutSeconds, TimeUnit.SECONDS);
            StringWriter error = new StringWriter();
            try (BufferedReader reader = process.errorReader();){
                reader.transferTo(error);
            }
            int exitCode = process.exitValue();
            if (exitCode != 0) {
                throw new IllegalStateException(String.format("1Password CLI process exited with code %d, Error: %s", exitCode, error.toString()));
            }
            return output.toString();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("1Password CLI process was interrupted", e);
        }
    }
}

