/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.security.AccessController;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.measure.Unit;
import org.apache.sis.internal.util.FinalFieldSetter;
import org.apache.sis.internal.util.LocalizedParseException;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.internal.util.StandardDateFormat;
import org.apache.sis.measure.Angle;
import org.apache.sis.measure.AngleFormat;
import org.apache.sis.measure.FormatField;
import org.apache.sis.measure.FormattedCharacterIterator;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Localized;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.resources.Errors;

public class RangeFormat
extends Format
implements Localized {
    private static final long serialVersionUID = 2459948572315667868L;
    private static final int MIN_VALUE_FIELD = 0;
    private static final int MAX_VALUE_FIELD = 1;
    private static final int UNIT_FIELD = 2;
    private final int openSet;
    private final int openInclusive;
    private final int openExclusive;
    private final int openExclusiveAlt;
    private final int closeSet;
    private final int closeInclusive;
    private final int closeExclusive;
    private final int closeExclusiveAlt;
    private final String separator;
    private final char minusSign;
    private final String infinity;
    private boolean alternateForm;
    protected final Class<?> elementType;
    protected final Format elementFormat;
    protected final UnitFormat unitFormat;
    private transient Map<Unit<?>, Boolean> insertSpaceBeforeUnit;
    private Locale locale;

    public RangeFormat() {
        this(Locale.getDefault(Locale.Category.FORMAT));
        this.locale = Locale.getDefault(Locale.Category.DISPLAY);
    }

    public RangeFormat(Locale locale) {
        this(locale, Number.class);
    }

    public RangeFormat(Locale locale, TimeZone timeZone) {
        this(locale, Date.class);
        ((DateFormat)this.elementFormat).setTimeZone(timeZone);
    }

    public RangeFormat(Locale locale, Class<?> clazz) throws IllegalArgumentException {
        Object object;
        ArgumentChecks.ensureNonNull("locale", locale);
        ArgumentChecks.ensureNonNull("elementType", clazz);
        this.locale = locale;
        this.elementType = clazz;
        if (Angle.class.isAssignableFrom(clazz)) {
            this.elementFormat = AngleFormat.getInstance(locale);
            this.unitFormat = null;
        } else if (Number.class.isAssignableFrom(clazz)) {
            this.elementFormat = NumberFormat.getNumberInstance(locale);
            this.unitFormat = new UnitFormat(locale);
        } else if (Date.class.isAssignableFrom(clazz) || clazz == Instant.class) {
            this.elementFormat = DateFormat.getDateTimeInstance(3, 3, locale);
            this.unitFormat = null;
        } else if (Temporal.class.isAssignableFrom(clazz)) {
            object = StandardDateFormat.hasDateFields(clazz) ? FormatStyle.SHORT : null;
            FormatStyle formatStyle = StandardDateFormat.hasTimeFields(clazz) ? FormatStyle.SHORT : null;
            this.elementFormat = new DateTimeFormatterBuilder().appendLocalized((FormatStyle)((Object)object), formatStyle).toFormatter(locale).toFormat();
            this.unitFormat = null;
        } else {
            throw new IllegalArgumentException(Errors.format((short)163, clazz));
        }
        object = this.elementFormat instanceof DecimalFormat ? ((DecimalFormat)this.elementFormat).getDecimalFormatSymbols() : DecimalFormatSymbols.getInstance(locale);
        this.minusSign = ((DecimalFormatSymbols)object).getMinusSign();
        this.infinity = ((DecimalFormatSymbols)object).getInfinity();
        this.openSet = 123;
        this.openInclusive = 91;
        this.openExclusive = 40;
        this.openExclusiveAlt = 93;
        this.closeSet = 125;
        this.closeInclusive = 93;
        this.closeExclusive = 41;
        this.closeExclusiveAlt = 91;
        this.separator = "\u2026";
    }

    private boolean isOpen(int n) {
        return n == this.openInclusive || n == this.openExclusive || n == this.openExclusiveAlt;
    }

    private boolean isClose(int n) {
        return n == this.closeInclusive || n == this.closeExclusive || n == this.closeExclusiveAlt;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public String getElementPattern(boolean bl) {
        Format format = this.elementFormat;
        if (format instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)format;
            return bl ? decimalFormat.toLocalizedPattern() : decimalFormat.toPattern();
        }
        if (format instanceof SimpleDateFormat) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)format;
            return bl ? simpleDateFormat.toLocalizedPattern() : simpleDateFormat.toPattern();
        }
        if (format instanceof AngleFormat) {
            return ((AngleFormat)format).toPattern();
        }
        return null;
    }

    public void setElementPattern(String string, boolean bl) {
        Format format = this.elementFormat;
        if (format instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)format;
            if (bl) {
                decimalFormat.applyLocalizedPattern(string);
            } else {
                decimalFormat.applyPattern(string);
            }
        } else if (format instanceof SimpleDateFormat) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)format;
            if (bl) {
                simpleDateFormat.applyLocalizedPattern(string);
            } else {
                simpleDateFormat.applyPattern(string);
            }
        } else if (format instanceof AngleFormat) {
            ((AngleFormat)format).applyPattern(string);
        } else {
            throw new IllegalStateException();
        }
    }

    public boolean isAlternateForm() {
        return this.alternateForm;
    }

    public void setAlternateForm(boolean bl) {
        this.alternateForm = bl;
    }

    private boolean insertSpaceBeforeUnit(Unit<?> unit) {
        Boolean bl;
        if (this.insertSpaceBeforeUnit == null) {
            this.insertSpaceBeforeUnit = new HashMap();
        }
        if ((bl = this.insertSpaceBeforeUnit.get(unit)) == null) {
            String string = this.unitFormat.format(unit);
            bl = !string.isEmpty() && Character.isLetterOrDigit(string.codePointAt(0));
            this.insertSpaceBeforeUnit.put(unit, bl);
        }
        return bl;
    }

    private static int getField(FieldPosition fieldPosition) {
        if (fieldPosition != null) {
            Format.Field field = fieldPosition.getFieldAttribute();
            if (field instanceof Field) {
                return ((Field)field).field;
            }
            return fieldPosition.getField();
        }
        return -1;
    }

    private static Range<?> cast(Object object) throws IllegalArgumentException {
        if (object instanceof Range) {
            return (Range)object;
        }
        String string = object == null ? Errors.format((short)113, "range") : Errors.format((short)43, "range", Range.class, object.getClass());
        throw new IllegalArgumentException(string);
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        this.format(RangeFormat.cast(object), stringBuffer, fieldPosition, null);
        return stringBuffer;
    }

    private void format(Range<?> range, StringBuffer stringBuffer, FieldPosition fieldPosition, FormattedCharacterIterator formattedCharacterIterator) {
        int n = RangeFormat.getField(fieldPosition);
        if (range.isEmpty()) {
            stringBuffer.appendCodePoint(this.openSet);
            if (n >= 0 && n <= 2) {
                int n2 = stringBuffer.length();
                fieldPosition.setBeginIndex(n2);
                fieldPosition.setEndIndex(n2);
            }
            stringBuffer.appendCodePoint(this.closeSet);
            return;
        }
        Object obj = range.getMinValue();
        Object obj2 = range.getMaxValue();
        boolean bl = obj != null && obj.equals(obj2);
        int n3 = 0;
        if (bl) {
            if (n == 0) {
                n = 1;
            }
            n3 = 1;
        }
        stringBuffer.appendCodePoint(bl ? this.openSet : (range.isMinIncluded() ? this.openInclusive : (this.alternateForm ? this.openExclusiveAlt : this.openExclusive)));
        while (n3 <= 2) {
            Object object2;
            switch (n3) {
                case 0: {
                    object2 = this.toFormattable(obj);
                    break;
                }
                case 1: {
                    object2 = this.toFormattable(obj2);
                    break;
                }
                case 2: {
                    object2 = range.unit();
                    break;
                }
                default: {
                    throw new AssertionError(n3);
                }
            }
            int n4 = stringBuffer.length();
            if (object2 == null) {
                switch (n3) {
                    case 0: {
                        stringBuffer.append(this.minusSign != '-' ? (char)this.minusSign : (char)'\u2212');
                    }
                    case 1: {
                        stringBuffer.append(this.infinity);
                    }
                }
            } else {
                Format format2;
                if (n3 == 2) {
                    if (this.insertSpaceBeforeUnit((Unit)object2)) {
                        n4 = stringBuffer.append(' ').length();
                    }
                    format2 = this.unitFormat;
                } else {
                    format2 = this.elementFormat;
                }
                Numerics.useScientificNotationIfNeeded(format2, object2, (format, object) -> {
                    if (formattedCharacterIterator != null) {
                        formattedCharacterIterator.append(format.formatToCharacterIterator(object), stringBuffer);
                    } else {
                        format.format(object, stringBuffer, new FieldPosition(-1));
                    }
                    return null;
                });
            }
            if (formattedCharacterIterator != null) {
                formattedCharacterIterator.addFieldLimit(Field.forCode(n3), object2, n4);
            }
            if (n3 == n) {
                fieldPosition.setBeginIndex(n4);
                fieldPosition.setEndIndex(stringBuffer.length());
            }
            switch (n3) {
                case 0: {
                    stringBuffer.append(' ').append(this.separator).append(' ');
                    break;
                }
                case 1: {
                    stringBuffer.appendCodePoint(bl ? this.closeSet : (range.isMaxIncluded() ? this.closeInclusive : (this.alternateForm ? this.closeExclusiveAlt : this.closeExclusive)));
                }
            }
            ++n3;
        }
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        FormattedCharacterIterator formattedCharacterIterator = new FormattedCharacterIterator(stringBuffer);
        this.format(RangeFormat.cast(object), stringBuffer, null, formattedCharacterIterator);
        return formattedCharacterIterator;
    }

    @Override
    public Object parseObject(String string) throws ParseException {
        return this.parse(string);
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    public Range<?> parse(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        UnconvertibleObjectException unconvertibleObjectException = null;
        try {
            Range<?> range = this.tryParse(string, parsePosition);
            if (range != null) {
                return range;
            }
        }
        catch (UnconvertibleObjectException unconvertibleObjectException2) {
            unconvertibleObjectException = unconvertibleObjectException2;
        }
        throw new LocalizedParseException(this.locale, this.elementType, string, parsePosition).initCause(unconvertibleObjectException);
    }

    public Range<?> parse(String string, ParsePosition parsePosition) {
        Range<?> range;
        int n = parsePosition.getIndex();
        try {
            range = this.tryParse(string, parsePosition);
        }
        catch (UnconvertibleObjectException unconvertibleObjectException) {
            range = null;
        }
        if (range != null) {
            parsePosition.setErrorIndex(-1);
        } else {
            parsePosition.setIndex(n);
        }
        return range;
    }

    private Range<?> tryParse(String string, ParsePosition parsePosition) throws UnconvertibleObjectException {
        Object object;
        Object object2;
        boolean bl;
        boolean bl2;
        Object object3;
        Object object4;
        int n;
        int n2;
        int n3 = string.length();
        int n4 = parsePosition.getIndex();
        while (true) {
            if (n4 >= n3) {
                parsePosition.setErrorIndex(n3);
                return null;
            }
            n2 = string.codePointAt(n4);
            if (!Character.isWhitespace(n2)) break;
            n4 += Character.charCount(n2);
        }
        if (!this.isOpen(n2)) {
            int n5 = n = n2 == this.openSet ? 1 : 0;
            if (n != 0) {
                while ((n4 += Character.charCount(n2)) < n3 && Character.isWhitespace(n2 = string.codePointAt(n4))) {
                }
            }
            if (n != 0 && n2 == this.closeSet) {
                object3 = object4 = this.valueOfNil();
                bl2 = false;
                bl = false;
            } else {
                parsePosition.setIndex(n4);
                object2 = this.elementFormat.parseObject(string, parsePosition);
                if (object2 == null) {
                    return null;
                }
                parsePosition.setErrorIndex(n4);
                object3 = object4 = this.convert(object2);
                n4 = parsePosition.getIndex();
                bl2 = true;
                bl = true;
            }
            if (n != 0) {
                do {
                    if (n4 >= n3) {
                        parsePosition.setErrorIndex(n3);
                        return null;
                    }
                    n2 = string.codePointAt(n4);
                    n4 += Character.charCount(n2);
                } while (Character.isWhitespace(n2));
                if (n2 != this.closeSet) {
                    parsePosition.setErrorIndex(n4 - Character.charCount(n2));
                    return null;
                }
                parsePosition.setIndex(n4);
            }
        } else {
            boolean bl3 = bl = n2 == this.openInclusive;
            do {
                if ((n4 += Character.charCount(n2)) < n3) continue;
                parsePosition.setErrorIndex(n3);
                return null;
            } while (Character.isWhitespace(n2 = string.codePointAt(n4)));
            if (this.isClose(n2)) {
                parsePosition.setErrorIndex(n4);
                object3 = object4 = this.valueOfNil();
                bl2 = false;
                n4 += Character.charCount(n2);
            } else {
                parsePosition.setIndex(n4);
                n = n4;
                object2 = this.elementFormat.parseObject(string, parsePosition);
                if (object2 == null) {
                    if (n2 == this.minusSign || n2 == 8722) {
                        n4 += Character.charCount(n2);
                    }
                    if (!string.startsWith(this.infinity, n4)) {
                        return null;
                    }
                    parsePosition.setIndex(n4 += this.infinity.length());
                }
                parsePosition.setErrorIndex(n);
                object3 = this.convert(object2);
                n4 = parsePosition.getIndex();
                while (true) {
                    if (n4 >= n3) {
                        parsePosition.setErrorIndex(n3);
                        return null;
                    }
                    n2 = string.codePointAt(n4);
                    if (!Character.isWhitespace(n2)) break;
                    n4 += Character.charCount(n2);
                }
                object = this.separator;
                if (string.startsWith((String)object, n4)) {
                    n4 += ((String)object).length();
                    while (true) {
                        if (n4 >= n3) {
                            parsePosition.setErrorIndex(n3);
                            return null;
                        }
                        n2 = string.codePointAt(n4);
                        if (!Character.isWhitespace(n2)) break;
                        n4 += Character.charCount(n2);
                    }
                    parsePosition.setIndex(n4);
                    object2 = this.elementFormat.parseObject(string, parsePosition);
                    if (object2 == null) {
                        if (!string.startsWith(this.infinity, n4)) {
                            return null;
                        }
                        parsePosition.setIndex(n4 += this.infinity.length());
                    }
                    parsePosition.setErrorIndex(n4);
                    object4 = this.convert(object2);
                    n4 = parsePosition.getIndex();
                    while (true) {
                        if (n4 >= n3) {
                            parsePosition.setErrorIndex(n3);
                            return null;
                        }
                        n2 = string.charAt(n4);
                        if (Character.isWhitespace(n2)) {
                            n4 += Character.charCount(n2);
                            continue;
                        }
                        break;
                    }
                } else {
                    object4 = object3;
                }
                if (!this.isClose(n2)) {
                    parsePosition.setErrorIndex(n4);
                    return null;
                }
                n4 += Character.charCount(n2);
                bl2 = n2 == this.closeInclusive;
            }
            parsePosition.setIndex(n4);
        }
        Unit<?> unit = null;
        if (this.unitFormat != null) {
            while (n4 < n3) {
                n2 = string.codePointAt(n4);
                if (Character.isWhitespace(n2)) {
                    n4 += Character.charCount(n2);
                    continue;
                }
                parsePosition.setIndex(n4);
                unit = this.unitFormat.parse(string, parsePosition);
                break;
            }
        }
        if (Number.class.isAssignableFrom(this.elementType)) {
            object2 = this.elementType;
            object = (Number)object3;
            Number number = (Number)object4;
            if (object2 == Number.class) {
                object2 = Numbers.widestClass(Numbers.narrowestClass((Number)object), Numbers.narrowestClass(number));
                object = Numbers.cast((Number)object, object2);
                number = Numbers.cast(number, object2);
            }
            if (object != null && ((Number)object).doubleValue() == Double.NEGATIVE_INFINITY) {
                object = null;
            }
            if (number != null && number.doubleValue() == Double.POSITIVE_INFINITY) {
                number = null;
            }
            if (unit != null) {
                MeasurementRange<Number> measurementRange = new MeasurementRange<Number>((Class<Number>)object2, (Number)object, bl, number, bl2, unit);
                return measurementRange;
            }
            return new NumberRange<Number>((Class<Number>)object2, (Number)object, bl, number, bl2);
        }
        if (Date.class.isAssignableFrom(this.elementType)) {
            return new Range<Date>(Date.class, (Date)object3, bl, (Date)object4, bl2);
        }
        return new Range<Comparable>(this.elementType, (Comparable)object3, bl, (Comparable)object4, bl2);
    }

    private Object convert(Object object) throws UnconvertibleObjectException {
        if (object == null || this.elementType.isInstance(object)) {
            return object;
        }
        if (object instanceof Number && Number.class.isAssignableFrom(this.elementType)) {
            return Numbers.cast((Number)object, this.elementType);
        }
        if (object instanceof Date && this.elementType == Instant.class) {
            return ((Date)object).toInstant();
        }
        throw new UnconvertibleObjectException(Errors.format((short)50, this.elementType, object.getClass()));
    }

    private Object toFormattable(Object object) {
        if (object instanceof Instant && this.elementType == Instant.class) {
            return Date.from((Instant)object);
        }
        return object;
    }

    private Object valueOfNil() {
        Object object = Numbers.valueOfNil(this.elementType);
        if (object == null) {
            object = Date.class.isAssignableFrom(this.elementType) ? new Date() : Integer.valueOf(0);
        }
        return this.convert(object);
    }

    @Override
    public RangeFormat clone() {
        RangeFormat rangeFormat = (RangeFormat)super.clone();
        try {
            ((FinalFieldSetter)((Object)AccessController.doPrivileged(new FinalFieldSetter<RangeFormat>(RangeFormat.class, "elementFormat", "unitFormat")))).set(rangeFormat, this.elementFormat.clone(), this.unitFormat.clone());
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw FinalFieldSetter.cloneFailure(reflectiveOperationException);
        }
        return rangeFormat;
    }

    public static final class Field
    extends FormatField {
        private static final long serialVersionUID = 2000378602311146796L;
        public static final Field MIN_VALUE = new Field("MIN_VALUE", 0);
        public static final Field MAX_VALUE = new Field("MAX_VALUE", 1);
        public static final Field UNIT = new Field("UNIT", 2);

        private Field(String string, int n) {
            super(string, n);
        }

        static Field forCode(int n) {
            switch (n) {
                case 0: {
                    return MIN_VALUE;
                }
                case 1: {
                    return MAX_VALUE;
                }
                case 2: {
                    return UNIT;
                }
            }
            throw new AssertionError(n);
        }
    }
}

