/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketProxy {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int ACCEPT_TIMEOUT_MILLIS = 100;
    public static final int PUMP_SOCKET_TIMEOUT_MS = 100000;
    private URI proxyUrl;
    private URI target;
    private Acceptor acceptor;
    private ServerSocket serverSocket;
    private CountDownLatch closed = new CountDownLatch(1);
    public List<Bridge> connections = new LinkedList<Bridge>();
    private final int listenPort;
    private int receiveBufferSize = -1;
    private boolean pauseAtStart = false;
    private int acceptBacklog = 50;
    private boolean usesSSL;

    public SocketProxy() throws Exception {
        this(0, false);
    }

    public SocketProxy(boolean useSSL) throws Exception {
        this(0, useSSL);
    }

    public SocketProxy(int port, boolean useSSL) throws Exception {
        int listenPort = port;
        this.usesSSL = useSSL;
        this.serverSocket = this.createServerSocket(useSSL);
        this.serverSocket.setReuseAddress(true);
        if (this.receiveBufferSize > 0) {
            this.serverSocket.setReceiveBufferSize(this.receiveBufferSize);
        }
        this.serverSocket.bind(new InetSocketAddress(listenPort), this.acceptBacklog);
        this.listenPort = this.serverSocket.getLocalPort();
    }

    public void open(URI uri) throws Exception {
        this.target = uri;
        this.proxyUrl = this.urlFromSocket(this.target, this.serverSocket);
        this.doOpen();
    }

    public String toString() {
        return "SocketyProxy: port=" + this.listenPort + "; target=" + this.target;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public void setTarget(URI tcpBrokerUri) {
        this.target = tcpBrokerUri;
    }

    private void doOpen() throws Exception {
        this.acceptor = new Acceptor(this.serverSocket, this.target);
        if (this.pauseAtStart) {
            this.acceptor.pause();
        }
        new Thread(null, this.acceptor, "SocketProxy-Acceptor-" + this.serverSocket.getLocalPort()).start();
        this.closed = new CountDownLatch(1);
    }

    public int getListenPort() {
        return this.listenPort;
    }

    private ServerSocket createServerSocket(boolean useSSL) throws Exception {
        if (useSSL) {
            return SSLServerSocketFactory.getDefault().createServerSocket();
        }
        return new ServerSocket();
    }

    private Socket createSocket(boolean useSSL) throws Exception {
        if (useSSL) {
            return SSLSocketFactory.getDefault().createSocket();
        }
        return new Socket();
    }

    public URI getUrl() {
        return this.proxyUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ArrayList<Bridge> connections;
        List<Bridge> list = this.connections;
        synchronized (list) {
            connections = new ArrayList<Bridge>(this.connections);
        }
        log.warn("Closing {} connections to: {}, target: {}", new Object[]{connections.size(), this.getUrl(), this.target});
        for (Bridge con : connections) {
            this.closeConnection(con);
        }
        this.acceptor.close();
        this.closed.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void halfClose() {
        ArrayList<Bridge> connections;
        List<Bridge> list = this.connections;
        synchronized (list) {
            connections = new ArrayList<Bridge>(this.connections);
        }
        if (log.isInfoEnabled()) {
            log.info("halfClose, numConnections= {}", (Object)connections.size());
        }
        for (Bridge con : connections) {
            this.halfCloseConnection(con);
        }
    }

    public boolean waitUntilClosed(long timeoutSeconds) throws InterruptedException {
        return this.closed.await(timeoutSeconds, TimeUnit.SECONDS);
    }

    public void reopen() {
        block5: {
            if (log.isInfoEnabled()) {
                log.info("Re-opening connectivity to {}", (Object)this.getUrl());
            }
            try {
                if (this.proxyUrl == null) {
                    throw new IllegalStateException("Can not call open before open(URI uri).");
                }
                this.serverSocket = this.createServerSocket(this.usesSSL);
                this.serverSocket.setReuseAddress(true);
                if (this.receiveBufferSize > 0) {
                    this.serverSocket.setReceiveBufferSize(this.receiveBufferSize);
                }
                this.serverSocket.bind(new InetSocketAddress(this.proxyUrl.getPort()));
                this.doOpen();
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug("exception on reopen url:{} ", (Object)this.getUrl(), (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        List<Bridge> list = this.connections;
        synchronized (list) {
            if (log.isInfoEnabled()) {
                log.info("pause, numConnections={}", (Object)this.connections.size());
            }
            this.acceptor.pause();
            for (Bridge con : this.connections) {
                con.pause();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goOn() {
        List<Bridge> list = this.connections;
        synchronized (list) {
            if (log.isInfoEnabled()) {
                log.info("goOn, numConnections={}", (Object)this.connections.size());
            }
            for (Bridge con : this.connections) {
                con.goOn();
            }
        }
        this.acceptor.goOn();
    }

    private void closeConnection(Bridge c) {
        try {
            c.close();
        }
        catch (Exception e) {
            log.debug("exception on close of: {}", (Object)c, (Object)e);
        }
    }

    private void halfCloseConnection(Bridge c) {
        try {
            c.halfClose();
        }
        catch (Exception e) {
            log.debug("exception on half close of: {}", (Object)c, (Object)e);
        }
    }

    public boolean isPauseAtStart() {
        return this.pauseAtStart;
    }

    public void setPauseAtStart(boolean pauseAtStart) {
        this.pauseAtStart = pauseAtStart;
    }

    public int getAcceptBacklog() {
        return this.acceptBacklog;
    }

    public void setAcceptBacklog(int acceptBacklog) {
        this.acceptBacklog = acceptBacklog;
    }

    private URI urlFromSocket(URI uri, ServerSocket serverSocket) throws Exception {
        int listenPort = serverSocket.getLocalPort();
        return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), listenPort, uri.getPath(), uri.getQuery(), uri.getFragment());
    }

    public class Acceptor
    implements Runnable {
        private ServerSocket socket;
        private URI target;
        private AtomicReference<CountDownLatch> pause = new AtomicReference();

        public Acceptor(ServerSocket serverSocket, URI uri) throws SocketException {
            this.socket = serverSocket;
            this.target = uri;
            this.pause.set(new CountDownLatch(0));
            this.socket.setSoTimeout(100);
        }

        public void pause() {
            this.pause.set(new CountDownLatch(1));
        }

        public void goOn() {
            this.pause.get().countDown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block10: {
                try {
                    while (!this.socket.isClosed()) {
                        this.pause.get().await();
                        try {
                            Socket source = this.socket.accept();
                            this.pause.get().await();
                            if (SocketProxy.this.receiveBufferSize > 0) {
                                source.setReceiveBufferSize(SocketProxy.this.receiveBufferSize);
                            }
                            if (log.isInfoEnabled()) {
                                log.info("accepted {}, receiveBufferSize: {}", (Object)source, (Object)source.getReceiveBufferSize());
                            }
                            List<Bridge> list = SocketProxy.this.connections;
                            synchronized (list) {
                                SocketProxy.this.connections.add(new Bridge(source, this.target));
                            }
                        }
                        catch (SocketTimeoutException source) {
                        }
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block10;
                    log.debug("acceptor: finished for reason: {}", (Object)e.getLocalizedMessage());
                }
            }
        }

        public void close() {
            try {
                this.socket.close();
                SocketProxy.this.closed.countDown();
                this.goOn();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public class Bridge {
        private Socket receiveSocket;
        private Socket sendSocket;
        private Pump requestThread;
        private Pump responseThread;

        public Bridge(Socket socket, URI target) throws Exception {
            this.receiveSocket = socket;
            this.sendSocket = SocketProxy.this.createSocket(SocketProxy.this.usesSSL);
            if (SocketProxy.this.receiveBufferSize > 0) {
                this.sendSocket.setReceiveBufferSize(SocketProxy.this.receiveBufferSize);
            }
            this.sendSocket.connect(new InetSocketAddress(target.getHost(), target.getPort()));
            this.linkWithThreads(this.receiveSocket, this.sendSocket);
            if (log.isInfoEnabled()) {
                log.info("proxy connection {}, receiveBufferSize={}", (Object)this.sendSocket, (Object)this.sendSocket.getReceiveBufferSize());
            }
        }

        public void goOn() {
            this.responseThread.goOn();
            this.requestThread.goOn();
        }

        public void pause() {
            this.requestThread.pause();
            this.responseThread.pause();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws Exception {
            List<Bridge> list = SocketProxy.this.connections;
            synchronized (list) {
                SocketProxy.this.connections.remove(this);
            }
            this.receiveSocket.close();
            this.sendSocket.close();
        }

        public void halfClose() throws Exception {
            this.receiveSocket.close();
        }

        private void linkWithThreads(Socket source, Socket dest) {
            this.requestThread = new Pump("Request", source, dest);
            this.requestThread.start();
            this.responseThread = new Pump("Response", dest, source);
            this.responseThread.start();
        }

        public class Pump
        extends Thread {
            protected Socket src;
            private Socket destination;
            private AtomicReference<CountDownLatch> pause;

            public Pump(String kind, Socket source, Socket dest) {
                super("SocketProxy-" + kind + "-" + source.getPort() + ":" + dest.getPort());
                this.pause = new AtomicReference();
                this.src = source;
                this.destination = dest;
                this.pause.set(new CountDownLatch(0));
            }

            public void pause() {
                this.pause.set(new CountDownLatch(1));
            }

            public void goOn() {
                this.pause.get().countDown();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                byte[] buf = new byte[1024];
                try {
                    this.src.setSoTimeout(100000);
                }
                catch (SocketException e) {
                    if (e.getMessage().equals("Socket is closed")) {
                        log.warn("Failed to set socket timeout on {} due to: ", (Object)this.src, (Object)e);
                        return;
                    }
                    log.error("Failed to set socket timeout on {} due to ", (Object)this.src, (Object)e);
                    throw new RuntimeException(e);
                }
                InputStream in = null;
                OutputStream out = null;
                try {
                    in = this.src.getInputStream();
                    out = this.destination.getOutputStream();
                    while (true) {
                        int len = -1;
                        try {
                            len = in.read(buf);
                        }
                        catch (SocketTimeoutException ste) {
                            log.warn("Error when reading from {}", (Object)this.src, (Object)ste);
                        }
                        if (len == -1) {
                            log.debug("read eof from: {}", (Object)this.src);
                            break;
                        }
                        this.pause.get().await();
                        if (len <= 0) continue;
                        out.write(buf, 0, len);
                    }
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug("read/write failed, reason: {}", (Object)e.getLocalizedMessage());
                    }
                    try {
                        if (!Bridge.this.receiveSocket.isClosed()) {
                            Bridge.this.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exc) {
                            log.debug("Error when closing InputStream on socket: {}", (Object)this.src, (Object)exc);
                        }
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception exc) {
                            log.debug("{} when closing OutputStream on socket: {}", (Object)exc, (Object)this.destination);
                        }
                    }
                }
            }
        }
    }
}

