/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.authorities.DCTM;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.manifoldcf.authorities.authorities.BaseAuthorityConnector;
import org.apache.manifoldcf.authorities.authorities.DCTM.Messages;
import org.apache.manifoldcf.authorities.interfaces.AuthorizationResponse;
import org.apache.manifoldcf.authorities.system.Logging;
import org.apache.manifoldcf.connectorcommon.interfaces.IKeystoreManager;
import org.apache.manifoldcf.connectorcommon.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.cachemanager.BaseDescription;
import org.apache.manifoldcf.core.interfaces.CacheManagerFactory;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ICacheCreateHandle;
import org.apache.manifoldcf.core.interfaces.ICacheDescription;
import org.apache.manifoldcf.core.interfaces.ICacheHandle;
import org.apache.manifoldcf.core.interfaces.ICacheManager;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.crawler.common.DCTM.DocumentumException;
import org.apache.manifoldcf.crawler.common.DCTM.IDocumentum;
import org.apache.manifoldcf.crawler.common.DCTM.IDocumentumFactory;
import org.apache.manifoldcf.crawler.common.DCTM.IDocumentumObject;
import org.apache.manifoldcf.crawler.common.DCTM.IDocumentumResult;
import org.apache.manifoldcf.ui.util.Encoder;

public class AuthorityConnector
extends BaseAuthorityConnector {
    public static final String CONFIG_PARAM_DOCBASE = "docbasename";
    public static final String CONFIG_PARAM_USERNAME = "docbaseusername";
    public static final String CONFIG_PARAM_PASSWORD = "docbasepassword";
    public static final String CONFIG_PARAM_DOMAIN = "domain";
    public static final String CONFIG_PARAM_CASEINSENSITIVE = "usernamecaseinsensitive";
    public static final String CONFIG_PARAM_USESYSTEMACLS = "usesystemacls";
    public static final String CONFIG_PARAM_CACHELIFETIME = "cachelifetimemins";
    public static final String CONFIG_PARAM_CACHELRUSIZE = "cachelrusize";
    protected String docbaseName = null;
    protected String userName = null;
    protected String password = null;
    protected String domain = null;
    protected boolean caseInsensitive = false;
    protected boolean useSystemAcls = true;
    protected ICacheManager cacheManager = null;
    protected boolean hasSessionParameters = false;
    protected IDocumentum session = null;
    protected long lastSessionFetch = -1L;
    protected static final long timeToRelease = 300000L;
    private String cacheLifetime = null;
    private String cacheLRUsize = null;
    private long responseLifetime = 60000L;
    private int LRUsize = 1000;
    protected static StringSet emptyStringSet = new StringSet();

    public void setThreadContext(IThreadContext tc) throws ManifoldCFException {
        super.setThreadContext(tc);
        this.cacheManager = CacheManagerFactory.make((IThreadContext)tc);
    }

    public void clearThreadContext() {
        super.clearThreadContext();
        this.cacheManager = null;
    }

    protected void getSessionParameters() throws ManifoldCFException {
        if (!this.hasSessionParameters) {
            try {
                this.responseLifetime = Long.parseLong(this.cacheLifetime) * 60L * 1000L;
                this.LRUsize = Integer.parseInt(this.cacheLRUsize);
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException("Cache lifetime or Cache LRU size must be an integer: " + e.getMessage(), (Throwable)e);
            }
            if (this.docbaseName == null || this.docbaseName.length() < 1) {
                throw new ManifoldCFException("Parameter docbasename required but not set");
            }
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("DCTM: Docbase = '" + this.docbaseName + "'"));
            }
            if (this.userName == null || this.userName.length() < 1) {
                throw new ManifoldCFException("Parameter docbaseusername required but not set");
            }
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("DCTM: Username = '" + this.userName + "'"));
            }
            if (this.password == null || this.password.length() < 1) {
                throw new ManifoldCFException("Parameter docbasepassword required but not set");
            }
            Logging.authorityConnectors.debug((Object)"DCTM: Password exists");
            if (this.domain == null) {
                Logging.authorityConnectors.debug((Object)"DCTM: No domain");
            } else {
                Logging.authorityConnectors.debug((Object)("DCTM: Domain = '" + this.domain + "'"));
            }
            if (this.caseInsensitive) {
                Logging.authorityConnectors.debug((Object)"DCTM: Case insensitivity enabled");
            }
            if (this.useSystemAcls) {
                Logging.authorityConnectors.debug((Object)"DCTM: Use system acls enabled");
            }
            this.hasSessionParameters = true;
        }
    }

    protected void getSession() throws ManifoldCFException {
        this.getSessionParameters();
        if (this.session == null) {
            GetSessionThread t = new GetSessionThread();
            try {
                t.start();
                t.join();
                Throwable thr = t.getException();
                if (thr != null) {
                    if (thr instanceof MalformedURLException) {
                        throw (MalformedURLException)thr;
                    }
                    if (thr instanceof NotBoundException) {
                        throw (NotBoundException)thr;
                    }
                    if (thr instanceof RemoteException) {
                        throw (RemoteException)thr;
                    }
                    if (thr instanceof DocumentumException) {
                        throw (DocumentumException)thr;
                    }
                    if (thr instanceof RuntimeException) {
                        throw (RuntimeException)thr;
                    }
                    throw (Error)thr;
                }
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (MalformedURLException e) {
                throw new ManifoldCFException(e.getMessage(), (Throwable)e);
            }
            catch (NotBoundException e) {
                throw new ManifoldCFException("Server not up at the moment: " + e.getMessage(), (Throwable)e);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                this.session = null;
                this.lastSessionFetch = -1L;
                throw new ManifoldCFException("Transient remote exception creating session: " + e.getMessage(), (Throwable)e);
            }
            catch (DocumentumException e) {
                if (e.getType() == 0) {
                    throw new ManifoldCFException("Remote service interruption creating session: " + e.getMessage(), (Throwable)e);
                }
                throw new ManifoldCFException(e.getMessage(), (Throwable)e);
            }
        }
        this.lastSessionFetch = System.currentTimeMillis();
    }

    protected IDocumentumResult performDQLQuery(String query) throws DocumentumException, ManifoldCFException {
        while (true) {
            boolean noSession = this.session == null;
            this.getSession();
            try {
                return this.session.performDQLQuery(query);
            }
            catch (RemoteException e) {
                if (noSession) {
                    throw new ManifoldCFException("Transient error connecting to documentum service", (Throwable)e);
                }
                this.session = null;
                this.lastSessionFetch = -1L;
                continue;
            }
            break;
        }
    }

    protected void checkConnection() throws DocumentumException, ManifoldCFException {
        while (true) {
            boolean noSession = this.session == null;
            this.getSession();
            CheckConnectionThread t = new CheckConnectionThread();
            try {
                t.start();
                t.join();
                Throwable thr = t.getException();
                if (thr != null) {
                    if (thr instanceof RemoteException) {
                        throw (RemoteException)thr;
                    }
                    if (thr instanceof DocumentumException) {
                        throw (DocumentumException)thr;
                    }
                    if (thr instanceof RuntimeException) {
                        throw (RuntimeException)thr;
                    }
                    throw (Error)thr;
                }
                return;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                if (noSession) {
                    throw new ManifoldCFException("Transient error connecting to documentum service", (Throwable)e);
                }
                this.session = null;
                this.lastSessionFetch = -1L;
                continue;
            }
            break;
        }
    }

    protected IDocumentumObject getObjectByQualification(String qualification) throws DocumentumException, ManifoldCFException {
        while (true) {
            boolean noSession = this.session == null;
            this.getSession();
            try {
                return this.session.getObjectByQualification(qualification);
            }
            catch (RemoteException e) {
                if (noSession) {
                    throw new ManifoldCFException("Transient error connecting to documentum service", (Throwable)e);
                }
                this.session = null;
                this.lastSessionFetch = -1L;
                continue;
            }
            break;
        }
    }

    protected String getServerVersion() throws DocumentumException, ManifoldCFException {
        while (true) {
            boolean noSession = this.session == null;
            this.getSession();
            try {
                return this.session.getServerVersion();
            }
            catch (RemoteException e) {
                if (noSession) {
                    throw new ManifoldCFException("Transient error connecting to documentum service", (Throwable)e);
                }
                this.session = null;
                this.lastSessionFetch = -1L;
                continue;
            }
            break;
        }
    }

    protected void releaseCheck() throws ManifoldCFException {
        if (this.lastSessionFetch == -1L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.lastSessionFetch + 300000L) {
            DestroySessionThread t = new DestroySessionThread();
            try {
                t.start();
                t.join();
                Throwable thr = t.getException();
                if (thr != null) {
                    if (thr instanceof RemoteException) {
                        throw (RemoteException)thr;
                    }
                    if (thr instanceof DocumentumException) {
                        throw (DocumentumException)thr;
                    }
                    if (thr instanceof RuntimeException) {
                        throw (RuntimeException)thr;
                    }
                    throw (Error)thr;
                }
                this.session = null;
                this.lastSessionFetch = -1L;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                this.session = null;
                this.lastSessionFetch = -1L;
                Logging.authorityConnectors.warn((Object)"Transient remote exception closing session", (Throwable)e);
            }
            catch (DocumentumException e) {
                if (e.getType() == 0) {
                    Logging.authorityConnectors.warn((Object)"Remote service interruption closing session", (Throwable)e);
                }
                Logging.authorityConnectors.warn((Object)"Error closing session", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationResponse getAuthorizationResponse(String strUserNamePassedIn) throws ManifoldCFException {
        if (Logging.authorityConnectors.isDebugEnabled()) {
            Logging.authorityConnectors.debug((Object)("DCTM: Inside AuthorityConnector.getAuthorizationResponse for user '" + strUserNamePassedIn + "'"));
        }
        this.getSessionParameters();
        AuthorizationResponseDescription objectDescription = new AuthorizationResponseDescription(strUserNamePassedIn, this.docbaseName, this.userName, this.password, this.domain, this.caseInsensitive, this.useSystemAcls, this.responseLifetime, this.LRUsize);
        ICacheHandle ch = this.cacheManager.enterCache(new ICacheDescription[]{objectDescription}, null, null);
        try {
            AuthorizationResponse response;
            ICacheCreateHandle createHandle;
            block9: {
                AuthorizationResponse authorizationResponse;
                createHandle = this.cacheManager.enterCreateSection(ch);
                try {
                    response = (AuthorizationResponse)this.cacheManager.lookupObject(createHandle, (ICacheDescription)objectDescription);
                    if (response == null) break block9;
                    authorizationResponse = response;
                }
                catch (Throwable throwable) {
                    this.cacheManager.leaveCreateSection(createHandle);
                    throw throwable;
                }
                this.cacheManager.leaveCreateSection(createHandle);
                return authorizationResponse;
            }
            response = this.getAuthorizationResponseUncached(strUserNamePassedIn);
            this.cacheManager.saveObject(createHandle, (ICacheDescription)objectDescription, (Object)response);
            AuthorizationResponse authorizationResponse = response;
            this.cacheManager.leaveCreateSection(createHandle);
            return authorizationResponse;
        }
        finally {
            this.cacheManager.leaveCache(ch);
        }
    }

    protected AuthorizationResponse getAuthorizationResponseUncached(String strUserNamePassedIn) throws ManifoldCFException {
        if (Logging.authorityConnectors.isDebugEnabled()) {
            Logging.authorityConnectors.debug((Object)("DCTM: Inside AuthorityConnector.getAuthorizationResponseUncached for user '" + strUserNamePassedIn + "'"));
        }
        try {
            String strAccessToken;
            String strUserName = strUserNamePassedIn;
            while (true) {
                boolean noSession = this.session == null;
                this.getSession();
                GetUserAccessIDThread t = new GetUserAccessIDThread(strUserName);
                try {
                    t.start();
                    t.join();
                    Throwable thr = t.getException();
                    if (thr != null) {
                        if (thr instanceof RemoteException) {
                            throw (RemoteException)thr;
                        }
                        if (thr instanceof DocumentumException) {
                            throw (DocumentumException)thr;
                        }
                        if (thr instanceof RuntimeException) {
                            throw (RuntimeException)thr;
                        }
                        throw (Error)thr;
                    }
                    if (t.getResponse() != null) {
                        return t.getResponse();
                    }
                    strAccessToken = t.getUserID();
                }
                catch (InterruptedException e) {
                    t.interrupt();
                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                }
                catch (RemoteException e) {
                    Throwable e2 = e.getCause();
                    if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                        throw new ManifoldCFException(e2.getMessage(), e2, 2);
                    }
                    if (noSession) {
                        Logging.authorityConnectors.warn((Object)("DCTM: Transient error checking authorization: " + e.getMessage()), (Throwable)e);
                        return RESPONSE_UNREACHABLE;
                    }
                    this.session = null;
                    this.lastSessionFetch = -1L;
                    continue;
                }
                break;
            }
            Object strDQL = "SELECT DISTINCT A.owner_name, A.object_name FROM dm_acl A  WHERE ";
            if (!this.useSystemAcls) {
                strDQL = (String)strDQL + "A.object_name NOT LIKE 'dm_%' AND (";
            }
            strDQL = (String)strDQL + "(any (A.r_accessor_name IN (" + AuthorityConnector.quoteDQLString(strAccessToken) + ", 'dm_world') AND r_accessor_permit>2) OR (any (A.r_accessor_name='dm_owner' AND A.r_accessor_permit>2) AND A.owner_name=" + AuthorityConnector.quoteDQLString(strAccessToken) + ") OR (ANY (A.r_accessor_name in (SELECT G.group_name FROM dm_group G WHERE ANY G.i_all_users_names = " + AuthorityConnector.quoteDQLString(strAccessToken) + ") AND r_accessor_permit>2))) ";
            strDQL = (String)strDQL + "AND NOT (any (A.r_accessor_name IN (" + AuthorityConnector.quoteDQLString(strAccessToken) + ", 'dm_world') AND r_accessor_permit<=2) OR (any (A.r_accessor_name='dm_owner' AND A.r_accessor_permit<=2) AND A.owner_name=" + AuthorityConnector.quoteDQLString(strAccessToken) + ") OR (ANY (A.r_accessor_name in (SELECT G.group_name FROM dm_group G WHERE ANY G.i_all_users_names = " + AuthorityConnector.quoteDQLString(strAccessToken) + ") AND r_accessor_permit<=2)))";
            if (!this.useSystemAcls) {
                strDQL = (String)strDQL + ")";
            }
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("DCTM: About to execute query= (" + (String)strDQL + ")"));
            }
            while (true) {
                boolean noSession = this.session == null;
                this.getSession();
                ArrayList list = new ArrayList();
                GetAccessTokensThread t = new GetAccessTokensThread((String)strDQL, list);
                try {
                    t.start();
                    t.join();
                    Throwable thr = t.getException();
                    if (thr != null) {
                        if (thr instanceof RemoteException) {
                            throw (RemoteException)thr;
                        }
                        if (thr instanceof DocumentumException) {
                            throw (DocumentumException)thr;
                        }
                        if (thr instanceof RuntimeException) {
                            throw (RuntimeException)thr;
                        }
                        throw (Error)thr;
                    }
                    Logging.authorityConnectors.debug((Object)"DCTM: Done processing authorization query");
                    String[] strArrayRetVal = new String[list.size()];
                    for (int intObjectIdIndex = 0; intObjectIdIndex < strArrayRetVal.length; ++intObjectIdIndex) {
                        strArrayRetVal[intObjectIdIndex] = (String)list.get(intObjectIdIndex);
                    }
                    return new AuthorizationResponse(strArrayRetVal, 0);
                }
                catch (InterruptedException e) {
                    t.interrupt();
                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                }
                catch (RemoteException e) {
                    Throwable e2 = e.getCause();
                    if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                        throw new ManifoldCFException(e2.getMessage(), e2, 2);
                    }
                    if (noSession) {
                        Logging.authorityConnectors.warn((Object)("DCTM: Transient error checking authorization: " + e.getMessage()), (Throwable)e);
                        return RESPONSE_UNREACHABLE;
                    }
                    this.session = null;
                    this.lastSessionFetch = -1L;
                    continue;
                }
                break;
            }
        }
        catch (DocumentumException e) {
            if (e.getType() == 0) {
                Logging.authorityConnectors.warn((Object)("DCTM: Transient error checking authorization: " + e.getMessage()), (Throwable)e);
                return RESPONSE_UNREACHABLE;
            }
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
    }

    public AuthorizationResponse getDefaultAuthorizationResponse(String userName) {
        return RESPONSE_UNREACHABLE;
    }

    protected static String insensitiveMatch(boolean insensitive, String field, String value) {
        StringBuilder sb = new StringBuilder();
        if (insensitive) {
            sb.append("upper(").append(field).append(")");
        } else {
            sb.append(field);
        }
        sb.append("=");
        if (insensitive) {
            sb.append(AuthorityConnector.quoteDQLString(value.toUpperCase(Locale.ROOT)));
        } else {
            sb.append(AuthorityConnector.quoteDQLString(value));
        }
        return sb.toString();
    }

    protected static String quoteDQLString(String value) {
        StringBuilder sb = new StringBuilder("'");
        int i = 0;
        while (i < value.length()) {
            char x;
            if ((x = value.charAt(i++)) == '\'') {
                sb.append(x);
            }
            sb.append(x);
        }
        sb.append("'");
        return sb.toString();
    }

    public String check() throws ManifoldCFException {
        try {
            try {
                this.checkConnection();
                return super.check();
            }
            catch (DocumentumException e) {
                if (e.getType() == 0) {
                    return "Connection temporarily failed: " + e.getMessage();
                }
                return "Connection failed: " + e.getMessage();
            }
        }
        catch (ManifoldCFException e) {
            return "Connection failed: " + e.getMessage();
        }
    }

    public void connect(ConfigParams configParams) {
        String strCaseInsensitive;
        super.connect(configParams);
        this.docbaseName = configParams.getParameter(CONFIG_PARAM_DOCBASE);
        this.userName = configParams.getParameter(CONFIG_PARAM_USERNAME);
        this.password = configParams.getObfuscatedParameter(CONFIG_PARAM_PASSWORD);
        this.domain = configParams.getParameter(CONFIG_PARAM_DOMAIN);
        if (this.domain == null || this.domain.length() < 1) {
            this.domain = null;
        }
        this.caseInsensitive = (strCaseInsensitive = configParams.getParameter(CONFIG_PARAM_CASEINSENSITIVE)) != null && strCaseInsensitive.equals("true");
        String strUseSystemAcls = configParams.getParameter(CONFIG_PARAM_USESYSTEMACLS);
        this.useSystemAcls = strUseSystemAcls == null || strUseSystemAcls.equals("true");
        this.cacheLifetime = configParams.getParameter(CONFIG_PARAM_CACHELIFETIME);
        if (this.cacheLifetime == null) {
            this.cacheLifetime = "1";
        }
        this.cacheLRUsize = configParams.getParameter(CONFIG_PARAM_CACHELRUSIZE);
        if (this.cacheLRUsize == null) {
            this.cacheLRUsize = "1000";
        }
    }

    public boolean isConnected() {
        return this.session != null;
    }

    public void disconnect() throws ManifoldCFException {
        this.hasSessionParameters = false;
        if (this.session != null) {
            DestroySessionThread t = new DestroySessionThread();
            try {
                t.start();
                t.join();
                Throwable thr = t.getException();
                if (thr != null) {
                    if (thr instanceof RemoteException) {
                        throw (RemoteException)thr;
                    }
                    if (thr instanceof DocumentumException) {
                        throw (DocumentumException)thr;
                    }
                    if (thr instanceof RuntimeException) {
                        throw (RuntimeException)thr;
                    }
                    throw (Error)thr;
                }
                this.session = null;
                this.lastSessionFetch = -1L;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                this.session = null;
                this.lastSessionFetch = -1L;
                Logging.authorityConnectors.warn((Object)("DCTM: Transient remote exception closing session: " + e.getMessage()), (Throwable)e);
            }
            catch (DocumentumException e) {
                if (e.getType() == 0) {
                    Logging.authorityConnectors.warn((Object)("DCTM: Remote service interruption closing session: " + e.getMessage()), (Throwable)e);
                }
                Logging.authorityConnectors.warn((Object)("DCTM: Error closing session: " + e.getMessage()), (Throwable)e);
            }
        }
        this.docbaseName = null;
        this.userName = null;
        this.password = null;
        this.domain = null;
        this.cacheLifetime = null;
        this.cacheLRUsize = null;
    }

    public void poll() throws ManifoldCFException {
        this.releaseCheck();
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "DCTM.Docbase"));
        tabsArray.add(Messages.getString(locale, "DCTM.UserMapping"));
        tabsArray.add(Messages.getString(locale, "DCTM.SystemACLs"));
        tabsArray.add(Messages.getString(locale, "DCTM.Cache"));
        out.print("<script type=\"text/javascript\">\n<!--\nfunction checkConfigForSave()\n{\n  if (editconnection.docbasename.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "DCTM.PleaseSupplyTheNameOfADocbase") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "DCTM.Docbase") + "\");\n    editconnection.docbasename.focus();\n    return false;\n  }\n  if (editconnection.docbaseusername.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "DCTM.TheConnectionRequiresAValidDocumentumUserName") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "DCTM.Docbase") + "\");\n    editconnection.docbaseusername.focus();\n    return false;\n  }\n  if (editconnection.docbasepassword.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "DCTM.TheConnectionRequiresTheDocumentumUsersPassword") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "DCTM.Docbase") + "\");\n    editconnection.docbasepassword.focus();\n    return false;\n  }\n  if (editconnection.cachelifetime.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "DCTM.CacheLifetimeCannotBeNull") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "DCTM.Cache") + "\");\n    editconnection.cachelifetime.focus();\n    return false;\n  }\n  if (editconnection.cachelifetime.value != \"\" && !isInteger(editconnection.cachelifetime.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "DCTM.CacheLifetimeMustBeAnInteger") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "DCTM.Cache") + "\");\n    editconnection.cachelifetime.focus();\n    return false;\n  }\n  if (editconnection.cachelrusize.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "DCTM.CacheLRUSizeCannotBeNull") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "DCTM.Cache") + "\");\n    editconnection.cachelrusize.focus();\n    return false;\n  }\n  if (editconnection.cachelrusize.value != \"\" && !isInteger(editconnection.cachelrusize.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "DCTM.CacheLRUSizeMustBeAnInteger") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "DCTM.Cache") + "\");\n    editconnection.cachelrusize.focus();\n    return false;\n  }\n  return true;\n}\n\n//-->\n</script>\n");
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        String cacheLRUsize;
        String cacheLifetime;
        String useSystemAcls;
        String caseInsensitiveUser;
        String docbasePassword;
        String docbaseUserName;
        String docbaseName = parameters.getParameter(CONFIG_PARAM_DOCBASE);
        if (docbaseName == null) {
            docbaseName = "";
        }
        if ((docbaseUserName = parameters.getParameter(CONFIG_PARAM_USERNAME)) == null) {
            docbaseUserName = "";
        }
        docbasePassword = (docbasePassword = parameters.getObfuscatedParameter(CONFIG_PARAM_PASSWORD)) == null ? "" : out.mapPasswordToKey(docbasePassword);
        String docbaseDomain = parameters.getParameter(CONFIG_PARAM_DOMAIN);
        if (docbaseDomain == null) {
            docbaseDomain = "";
        }
        if ((caseInsensitiveUser = parameters.getParameter(CONFIG_PARAM_CASEINSENSITIVE)) == null) {
            caseInsensitiveUser = "false";
        }
        if ((useSystemAcls = parameters.getParameter(CONFIG_PARAM_USESYSTEMACLS)) == null) {
            useSystemAcls = "true";
        }
        if ((cacheLifetime = parameters.getParameter(CONFIG_PARAM_CACHELIFETIME)) == null) {
            cacheLifetime = "1";
        }
        if ((cacheLRUsize = parameters.getParameter(CONFIG_PARAM_CACHELRUSIZE)) == null) {
            cacheLRUsize = "1000";
        }
        if (tabName.equals(Messages.getString(locale, "DCTM.Docbase"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "DCTM.DocbaseName") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"32\" name=\"docbasename\" value=\"" + Encoder.attributeEscape((String)docbaseName) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "DCTM.DocbaseUserName") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"32\" name=\"docbaseusername\" value=\"" + Encoder.attributeEscape((String)docbaseUserName) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "DCTM.DocbasePassword") + "</nobr></td>\n    <td class=\"value\"><input type=\"password\" size=\"32\" name=\"docbasepassword\" value=\"" + Encoder.attributeEscape((String)docbasePassword) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "DCTM.DocbaseDomain") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"32\" name=\"docbasedomain\" value=\"" + Encoder.attributeEscape((String)docbaseDomain) + "\"/></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"docbasename\" value=\"" + Encoder.attributeEscape((String)docbaseName) + "\"/>\n<input type=\"hidden\" name=\"docbaseusername\" value=\"" + Encoder.attributeEscape((String)docbaseUserName) + "\"/>\n<input type=\"hidden\" name=\"docbasepassword\" value=\"" + Encoder.attributeEscape((String)docbasePassword) + "\"/>\n<input type=\"hidden\" name=\"docbasedomain\" value=\"" + Encoder.attributeEscape((String)docbaseDomain) + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "DCTM.UserMapping"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "DCTM.AuthenticationUsernameMatching") + "</nobr></td>\n    <td class=\"value\">\n      <table class=\"displaytable\">\n        <tr>\n          <td class=\"description\"><input name=\"usernamecaseinsensitive\" type=\"radio\" value=\"true\" " + (caseInsensitiveUser.equals("true") ? "checked=\"true\"" : "") + " /></td>\n          <td class=\"value\"><nobr>" + Messages.getBodyString(locale, "DCTM.CaseInsensitive") + "</nobr></td>\n        </tr>\n        <tr>\n          <td class=\"description\"><input name=\"usernamecaseinsensitive\" type=\"radio\" value=\"false\" " + (!caseInsensitiveUser.equals("true") ? "checked=\"true\"" : "") + " /></td>\n          <td class=\"value\"><nobr>" + Messages.getBodyString(locale, "DCTM.CaseSensitive") + "</nobr></td>\n        </tr>\n      </table>\n    </td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"usernamecaseinsensitive\" value=\"" + caseInsensitiveUser + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "DCTM.SystemACLs"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "DCTM.UseSystemAcls") + "</nobr></td>\n    <td class=\"value\">\n      <table class=\"displaytable\">\n        <tr>\n          <td class=\"description\"><input name=\"usesystemacls\" type=\"radio\" value=\"true\" " + (useSystemAcls.equals("true") ? "checked=\"true\"" : "") + " /></td>\n          <td class=\"value\"><nobr>" + Messages.getBodyString(locale, "DCTM.UseSystemAcls") + "</nobr></td>\n        </tr>\n        <tr>\n          <td class=\"description\"><input name=\"usesystemacls\" type=\"radio\" value=\"false\" " + (!useSystemAcls.equals("true") ? "checked=\"true\"" : "") + " /></td>\n          <td class=\"value\"><nobr>" + Messages.getBodyString(locale, "DCTM.DontUseSystemAcls") + "</nobr></td>\n        </tr>\n      </table>\n    </td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"usesystemacls\" value=\"" + useSystemAcls + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "DCTM.Cache"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "DCTM.CacheLifetime") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"5\" name=\"cachelifetime\" value=\"" + Encoder.attributeEscape((String)cacheLifetime) + "\"/> " + Messages.getBodyString(locale, "DCTM.minutes") + "</td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "DCTM.CacheLRUSize") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"5\" name=\"cachelrusize\" value=\"" + Encoder.attributeEscape((String)cacheLRUsize) + "\"/></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"cachelifetime\" value=\"" + Encoder.attributeEscape((String)cacheLifetime) + "\"/>\n<input type=\"hidden\" name=\"cachelrusize\" value=\"" + Encoder.attributeEscape((String)cacheLRUsize) + "\"/>\n");
        }
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String cacheLRUsize;
        String cacheLifetime;
        String useSystemAcls;
        String caseInsensitiveUser;
        String docbaseDomain;
        String docbasePassword;
        String docbaseUserName;
        String docbaseName = variableContext.getParameter(CONFIG_PARAM_DOCBASE);
        if (docbaseName != null) {
            parameters.setParameter(CONFIG_PARAM_DOCBASE, docbaseName);
        }
        if ((docbaseUserName = variableContext.getParameter(CONFIG_PARAM_USERNAME)) != null) {
            parameters.setParameter(CONFIG_PARAM_USERNAME, docbaseUserName);
        }
        if ((docbasePassword = variableContext.getParameter(CONFIG_PARAM_PASSWORD)) != null) {
            parameters.setObfuscatedParameter(CONFIG_PARAM_PASSWORD, variableContext.mapKeyToPassword(docbasePassword));
        }
        if ((docbaseDomain = variableContext.getParameter("docbasedomain")) != null) {
            parameters.setParameter(CONFIG_PARAM_DOMAIN, docbaseDomain);
        }
        if ((caseInsensitiveUser = variableContext.getParameter(CONFIG_PARAM_CASEINSENSITIVE)) != null) {
            parameters.setParameter(CONFIG_PARAM_CASEINSENSITIVE, caseInsensitiveUser);
        }
        if ((useSystemAcls = variableContext.getParameter(CONFIG_PARAM_USESYSTEMACLS)) != null) {
            parameters.setParameter(CONFIG_PARAM_USESYSTEMACLS, useSystemAcls);
        }
        if ((cacheLifetime = variableContext.getParameter("cachelifetime")) != null) {
            parameters.setParameter(CONFIG_PARAM_CACHELIFETIME, cacheLifetime);
        }
        if ((cacheLRUsize = variableContext.getParameter(CONFIG_PARAM_CACHELRUSIZE)) != null) {
            parameters.setParameter(CONFIG_PARAM_CACHELRUSIZE, cacheLRUsize);
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        out.print("<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\" colspan=\"1\"><nobr>" + Messages.getBodyString(locale, "DCTM.Parameters") + "</nobr></td>\n    <td class=\"value\" colspan=\"3\">\n");
        Iterator iter = parameters.listParameters();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            String value = parameters.getParameter(param);
            if (param.length() >= "password".length() && param.substring(param.length() - "password".length()).equalsIgnoreCase("password")) {
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=********</nobr><br/>\n");
                continue;
            }
            if (param.length() >= "keystore".length() && param.substring(param.length() - "keystore".length()).equalsIgnoreCase("keystore")) {
                IKeystoreManager kmanager = KeystoreManagerFactory.make((String)"", (String)value);
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=&lt;" + Integer.toString(kmanager.getContents().length) + " " + Messages.getBodyString(locale, "DCTM.certificate") + "&gt;</nobr><br/>\n");
                continue;
            }
            out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=" + Encoder.bodyEscape((String)value) + "</nobr><br/>\n");
        }
        out.print("    </td>\n  </tr>\n</table>\n");
    }

    protected static class AuthorizationResponseDescription
    extends BaseDescription {
        protected String userName;
        protected String docbaseName;
        protected String adminUserName;
        protected String adminPassword;
        protected String domain;
        protected boolean caseInsensitive;
        protected boolean useSystemACLs;
        protected long expirationTime = -1L;
        protected long responseLifetime;

        public AuthorizationResponseDescription(String userName, String docbaseName, String adminUserName, String adminPassword, String domain, boolean caseInsensitive, boolean useSystemACLs, long responseLifetime, int LRUsize) {
            super("DocumentumDirectoryAuthority", LRUsize);
            this.userName = userName;
            this.docbaseName = docbaseName;
            this.adminUserName = adminUserName;
            this.adminPassword = adminPassword;
            this.domain = domain;
            this.caseInsensitive = caseInsensitive;
            this.useSystemACLs = useSystemACLs;
            this.responseLifetime = responseLifetime;
        }

        public StringSet getObjectKeys() {
            return emptyStringSet;
        }

        public String getCriticalSectionName() {
            return ((Object)((Object)this)).getClass().getName() + "-" + this.userName + "-" + this.docbaseName + "-" + this.adminUserName + "-" + this.adminPassword + "-" + (this.domain == null ? "NULL" : this.domain) + "-" + (this.caseInsensitive ? "true" : "false") + "-" + (this.useSystemACLs ? "true" : "false");
        }

        public long getObjectExpirationTime(long currentTime) {
            if (this.expirationTime == -1L) {
                this.expirationTime = currentTime + this.responseLifetime;
            }
            return this.expirationTime;
        }

        public int hashCode() {
            return this.userName.hashCode() + this.docbaseName.hashCode() + this.adminUserName.hashCode() + this.adminPassword.hashCode() + (this.domain == null ? 0 : this.domain.hashCode()) + (this.caseInsensitive ? 1 : 0) + (this.useSystemACLs ? 1 : 0);
        }

        public boolean equals(Object o) {
            if (!(o instanceof AuthorizationResponseDescription)) {
                return false;
            }
            AuthorizationResponseDescription ard = (AuthorizationResponseDescription)((Object)o);
            return ard.userName.equals(this.userName) && ard.docbaseName.equals(this.docbaseName) && ard.adminUserName.equals(this.adminUserName) && ard.adminPassword.equals(this.adminPassword) && (ard.domain == null || this.domain == null ? ard.domain == this.domain : ard.domain.equals(this.domain)) && ard.caseInsensitive == this.caseInsensitive && ard.useSystemACLs == this.useSystemACLs;
        }
    }

    protected class GetAccessTokensThread
    extends Thread {
        protected String strDQL;
        protected ArrayList list;
        protected Throwable exception = null;

        public GetAccessTokensThread(String strDQL, ArrayList list) {
            this.setDaemon(true);
            this.strDQL = strDQL;
            this.list = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try (IDocumentumResult result = AuthorityConnector.this.session.performDQLQuery(this.strDQL);){
                if (Logging.authorityConnectors.isDebugEnabled()) {
                    Logging.authorityConnectors.debug((Object)"DCTM: Collection returned.");
                }
                while (result.isValidRow()) {
                    String strObjectName = result.getStringValue("object_name");
                    String strOwnerName = result.getStringValue("owner_name");
                    String strFullTokenName = AuthorityConnector.this.docbaseName + ":" + strOwnerName + "." + strObjectName;
                    this.list.add(strFullTokenName);
                    if (Logging.authorityConnectors.isDebugEnabled()) {
                        Logging.authorityConnectors.debug((Object)("DCTM: ACL being added: " + strFullTokenName));
                    }
                    result.nextRow();
                }
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    protected class GetUserAccessIDThread
    extends Thread {
        protected String strUserName;
        protected Throwable exception = null;
        protected String rval = null;
        protected AuthorizationResponse response = null;

        public GetUserAccessIDThread(String strUserName) {
            this.setDaemon(true);
            this.strUserName = strUserName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String serverVersion = AuthorityConnector.this.session.getServerVersion();
                boolean hasLoginNameColumn = serverVersion.compareTo("5.3.") >= 0;
                IDocumentumObject object = null;
                try {
                    if (hasLoginNameColumn) {
                        object = AuthorityConnector.this.getObjectByQualification("dm_user where " + AuthorityConnector.insensitiveMatch(AuthorityConnector.this.caseInsensitive, "user_login_name", this.strUserName));
                    }
                    if (!object.exists()) {
                        object = AuthorityConnector.this.getObjectByQualification("dm_user where " + AuthorityConnector.insensitiveMatch(AuthorityConnector.this.caseInsensitive, "user_os_name", this.strUserName));
                    }
                    if (!object.exists()) {
                        if (Logging.authorityConnectors.isDebugEnabled()) {
                            Logging.authorityConnectors.debug((Object)("DCTM: No user found for username '" + this.strUserName + "'"));
                        }
                        this.response = RESPONSE_USERNOTFOUND;
                        return;
                    }
                    if (object.getUserState() != 0) {
                        if (Logging.authorityConnectors.isDebugEnabled()) {
                            Logging.authorityConnectors.debug((Object)("DCTM: User found for username '" + this.strUserName + "' but the account is not active."));
                        }
                        this.response = RESPONSE_USERUNAUTHORIZED;
                        return;
                    }
                    this.rval = object.getUserName();
                }
                finally {
                    if (object != null) {
                        object.release();
                    }
                }
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public Throwable getException() {
            return this.exception;
        }

        public String getUserID() {
            return this.rval;
        }

        public AuthorizationResponse getResponse() {
            return this.response;
        }
    }

    protected class DestroySessionThread
    extends Thread {
        protected Throwable exception = null;

        public DestroySessionThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                AuthorityConnector.this.session.destroySession();
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    protected class CheckConnectionThread
    extends Thread {
        protected Throwable exception = null;

        public CheckConnectionThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                AuthorityConnector.this.session.checkConnection();
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    protected class GetSessionThread
    extends Thread {
        protected Throwable exception = null;

        public GetSessionThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                IDocumentumFactory df = (IDocumentumFactory)Naming.lookup("rmi://127.0.0.1:8300/documentum_factory");
                IDocumentum newSession = df.make();
                newSession.createSession(AuthorityConnector.this.docbaseName, AuthorityConnector.this.userName, AuthorityConnector.this.password, AuthorityConnector.this.domain);
                AuthorityConnector.this.session = newSession;
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }
}

