/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.solr;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.net.ConnectException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.manifoldcf.agents.output.solr.ModifiedCloudHttp2SolrClient;
import org.apache.manifoldcf.agents.output.solr.ModifiedLBSolrClient;
import org.apache.manifoldcf.agents.output.solr.ModifiedUpdateRequest;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.V2RequestSupport;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.IsUpdateRequest;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.request.V2Request;
import org.apache.solr.client.solrj.routing.ReplicaListTransformer;
import org.apache.solr.client.solrj.routing.RequestReplicaListTransformerGenerator;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.ToleratedUpdateError;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.ImplicitDocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CommonParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.Hash;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class ModifiedCloudSolrClient
extends SolrClient {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private volatile String defaultCollection;
    private static final int MAX_STALE_RETRIES = Integer.parseInt(System.getProperty("cloudSolrClientMaxStaleRetries", "5"));
    private final Random rand = new Random();
    private final boolean updatesToLeaders;
    private final boolean directUpdatesToLeadersOnly;
    private final RequestReplicaListTransformerGenerator requestRLTGenerator;
    boolean parallelUpdates;
    private ExecutorService threadPool = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)new SolrNamedThreadFactory("CloudSolrClient ThreadPool"));
    public static final String STATE_VERSION = "_stateVer_";
    private long retryExpiryTime = TimeUnit.NANOSECONDS.convert(3L, TimeUnit.SECONDS);
    private final Set<String> NON_ROUTABLE_PARAMS = new HashSet<String>();
    private volatile List<Object> locks;
    protected final StateCache collectionStateCache;

    public void setRetryExpiryTime(int secs) {
        this.retryExpiryTime = TimeUnit.NANOSECONDS.convert(secs, TimeUnit.SECONDS);
    }

    protected ModifiedCloudSolrClient(boolean updatesToLeaders, boolean parallelUpdates, boolean directUpdatesToLeadersOnly) {
        this.NON_ROUTABLE_PARAMS.add("expungeDeletes");
        this.NON_ROUTABLE_PARAMS.add("maxSegments");
        this.NON_ROUTABLE_PARAMS.add("commit");
        this.NON_ROUTABLE_PARAMS.add("waitSearcher");
        this.NON_ROUTABLE_PARAMS.add("openSearcher");
        this.NON_ROUTABLE_PARAMS.add("softCommit");
        this.NON_ROUTABLE_PARAMS.add("prepareCommit");
        this.NON_ROUTABLE_PARAMS.add("optimize");
        this.locks = ModifiedCloudSolrClient.objectList(3);
        this.collectionStateCache = new StateCache();
        this.updatesToLeaders = updatesToLeaders;
        this.parallelUpdates = parallelUpdates;
        this.directUpdatesToLeadersOnly = directUpdatesToLeadersOnly;
        this.requestRLTGenerator = new RequestReplicaListTransformerGenerator();
    }

    public void setCollectionCacheTTl(int seconds) {
        assert (seconds > 0);
        this.collectionStateCache.timeToLive = (long)seconds * 1000L;
    }

    protected abstract ModifiedLBSolrClient getLbClient();

    public abstract ClusterStateProvider getClusterStateProvider();

    public ClusterState getClusterState() {
        return this.getClusterStateProvider().getClusterState();
    }

    protected abstract boolean wasCommError(Throwable var1);

    public void close() throws IOException {
        if (this.threadPool != null && !this.threadPool.isShutdown()) {
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.threadPool);
            this.threadPool = null;
        }
    }

    public ResponseParser getParser() {
        return this.getLbClient().getParser();
    }

    public void setParser(ResponseParser processor) {
        this.getLbClient().setParser(processor);
    }

    public RequestWriter getRequestWriter() {
        return this.getLbClient().getRequestWriter();
    }

    public void setRequestWriter(RequestWriter requestWriter) {
        this.getLbClient().setRequestWriter(requestWriter);
    }

    public void setDefaultCollection(String collection) {
        this.defaultCollection = collection;
    }

    public String getDefaultCollection() {
        return this.defaultCollection;
    }

    public boolean isParallelUpdates() {
        return this.parallelUpdates;
    }

    public void connect() {
        this.getClusterStateProvider().connect();
    }

    public void connect(long duration, TimeUnit timeUnit) throws TimeoutException, InterruptedException {
        if (log.isInfoEnabled()) {
            log.info("Waiting for {} {} for cluster at {} to be ready", new Object[]{duration, timeUnit, this.getClusterStateProvider()});
        }
        long timeout = System.nanoTime() + timeUnit.toNanos(duration);
        while (System.nanoTime() < timeout) {
            try {
                this.connect();
                if (log.isInfoEnabled()) {
                    log.info("Cluster at {} ready", (Object)this.getClusterStateProvider());
                }
                return;
            }
            catch (RuntimeException runtimeException) {
                TimeUnit.MILLISECONDS.sleep(250L);
            }
        }
        throw new TimeoutException("Timed out waiting for cluster");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NamedList<Object> directUpdate(AbstractUpdateRequest request, String collection) throws SolrServerException {
        String routeField;
        ModifiedUpdateRequest updateRequest = (ModifiedUpdateRequest)request;
        ModifiableSolrParams params = request.getParams();
        ModifiableSolrParams routableParams = new ModifiableSolrParams();
        ModifiableSolrParams nonRoutableParams = new ModifiableSolrParams();
        if (params != null) {
            nonRoutableParams.add((SolrParams)params);
            routableParams.add((SolrParams)params);
            for (String param : this.NON_ROUTABLE_PARAMS) {
                routableParams.remove(param);
            }
        } else {
            params = new ModifiableSolrParams();
        }
        if (collection == null) {
            throw new SolrServerException("No collection param specified on request and no default collection has been set.");
        }
        List aliasedCollections = this.getClusterStateProvider().resolveAlias(collection);
        if (!this.getClusterStateProvider().isRoutedAlias(collection) && aliasedCollections.size() != 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Update request to non-routed multi-collection alias not supported: " + collection + " -> " + aliasedCollections);
        }
        collection = (String)aliasedCollections.get(0);
        DocCollection col = this.getDocCollection(collection, null);
        DocRouter router = col.getRouter();
        if (router instanceof ImplicitDocRouter) {
            return null;
        }
        ReplicaListTransformer replicaListTransformer = this.requestRLTGenerator.getReplicaListTransformer((SolrParams)params);
        Map<String, List<String>> urlMap = this.buildUrlMap(col, replicaListTransformer);
        Map<String, ? extends ModifiedLBSolrClient.Req> routes = this.createRoutes(updateRequest, routableParams, col, router, urlMap, routeField = col.getRouter().getRouteField(col) == null ? "id" : col.getRouter().getRouteField(col));
        if (routes == null) {
            if (this.directUpdatesToLeadersOnly && ModifiedCloudSolrClient.hasInfoToFindLeaders(updateRequest, routeField)) {
                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "directUpdatesToLeadersOnly==true but could not find leader(s)");
            }
            return null;
        }
        NamedList exceptions = new NamedList();
        NamedList shardResponses = new NamedList(routes.size() + 1);
        long start = System.nanoTime();
        if (this.parallelUpdates) {
            String url;
            HashMap responseFutures = new HashMap(routes.size());
            for (Map.Entry<String, ? extends ModifiedLBSolrClient.Req> entry : routes.entrySet()) {
                url = entry.getKey();
                ModifiedLBSolrClient.Req lbRequest = entry.getValue();
                try {
                    MDC.put((String)"CloudSolrClient.url", (String)url);
                    responseFutures.put(url, this.threadPool.submit(() -> this.getLbClient().request(lbRequest).getResponse()));
                }
                finally {
                    MDC.remove((String)"CloudSolrClient.url");
                }
            }
            for (Map.Entry entry : responseFutures.entrySet()) {
                url = (String)entry.getKey();
                Future responseFuture = (Future)entry.getValue();
                try {
                    shardResponses.add(url, (Object)((NamedList)responseFuture.get()));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    exceptions.add(url, (Object)e.getCause());
                }
            }
            if (exceptions.size() > 0) {
                Throwable throwable = (Throwable)exceptions.getVal(0);
                if (throwable instanceof SolrException) {
                    SolrException solrException = (SolrException)throwable;
                    throw this.getRouteException(SolrException.ErrorCode.getErrorCode((int)solrException.code()), (NamedList<Throwable>)exceptions, routes);
                }
                throw this.getRouteException(SolrException.ErrorCode.SERVER_ERROR, (NamedList<Throwable>)exceptions, routes);
            }
        } else {
            for (Map.Entry entry : routes.entrySet()) {
                String string = (String)entry.getKey();
                ModifiedLBSolrClient.Req lbRequest = (ModifiedLBSolrClient.Req)entry.getValue();
                try {
                    NamedList<Object> rsp = this.getLbClient().request(lbRequest).getResponse();
                    shardResponses.add(string, rsp);
                }
                catch (Exception e) {
                    if (e instanceof SolrException) {
                        throw (SolrException)((Object)e);
                    }
                    throw new SolrServerException((Throwable)e);
                }
            }
        }
        ModifiedUpdateRequest nonRoutableRequest = null;
        List<String> list = updateRequest.getDeleteQuery();
        if (list != null && list.size() > 0) {
            ModifiedUpdateRequest modifiedUpdateRequest = new ModifiedUpdateRequest();
            modifiedUpdateRequest.setDeleteQuery(list);
            nonRoutableRequest = modifiedUpdateRequest;
        }
        Set set = nonRoutableParams.getParameterNames();
        HashSet intersection = new HashSet(set);
        intersection.retainAll(this.NON_ROUTABLE_PARAMS);
        if (nonRoutableRequest != null || intersection.size() > 0) {
            if (nonRoutableRequest == null) {
                nonRoutableRequest = new ModifiedUpdateRequest();
            }
            nonRoutableRequest.setParams(nonRoutableParams);
            nonRoutableRequest.setBasicAuthCredentials(request.getBasicAuthUser(), request.getBasicAuthPassword());
            ArrayList<String> urlList = new ArrayList<String>(routes.keySet());
            Collections.shuffle(urlList, this.rand);
            ModifiedLBSolrClient.Req req = new ModifiedLBSolrClient.Req((SolrRequest<?>)nonRoutableRequest, (List<String>)urlList);
            try {
                ModifiedLBSolrClient.Rsp rsp = this.getLbClient().request(req);
                shardResponses.add((String)urlList.get(0), rsp.getResponse());
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (String)urlList.get(0), (Throwable)e);
            }
        }
        long end = System.nanoTime();
        RouteResponse rr = this.condenseResponse(shardResponses, (int)TimeUnit.MILLISECONDS.convert(end - start, TimeUnit.NANOSECONDS));
        rr.setRouteResponses(shardResponses);
        rr.setRoutes(routes);
        return rr;
    }

    protected RouteException getRouteException(SolrException.ErrorCode serverError, NamedList<Throwable> exceptions, Map<String, ? extends ModifiedLBSolrClient.Req> routes) {
        return new RouteException(serverError, exceptions, routes);
    }

    protected Map<String, ? extends ModifiedLBSolrClient.Req> createRoutes(ModifiedUpdateRequest updateRequest, ModifiableSolrParams routableParams, DocCollection col, DocRouter router, Map<String, List<String>> urlMap, String routeField) {
        return urlMap == null ? null : updateRequest.getRoutesToCollection(router, col, urlMap, routableParams, routeField);
    }

    private Map<String, List<String>> buildUrlMap(DocCollection col, ReplicaListTransformer replicaListTransformer) {
        Slice[] slices;
        HashMap<String, List<String>> urlMap = new HashMap<String, List<String>>();
        for (Slice slice : slices = col.getActiveSlicesArr()) {
            Replica replica2;
            Iterator iterator;
            String name = slice.getName();
            ArrayList<Replica> sortedReplicas = new ArrayList<Replica>();
            Replica leader = slice.getLeader();
            if (this.directUpdatesToLeadersOnly && leader == null && (iterator = slice.getReplicas(replica -> replica.isActive(this.getClusterStateProvider().getLiveNodes()) && replica.getType() == Replica.Type.NRT).iterator()).hasNext()) {
                leader = replica2 = (Replica)iterator.next();
            }
            if (leader == null) {
                if (this.directUpdatesToLeadersOnly) continue;
                return null;
            }
            if (!this.directUpdatesToLeadersOnly) {
                iterator = slice.getReplicas().iterator();
                while (iterator.hasNext()) {
                    replica2 = (Replica)iterator.next();
                    if (replica2.equals((Object)leader)) continue;
                    sortedReplicas.add(replica2);
                }
            }
            replicaListTransformer.transform(sortedReplicas);
            sortedReplicas.add(0, leader);
            urlMap.put(name, sortedReplicas.stream().map(Replica::getCoreUrl).collect(Collectors.toList()));
        }
        return urlMap;
    }

    protected <T extends RouteResponse<?>> T condenseResponse(NamedList<?> response, int timeMillis, Supplier<T> supplier) {
        RouteResponse condensed = (RouteResponse)((Object)supplier.get());
        int status = 0;
        Integer rf = null;
        ArrayList<SimpleOrderedMap> toleratedErrors = null;
        int maxToleratedErrors = Integer.MAX_VALUE;
        HashMap<String, NamedList> versions = new HashMap<String, NamedList>();
        for (int i = 0; i < response.size(); ++i) {
            List shardTolerantErrors;
            Object rfObj;
            NamedList shardResponse = (NamedList)response.getVal(i);
            NamedList header = (NamedList)shardResponse.get("responseHeader");
            Integer shardStatus = (Integer)header.get("status");
            int s = shardStatus;
            if (s > 0) {
                status = s;
            }
            if ((rfObj = header.get("rf")) != null && rfObj instanceof Integer) {
                Integer routeRf = (Integer)rfObj;
                if (rf == null || routeRf < rf) {
                    rf = routeRf;
                }
            }
            if (null != (shardTolerantErrors = (List)header.get("errors"))) {
                Integer shardMaxToleratedErrors = (Integer)header.get("maxErrors");
                assert (null != shardMaxToleratedErrors) : "TolerantUpdateProcessor reported errors but not maxErrors";
                maxToleratedErrors = Math.min(maxToleratedErrors, ToleratedUpdateError.getEffectiveMaxErrors((int)shardMaxToleratedErrors));
                if (null == toleratedErrors) {
                    toleratedErrors = new ArrayList<SimpleOrderedMap>(shardTolerantErrors.size());
                }
                for (SimpleOrderedMap err : shardTolerantErrors) {
                    toleratedErrors.add(err);
                }
            }
            for (String updateType : Arrays.asList("adds", "deletes", "deleteByQuery")) {
                Object obj = shardResponse.get(updateType);
                if (!(obj instanceof NamedList)) continue;
                NamedList versionsList = versions.containsKey(updateType) ? (NamedList)versions.get(updateType) : new NamedList();
                NamedList nl = (NamedList)obj;
                versionsList.addAll(nl);
                versions.put(updateType, versionsList);
            }
        }
        NamedList cheader = new NamedList();
        cheader.add("status", (Object)status);
        cheader.add("QTime", (Object)timeMillis);
        if (rf != null) {
            cheader.add("rf", rf);
        }
        if (null != toleratedErrors) {
            cheader.add("maxErrors", (Object)ToleratedUpdateError.getUserFriendlyMaxErrors((int)maxToleratedErrors));
            cheader.add("errors", toleratedErrors);
            if (maxToleratedErrors < toleratedErrors.size()) {
                StringBuilder msgBuf = new StringBuilder().append(toleratedErrors.size()).append(" Async failures during distributed update: ");
                NamedList metadata = new NamedList();
                for (SimpleOrderedMap err : toleratedErrors) {
                    ToleratedUpdateError te = ToleratedUpdateError.parseMap((SimpleOrderedMap)err);
                    metadata.add(te.getMetadataKey(), (Object)te.getMetadataValue());
                    msgBuf.append("\n").append(te.getMessage());
                }
                SolrException toThrow = new SolrException(SolrException.ErrorCode.BAD_REQUEST, msgBuf.toString());
                toThrow.setMetadata(metadata);
                throw toThrow;
            }
        }
        for (Map.Entry entry : versions.entrySet()) {
            condensed.add((String)entry.getKey(), entry.getValue());
        }
        condensed.add("responseHeader", cheader);
        return (T)((Object)condensed);
    }

    public RouteResponse condenseResponse(NamedList<?> response, int timeMillis) {
        return this.condenseResponse(response, timeMillis, RouteResponse::new);
    }

    public NamedList<Object> request(SolrRequest<?> request, String collection) throws SolrServerException, IOException {
        String requestCollection = request.getCollection();
        if (requestCollection != null) {
            collection = requestCollection;
        } else if (collection == null) {
            collection = this.defaultCollection;
        }
        List inputCollections = collection == null ? Collections.emptyList() : StrUtils.splitSmart((String)collection, (String)",", (boolean)true);
        return this.requestWithRetryOnStaleState(request, 0, inputCollections);
    }

    protected NamedList<Object> requestWithRetryOnStaleState(SolrRequest<?> request, int retryCount, List<String> inputCollections) throws SolrServerException, IOException {
        boolean isUpdate;
        this.connect();
        String stateVerParam = null;
        ArrayList<DocCollection> requestedCollections = null;
        boolean isCollectionRequestOfV2 = false;
        if (request instanceof V2RequestSupport) {
            request = ((V2RequestSupport)request).getV2Request();
        }
        if (request instanceof V2Request) {
            isCollectionRequestOfV2 = ((V2Request)request).isPerCollectionRequest();
        }
        boolean isAdmin = CommonParams.ADMIN_PATHS.contains(request.getPath());
        boolean bl = isUpdate = request instanceof IsUpdateRequest && request instanceof ModifiedUpdateRequest;
        if (!(inputCollections.isEmpty() || isAdmin || isCollectionRequestOfV2)) {
            Set<String> requestedCollectionNames = this.resolveAliases(inputCollections, isUpdate);
            StringBuilder stateVerParamBuilder = null;
            for (String string : requestedCollectionNames) {
                DocCollection docCollection = this.getDocCollection(string, null);
                if (docCollection == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection not found: " + string);
                }
                int collVer = docCollection.getZNodeVersion();
                if (requestedCollections == null) {
                    requestedCollections = new ArrayList<DocCollection>(requestedCollectionNames.size());
                }
                requestedCollections.add(docCollection);
                if (stateVerParamBuilder == null) {
                    stateVerParamBuilder = new StringBuilder();
                } else {
                    stateVerParamBuilder.append("|");
                }
                stateVerParamBuilder.append(docCollection.getName()).append(":").append(collVer);
            }
            if (stateVerParamBuilder != null) {
                stateVerParam = stateVerParamBuilder.toString();
            }
        }
        if (request.getParams() instanceof ModifiableSolrParams) {
            ModifiableSolrParams params = (ModifiableSolrParams)request.getParams();
            if (stateVerParam != null) {
                params.set(STATE_VERSION, new String[]{stateVerParam});
            } else {
                params.remove(STATE_VERSION);
            }
        }
        NamedList<Object> resp = null;
        try {
            Object o;
            resp = this.sendRequest(request, inputCollections);
            Object object = o = resp == null || resp.size() == 0 ? null : resp.get(STATE_VERSION, resp.size() - 1);
            if (o != null && o instanceof Map) {
                resp.remove(resp.size() - 1);
                Map invalidStates = (Map)o;
                for (Map.Entry entry : invalidStates.entrySet()) {
                    this.getDocCollection((String)entry.getKey(), (Integer)entry.getValue());
                }
            }
        }
        catch (Exception exc) {
            boolean bl2;
            Throwable rootCause = SolrException.getRootCause((Throwable)exc);
            if (inputCollections.isEmpty() || isAdmin || request instanceof V2Request && request.getMethod() != SolrRequest.METHOD.GET) {
                if (exc instanceof SolrServerException) {
                    throw (SolrServerException)((Object)exc);
                }
                if (exc instanceof IOException) {
                    throw (IOException)exc;
                }
                if (exc instanceof RuntimeException) {
                    throw (RuntimeException)exc;
                }
                throw new SolrServerException(rootCause);
            }
            int n = rootCause instanceof SolrException ? ((SolrException)rootCause).code() : SolrException.ErrorCode.UNKNOWN.code;
            boolean bl3 = bl2 = rootCause instanceof ConnectException || rootCause instanceof SocketException || this.wasCommError(rootCause);
            if (bl2 || exc instanceof RouteException && n == 503) {
                if (requestedCollections != null) {
                    for (DocCollection ext : requestedCollections) {
                        ExpiringCachedDocCollection cacheEntry = this.collectionStateCache.get(ext.getName());
                        if (cacheEntry == null) continue;
                        cacheEntry.maybeStale = true;
                    }
                }
                if (retryCount < MAX_STALE_RETRIES) {
                    log.info("Request to collection {} failed due to ({}) {}, retry={} maxRetries={} commError={} errorCode={} - retrying", new Object[]{inputCollections, n, rootCause, retryCount, MAX_STALE_RETRIES, bl2, n});
                    return this.requestWithRetryOnStaleState(request, retryCount + 1, inputCollections);
                }
            } else {
                log.info("request was not communication error it seems");
            }
            log.info("Request to collection {} failed due to ({}) {}, retry={} maxRetries={} commError={} errorCode={} ", new Object[]{inputCollections, n, rootCause, retryCount, MAX_STALE_RETRIES, bl2, n});
            boolean stateWasStale = false;
            if (!(retryCount >= MAX_STALE_RETRIES || requestedCollections == null || requestedCollections.isEmpty() || SolrException.ErrorCode.getErrorCode((int)n) != SolrException.ErrorCode.INVALID_STATE && n != 404)) {
                stateWasStale = true;
                for (DocCollection ext : requestedCollections) {
                    this.collectionStateCache.remove(ext.getName());
                }
            }
            if (retryCount < MAX_STALE_RETRIES && !stateWasStale && requestedCollections != null && !requestedCollections.isEmpty() && bl2) {
                for (DocCollection ext : requestedCollections) {
                    DocCollection latestStateFromZk = this.getDocCollection(ext.getName(), null);
                    if (latestStateFromZk.getZNodeVersion() == ext.getZNodeVersion()) continue;
                    stateWasStale = true;
                    this.collectionStateCache.put(ext.getName(), new ExpiringCachedDocCollection(latestStateFromZk));
                }
            }
            if (requestedCollections != null) {
                requestedCollections.clear();
            }
            if (stateWasStale) {
                log.warn("Re-trying request to collection(s) {} after stale state error from server.", inputCollections);
                resp = this.requestWithRetryOnStaleState(request, retryCount + 1, inputCollections);
            }
            if (exc instanceof SolrException || exc instanceof SolrServerException || exc instanceof IOException) {
                throw exc;
            }
            throw new SolrServerException(rootCause);
        }
        return resp;
    }

    protected NamedList<Object> sendRequest(SolrRequest<?> request, List<String> inputCollections) throws SolrServerException, IOException {
        SolrParams reqParams;
        this.connect();
        boolean sendToLeaders = false;
        boolean isUpdate = false;
        if (request instanceof IsUpdateRequest) {
            if (request instanceof ModifiedUpdateRequest) {
                isUpdate = true;
                if (inputCollections.size() > 1) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Update request must be sent to a single collection or an alias: " + inputCollections);
                }
                String collection = inputCollections.isEmpty() ? null : inputCollections.get(0);
                NamedList<Object> response = this.directUpdate((AbstractUpdateRequest)request, collection);
                if (response != null) {
                    return response;
                }
            }
            sendToLeaders = true;
        }
        if ((reqParams = request.getParams()) == null) {
            reqParams = new ModifiableSolrParams();
        }
        ReplicaListTransformer replicaListTransformer = this.requestRLTGenerator.getReplicaListTransformer(reqParams);
        ClusterStateProvider provider = this.getClusterStateProvider();
        String urlScheme = (String)provider.getClusterProperty("urlScheme", (Object)"http");
        Set liveNodes = provider.getLiveNodes();
        ArrayList<String> theUrlList = new ArrayList<String>();
        if (request instanceof V2Request) {
            if (!liveNodes.isEmpty()) {
                ArrayList liveNodesList = new ArrayList(liveNodes);
                Collections.shuffle(liveNodesList, this.rand);
                theUrlList.add(Utils.getBaseUrlForNodeName((String)((String)liveNodesList.get(0)), (String)urlScheme));
            }
        } else if (CommonParams.ADMIN_PATHS.contains(request.getPath())) {
            for (String liveNode : liveNodes) {
                theUrlList.add(Utils.getBaseUrlForNodeName((String)liveNode, (String)urlScheme));
            }
        } else {
            Set<String> collectionNames = this.resolveAliases(inputCollections, isUpdate);
            if (collectionNames.isEmpty()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No collection param specified on request and no default collection has been set: " + inputCollections);
            }
            List preferredNodes = request.getPreferredNodes();
            if (preferredNodes != null && !preferredNodes.isEmpty()) {
                String joinedInputCollections = StrUtils.join(inputCollections, (char)',');
                ArrayList<String> urlList = new ArrayList<String>(preferredNodes.size());
                for (String nodeName : preferredNodes) {
                    urlList.add(Utils.getBaseUrlForNodeName((String)nodeName, (String)urlScheme) + "/" + joinedInputCollections);
                }
                if (!urlList.isEmpty()) {
                    ModifiedLBSolrClient.Req req = new ModifiedLBSolrClient.Req(request, urlList);
                    ModifiedLBSolrClient.Rsp rsp = this.getLbClient().request(req);
                    return rsp.getResponse();
                }
            }
            HashMap slices = new HashMap();
            String shardKeys = reqParams.get("_route_");
            for (String collectionName : collectionNames) {
                DocCollection col = this.getDocCollection(collectionName, null);
                if (col == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection not found: " + collectionName);
                }
                Collection routeSlices = col.getRouter().getSearchSlices(shardKeys, reqParams, col);
                ClientUtils.addSlices(slices, (String)collectionName, (Collection)routeSlices, (boolean)true);
            }
            ArrayList<Object> sortedReplicas = new ArrayList<Object>();
            ArrayList<Replica> replicas = new ArrayList<Replica>();
            for (Slice slice : slices.values()) {
                Replica leader = slice.getLeader();
                for (Replica replica2 : slice.getReplicas()) {
                    String node = replica2.getNodeName();
                    if (!liveNodes.contains(node) || replica2.getState() != Replica.State.ACTIVE) continue;
                    if (sendToLeaders && replica2.equals((Object)leader)) {
                        sortedReplicas.add(replica2);
                        continue;
                    }
                    replicas.add(replica2);
                }
            }
            replicaListTransformer.transform(sortedReplicas);
            replicaListTransformer.transform(replicas);
            sortedReplicas.addAll(replicas);
            String joinedInputCollections = StrUtils.join(inputCollections, (char)',');
            HashSet seenNodes = new HashSet();
            sortedReplicas.forEach(replica -> {
                if (seenNodes.add(replica.getNodeName())) {
                    theUrlList.add(ZkCoreNodeProps.getCoreUrl((String)replica.getBaseUrl(), (String)joinedInputCollections));
                }
            });
            if (theUrlList.isEmpty()) {
                ((ConcurrentHashMap.KeySetView)this.collectionStateCache.keySet()).removeAll(collectionNames);
                throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "Could not find a healthy node to handle the request.");
            }
        }
        ModifiedLBSolrClient.Req req = new ModifiedLBSolrClient.Req(request, theUrlList);
        ModifiedLBSolrClient.Rsp rsp = this.getLbClient().request(req);
        return rsp.getResponse();
    }

    private Set<String> resolveAliases(List<String> inputCollections, boolean isUpdate) {
        if (inputCollections.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> uniqueNames = new LinkedHashSet<String>();
        for (String collectionName : inputCollections) {
            if (this.getClusterStateProvider().getState(collectionName) == null) {
                uniqueNames.addAll(this.getClusterStateProvider().resolveAlias(collectionName));
                continue;
            }
            uniqueNames.add(collectionName);
        }
        return uniqueNames;
    }

    public boolean isUpdatesToLeaders() {
        return this.updatesToLeaders;
    }

    public boolean isDirectUpdatesToLeadersOnly() {
        return this.directUpdatesToLeadersOnly;
    }

    public void setParallelCacheRefreshes(int n) {
        this.locks = ModifiedCloudSolrClient.objectList(n);
    }

    protected static ArrayList<Object> objectList(int n) {
        ArrayList<Object> l = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            l.add(new Object());
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DocCollection getDocCollection(String collection, Integer expectedVersion) throws SolrException {
        DocCollection col;
        if (expectedVersion == null) {
            expectedVersion = -1;
        }
        if (collection == null) {
            return null;
        }
        ExpiringCachedDocCollection cacheEntry = this.collectionStateCache.get(collection);
        DocCollection docCollection = col = cacheEntry == null ? null : cacheEntry.cached;
        if (col != null && expectedVersion <= col.getZNodeVersion() && !cacheEntry.shouldRetry()) {
            return col;
        }
        ClusterState.CollectionRef ref = this.getCollectionRef(collection);
        if (ref == null) {
            return null;
        }
        if (!ref.isLazilyLoaded()) {
            return ref.get();
        }
        List<Object> locks = this.locks;
        Object lock = locks.get(Math.abs(Hash.murmurhash3_x86_32((CharSequence)collection, (int)0, (int)collection.length(), (int)0) % locks.size()));
        DocCollection fetchedCol = null;
        Object object = lock;
        synchronized (object) {
            cacheEntry = this.collectionStateCache.get(collection);
            DocCollection docCollection2 = col = cacheEntry == null ? null : cacheEntry.cached;
            if (col != null && expectedVersion <= col.getZNodeVersion() && !cacheEntry.shouldRetry()) {
                return col;
            }
            fetchedCol = ref.get();
            if (fetchedCol == null) {
                return null;
            }
            if (col != null && fetchedCol.getZNodeVersion() == col.getZNodeVersion()) {
                cacheEntry.setRetriedAt();
                cacheEntry.maybeStale = false;
            } else {
                this.collectionStateCache.put(collection, new ExpiringCachedDocCollection(fetchedCol));
            }
            return fetchedCol;
        }
    }

    ClusterState.CollectionRef getCollectionRef(String collection) {
        return this.getClusterStateProvider().getState(collection);
    }

    public int getMinAchievedReplicationFactor(String collection, NamedList<?> resp) {
        NamedList header = (NamedList)resp.get("responseHeader");
        Integer achRf = (Integer)header.get("rf");
        if (achRf != null) {
            return achRf;
        }
        Map<String, Integer> shardRf = this.getShardReplicationFactor(collection, resp);
        for (Integer rf : shardRf.values()) {
            if (achRf != null && rf >= achRf) continue;
            achRf = rf;
        }
        return achRf != null ? achRf : -1;
    }

    public Map<String, Integer> getShardReplicationFactor(String collection, NamedList<?> resp) {
        this.connect();
        HashMap<String, Integer> results = new HashMap<String, Integer>();
        if (resp instanceof RouteResponse) {
            NamedList<NamedList<?>> routes = ((RouteResponse)resp).getRouteResponses();
            DocCollection coll = this.getDocCollection(collection, null);
            HashMap<CallSite, String> leaders = new HashMap<CallSite, String>();
            for (Slice slice : coll.getActiveSlicesArr()) {
                Replica leader = slice.getLeader();
                if (leader == null) continue;
                ZkCoreNodeProps zkProps = new ZkCoreNodeProps((ZkNodeProps)leader);
                String leaderUrl = zkProps.getBaseUrl() + "/" + zkProps.getCoreName();
                leaders.put((CallSite)((Object)leaderUrl), slice.getName());
                String altLeaderUrl = zkProps.getBaseUrl() + "/" + collection;
                leaders.put((CallSite)((Object)altLeaderUrl), slice.getName());
            }
            for (Map.Entry next : routes) {
                String host = (String)next.getKey();
                NamedList hostResp = (NamedList)next.getValue();
                Integer rf = (Integer)((NamedList)hostResp.get("responseHeader")).get("rf");
                if (rf == null) continue;
                String shard = (String)leaders.get(host);
                if (shard == null) {
                    if (host.endsWith("/")) {
                        shard = (String)leaders.get(host.substring(0, host.length() - 1));
                    }
                    if (shard == null) {
                        shard = host;
                    }
                }
                results.put(shard, rf);
            }
        }
        return results;
    }

    private static boolean hasInfoToFindLeaders(ModifiedUpdateRequest updateRequest, String idField) {
        boolean hasNoDeleteById;
        Map<SolrInputDocument, Map<String, Object>> documents = updateRequest.getDocumentsMap();
        Map<String, Map<String, Object>> deleteById = updateRequest.getDeleteByIdMap();
        boolean hasNoDocuments = documents == null || documents.isEmpty();
        boolean bl = hasNoDeleteById = deleteById == null || deleteById.isEmpty();
        if (hasNoDocuments && hasNoDeleteById) {
            return false;
        }
        if (documents != null) {
            for (Map.Entry<SolrInputDocument, Map<String, Object>> entry : documents.entrySet()) {
                SolrInputDocument doc = entry.getKey();
                Object fieldValue = doc.getFieldValue(idField);
                if (fieldValue != null) continue;
                return false;
            }
        }
        return true;
    }

    public static class RouteException
    extends SolrException {
        private final NamedList<Throwable> throwables;
        private final Map<String, ? extends ModifiedLBSolrClient.Req> routes;

        public RouteException(SolrException.ErrorCode errorCode, NamedList<Throwable> throwables, Map<String, ? extends ModifiedLBSolrClient.Req> routes) {
            super(errorCode, ((Throwable)throwables.getVal(0)).getMessage(), (Throwable)throwables.getVal(0));
            this.throwables = throwables;
            this.routes = routes;
            NamedList metadata = new NamedList();
            for (int i = 0; i < throwables.size(); ++i) {
                SolrException e;
                NamedList eMeta;
                Throwable t = (Throwable)throwables.getVal(i);
                if (!(t instanceof SolrException) || null == (eMeta = (e = (SolrException)t).getMetadata())) continue;
                metadata.addAll(eMeta);
            }
            if (0 < metadata.size()) {
                this.setMetadata(metadata);
            }
        }

        public NamedList<Throwable> getThrowables() {
            return this.throwables;
        }

        public Map<String, ? extends ModifiedLBSolrClient.Req> getRoutes() {
            return this.routes;
        }
    }

    public static class RouteResponse<T extends ModifiedLBSolrClient.Req>
    extends NamedList<Object> {
        private NamedList<NamedList<?>> routeResponses;
        private Map<String, T> routes;

        public void setRouteResponses(NamedList<NamedList<?>> routeResponses) {
            this.routeResponses = routeResponses;
        }

        public NamedList<NamedList<?>> getRouteResponses() {
            return this.routeResponses;
        }

        public void setRoutes(Map<String, T> routes) {
            this.routes = routes;
        }

        public Map<String, T> getRoutes() {
            return this.routes;
        }
    }

    class ExpiringCachedDocCollection {
        final DocCollection cached;
        final long cachedAt;
        volatile long retriedAt = -1L;
        volatile boolean maybeStale = false;

        ExpiringCachedDocCollection(DocCollection cached) {
            this.cached = cached;
            this.cachedAt = System.nanoTime();
        }

        boolean isExpired(long timeToLiveMs) {
            return System.nanoTime() - this.cachedAt > TimeUnit.NANOSECONDS.convert(timeToLiveMs, TimeUnit.MILLISECONDS);
        }

        boolean shouldRetry() {
            return this.maybeStale && (this.retriedAt == -1L || System.nanoTime() - this.retriedAt > ModifiedCloudSolrClient.this.retryExpiryTime);
        }

        void setRetriedAt() {
            this.retriedAt = System.nanoTime();
        }
    }

    static class StateCache
    extends ConcurrentHashMap<String, ExpiringCachedDocCollection> {
        final AtomicLong puts = new AtomicLong();
        final AtomicLong hits = new AtomicLong();
        final Lock evictLock = new ReentrantLock(true);
        protected volatile long timeToLive = 60000L;

        StateCache() {
        }

        @Override
        public ExpiringCachedDocCollection get(Object key) {
            ExpiringCachedDocCollection val = (ExpiringCachedDocCollection)super.get(key);
            if (val == null) {
                this.evictStale();
                return null;
            }
            if (val.isExpired(this.timeToLive)) {
                super.remove(key);
                return null;
            }
            this.hits.incrementAndGet();
            return val;
        }

        @Override
        public ExpiringCachedDocCollection put(String key, ExpiringCachedDocCollection value) {
            this.puts.incrementAndGet();
            return super.put(key, value);
        }

        void evictStale() {
            if (!this.evictLock.tryLock()) {
                return;
            }
            try {
                for (Map.Entry e : this.entrySet()) {
                    if (!((ExpiringCachedDocCollection)e.getValue()).isExpired(this.timeToLive)) continue;
                    super.remove(e.getKey());
                }
            }
            finally {
                this.evictLock.unlock();
            }
        }
    }

    public static class Builder
    extends ModifiedCloudHttp2SolrClient.Builder {
        public Builder(List<String> solrUrls) {
            super(solrUrls);
        }

        public Builder(List<String> zkHosts, Optional<String> zkChroot) {
            super(zkHosts, zkChroot);
        }
    }
}

