/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.lang;

import org.apache.juneau.commons.function.Snippet;
import org.apache.juneau.commons.utils.Utils;

public class Flag {
    private boolean value;

    public static Flag create() {
        return Flag.of(false);
    }

    public static Flag of(boolean value) {
        return new Flag(value);
    }

    private Flag(boolean value) {
        this.value = value;
    }

    public boolean getAndSet() {
        boolean b = this.value;
        this.value = true;
        return b;
    }

    public boolean getAndUnset() {
        boolean v = this.value;
        this.value = false;
        return v;
    }

    public Flag ifNotSet(Snippet snippet) {
        if (!this.value) {
            Utils.safe(snippet);
        }
        return this;
    }

    public Flag ifSet(Snippet snippet) {
        if (this.value) {
            Utils.safe(snippet);
        }
        return this;
    }

    public boolean isSet() {
        return this.value;
    }

    public boolean isUnset() {
        return !this.value;
    }

    public Flag set() {
        this.value = true;
        return this;
    }

    public Flag setIf(boolean value) {
        this.value |= value;
        return this;
    }

    public Flag unset() {
        this.value = false;
        return this;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object o) {
        Flag o2;
        return o instanceof Flag && Utils.eq(this, o2 = (Flag)o, (x, y) -> x.value == y.value);
    }

    public int hashCode() {
        return Boolean.hashCode(this.value);
    }
}

