/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.loader.sequential;

import org.apache.jena.system.progress.MonitorOutput;
import org.apache.jena.system.progress.ProgressMonitor;
import org.apache.jena.system.progress.ProgressMonitorOutput;
import org.apache.jena.tdb2.loader.base.LoaderOps;
import org.apache.jena.tdb2.store.tupletable.TupleIndex;

public class BuilderSecondaryIndexes {
    public static void createSecondaryIndexes(MonitorOutput output, TupleIndex primaryIndex, TupleIndex[] secondaryIndexes) {
        boolean printTiming = true;
        for (TupleIndex index : secondaryIndexes) {
            String msg = primaryIndex.getName() + "->" + index.getName();
            if (index == null) continue;
            ProgressMonitorOutput monitor = ProgressMonitorOutput.create((MonitorOutput)output, (String)msg, (long)1000000L, (int)10);
            monitor.startMessage(msg);
            monitor.start();
            LoaderOps.copyIndex(primaryIndex.all(), new TupleIndex[]{index}, (ProgressMonitor)monitor);
            monitor.finish();
            monitor.finishMessage(index.getName() + " indexing: ");
        }
    }
}

