/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.tools;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.ij.ijException;

public class JDBCDisplayUtil {
    private static final int MINWIDTH = 4;
    private static int maxWidth = 128;
    private static boolean showSelectCount = false;
    private static final int MAX_RETRIES = 0;

    public static boolean getShowSelectCount() {
        return showSelectCount;
    }

    public static void setShowSelectCount(boolean bl) {
        showSelectCount = bl;
    }

    public static void ShowException(PrintWriter printWriter, Throwable throwable) {
        if (throwable == null) {
            return;
        }
        if (throwable instanceof SQLException) {
            JDBCDisplayUtil.ShowSQLException(printWriter, (SQLException)throwable);
        } else {
            throwable.printStackTrace(printWriter);
        }
    }

    public static void ShowSQLException(PrintWriter printWriter, SQLException sQLException) {
        String string = JDBCDisplayUtil.getSystemBoolean("ij.showErrorCode") ? LocalizedResource.getMessage("UT_Error0", LocalizedResource.getNumber(sQLException.getErrorCode())) : "";
        while (sQLException != null) {
            String string2 = JDBCDisplayUtil.mapNull(sQLException.getSQLState(), LocalizedResource.getMessage("UT_NoSqlst", new Object[0]));
            String string3 = JDBCDisplayUtil.mapNull(sQLException.getMessage(), LocalizedResource.getMessage("UT_NoMessa", new Object[0]));
            printWriter.println(LocalizedResource.getMessage("UT_Error012", string2, string3, string));
            JDBCDisplayUtil.doTrace(printWriter, (Exception)sQLException);
            sQLException = sQLException.getNextException();
        }
    }

    public static void ShowWarnings(PrintWriter printWriter, Connection connection) {
        try {
            Object var2_2 = null;
            if (connection != null) {
                JDBCDisplayUtil.ShowWarnings(printWriter, connection.getWarnings());
            }
            if (connection != null) {
                connection.clearWarnings();
            }
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException(printWriter, sQLException);
        }
    }

    public static void ShowWarnings(PrintWriter printWriter, SQLWarning sQLWarning) {
        while (sQLWarning != null) {
            String string = JDBCDisplayUtil.mapNull(sQLWarning.getSQLState(), LocalizedResource.getMessage("UT_NoSqlst_7", new Object[0]));
            String string2 = JDBCDisplayUtil.mapNull(sQLWarning.getMessage(), LocalizedResource.getMessage("UT_NoMessa_8", new Object[0]));
            printWriter.println(LocalizedResource.getMessage("UT_Warni01", string, string2));
            sQLWarning = sQLWarning.getNextWarning();
        }
    }

    public static void ShowWarnings(PrintWriter printWriter, ResultSet resultSet) {
        try {
            Object var2_2 = null;
            if (resultSet != null) {
                JDBCDisplayUtil.ShowWarnings(printWriter, resultSet.getWarnings());
            }
            if (resultSet != null) {
                resultSet.clearWarnings();
            }
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException(printWriter, sQLException);
        }
    }

    public static void ShowWarnings(PrintWriter printWriter, Statement statement) {
        try {
            Object var2_2 = null;
            if (statement != null) {
                JDBCDisplayUtil.ShowWarnings(printWriter, statement.getWarnings());
            }
            if (statement != null) {
                statement.clearWarnings();
            }
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException(printWriter, sQLException);
        }
    }

    public static void DisplayResults(PrintWriter printWriter, Statement statement, Connection connection) throws SQLException {
        JDBCDisplayUtil.indent_DisplayResults(printWriter, statement, connection, 0, null, null);
    }

    private static void indent_DisplayResults(PrintWriter printWriter, Statement statement, Connection connection, int n, int[] nArray, int[] nArray2) throws SQLException {
        JDBCDisplayUtil.checkNotNull(statement, "Statement");
        ResultSet resultSet = statement.getResultSet();
        if (resultSet != null) {
            JDBCDisplayUtil.indent_DisplayResults(printWriter, resultSet, connection, n, nArray, nArray2);
            resultSet.close();
        } else {
            JDBCDisplayUtil.DisplayUpdateCount(printWriter, statement.getUpdateCount(), n);
        }
        JDBCDisplayUtil.ShowWarnings(printWriter, statement);
    }

    static void DisplayUpdateCount(PrintWriter printWriter, int n, int n2) {
        if (n == 1) {
            JDBCDisplayUtil.indentedPrintLine(printWriter, n2, LocalizedResource.getMessage("UT_1RowInserUpdatDelet", new Object[0]));
        } else if (n >= 0) {
            JDBCDisplayUtil.indentedPrintLine(printWriter, n2, LocalizedResource.getMessage("UT_0RowsInserUpdatDelet", LocalizedResource.getNumber(n)));
        } else {
            JDBCDisplayUtil.indentedPrintLine(printWriter, n2, LocalizedResource.getMessage("UT_StateExecu", new Object[0]));
        }
    }

    private static int[] getColumnDisplayWidths(ResultSetMetaData resultSetMetaData, int[] nArray, boolean bl) throws SQLException {
        int n = nArray == null ? resultSetMetaData.getColumnCount() : nArray.length;
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2 = nArray == null ? i + 1 : nArray[i];
            int n3 = bl ? LocalizedResource.getInstance().getColumnDisplaySize(resultSetMetaData, n2) : resultSetMetaData.getColumnDisplaySize(n2);
            nArray2[i] = Math.min(maxWidth, Math.max(resultSetMetaData.isNullable(n2) == 0 ? 0 : 4, n3));
        }
        return nArray2;
    }

    public static void DisplayMultipleResults(PrintWriter printWriter, List<ResultSet> list, Connection connection, int[] nArray, int[] nArray2) throws SQLException {
        JDBCDisplayUtil.indent_DisplayResults(printWriter, list, connection, 0, nArray, nArray2);
    }

    public static void DisplayResults(PrintWriter printWriter, ResultSet resultSet, Connection connection, int[] nArray, int[] nArray2) throws SQLException {
        JDBCDisplayUtil.indent_DisplayResults(printWriter, resultSet, connection, 0, nArray, nArray2);
    }

    private static void indent_DisplayResults(PrintWriter printWriter, ResultSet resultSet, Connection connection, int n, int[] nArray, int[] nArray2) throws SQLException {
        ArrayList<ResultSet> arrayList = new ArrayList<ResultSet>();
        arrayList.add(resultSet);
        JDBCDisplayUtil.indent_DisplayResults(printWriter, arrayList, connection, 0, nArray, nArray2);
    }

    private static void indent_DisplayResults(PrintWriter printWriter, List<ResultSet> list, Connection connection, int n, int[] nArray, int[] nArray2) throws SQLException {
        ResultSetMetaData resultSetMetaData = null;
        if (list != null && list.size() > 0) {
            resultSetMetaData = list.get(0).getMetaData();
        }
        JDBCDisplayUtil.checkNotNull(resultSetMetaData, "ResultSetMetaData");
        int n2 = 0;
        Vector<ResultSet> vector = !connection.getAutoCommit() ? new Vector<ResultSet>() : null;
        if (nArray2 == null) {
            nArray2 = JDBCDisplayUtil.getColumnDisplayWidths(resultSetMetaData, nArray, true);
        }
        int n3 = JDBCDisplayUtil.indent_DisplayBanner(printWriter, resultSetMetaData, n, nArray, nArray2);
        int n4 = 0;
        ResultSet resultSet = null;
        boolean bl = true;
        for (int i = 0; i < list.size(); ++i) {
            resultSet = list.get(i);
            bl = true;
            while (bl) {
                try {
                    bl = resultSet.next();
                    if (!bl) continue;
                    JDBCDisplayUtil.DisplayRow(printWriter, resultSet, resultSetMetaData, n3, vector, connection, n, nArray, nArray2);
                    JDBCDisplayUtil.ShowWarnings(printWriter, resultSet);
                    ++n2;
                }
                catch (SQLException sQLException) {
                    if (++n4 > 0) {
                        throw sQLException;
                    }
                    JDBCDisplayUtil.ShowSQLException(printWriter, sQLException);
                }
            }
        }
        if (showSelectCount) {
            if (n2 == 1) {
                printWriter.println();
                JDBCDisplayUtil.indentedPrintLine(printWriter, n, LocalizedResource.getMessage("UT_1RowSelec", new Object[0]));
            } else if (n2 >= 0) {
                printWriter.println();
                JDBCDisplayUtil.indentedPrintLine(printWriter, n, LocalizedResource.getMessage("UT_0RowsSelec", LocalizedResource.getNumber(n2)));
            }
        }
        JDBCDisplayUtil.DisplayNestedResults(printWriter, vector, connection, n);
        vector = null;
    }

    private static void DisplayNestedResults(PrintWriter printWriter, Vector<ResultSet> vector, Connection connection, int n) throws SQLException {
        if (vector == null) {
            return;
        }
        Object object = LocalizedResource.getMessage("UT_JDBCDisplayUtil_16", new Object[0]);
        String string = "0";
        for (int i = 0; i < vector.size(); ++i) {
            LocalizedResource.OutputWriter().println();
            String string2 = Integer.toString(i);
            if (string2.length() > string.length()) {
                string = string2;
                object = (String)object + LocalizedResource.getMessage("UT_JDBCDisplayUtil_17", new Object[0]);
            }
            LocalizedResource.OutputWriter().println((String)object);
            LocalizedResource.OutputWriter().println(LocalizedResource.getMessage("UT_Resul0", LocalizedResource.getNumber(i)));
            LocalizedResource.OutputWriter().println((String)object);
            JDBCDisplayUtil.indent_DisplayResults(printWriter, vector.elementAt(i), connection, n, null, null);
        }
    }

    public static void DisplayNextRow(PrintWriter printWriter, ResultSet resultSet, Connection connection) throws SQLException {
        JDBCDisplayUtil.indent_DisplayNextRow(printWriter, resultSet, connection, 0, null, resultSet == null ? null : JDBCDisplayUtil.getColumnDisplayWidths(resultSet.getMetaData(), null, true));
    }

    private static void indent_DisplayNextRow(PrintWriter printWriter, ResultSet resultSet, Connection connection, int n, int[] nArray, int[] nArray2) throws SQLException {
        Vector<ResultSet> vector = !connection.getAutoCommit() ? new Vector<ResultSet>() : null;
        JDBCDisplayUtil.checkNotNull(resultSet, "ResultSet");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        JDBCDisplayUtil.checkNotNull(resultSetMetaData, "ResultSetMetaData");
        if (resultSet.next()) {
            int n2 = JDBCDisplayUtil.indent_DisplayBanner(printWriter, resultSetMetaData, n, nArray, nArray2);
            JDBCDisplayUtil.DisplayRow(printWriter, resultSet, resultSetMetaData, n2, vector, connection, n, null, null);
        } else {
            JDBCDisplayUtil.indentedPrintLine(printWriter, n, LocalizedResource.getMessage("UT_NoCurreRow", new Object[0]));
        }
        JDBCDisplayUtil.ShowWarnings(printWriter, resultSet);
        JDBCDisplayUtil.DisplayNestedResults(printWriter, vector, connection, n);
        vector = null;
    }

    public static void DisplayCurrentRow(PrintWriter printWriter, ResultSet resultSet, Connection connection) throws SQLException {
        JDBCDisplayUtil.indent_DisplayCurrentRow(printWriter, resultSet, connection, 0, null, resultSet == null ? null : JDBCDisplayUtil.getColumnDisplayWidths(resultSet.getMetaData(), null, true));
    }

    private static void indent_DisplayCurrentRow(PrintWriter printWriter, ResultSet resultSet, Connection connection, int n, int[] nArray, int[] nArray2) throws SQLException {
        if (resultSet == null) {
            JDBCDisplayUtil.indentedPrintLine(printWriter, n, LocalizedResource.getMessage("UT_NoCurreRow_19", new Object[0]));
            return;
        }
        Vector<ResultSet> vector = !connection.getAutoCommit() ? new Vector<ResultSet>() : null;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        JDBCDisplayUtil.checkNotNull(resultSetMetaData, "ResultSetMetaData");
        int n2 = JDBCDisplayUtil.indent_DisplayBanner(printWriter, resultSetMetaData, n, nArray, nArray2);
        JDBCDisplayUtil.DisplayRow(printWriter, resultSet, resultSetMetaData, n2, vector, connection, n, nArray, nArray2);
        JDBCDisplayUtil.ShowWarnings(printWriter, resultSet);
        JDBCDisplayUtil.DisplayNestedResults(printWriter, vector, connection, n);
        vector = null;
    }

    public static int DisplayBanner(PrintWriter printWriter, ResultSetMetaData resultSetMetaData) throws SQLException {
        return JDBCDisplayUtil.indent_DisplayBanner(printWriter, resultSetMetaData, 0, null, JDBCDisplayUtil.getColumnDisplayWidths(resultSetMetaData, null, true));
    }

    private static int indent_DisplayBanner(PrintWriter printWriter, ResultSetMetaData resultSetMetaData, int n, int[] nArray, int[] nArray2) throws SQLException {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = nArray2.length;
        int n4 = n3 - 1;
        for (n2 = 1; n2 <= n3; ++n2) {
            n4 += nArray2[n2 - 1];
        }
        stringBuffer.ensureCapacity(n4);
        for (n2 = 1; n2 <= n3; ++n2) {
            int n5;
            int n6 = n5 = nArray == null ? n2 : nArray[n2 - 1];
            if (n2 > 1) {
                stringBuffer.append('|');
            }
            String string = resultSetMetaData.getColumnLabel(n5);
            int n7 = nArray2[n2 - 1];
            if (string.length() < n7) {
                int n8;
                stringBuffer.append(string);
                for (n8 = n7 - string.length(); n8 >= 64; n8 -= 64) {
                    stringBuffer.append("                                                                ");
                }
                while (n8 >= 16) {
                    stringBuffer.append("                ");
                    n8 -= 16;
                }
                while (n8 >= 4) {
                    stringBuffer.append("    ");
                    n8 -= 4;
                }
                while (n8 > 0) {
                    stringBuffer.append(' ');
                    --n8;
                }
                continue;
            }
            if (string.length() > n7) {
                if (n7 > 1) {
                    stringBuffer.append(string.substring(0, n7 - 1));
                }
                if (n7 <= 0) continue;
                stringBuffer.append('&');
                continue;
            }
            stringBuffer.append(string);
        }
        stringBuffer.setLength(Math.min(n4, 1024));
        JDBCDisplayUtil.indentedPrintLine(printWriter, n, stringBuffer);
        for (n2 = 0; n2 < Math.min(n4, 1024); ++n2) {
            stringBuffer.setCharAt(n2, '-');
        }
        JDBCDisplayUtil.indentedPrintLine(printWriter, n, stringBuffer);
        stringBuffer = null;
        return n4;
    }

    private static void DisplayRow(PrintWriter printWriter, ResultSet resultSet, ResultSetMetaData resultSetMetaData, int n, Vector<ResultSet> vector, Connection connection, int n2, int[] nArray, int[] nArray2) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.ensureCapacity(n);
        int n3 = nArray2.length;
        for (int i = 1; i <= n3; ++i) {
            Object object;
            int n4;
            int n5 = n4 = nArray == null ? i : nArray[i - 1];
            if (i > 1) {
                stringBuffer.append('|');
            }
            switch (resultSetMetaData.getColumnType(n4)) {
                default: {
                    object = LocalizedResource.getInstance().getLocalizedString(resultSet, resultSetMetaData, n4);
                    break;
                }
                case 1111: 
                case 2000: {
                    Object object2 = resultSet.getObject(n4);
                    if (object2 == null) {
                        object = "NULL";
                        break;
                    }
                    if (object2 instanceof ResultSet && vector != null) {
                        object = LocalizedResource.getMessage("UT_Resul0_20", LocalizedResource.getNumber(vector.size()));
                        vector.addElement((ResultSet)object2);
                        break;
                    }
                    try {
                        object = resultSet.getString(n4);
                        break;
                    }
                    catch (SQLException sQLException) {
                        object = object2.toString();
                    }
                }
            }
            if (object == null) {
                object = "NULL";
            }
            int n6 = nArray2[i - 1];
            if (((String)object).length() < n6) {
                StringBuffer stringBuffer2 = new StringBuffer((String)object);
                stringBuffer2.ensureCapacity(n6);
                for (int j = ((String)object).length(); j < n6; ++j) {
                    stringBuffer2.append(' ');
                }
                object = stringBuffer2.toString();
            } else if (((String)object).length() > n6) {
                object = ((String)object).substring(0, n6 - 1) + "&";
            }
            stringBuffer.append((String)object);
        }
        JDBCDisplayUtil.indentedPrintLine(printWriter, n2, stringBuffer);
    }

    public static void checkNotNull(Object object, String string) {
        if (object == null) {
            throw ijException.objectWasNull(string);
        }
    }

    public static String mapNull(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return string;
    }

    public static void doTrace(PrintWriter printWriter, Exception exception) {
        if (JDBCDisplayUtil.getSystemBoolean("ij.exceptionTrace")) {
            exception.printStackTrace(printWriter);
            printWriter.flush();
        }
    }

    public static void setMaxDisplayWidth(int n) {
        maxWidth = n;
    }

    private static void indentedPrintLine(PrintWriter printWriter, int n, String string) {
        JDBCDisplayUtil.indent(printWriter, n);
        printWriter.println(string);
    }

    private static void indentedPrintLine(PrintWriter printWriter, int n, StringBuffer stringBuffer) {
        JDBCDisplayUtil.indent(printWriter, n);
        printWriter.println(stringBuffer);
    }

    private static void indent(PrintWriter printWriter, int n) {
        for (int i = 0; i < n; ++i) {
            printWriter.print("  ");
        }
    }

    public static void ShowException(PrintStream printStream, Throwable throwable) {
        if (throwable == null) {
            return;
        }
        if (throwable instanceof SQLException) {
            JDBCDisplayUtil.ShowSQLException(printStream, (SQLException)throwable);
        } else {
            throwable.printStackTrace(printStream);
        }
    }

    public static void ShowSQLException(PrintStream printStream, SQLException sQLException) {
        Object object = JDBCDisplayUtil.getSystemBoolean("ij.showErrorCode") ? " (errorCode = " + sQLException.getErrorCode() + ")" : "";
        while (sQLException != null) {
            printStream.println("ERROR " + JDBCDisplayUtil.mapNull(sQLException.getSQLState(), "(no SQLState)") + ": " + JDBCDisplayUtil.mapNull(sQLException.getMessage(), "(no message)") + (String)object);
            JDBCDisplayUtil.doTrace(printStream, (Exception)sQLException);
            sQLException = sQLException.getNextException();
        }
    }

    public static void ShowWarnings(PrintStream printStream, Connection connection) {
        try {
            Object var2_2 = null;
            if (connection != null) {
                JDBCDisplayUtil.ShowWarnings(printStream, connection.getWarnings());
            }
            if (connection != null) {
                connection.clearWarnings();
            }
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException(printStream, sQLException);
        }
    }

    public static void ShowWarnings(PrintStream printStream, SQLWarning sQLWarning) {
        while (sQLWarning != null) {
            printStream.println("WARNING " + JDBCDisplayUtil.mapNull(sQLWarning.getSQLState(), "(no SQLState)") + ": " + JDBCDisplayUtil.mapNull(sQLWarning.getMessage(), "(no message)"));
            sQLWarning = sQLWarning.getNextWarning();
        }
    }

    public static void ShowWarnings(PrintStream printStream, ResultSet resultSet) {
        try {
            Object var2_2 = null;
            if (resultSet != null) {
                JDBCDisplayUtil.ShowWarnings(printStream, resultSet.getWarnings());
            }
            if (resultSet != null) {
                resultSet.clearWarnings();
            }
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException(printStream, sQLException);
        }
    }

    public static void ShowWarnings(PrintStream printStream, Statement statement) {
        try {
            Object var2_2 = null;
            if (statement != null) {
                JDBCDisplayUtil.ShowWarnings(printStream, statement.getWarnings());
            }
            if (statement != null) {
                statement.clearWarnings();
            }
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException(printStream, sQLException);
        }
    }

    public static void DisplayResults(PrintStream printStream, Statement statement, Connection connection) throws SQLException {
        JDBCDisplayUtil.indent_DisplayResults(printStream, statement, connection, 0, null, null);
    }

    private static void indent_DisplayResults(PrintStream printStream, Statement statement, Connection connection, int n, int[] nArray, int[] nArray2) throws SQLException {
        JDBCDisplayUtil.checkNotNull(statement, "Statement");
        ResultSet resultSet = statement.getResultSet();
        if (resultSet != null) {
            JDBCDisplayUtil.indent_DisplayResults(printStream, resultSet, connection, n, nArray, nArray2);
            resultSet.close();
        } else {
            JDBCDisplayUtil.DisplayUpdateCount(printStream, statement.getUpdateCount(), n);
        }
        JDBCDisplayUtil.ShowWarnings(printStream, statement);
    }

    static void DisplayUpdateCount(PrintStream printStream, int n, int n2) {
        if (n == 1) {
            JDBCDisplayUtil.indentedPrintLine(printStream, n2, "1 row inserted/updated/deleted");
        } else if (n >= 0) {
            JDBCDisplayUtil.indentedPrintLine(printStream, n2, n + " rows inserted/updated/deleted");
        } else {
            JDBCDisplayUtil.indentedPrintLine(printStream, n2, "Statement executed.");
        }
    }

    public static void DisplayResults(PrintStream printStream, ResultSet resultSet, Connection connection) throws SQLException {
        JDBCDisplayUtil.indent_DisplayResults(printStream, resultSet, connection, 0, null, null);
    }

    private static void indent_DisplayResults(PrintStream printStream, ResultSet resultSet, Connection connection, int n, int[] nArray, int[] nArray2) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        JDBCDisplayUtil.checkNotNull(resultSetMetaData, "ResultSetMetaData");
        int n2 = 0;
        Vector<ResultSet> vector = !connection.getAutoCommit() ? new Vector<ResultSet>() : null;
        if (nArray2 == null) {
            nArray2 = JDBCDisplayUtil.getColumnDisplayWidths(resultSetMetaData, nArray, false);
        }
        int n3 = JDBCDisplayUtil.indent_DisplayBanner(printStream, resultSetMetaData, n, nArray, nArray2);
        boolean bl = true;
        int n4 = 0;
        while (bl) {
            try {
                bl = resultSet.next();
                if (!bl) continue;
                JDBCDisplayUtil.DisplayRow(printStream, resultSet, resultSetMetaData, n3, vector, connection, n, nArray, nArray2);
                JDBCDisplayUtil.ShowWarnings(printStream, resultSet);
                ++n2;
            }
            catch (SQLException sQLException) {
                if (++n4 > 0) {
                    throw sQLException;
                }
                JDBCDisplayUtil.ShowSQLException(printStream, sQLException);
            }
        }
        if (showSelectCount) {
            if (n2 == 1) {
                printStream.println();
                JDBCDisplayUtil.indentedPrintLine(printStream, n, "1 row selected");
            } else if (n2 >= 0) {
                printStream.println();
                JDBCDisplayUtil.indentedPrintLine(printStream, n, n2 + " rows selected");
            }
        }
        JDBCDisplayUtil.DisplayNestedResults(printStream, vector, connection, n);
        vector = null;
    }

    private static void DisplayNestedResults(PrintStream printStream, Vector<ResultSet> vector, Connection connection, int n) throws SQLException {
        if (vector == null) {
            return;
        }
        String string = "+ ResultSet #";
        Object object = "++++++++++++++++";
        String string2 = "0";
        for (int i = 0; i < vector.size(); ++i) {
            System.out.println();
            String string3 = Integer.toString(i);
            if (string3.length() > string2.length()) {
                string2 = string3;
                object = (String)object + "+";
            }
            System.out.println((String)object);
            System.out.println(string + i + " +");
            System.out.println((String)object);
            JDBCDisplayUtil.indent_DisplayResults(printStream, vector.elementAt(i), connection, n, null, null);
        }
    }

    public static void DisplayNextRow(PrintStream printStream, ResultSet resultSet, Connection connection) throws SQLException {
        JDBCDisplayUtil.indent_DisplayNextRow(printStream, resultSet, connection, 0, null, resultSet == null ? null : JDBCDisplayUtil.getColumnDisplayWidths(resultSet.getMetaData(), null, false));
    }

    private static void indent_DisplayNextRow(PrintStream printStream, ResultSet resultSet, Connection connection, int n, int[] nArray, int[] nArray2) throws SQLException {
        Vector<ResultSet> vector = !connection.getAutoCommit() ? new Vector<ResultSet>() : null;
        JDBCDisplayUtil.checkNotNull(resultSet, "ResultSet");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        JDBCDisplayUtil.checkNotNull(resultSetMetaData, "ResultSetMetaData");
        if (resultSet.next()) {
            int n2 = JDBCDisplayUtil.indent_DisplayBanner(printStream, resultSetMetaData, n, null, null);
            JDBCDisplayUtil.DisplayRow(printStream, resultSet, resultSetMetaData, n2, vector, connection, n, nArray, nArray2);
        } else {
            JDBCDisplayUtil.indentedPrintLine(printStream, n, LocalizedResource.getMessage("UT_NoCurreRow", new Object[0]));
        }
        JDBCDisplayUtil.ShowWarnings(printStream, resultSet);
        JDBCDisplayUtil.DisplayNestedResults(printStream, vector, connection, n);
        vector = null;
    }

    public static void DisplayCurrentRow(PrintStream printStream, ResultSet resultSet, Connection connection) throws SQLException {
        JDBCDisplayUtil.indent_DisplayCurrentRow(printStream, resultSet, connection, 0, null, resultSet == null ? null : JDBCDisplayUtil.getColumnDisplayWidths(resultSet.getMetaData(), null, false));
    }

    private static void indent_DisplayCurrentRow(PrintStream printStream, ResultSet resultSet, Connection connection, int n, int[] nArray, int[] nArray2) throws SQLException {
        if (resultSet == null) {
            JDBCDisplayUtil.indentedPrintLine(printStream, n, LocalizedResource.getMessage("UT_NoCurreRow_19", new Object[0]));
            return;
        }
        Vector<ResultSet> vector = !connection.getAutoCommit() ? new Vector<ResultSet>() : null;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        JDBCDisplayUtil.checkNotNull(resultSetMetaData, "ResultSetMetaData");
        int n2 = JDBCDisplayUtil.indent_DisplayBanner(printStream, resultSetMetaData, n, nArray, nArray2);
        JDBCDisplayUtil.DisplayRow(printStream, resultSet, resultSetMetaData, n2, vector, connection, n, nArray, nArray2);
        JDBCDisplayUtil.ShowWarnings(printStream, resultSet);
        JDBCDisplayUtil.DisplayNestedResults(printStream, vector, connection, n);
        vector = null;
    }

    public static int DisplayBanner(PrintStream printStream, ResultSetMetaData resultSetMetaData) throws SQLException {
        return JDBCDisplayUtil.indent_DisplayBanner(printStream, resultSetMetaData, 0, null, JDBCDisplayUtil.getColumnDisplayWidths(resultSetMetaData, null, false));
    }

    private static int indent_DisplayBanner(PrintStream printStream, ResultSetMetaData resultSetMetaData, int n, int[] nArray, int[] nArray2) throws SQLException {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = nArray2.length;
        int n4 = n3 - 1;
        for (n2 = 1; n2 <= n3; ++n2) {
            n4 += nArray2[n2 - 1];
        }
        stringBuffer.ensureCapacity(n4);
        for (n2 = 1; n2 <= n3; ++n2) {
            int n5;
            int n6 = n5 = nArray == null ? n2 : nArray[n2 - 1];
            if (n2 > 1) {
                stringBuffer.append('|');
            }
            String string = resultSetMetaData.getColumnLabel(n5);
            int n7 = nArray2[n2 - 1];
            if (string.length() < n7) {
                int n8;
                StringBuffer stringBuffer2 = new StringBuffer(string);
                stringBuffer2.ensureCapacity(n7);
                for (n8 = stringBuffer2.length() + 64; n8 <= n7; n8 += 64) {
                    stringBuffer2.append("                                                                ");
                }
                for (n8 = stringBuffer2.length() + 16; n8 <= n7; n8 += 16) {
                    stringBuffer2.append("                ");
                }
                for (n8 = stringBuffer2.length() + 4; n8 <= n7; n8 += 4) {
                    stringBuffer2.append("    ");
                }
                for (n8 = stringBuffer2.length(); n8 < n7; ++n8) {
                    stringBuffer2.append(' ');
                }
                stringBuffer.append(stringBuffer2);
                continue;
            }
            if (string.length() > n7) {
                if (n7 > 1) {
                    stringBuffer.append(string.substring(0, n7 - 1));
                }
                if (n7 <= 0) continue;
                stringBuffer.append('&');
                continue;
            }
            stringBuffer.append(string);
        }
        stringBuffer.setLength(Math.min(n4, 1024));
        JDBCDisplayUtil.indentedPrintLine(printStream, n, stringBuffer);
        for (n2 = 0; n2 < Math.min(n4, 1024); ++n2) {
            stringBuffer.setCharAt(n2, '-');
        }
        JDBCDisplayUtil.indentedPrintLine(printStream, n, stringBuffer);
        stringBuffer = null;
        return n4;
    }

    private static void DisplayRow(PrintStream printStream, ResultSet resultSet, ResultSetMetaData resultSetMetaData, int n, Vector<ResultSet> vector, Connection connection, int n2, int[] nArray, int[] nArray2) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.ensureCapacity(n);
        int n3 = nArray2.length;
        for (int i = 1; i <= n3; ++i) {
            Object object;
            int n4;
            int n5 = n4 = nArray == null ? i : nArray[i - 1];
            if (i > 1) {
                stringBuffer.append('|');
            }
            switch (resultSetMetaData.getColumnType(n4)) {
                default: {
                    object = resultSet.getString(n4);
                    break;
                }
                case 1111: 
                case 2000: {
                    Object object2 = resultSet.getObject(n4);
                    if (object2 == null) {
                        object = "NULL";
                        break;
                    }
                    if (object2 instanceof ResultSet && vector != null) {
                        object = "ResultSet #" + vector.size();
                        vector.addElement((ResultSet)object2);
                        break;
                    }
                    try {
                        object = resultSet.getString(n4);
                        break;
                    }
                    catch (SQLException sQLException) {
                        object = object2.toString();
                    }
                }
            }
            if (object == null) {
                object = "NULL";
            }
            int n6 = nArray2[i - 1];
            if (((String)object).length() < n6) {
                StringBuffer stringBuffer2 = new StringBuffer((String)object);
                stringBuffer2.ensureCapacity(n6);
                for (int j = ((String)object).length(); j < n6; ++j) {
                    stringBuffer2.append(' ');
                }
                object = stringBuffer2.toString();
            } else if (((String)object).length() > n6) {
                object = ((String)object).substring(0, n6 - 1) + "&";
            }
            stringBuffer.append((String)object);
        }
        JDBCDisplayUtil.indentedPrintLine(printStream, n2, stringBuffer);
    }

    public static void doTrace(PrintStream printStream, Exception exception) {
        if (JDBCDisplayUtil.getSystemBoolean("ij.exceptionTrace")) {
            exception.printStackTrace(printStream);
            printStream.flush();
        }
    }

    private static void indentedPrintLine(PrintStream printStream, int n, String string) {
        JDBCDisplayUtil.indent(printStream, n);
        printStream.println(string);
    }

    private static void indentedPrintLine(PrintStream printStream, int n, StringBuffer stringBuffer) {
        JDBCDisplayUtil.indent(printStream, n);
        printStream.println(stringBuffer);
    }

    private static void indent(PrintStream printStream, int n) {
        for (int i = 0; i < n; ++i) {
            printStream.print("  ");
        }
    }

    private static boolean getSystemBoolean(String string) {
        return Boolean.getBoolean(string);
    }

    static {
        LocalizedResource.getInstance();
    }
}

