/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import java.util.Collection;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.ImapResponseEncoder;
import org.apache.james.imap.message.response.NamespaceResponse;

public class NamespaceResponseEncoder
implements ImapResponseEncoder<NamespaceResponse> {
    @Override
    public Class<NamespaceResponse> acceptableMessages() {
        return NamespaceResponse.class;
    }

    @Override
    public void encode(NamespaceResponse response, ImapResponseComposer composer) throws IOException {
        composer.untagged();
        composer.commandName(ImapConstants.NAMESPACE_COMMAND);
        this.encode(response.getPersonal(), composer);
        this.encode(response.getUsers(), composer);
        this.encode(response.getShared(), composer);
        composer.end();
    }

    @Override
    private void encode(Collection<NamespaceResponse.Namespace> namespaces, ImapResponseComposer composer) throws IOException {
        if (namespaces == null || namespaces.isEmpty()) {
            composer.nil();
        } else {
            composer.openParen();
            for (NamespaceResponse.Namespace namespace : namespaces) {
                this.encode(namespace, composer);
            }
            composer.closeParen();
        }
    }

    @Override
    private void encode(NamespaceResponse.Namespace namespace, ImapResponseComposer composer) throws IOException {
        composer.openParen();
        Object prefix = namespace.getPrefix();
        String delimiter = Character.toString(namespace.getDelimiter());
        if (!((String)prefix).isEmpty()) {
            prefix = (String)prefix + delimiter;
        }
        composer.quote((String)prefix);
        composer.quote(delimiter);
        composer.closeParen();
    }
}

