/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSession;
import org.apache.james.imap.api.ImapSessionState;
import org.apache.james.imap.api.process.ImapLineHandler;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.protocols.api.OidcSASLConfiguration;
import org.apache.james.util.concurrent.NamedThreadFactory;
import reactor.core.publisher.Mono;

public class FakeImapSession
implements ImapSession {
    private static final int DEFAULT_SCHEDULED_POOL_CORE_SIZE = 5;
    private static final ThreadFactory THREAD_FACTORY = NamedThreadFactory.withClassName(FakeImapSession.class);
    private static final ScheduledExecutorService EXECUTOR_SERVICE = Executors.newScheduledThreadPool(5, THREAD_FACTORY);
    private ImapSessionState state = ImapSessionState.NON_AUTHENTICATED;
    private SelectedMailbox selectedMailbox = null;
    private final Map<String, Object> attributesByKey;
    private final ImapSession.SessionId sessionId = ImapSession.SessionId.generate();

    public FakeImapSession() {
        this.attributesByKey = new ConcurrentHashMap<String, Object>();
    }

    public boolean needsCommandInjectionDetection() {
        throw new UnsupportedOperationException();
    }

    public void startDetectingCommandInjection() {
    }

    public void stopDetectingCommandInjection() {
    }

    @Override
    public ImapSession.SessionId sessionId() {
        return this.sessionId;
    }

    @Override
    public Mono<Void> logout() {
        return this.closeMailbox().then(Mono.fromRunnable(() -> {
            this.state = ImapSessionState.LOGOUT;
        }));
    }

    @Override
    public void authenticated() {
        this.state = ImapSessionState.AUTHENTICATED;
    }

    @Override
    public Mono<Void> deselect() {
        this.state = ImapSessionState.AUTHENTICATED;
        return this.closeMailbox();
    }

    @Override
    public Mono<Void> selected(SelectedMailbox mailbox) {
        this.state = ImapSessionState.SELECTED;
        return this.closeMailbox().then(Mono.fromRunnable(() -> {
            this.selectedMailbox = mailbox;
        }));
    }

    @Override
    public SelectedMailbox getSelected() {
        return this.selectedMailbox;
    }

    @Override
    public ImapSessionState getState() {
        return this.state;
    }

    private Mono<Void> closeMailbox() {
        if (this.selectedMailbox != null) {
            return this.selectedMailbox.deselect().then(Mono.fromRunnable(() -> {
                this.selectedMailbox = null;
            }));
        }
        return Mono.empty();
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributesByKey.get(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (value == null) {
            this.attributesByKey.remove(key);
        } else {
            this.attributesByKey.put(key, value);
        }
    }

    @Override
    public boolean startTLS(Runnable runnable) {
        return false;
    }

    @Override
    public boolean supportStartTLS() {
        return false;
    }

    @Override
    public Optional<SSLSession> getSSLSession() {
        return Optional.empty();
    }

    @Override
    public boolean isCompressionSupported() {
        return false;
    }

    @Override
    public boolean startCompression(Runnable runnable) {
        return false;
    }

    @Override
    public void pushLineHandler(ImapLineHandler lineHandler) {
    }

    @Override
    public void popLineHandler() {
    }

    @Override
    public boolean isSSLRequired() {
        return false;
    }

    @Override
    public boolean isPlainAuthEnabled() {
        return true;
    }

    @Override
    public boolean supportsOAuth() {
        return false;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return null;
    }

    @Override
    public Optional<OidcSASLConfiguration> oidcSaslConfiguration() {
        return Optional.empty();
    }

    @Override
    public boolean isTLSActive() {
        return false;
    }

    @Override
    public boolean isCompressionActive() {
        return false;
    }

    @Override
    public void schedule(Runnable runnable, Duration waitDelay) {
        EXECUTOR_SERVICE.schedule(runnable, waitDelay.toMillis(), TimeUnit.MILLISECONDS);
    }
}

