/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.util.Collections;
import reactor.util.annotation.Nullable;

final class RefCursorNameCodec
extends AbstractCodec<String> {
    static final RefCursorNameCodec INSTANCE = new RefCursorNameCodec();

    RefCursorNameCodec() {
        super(String.class);
    }

    @Override
    public EncodedParameter encodeNull() {
        throw new UnsupportedOperationException("Cannot encode RefCursor");
    }

    @Override
    public Iterable<PostgresTypeIdentifier> getDataTypes() {
        return Collections.singleton(PostgresqlObjectId.REF_CURSOR);
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return PostgresqlObjectId.REF_CURSOR == type;
    }

    @Override
    String doDecode(ByteBuf buffer, PostgresTypeIdentifier dataType, @Nullable Format format, @Nullable Class<? extends String> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        return ByteBufUtils.decode(buffer);
    }

    @Override
    EncodedParameter doEncode(String value) {
        throw new UnsupportedOperationException("Cannot encode RefCursor");
    }

    @Override
    EncodedParameter doEncode(String value, PostgresTypeIdentifier dataType) {
        throw new UnsupportedOperationException("Cannot encode RefCursor");
    }
}

