/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.api;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;

public class OidcSASLConfiguration {
    private final URL jwksURL;
    private final String claim;
    private final URL oidcConfigurationURL;
    private final String scope;
    private final Optional<URL> introspectionEndpoint;
    private final Optional<String> introspectionEndpointAuthorization;
    private final Optional<URL> userInfoEndpoint;

    public static OidcSASLConfiguration parse(HierarchicalConfiguration<ImmutableNode> configuration) throws MalformedURLException, URISyntaxException {
        String jwksURL = configuration.getString("jwksURL", null);
        String claim = configuration.getString("claim", null);
        String oidcConfigurationURL = configuration.getString("oidcConfigurationURL", null);
        String scope = configuration.getString("scope", null);
        Preconditions.checkNotNull((Object)jwksURL, (Object)"`jwksURL` property need to be specified inside the oidc tag");
        Preconditions.checkNotNull((Object)claim, (Object)"`claim` property need to be specified inside the oidc tag");
        Preconditions.checkNotNull((Object)oidcConfigurationURL, (Object)"`oidcConfigurationURL` property need to be specified inside the oidc tag");
        Preconditions.checkNotNull((Object)scope, (Object)"`scope` property need to be specified inside the oidc tag");
        String introspectionUrl = configuration.getString("introspection.url", null);
        String userInfoUrl = configuration.getString("userinfo.url", null);
        return new OidcSASLConfiguration(new URI(jwksURL).toURL(), claim, new URI(oidcConfigurationURL).toURL(), scope, Optional.ofNullable(introspectionUrl).map(Throwing.function(value -> new URI((String)value).toURL())), Optional.ofNullable(configuration.getString("introspection.auth", null)), Optional.ofNullable(userInfoUrl).map(Throwing.function(value -> new URI((String)value).toURL())));
    }

    public OidcSASLConfiguration(URL jwksURL, String claim, URL oidcConfigurationURL, String scope, Optional<URL> introspectionEndpoint, Optional<String> introspectionEndpointAuthorization, Optional<URL> userInfoEndpoint) {
        this.jwksURL = jwksURL;
        this.claim = claim;
        this.oidcConfigurationURL = oidcConfigurationURL;
        this.scope = scope;
        this.introspectionEndpoint = introspectionEndpoint;
        this.introspectionEndpointAuthorization = introspectionEndpointAuthorization;
        this.userInfoEndpoint = userInfoEndpoint;
    }

    public URL getJwksURL() {
        return this.jwksURL;
    }

    public String getClaim() {
        return this.claim;
    }

    public URL getOidcConfigurationURL() {
        return this.oidcConfigurationURL;
    }

    public String getScope() {
        return this.scope;
    }

    public Optional<URL> getIntrospectionEndpoint() {
        return this.introspectionEndpoint;
    }

    public Optional<String> getIntrospectionEndpointAuthorization() {
        return this.introspectionEndpointAuthorization;
    }

    public Optional<URL> getUserInfoEndpoint() {
        return this.userInfoEndpoint;
    }

    public boolean isCheckTokenByIntrospectionEndpoint() {
        return this.getIntrospectionEndpoint().isPresent();
    }

    public boolean isCheckTokenByUserinfoEndpoint() {
        return this.getUserInfoEndpoint().isPresent();
    }
}

