/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.snapshot;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class FileCountSnapshotStats
implements PlainJsonSerializable {
    private final int fileCount;
    private final long sizeInBytes;
    public static final JsonpDeserializer<FileCountSnapshotStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FileCountSnapshotStats::setupFileCountSnapshotStatsDeserializer);

    private FileCountSnapshotStats(Builder builder) {
        this.fileCount = ApiTypeHelper.requireNonNull(builder.fileCount, this, "fileCount");
        this.sizeInBytes = ApiTypeHelper.requireNonNull(builder.sizeInBytes, this, "sizeInBytes");
    }

    public static FileCountSnapshotStats of(Function<Builder, ObjectBuilder<FileCountSnapshotStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int fileCount() {
        return this.fileCount;
    }

    public final long sizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("file_count");
        generator.write(this.fileCount);
        generator.writeKey("size_in_bytes");
        generator.write(this.sizeInBytes);
    }

    protected static void setupFileCountSnapshotStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fileCount, JsonpDeserializer.integerDeserializer(), "file_count");
        op.add(Builder::sizeInBytes, JsonpDeserializer.longDeserializer(), "size_in_bytes");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<FileCountSnapshotStats> {
        private Integer fileCount;
        private Long sizeInBytes;

        public final Builder fileCount(int value) {
            this.fileCount = value;
            return this;
        }

        public final Builder sizeInBytes(long value) {
            this.sizeInBytes = value;
            return this;
        }

        @Override
        public FileCountSnapshotStats build() {
            this._checkSingleUse();
            return new FileCountSnapshotStats(this);
        }
    }
}

