/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class ClusterFileSystem
implements PlainJsonSerializable {
    private final long availableInBytes;
    private final long freeInBytes;
    private final long totalInBytes;
    public static final JsonpDeserializer<ClusterFileSystem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterFileSystem::setupClusterFileSystemDeserializer);

    private ClusterFileSystem(Builder builder) {
        this.availableInBytes = ApiTypeHelper.requireNonNull(builder.availableInBytes, this, "availableInBytes");
        this.freeInBytes = ApiTypeHelper.requireNonNull(builder.freeInBytes, this, "freeInBytes");
        this.totalInBytes = ApiTypeHelper.requireNonNull(builder.totalInBytes, this, "totalInBytes");
    }

    public static ClusterFileSystem of(Function<Builder, ObjectBuilder<ClusterFileSystem>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long availableInBytes() {
        return this.availableInBytes;
    }

    public final long freeInBytes() {
        return this.freeInBytes;
    }

    public final long totalInBytes() {
        return this.totalInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("available_in_bytes");
        generator.write(this.availableInBytes);
        generator.writeKey("free_in_bytes");
        generator.write(this.freeInBytes);
        generator.writeKey("total_in_bytes");
        generator.write(this.totalInBytes);
    }

    protected static void setupClusterFileSystemDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::availableInBytes, JsonpDeserializer.longDeserializer(), "available_in_bytes");
        op.add(Builder::freeInBytes, JsonpDeserializer.longDeserializer(), "free_in_bytes");
        op.add(Builder::totalInBytes, JsonpDeserializer.longDeserializer(), "total_in_bytes");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ClusterFileSystem> {
        private Long availableInBytes;
        private Long freeInBytes;
        private Long totalInBytes;

        public final Builder availableInBytes(long value) {
            this.availableInBytes = value;
            return this;
        }

        public final Builder freeInBytes(long value) {
            this.freeInBytes = value;
            return this;
        }

        public final Builder totalInBytes(long value) {
            this.totalInBytes = value;
            return this;
        }

        @Override
        public ClusterFileSystem build() {
            this._checkSingleUse();
            return new ClusterFileSystem(this);
        }
    }
}

