/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import org.apache.james.backends.opensearch.IndexName;
import org.apache.james.backends.opensearch.OpenSearchConfiguration;
import org.apache.james.backends.opensearch.OpenSearchIndexer;
import org.apache.james.backends.opensearch.ReactorOpenSearchClient;
import org.apache.james.backends.opensearch.ReadAliasName;
import org.apache.james.backends.opensearch.RoutingKey;
import org.apache.james.backends.opensearch.WriteAliasName;
import org.apache.james.events.EventListener;
import org.apache.james.lifecycle.api.StartUpCheck;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.opensearch.IndexAttachments;
import org.apache.james.mailbox.opensearch.IndexHeaders;
import org.apache.james.mailbox.opensearch.MailboxIdRoutingKeyFactory;
import org.apache.james.mailbox.opensearch.MailboxIndexCreationUtil;
import org.apache.james.mailbox.opensearch.MailboxMappingFactory;
import org.apache.james.mailbox.opensearch.OpenSearchMailboxConfiguration;
import org.apache.james.mailbox.opensearch.events.OpenSearchListeningMessageSearchIndex;
import org.apache.james.mailbox.opensearch.query.QueryConverter;
import org.apache.james.mailbox.opensearch.search.OpenSearchSearcher;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.modules.mailbox.OpenSearchMailboxConfigurationModule;
import org.apache.james.modules.mailbox.OpenSearchQuotaSearcherModule;
import org.apache.james.modules.mailbox.OpenSearchStartUpCheck;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchMailboxModule
extends AbstractModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenSearchMailboxModule.class);
    public static final String OPENSEARCH_CONFIGURATION_NAME = "opensearch";

    protected void configure() {
        this.install((Module)new OpenSearchMailboxConfigurationModule());
        this.install((Module)new OpenSearchQuotaSearcherModule());
        this.bind(OpenSearchListeningMessageSearchIndex.class).in(Scopes.SINGLETON);
        this.bind(MessageSearchIndex.class).to(OpenSearchListeningMessageSearchIndex.class);
        this.bind(ListeningMessageSearchIndex.class).to(OpenSearchListeningMessageSearchIndex.class);
        this.bind((TypeLiteral)new TypeLiteral<RoutingKey.Factory<MailboxId>>(this){}).to(MailboxIdRoutingKeyFactory.class);
        Multibinder.newSetBinder((Binder)this.binder(), EventListener.ReactiveGroupEventListener.class).addBinding().to(OpenSearchListeningMessageSearchIndex.class);
        Multibinder.newSetBinder((Binder)this.binder(), StartUpCheck.class).addBinding().to(OpenSearchStartUpCheck.class);
        Multibinder.newSetBinder((Binder)this.binder(), OpenSearchListeningMessageSearchIndex.Indexer.class);
    }

    @Provides
    @Singleton
    private OpenSearchSearcher createMailboxOpenSearchSearcher(ReactorOpenSearchClient client, QueryConverter queryConverter, OpenSearchMailboxConfiguration configuration, RoutingKey.Factory<MailboxId> routingKeyFactory) {
        return new OpenSearchSearcher(client, queryConverter, 100, configuration.getReadAliasMailboxName(), routingKeyFactory);
    }

    @Provides
    @Singleton
    @Named(value="mailbox")
    private OpenSearchIndexer createMailboxOpenSearchIndexer(ReactorOpenSearchClient client, OpenSearchMailboxConfiguration configuration) {
        return new OpenSearchIndexer(client, configuration.getWriteAliasMailboxName());
    }

    @Provides
    @Singleton
    public IndexAttachments provideIndexAttachments(OpenSearchMailboxConfiguration configuration) {
        return configuration.getIndexAttachment();
    }

    @Provides
    @Singleton
    public IndexHeaders provideIndexHeaders(OpenSearchMailboxConfiguration configuration) {
        return configuration.getIndexHeaders();
    }

    @ProvidesIntoSet
    InitializationOperation createIndex(MailboxIndexCreator instance) {
        return InitilizationOperationBuilder.forClass(MailboxIndexCreator.class).init(instance::createIndex);
    }

    static class MailboxIndexCreator
    implements Startable {
        private final OpenSearchConfiguration configuration;
        private final OpenSearchMailboxConfiguration mailboxConfiguration;
        private final ReactorOpenSearchClient client;
        private final MailboxMappingFactory mailboxMappingFactory;

        @Inject
        MailboxIndexCreator(OpenSearchConfiguration configuration, OpenSearchMailboxConfiguration mailboxConfiguration, ReactorOpenSearchClient client, MailboxMappingFactory mailboxMappingFactory) {
            this.configuration = configuration;
            this.mailboxConfiguration = mailboxConfiguration;
            this.client = client;
            this.mailboxMappingFactory = mailboxMappingFactory;
        }

        void createIndex() {
            MailboxIndexCreationUtil.prepareClient((ReactorOpenSearchClient)this.client, (ReadAliasName)this.mailboxConfiguration.getReadAliasMailboxName(), (WriteAliasName)this.mailboxConfiguration.getWriteAliasMailboxName(), (IndexName)this.mailboxConfiguration.getIndexMailboxName(), (OpenSearchConfiguration)this.configuration, (MailboxMappingFactory)this.mailboxMappingFactory);
        }
    }
}

