/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import com.google.common.collect.ImmutableList;
import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.auto$;
import eu.timepit.refined.string;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.mail.Message;
import jakarta.mail.internet.MimeMessage;
import java.io.Serializable;
import java.util.Collection;
import org.apache.james.core.MailAddress;
import org.apache.james.jmap.api.model.Identity;
import org.apache.james.jmap.api.model.IdentityId;
import org.apache.james.jmap.core.CapabilityIdentifier$;
import org.apache.james.jmap.core.Invocation;
import org.apache.james.jmap.core.JmapRfc8621Configuration;
import org.apache.james.jmap.core.SessionTranslator;
import org.apache.james.jmap.json.MDNSerializer;
import org.apache.james.jmap.mail.EmailHeaderName$;
import org.apache.james.jmap.mail.EmailSetRequest;
import org.apache.james.jmap.mail.ErrorField;
import org.apache.james.jmap.mail.ExtensionFieldName;
import org.apache.james.jmap.mail.ExtensionFieldValue;
import org.apache.james.jmap.mail.FinalRecipientField;
import org.apache.james.jmap.mail.FinalRecipientField$;
import org.apache.james.jmap.mail.IdentityIdNotFoundException;
import org.apache.james.jmap.mail.IncludeOriginalMessageField;
import org.apache.james.jmap.mail.MDN$;
import org.apache.james.jmap.mail.MDNGatewayField;
import org.apache.james.jmap.mail.MDNId$;
import org.apache.james.jmap.mail.MDNSend$;
import org.apache.james.jmap.mail.MDNSendAlreadySentException;
import org.apache.james.jmap.mail.MDNSendCreateRequest;
import org.apache.james.jmap.mail.MDNSendCreateRequest$;
import org.apache.james.jmap.mail.MDNSendCreateResponse;
import org.apache.james.jmap.mail.MDNSendCreateSuccess;
import org.apache.james.jmap.mail.MDNSendCreationId;
import org.apache.james.jmap.mail.MDNSendForbiddenFromException;
import org.apache.james.jmap.mail.MDNSendNotFoundException;
import org.apache.james.jmap.mail.MDNSendRequest;
import org.apache.james.jmap.mail.MDNSendRequestInvalidException;
import org.apache.james.jmap.mail.MDNSendRequestInvalidException$;
import org.apache.james.jmap.mail.MDNSendResults;
import org.apache.james.jmap.mail.MDNSendResults$;
import org.apache.james.jmap.mail.OriginalMessageIdField;
import org.apache.james.jmap.mail.OriginalRecipientField;
import org.apache.james.jmap.mail.ReportUAField;
import org.apache.james.jmap.mail.ReportUAField$;
import org.apache.james.jmap.mail.SubjectField;
import org.apache.james.jmap.mail.TextBodyField;
import org.apache.james.jmap.mail.TextHeaderValue$;
import org.apache.james.jmap.method.EmailSetMethod;
import org.apache.james.jmap.method.EmailSubmissionSetMethod$;
import org.apache.james.jmap.method.IdentityResolver;
import org.apache.james.jmap.method.InvocationWithContext;
import org.apache.james.jmap.method.Method;
import org.apache.james.jmap.method.MethodRequiringAccountId;
import org.apache.james.jmap.method.package$;
import org.apache.james.jmap.routes.ProcessingContext;
import org.apache.james.jmap.routes.SessionSupplier;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mdn.MDN;
import org.apache.james.mdn.MDNReport;
import org.apache.james.mdn.fields.Disposition;
import org.apache.james.mdn.fields.Error;
import org.apache.james.mdn.fields.ExtensionField;
import org.apache.james.mdn.fields.FinalRecipient;
import org.apache.james.mdn.fields.OriginalRecipient;
import org.apache.james.mdn.fields.Text;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.field.AddressListField;
import org.apache.james.mime4j.field.AddressListFieldLenientImpl;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.server.core.MailImpl;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.reactivestreams.Publisher;
import play.api.libs.json.JsError;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsPath;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsonValidationError;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import reactor.core.publisher.SignalType;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\r-g\u0001B\u0016-\u0001]B\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!\u0015\u0005\t/\u0002\u0011\t\u0011)A\u00051\"A1\u000e\u0001B\u0001B\u0003%A\u000e\u0003\u0005s\u0001\t\u0005\t\u0015!\u0003t\u0011!1\bA!b\u0001\n\u00039\b\u0002\u0003@\u0001\u0005\u0003\u0005\u000b\u0011\u0002=\t\u0013}\u0004!Q1A\u0005\u0002\u0005\u0005\u0001BCA\u0005\u0001\t\u0005\t\u0015!\u0003\u0002\u0004!Q\u00111\u0002\u0001\u0003\u0006\u0004%\t!!\u0004\t\u0015\u0005u\u0001A!A!\u0002\u0013\ty\u0001\u0003\u0006\u0002 \u0001\u0011)\u0019!C\u0001\u0003CA!\"a\f\u0001\u0005\u0003\u0005\u000b\u0011BA\u0012\u0011)\t\t\u0004\u0001BC\u0002\u0013\u0005\u00111\u0007\u0005\u000b\u0003w\u0001!\u0011!Q\u0001\n\u0005U\u0002bBA\u001f\u0001\u0011\u0005\u0011q\b\u0005\n\u0003_\u0002!\u0019!C!\u0003cB\u0001\"a'\u0001A\u0003%\u00111\u000f\u0005\n\u0003;\u0003!\u0019!C!\u0003?C\u0001\"a0\u0001A\u0003%\u0011\u0011\u0015\u0005\u000b;\u0002\u0001\r\u00111A\u0005\u0002\u0005\u0005\u0007bCAb\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u000bD!\"!5\u0001\u0001\u0004\u0005\t\u0015)\u0003i\u0011\u001d\t\u0019\u000e\u0001C\u0001\u0003+Dq!a6\u0001\t\u0003\t)\u000eC\u0004\u0002h\u0002!\t%!;\t\u000f\tm\u0001\u0001\"\u0011\u0003\u001e!9!\u0011\t\u0001\u0005\n\t\r\u0003b\u0002B=\u0001\u0011%!1\u0010\u0005\b\u0005K\u0003A\u0011\u0002BT\u0011\u001d\u0011I\f\u0001C\u0005\u0005wCqAa4\u0001\t\u0013\u0011\t\u000eC\u0004\u0003f\u0002!IAa:\t\u000f\te\b\u0001\"\u0003\u0003|\"91\u0011\u0002\u0001\u0005\n\r-\u0001bBB!\u0001\u0011%11\t\u0005\b\u0007_\u0002A\u0011BB9\u0011\u001d\u0019i\b\u0001C\u0005\u0007\u007fBqaa%\u0001\t\u0013\u0019)\nC\u0004\u0004*\u0002!Iaa+\t\u000f\r=\u0006\u0001\"\u0003\u00042\"91q\u0017\u0001\u0005\n\re\u0006bBBb\u0001\u0011%1Q\u0019\u0002\u000e\u001b\u0012s5+\u001a8e\u001b\u0016$\bn\u001c3\u000b\u00055r\u0013AB7fi\"|GM\u0003\u00020a\u0005!!.\\1q\u0015\t\t$'A\u0003kC6,7O\u0003\u00024i\u00051\u0011\r]1dQ\u0016T\u0011!N\u0001\u0004_J<7\u0001A\n\u0005\u0001ar\u0004\n\u0005\u0002:y5\t!HC\u0001<\u0003\u0015\u00198-\u00197b\u0013\ti$H\u0001\u0004B]f\u0014VM\u001a\t\u0004\u007f\u0001\u0013U\"\u0001\u0017\n\u0005\u0005c#\u0001G'fi\"|GMU3rk&\u0014\u0018N\\4BG\u000e|WO\u001c;JIB\u00111IR\u0007\u0002\t*\u0011QIL\u0001\u0005[\u0006LG.\u0003\u0002H\t\nqQ\n\u0012(TK:$'+Z9vKN$\bCA%O\u001b\u0005Q%BA&M\u0003\r\t\u0007/\u001b\u0006\u0003\u001bB\n\u0011\u0002\\5gK\u000eL8\r\\3\n\u0005=S%!C*uCJ$\u0018M\u00197f\u0003)\u0019XM]5bY&TXM\u001d\t\u0003%Vk\u0011a\u0015\u0006\u0003):\nAA[:p]&\u0011ak\u0015\u0002\u000e\u001b\u0012s5+\u001a:jC2L'0\u001a:\u0002!5\f\u0017\u000e\\)vKV,g)Y2u_JL\bGA-c!\rQf\fY\u0007\u00027*\u00111\n\u0018\u0006\u0003;B\nQ!];fk\u0016L!aX.\u0003!5\u000b\u0017\u000e\\)vKV,g)Y2u_JL\bCA1c\u0019\u0001!\u0011b\u0019\u0002\u0002\u0002\u0003\u0005)\u0011\u00013\u0003\u0007}#\u0013'\u0005\u0002fQB\u0011\u0011HZ\u0005\u0003Oj\u0012qAT8uQ&tw\r\u0005\u0002[S&\u0011!n\u0017\u0002\n\u001b\u0006LG.U;fk\u0016\f\u0001#\\3tg\u0006<W-\u00133NC:\fw-\u001a:\u0011\u00055\u0004X\"\u00018\u000b\u0005=\u0004\u0014aB7bS2\u0014w\u000e_\u0005\u0003c:\u0014\u0001#T3tg\u0006<W-\u00133NC:\fw-\u001a:\u0002\u001d\u0015l\u0017-\u001b7TKRlU\r\u001e5pIB\u0011q\b^\u0005\u0003k2\u0012a\"R7bS2\u001cV\r^'fi\"|G-A\u0007d_:4\u0017nZ;sCRLwN\\\u000b\u0002qB\u0011\u0011\u0010`\u0007\u0002u*\u00111PL\u0001\u0005G>\u0014X-\u0003\u0002~u\nA\"*\\1q%\u001a\u001c\u0007H\u000e\u001a2\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u001d\r|gNZ5hkJ\fG/[8oA\u0005\u0001\u0012\u000eZ3oi&$\u0018PU3t_24XM]\u000b\u0003\u0003\u0007\u00012aPA\u0003\u0013\r\t9\u0001\f\u0002\u0011\u0013\u0012,g\u000e^5usJ+7o\u001c7wKJ\f\u0011#\u001b3f]RLG/\u001f*fg>dg/\u001a:!\u00035iW\r\u001e:jG\u001a\u000b7\r^8ssV\u0011\u0011q\u0002\t\u0005\u0003#\tI\"\u0004\u0002\u0002\u0014)\u00191*!\u0006\u000b\u0007\u0005]\u0001'A\u0004nKR\u0014\u0018nY:\n\t\u0005m\u00111\u0003\u0002\u000e\u001b\u0016$(/[2GC\u000e$xN]=\u0002\u001d5,GO]5d\r\u0006\u001cGo\u001c:zA\u0005y1/Z:tS>t7+\u001e9qY&,'/\u0006\u0002\u0002$A!\u0011QEA\u0016\u001b\t\t9CC\u0002\u0002*9\naA]8vi\u0016\u001c\u0018\u0002BA\u0017\u0003O\u0011qbU3tg&|gnU;qa2LWM]\u0001\u0011g\u0016\u001c8/[8o'V\u0004\b\u000f\\5fe\u0002\n\u0011c]3tg&|g\u000e\u0016:b]Nd\u0017\r^8s+\t\t)\u0004E\u0002z\u0003oI1!!\u000f{\u0005E\u0019Vm]:j_:$&/\u00198tY\u0006$xN]\u0001\u0013g\u0016\u001c8/[8o)J\fgn\u001d7bi>\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u0015\u0003\u0003\n\u0019%!\u0012\u0002P\u0005E\u00131KA+\u0003/\nI&a\u0017\u0011\u0005}\u0002\u0001\"\u0002)\u0010\u0001\u0004\t\u0006BB,\u0010\u0001\u0004\t9\u0005\r\u0003\u0002J\u00055\u0003\u0003\u0002._\u0003\u0017\u00022!YA'\t)\u0019\u0017QIA\u0001\u0002\u0003\u0015\t\u0001\u001a\u0005\u0006W>\u0001\r\u0001\u001c\u0005\u0006e>\u0001\ra\u001d\u0005\u0006m>\u0001\r\u0001\u001f\u0005\u0007\u007f>\u0001\r!a\u0001\t\u000f\u0005-q\u00021\u0001\u0002\u0010!9\u0011qD\bA\u0002\u0005\r\u0002bBA\u0019\u001f\u0001\u0007\u0011Q\u0007\u0015\u0004\u001f\u0005}\u0003\u0003BA1\u0003Wj!!a\u0019\u000b\t\u0005\u0015\u0014qM\u0001\u0007S:TWm\u0019;\u000b\u0005\u0005%\u0014a\u00026bW\u0006\u0014H/Y\u0005\u0005\u0003[\n\u0019G\u0001\u0004J]*,7\r^\u0001\u000b[\u0016$\bn\u001c3OC6,WCAA:!\u0011\t)(!&\u000f\t\u0005]\u0014\u0011\u0013\b\u0005\u0003s\nyI\u0004\u0003\u0002|\u00055e\u0002BA?\u0003\u0017sA!a \u0002\n:!\u0011\u0011QAD\u001b\t\t\u0019IC\u0002\u0002\u0006Z\na\u0001\u0010:p_Rt\u0014\"A\u001b\n\u0005M\"\u0014BA\u00193\u0013\ty\u0003'\u0003\u0002|]%\u0019\u00111\u0013>\u0002\u0015%sgo\\2bi&|g.\u0003\u0003\u0002\u0018\u0006e%AC'fi\"|GMT1nK*\u0019\u00111\u0013>\u0002\u00175,G\u000f[8e\u001d\u0006lW\rI\u0001\u0015e\u0016\fX/\u001b:fI\u000e\u000b\u0007/\u00192jY&$\u0018.Z:\u0016\u0005\u0005\u0005\u0006CBAR\u0003W\u000b\tL\u0004\u0003\u0002&\u0006\u001d\u0006cAAAu%\u0019\u0011\u0011\u0016\u001e\u0002\rA\u0013X\rZ3g\u0013\u0011\ti+a,\u0003\u0007M+GOC\u0002\u0002*j\u0002B!a-\u0002::!\u0011qOA[\u0013\r\t9L_\u0001\u0015\u0007\u0006\u0004\u0018MY5mSRL\u0018\nZ3oi&4\u0017.\u001a:\n\t\u0005m\u0016Q\u0018\u0002\u0015\u0007\u0006\u0004\u0018MY5mSRL\u0018\nZ3oi&4\u0017.\u001a:\u000b\u0007\u0005]&0A\u000bsKF,\u0018N]3e\u0007\u0006\u0004\u0018MY5mSRLWm\u001d\u0011\u0016\u0003!\f\u0011\"];fk\u0016|F%Z9\u0015\t\u0005\u001d\u0017Q\u001a\t\u0004s\u0005%\u0017bAAfu\t!QK\\5u\u0011!\ty-FA\u0001\u0002\u0004A\u0017a\u0001=%c\u00051\u0011/^3vK\u0002\nA!\u001b8jiV\u0011\u0011qY\u0001\bI&\u001c\bo\\:fQ\rA\u00121\u001c\t\u0005\u0003;\f\u0019/\u0004\u0002\u0002`*!\u0011\u0011]A4\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003K\fyN\u0001\u0006Qe\u0016$Um\u001d;s_f\f\u0011\u0002Z8Qe>\u001cWm]:\u0015\u0015\u0005-(Q\u0001B\u0005\u0005\u001b\u00119\u0002\u0005\u0004\u0002n\u0006m\u0018q`\u0007\u0003\u0003_TA!!=\u0002t\u0006I\u0001/\u001e2mSNDWM\u001d\u0006\u0004w\u0005U(bA>\u0002x*\u0011\u0011\u0011`\u0001\be\u0016\f7\r^8s\u0013\u0011\ti0a<\u0003\u000bM3E.\u001e=\u0011\u0007}\u0012\t!C\u0002\u0003\u00041\u0012Q#\u00138w_\u000e\fG/[8o/&$\bnQ8oi\u0016DH\u000fC\u0004\u0003\be\u0001\r!!)\u0002\u0019\r\f\u0007/\u00192jY&$\u0018.Z:\t\u000f\t-\u0011\u00041\u0001\u0002\u0000\u0006Q\u0011N\u001c<pG\u0006$\u0018n\u001c8\t\u000f\t=\u0011\u00041\u0001\u0003\u0012\u0005qQ.Y5mE>D8+Z:tS>t\u0007cA7\u0003\u0014%\u0019!Q\u00038\u0003\u001d5\u000b\u0017\u000e\u001c2pqN+7o]5p]\"1!\u0011D\rA\u0002\t\u000bqA]3rk\u0016\u001cH/\u0001\u0006hKR\u0014V-];fgR$bAa\b\u00038\te\u0002c\u0002B\u0011\u0005W\u0011\tD\u0011\b\u0005\u0005G\u00119C\u0004\u0003\u0002\u0002\n\u0015\u0012\"A\u001e\n\u0007\t%\"(A\u0004qC\u000e\\\u0017mZ3\n\t\t5\"q\u0006\u0002\u0007\u000b&$\b.\u001a:\u000b\u0007\t%\"\b\u0005\u0003\u0003\"\tM\u0012\u0002\u0002B\u001b\u0005_\u0011\u0011\"\u0012=dKB$\u0018n\u001c8\t\u000f\t=!\u00041\u0001\u0003\u0012!9!1\u0002\u000eA\u0002\tm\u0002cA=\u0003>%\u0019!q\b>\u0003\u0015%sgo\\2bi&|g.\u0001\u0004de\u0016\fG/\u001a\u000b\u000b\u0005\u000b\u0012iFa\u001c\u0003r\tU\u0004CBAw\u0005\u000f\u0012Y%\u0003\u0003\u0003J\u0005=(!B*N_:|\u0007cB\u001d\u0003N\tE#qK\u0005\u0004\u0005\u001fR$A\u0002+va2,'\u0007E\u0002D\u0005'J1A!\u0016E\u00059iEIT*f]\u0012\u0014Vm];miN\u0004B!!\n\u0003Z%!!1LA\u0014\u0005E\u0001&o\\2fgNLgnZ\"p]R,\u0007\u0010\u001e\u0005\b\u0005?Z\u0002\u0019\u0001B1\u0003!IG-\u001a8uSRL\b\u0003\u0002B2\u0005Wj!A!\u001a\u000b\t\t\u001d$\u0011N\u0001\u0006[>$W\r\u001c\u0006\u0003\u0017:JAA!\u001c\u0003f\tA\u0011\nZ3oi&$\u0018\u0010\u0003\u0004\u0003\u001am\u0001\rA\u0011\u0005\b\u0005gZ\u0002\u0019\u0001B\t\u0003\u001d\u0019Xm]:j_:DqAa\u001e\u001c\u0001\u0004\u00119&A\tqe>\u001cWm]:j]\u001e\u001cuN\u001c;fqR\fQb\u0019:fCR,W\n\u0012(TK:$G\u0003\u0004B#\u0005{\u0012yH!!\u0003\f\n\r\u0006b\u0002B:9\u0001\u0007!\u0011\u0003\u0005\b\u0005?b\u0002\u0019\u0001B1\u0011\u001d\u0011\u0019\t\ba\u0001\u0005\u000b\u000b\u0011#\u001c3o'\u0016tGm\u0011:fCRLwN\\%e!\r\u0019%qQ\u0005\u0004\u0005\u0013#%!E'E\u001dN+g\u000eZ\"sK\u0006$\u0018n\u001c8JI\"9!Q\u0012\u000fA\u0002\t=\u0015\u0001\u00036t\u001f\nTWm\u0019;\u0011\t\tE%qT\u0007\u0003\u0005'S1\u0001\u0016BK\u0015\u0011\u00119J!'\u0002\t1L'm\u001d\u0006\u0004\u0017\nm%B\u0001BO\u0003\u0011\u0001H.Y=\n\t\t\u0005&1\u0013\u0002\t\u0015N|%M[3di\"9!q\u000f\u000fA\u0002\t]\u0013a\u00049beN,W\n\u0012(SKF,Xm\u001d;\u0015\t\t%&q\u0017\t\t\u0005C\u0011YCa+\u00032B\u00191I!,\n\u0007\t=FI\u0001\u0010N\t:\u001bVM\u001c3SKF,Xm\u001d;J]Z\fG.\u001b3Fq\u000e,\u0007\u000f^5p]B\u00191Ia-\n\u0007\tUFI\u0001\u000bN\t:\u001bVM\u001c3De\u0016\fG/\u001a*fcV,7\u000f\u001e\u0005\b\u0005\u001bk\u0002\u0019\u0001BH\u0003\u001d\u0019XM\u001c3N\t:#\"B!0\u0003F\n\u001d'\u0011\u001aBf!\u0019\tiOa\u0012\u0003@B\u00191I!1\n\u0007\t\rGI\u0001\u000bN\t:\u001bVM\u001c3De\u0016\fG/Z*vG\u000e,7o\u001d\u0005\b\u0005gr\u0002\u0019\u0001B\t\u0011\u001d\u0011yF\ba\u0001\u0005CBqAa!\u001f\u0001\u0004\u0011)\tC\u0004\u0003Nz\u0001\rA!-\u0002\u0019I,\u0017/^3ti\u0016sGO]=\u0002\u000f\u0015t\u0017/^3vKR!!1\u001bBk!\u0019\tiOa\u0012\u0002H\"1Qi\ba\u0001\u0005/\u0004BA!7\u0003b6\u0011!1\u001c\u0006\u0004w\nu'b\u0001Bpa\u000511/\u001a:wKJLAAa9\u0003\\\nAQ*Y5m\u00136\u0004H.\u0001\u000fsKR\u0014\u0018.\u001a<f%\u0016d\u0017\r^3e\u001b\u0016\u001c8/Y4f%\u0016\u001cX\u000f\u001c;\u0015\r\t%(Q\u001fB|!\u0019\tiOa\u0012\u0003lB!!Q\u001eBy\u001b\t\u0011yOC\u0002\u0003h9LAAa=\u0003p\niQ*Z:tC\u001e,'+Z:vYRDqAa\u001d!\u0001\u0004\u0011\t\u0002C\u0004\u0003N\u0002\u0002\rA!-\u00023Y\fG.\u001b3bi\u0016lEI\u0014(pi\u0006c'/Z1esN+g\u000e\u001e\u000b\u0005\u0005{\u001c)\u0001\u0005\u0005\u0003\"\t-\"q Bv!\r\u00195\u0011A\u0005\u0004\u0007\u0007!%aG'E\u001dN+g\u000eZ!me\u0016\fG-_*f]R,\u0005pY3qi&|g\u000eC\u0004\u0004\b\u0005\u0002\rAa;\u0002)I,G.\u0019;fI6+7o]1hKJ+7/\u001e7u\u0003Q\u0011W/\u001b7e\u001b\u0006LG.\u00118e%\u0016\u001c\bo\u001c8tKRa1QBB\u000f\u0007?\u0019Ica\u000b\u0004@AA!\u0011\u0005B\u0016\u0007\u001f\u0019)\u0002\u0005\u0003\u0003\"\rE\u0011\u0002BB\n\u0005_\u0011\u0011\u0002\u00165s_^\f'\r\\3\u0011\u000fe\u0012iEa6\u0004\u0018A\u00191i!\u0007\n\u0007\rmAIA\u000bN\t:\u001bVM\u001c3De\u0016\fG/\u001a*fgB|gn]3\t\u000f\t}#\u00051\u0001\u0003b!91\u0011\u0005\u0012A\u0002\r\r\u0012AB:f]\u0012,'\u000f\u0005\u0003\u0002$\u000e\u0015\u0012\u0002BB\u0014\u0003_\u0013aa\u0015;sS:<\u0007b\u0002BgE\u0001\u0007!\u0011\u0017\u0005\b\u0007[\u0011\u0003\u0019AB\u0018\u0003=y'/[4j]\u0006dW*Z:tC\u001e,\u0007\u0003BB\u0019\u0007wi!aa\r\u000b\t\rU2qG\u0001\u0004I>l'bAB\u001da\u00051Q.[7fi)LAa!\u0010\u00044\t9Q*Z:tC\u001e,\u0007b\u0002B\bE\u0001\u0007!\u0011C\u0001\u0018EVLG\u000eZ'bS2\fe\u000eZ'j[\u0016lUm]:bO\u0016$Bb!\u0012\u0004V\r]31LB0\u0007[\u0002r!\u000fB'\u0005/\u001c9\u0005\u0005\u0003\u0004J\rESBAB&\u0015\u0011\u0019iea\u0014\u0002\u0011%tG/\u001a:oKRT1!RA4\u0013\u0011\u0019\u0019fa\u0013\u0003\u00175KW.Z'fgN\fw-\u001a\u0005\b\u0007C\u0019\u0003\u0019AB\u0012\u0011\u001d\u0019If\ta\u0001\u0007G\t\u0011B]3dSBLWM\u001c;\t\u000f\ru3\u00051\u0001\u0004$\u000591/\u001e2kK\u000e$\bbBB1G\u0001\u000711M\u0001\u0004[\u0012t\u0007\u0003BB3\u0007Sj!aa\u001a\u000b\u0007\r\u0005\u0004'\u0003\u0003\u0004l\r\u001d$aA'E\u001d\"9!qB\u0012A\u0002\tE\u0011\u0001E4fi6\u000b\u0017\u000e\u001c*fG&\u0004\u0018.\u001a8u)\u0011\u0019\u0019ha\u001f\u0011\u0011\t\u0005\"1FB;\u0007G\u00012aQB<\u0013\r\u0019I\b\u0012\u0002\u0019\u001b\u0012s5+\u001a8e\u001d>$hi\\;oI\u0016C8-\u001a9uS>t\u0007bBB\u0017I\u0001\u00071qF\u0001\u0015O\u0016$X\n\u0012(GS:\fGNU3dSBLWM\u001c;\u0015\r\r\u00055qRBI!!\u0011\tCa\u000b\u0004\u0010\r\r\u0005\u0003BBC\u0007\u0017k!aa\"\u000b\t\r%5qM\u0001\u0007M&,G\u000eZ:\n\t\r55q\u0011\u0002\u000f\r&t\u0017\r\u001c*fG&\u0004\u0018.\u001a8u\u0011\u001d\u0011i-\na\u0001\u0005cCqAa\u0018&\u0001\u0004\u0011\t'\u0001\u0005ck&dG-\u0014#O))\u0019\u0019ga&\u0004\u001a\u000em5q\u0014\u0005\b\u0005\u001b4\u0003\u0019\u0001BY\u0011\u001d\u0019iC\na\u0001\u0007_Aqa!('\u0001\u0004\u0019\u0019)\u0001\bgS:\fGNU3dSBLWM\u001c;\t\u000f\r\u0005f\u00051\u0001\u0004$\u0006\trN]5hS:\fGNU3dSBLWM\u001c;\u0011\t\r\u00155QU\u0005\u0005\u0007O\u001b9IA\tPe&<\u0017N\\1m%\u0016\u001c\u0017\u000e]5f]R\f\u0011DY;jY\u0012lEI\u0014%v[\u0006t'+Z1eC\ndW\rV3yiR!11EBW\u0011\u001d\u0011im\na\u0001\u0005c\u000b1CY;jY\u0012lUm]:bO\u0016\u001cVO\u00196fGR$baa\t\u00044\u000eU\u0006b\u0002BgQ\u0001\u0007!\u0011\u0017\u0005\b\u0007[A\u0003\u0019AB\u0018\u0003i\u0011W/\u001b7e\u001b\u0012s5+\u001a8e\u0007J,\u0017\r^3SKN\u0004xN\\:f)!\u00199ba/\u0004>\u000e}\u0006b\u0002BgS\u0001\u0007!\u0011\u0017\u0005\b\u0007CJ\u0003\u0019AB2\u0011\u001d\u0019\t-\u000ba\u0001\u0007\u000f\n1\"\\5nK6+7o]1hK\u0006q\u0001/\u0019:tK\u0006\u001bX*Z:tC\u001e,G\u0003BB\u0018\u0007\u000fDqa!3+\u0001\u0004\u0011Y/\u0001\bnKN\u001c\u0018mZ3SK2\fG/\u001a3")
public class MDNSendMethod
implements MethodRequiringAccountId<MDNSendRequest>,
Startable {
    private final MDNSerializer serializer;
    private final MailQueueFactory<? extends MailQueue> mailQueueFactory;
    private final MessageIdManager messageIdManager;
    private final EmailSetMethod emailSetMethod;
    private final JmapRfc8621Configuration configuration;
    private final IdentityResolver identityResolver;
    private final MetricFactory metricFactory;
    private final SessionSupplier sessionSupplier;
    private final SessionTranslator sessionTranslator;
    private final Invocation.MethodName methodName;
    private final Set<Refined<String, string.Uri>> requiredCapabilities;
    private MailQueue queue;
    private String JMAP_RFC8621_PREFIX;

    @Override
    public Publisher<InvocationWithContext> process(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession) {
        return MethodRequiringAccountId.process$(this, capabilities, invocation, mailboxSession);
    }

    @Override
    public String JMAP_RFC8621_PREFIX() {
        return this.JMAP_RFC8621_PREFIX;
    }

    @Override
    public void org$apache$james$jmap$method$Method$_setter_$JMAP_RFC8621_PREFIX_$eq(String x$1) {
        this.JMAP_RFC8621_PREFIX = x$1;
    }

    public JmapRfc8621Configuration configuration() {
        return this.configuration;
    }

    public IdentityResolver identityResolver() {
        return this.identityResolver;
    }

    @Override
    public MetricFactory metricFactory() {
        return this.metricFactory;
    }

    @Override
    public SessionSupplier sessionSupplier() {
        return this.sessionSupplier;
    }

    @Override
    public SessionTranslator sessionTranslator() {
        return this.sessionTranslator;
    }

    @Override
    public Invocation.MethodName methodName() {
        return this.methodName;
    }

    @Override
    public Set<Refined<String, string.Uri>> requiredCapabilities() {
        return this.requiredCapabilities;
    }

    public MailQueue queue() {
        return this.queue;
    }

    public void queue_$eq(MailQueue x$1) {
        this.queue = x$1;
    }

    public void init() {
        this.queue_$eq(this.mailQueueFactory.createQueue(MailQueueFactory.SPOOL));
    }

    @PreDestroy
    public void dispose() {
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.queue().close()).recover((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 e, Function1<A1, B1> function1) {
                A1 A1 = e;
                EmailSubmissionSetMethod$.MODULE$.LOGGER().debug("error closing queue", e);
                return (B1)BoxedUnit.UNIT;
            }

            public final boolean isDefinedAt(Throwable e) {
                Throwable throwable = e;
                return true;
            }
        });
    }

    public SFlux<InvocationWithContext> doProcess(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession, MDNSendRequest request) {
        return ((SMono)request.identityId().validate().fold((Function1 & Serializable)e -> SMono$.MODULE$.error((Throwable)new IllegalArgumentException("The IdentityId cannot be found", (Throwable)e)), (Function1 & Serializable)id -> this.identityResolver().resolveIdentityId((IdentityId)id, mailboxSession))).flatMap((Function1 & Serializable)maybeIdentity -> (SMono)maybeIdentity.map((Function1 & Serializable)identity -> this.create((Identity)identity, request, mailboxSession, invocation.processingContext())).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.error((Throwable)new IdentityIdNotFoundException("The IdentityId cannot be found")))).flatMapMany((Function1 & Serializable)createdResults -> {
            InvocationWithContext explicitInvocation = new InvocationWithContext(new Invocation(invocation.invocation().methodName(), (JsObject)$this.serializer.serializeMDNSendResponse(((MDNSendResults)createdResults._1()).asResponse(request.accountId())).as((Reads)Reads$.MODULE$.JsObjectReads()), invocation.invocation().methodCallId()), (ProcessingContext)createdResults._2());
            SMono emailSetCall = (SMono)request.implicitEmailSetRequest((Function1<MDNSendCreationId, Either<IllegalArgumentException, Option<MessageId>>>)(Function1 & Serializable)sendId -> ((MDNSendResults)createdResults._1()).resolveMessageId((MDNSendCreationId)sendId)).fold((Function1 & Serializable)e -> SMono$.MODULE$.error((Throwable)e), (Function1 & Serializable)maybeEmailSetRequest -> (SMono)maybeEmailSetRequest.map((Function1 & Serializable)emailSetRequest -> $this.emailSetMethod.doProcess(capabilities, invocation, mailboxSession, (EmailSetRequest)emailSetRequest)).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.empty()));
            return SFlux$.MODULE$.concat((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Publisher[]{SMono$.MODULE$.just((Object)explicitInvocation), emailSetCall}));
        });
    }

    @Override
    public Either<Exception, MDNSendRequest> getRequest(MailboxSession mailboxSession, Invocation invocation) {
        return package$.MODULE$.AsEitherRequest(this.serializer.deserializeMDNSendRequest((JsValue)invocation.arguments())).asEitherRequest().flatMap((Function1 & Serializable)x$2 -> x$2.validate(this.configuration()));
    }

    private SMono<Tuple2<MDNSendResults, ProcessingContext>> create(Identity identity, MDNSendRequest request, MailboxSession session, ProcessingContext processingContext) {
        List list = request.send().view().toList();
        SFlux qual$1 = SFlux$.MODULE$.just((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)list, (Object)MDNSendResults$.MODULE$.empty(), (Object)processingContext)}));
        Function1 & Serializable x$1 = (Function1 & Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                List list = (List)tuple3._1();
                MDNSendResults result = (MDNSendResults)tuple3._2();
                ProcessingContext context = (ProcessingContext)tuple3._3();
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    Tuple2 head = (Tuple2)colon2.head();
                    List tail = colon2.next$access$1();
                    return this.createMDNSend(session, identity, (MDNSendCreationId)head._1(), (JsObject)head._2(), context).map((Function1 & Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 != null) {
                            MDNSendResults newResult = (MDNSendResults)tuple2._1();
                            ProcessingContext newContext = (ProcessingContext)tuple2._2();
                            return new Tuple3((Object)tail, (Object)MDNSendResults$.MODULE$.merge(result, newResult), (Object)newContext);
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }
            }
            return SMono$.MODULE$.empty();
        };
        int x$2 = qual$1.expand$default$2();
        SFlux qual$2 = qual$1.expand((Function1)x$1, x$2);
        None$ x$3 = qual$2.last$default$1();
        return qual$2.last((Option)x$3).map((Function1 & Serializable)x0$3 -> {
            Tuple3 tuple3 = x0$3;
            if (tuple3 != null) {
                MDNSendResults result = (MDNSendResults)tuple3._2();
                ProcessingContext context = (ProcessingContext)tuple3._3();
                return new Tuple2((Object)result, (Object)context);
            }
            throw new MatchError((Object)tuple3);
        });
    }

    private SMono<Tuple2<MDNSendResults, ProcessingContext>> createMDNSend(MailboxSession session, Identity identity, MDNSendCreationId mdnSendCreationId, JsObject jsObject, ProcessingContext processingContext) {
        return ((SMono)this.parseMDNRequest(jsObject).fold((Function1 & Serializable)e -> SMono$.MODULE$.error((Throwable)e), (Function1 & Serializable)request -> SMono$.MODULE$.just(request))).flatMap((Function1 & Serializable)createRequest -> this.sendMDN(session, identity, mdnSendCreationId, (MDNSendCreateRequest)createRequest)).map((Function1 & Serializable)creation -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MDNSendResults$.MODULE$.sent((MDNSendCreateSuccess)creation)), (Object)processingContext)).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MDNSendResults$.MODULE$.notSent(mdnSendCreationId, (Throwable)e)), (Object)processingContext)));
    }

    private Either<MDNSendRequestInvalidException, MDNSendCreateRequest> parseMDNRequest(JsObject jsObject) {
        return MDNSendCreateRequest$.MODULE$.validateProperties(jsObject).flatMap((Function1 & Serializable)validJson -> {
            JsResult<MDNSendCreateRequest> jsResult = $this.serializer.deserializeMDNSendCreateRequest((JsValue)validJson);
            if (jsResult instanceof JsSuccess) {
                JsSuccess jsSuccess = (JsSuccess)jsResult;
                MDNSendCreateRequest createRequest = (MDNSendCreateRequest)jsSuccess.value();
                return createRequest.validate();
            }
            if (jsResult instanceof JsError) {
                JsError jsError = (JsError)jsResult;
                Seq errors = jsError.errors();
                return new Left((Object)MDNSendRequestInvalidException$.MODULE$.parse((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)errors));
            }
            throw new MatchError(jsResult);
        });
    }

    private SMono<MDNSendCreateSuccess> sendMDN(MailboxSession session, Identity identity, MDNSendCreationId mdnSendCreationId, MDNSendCreateRequest requestEntry) {
        return this.retrieveRelatedMessageResult(session, requestEntry).flatMap((Function1 & Serializable)mdnRelatedMessageResult -> ((SMono)this.validateMDNNotAlreadySent((MessageResult)mdnRelatedMessageResult).fold((Function1 & Serializable)e -> SMono$.MODULE$.error((Throwable)e), (Function1 & Serializable)result -> SMono$.MODULE$.just(result))).map((Function1 & Serializable)mdnRelatedMessageResultAlready -> {
            Message messageRelated = this.parseAsMessage((MessageResult)mdnRelatedMessageResultAlready);
            return new Tuple2(mdnRelatedMessageResultAlready, (Object)messageRelated);
        }).flatMap((Function1 & Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 != null) {
                MessageResult mdnRelatedMessageResultAlready = (MessageResult)tuple2._1();
                Message messageRelated = (Message)tuple2._2();
                return ((SMono)this.buildMailAndResponse(identity, session.getUser().asString(), requestEntry, messageRelated, session).fold((Function1 & Serializable)e -> SMono$.MODULE$.error(e), (Function1 & Serializable)result -> SMono$.MODULE$.just(result))).flatMap((Function1 & Serializable)mailAndResponseAndId -> this.enqueue((MailImpl)mailAndResponseAndId._1()).then(SMono$.MODULE$.just(mailAndResponseAndId._1())).map((Function1 & Serializable)x$3 -> {
                    MailImpl mailImpl = x$3;
                    return new MDNSendCreateSuccess(mdnSendCreationId, (MDNSendCreateResponse)mailAndResponseAndId._2(), mdnRelatedMessageResultAlready.getMessageId());
                }));
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    private SMono<BoxedUnit> enqueue(MailImpl mail) {
        return SMono$.MODULE$.apply(this.queue().enqueueReactive((Mail)mail)).doFinally((Function1 & Serializable)x$5 -> {
            MDNSendMethod.$anonfun$enqueue$1(mail, x$5);
            return BoxedUnit.UNIT;
        }).then();
    }

    private SMono<MessageResult> retrieveRelatedMessageResult(MailboxSession session, MDNSendCreateRequest requestEntry) {
        return SMono$.MODULE$.apply(this.messageIdManager.getMessagesReactive((Collection)ImmutableList.of((Object)requestEntry.forEmailId()), FetchGroup.FULL_CONTENT, session)).switchIfEmpty(SMono$.MODULE$.error((Throwable)new MDNSendNotFoundException("The reference \"forEmailId\" " + requestEntry.forEmailId().serialize() + " cannot be found for user " + session.getUser().asString() + ".")));
    }

    private Either<MDNSendAlreadySentException, MessageResult> validateMDNNotAlreadySent(MessageResult relatedMessageResult) {
        if (relatedMessageResult.getFlags().contains(MDNSend$.MODULE$.MDN_ALREADY_SENT_FLAG())) {
            return new Left((Object)new MDNSendAlreadySentException());
        }
        return new Right((Object)relatedMessageResult);
    }

    private Either<Throwable, Tuple2<MailImpl, MDNSendCreateResponse>> buildMailAndResponse(Identity identity, String sender, MDNSendCreateRequest requestEntry, Message originalMessage, MailboxSession mailboxSession) {
        return this.getMailRecipient(originalMessage).flatMap((Function1 & Serializable)mailRecipient -> this.getMDNFinalRecipient(requestEntry, identity).map((Function1 & Serializable)mdnFinalRecipient -> {
            OriginalRecipient mdnOriginalRecipient = OriginalRecipient.builder().originalRecipient(Text.fromRawText((String)sender)).build();
            MDN mdn = this.buildMDN(requestEntry, originalMessage, (FinalRecipient)mdnFinalRecipient, mdnOriginalRecipient);
            String subject = this.buildMessageSubject(requestEntry, originalMessage);
            Tuple2<MailImpl, MimeMessage> tuple2 = this.buildMailAndMimeMessage(sender, (String)mailRecipient, subject, mdn, mailboxSession);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            MailImpl mailImpl = (MailImpl)tuple2._1();
            MimeMessage mimeMessage = (MimeMessage)tuple2._2();
            Tuple3 tuple3 = new Tuple3(tuple2, (Object)mailImpl, (Object)mimeMessage);
            Tuple2 x$6 = (Tuple2)tuple3._1();
            MailImpl mailImpl2 = (MailImpl)tuple3._2();
            MimeMessage mimeMessage2 = (MimeMessage)tuple3._3();
            return new Tuple5(mdnFinalRecipient, (Object)mdnOriginalRecipient, (Object)mdn, (Object)subject, (Object)x$6);
        }).map((Function1 & Serializable)x$8 -> {
            Tuple5 tuple5 = x$8;
            if (tuple5 != null) {
                MDN mdn = (MDN)tuple5._3();
                Tuple2 tuple2 = (Tuple2)tuple5._5();
                if (tuple2 != null) {
                    MailImpl mailImpl = (MailImpl)tuple2._1();
                    MimeMessage mimeMessage = (MimeMessage)tuple2._2();
                    return new Tuple2((Object)mailImpl, (Object)this.buildMDNSendCreateResponse(requestEntry, mdn, mimeMessage));
                }
            }
            throw new MatchError((Object)tuple5);
        }));
    }

    private Tuple2<MailImpl, MimeMessage> buildMailAndMimeMessage(String sender, String recipient, String subject, MDN mdn, MailboxSession mailboxSession) {
        MimeMessage mimeMessage = mdn.asMimeMessage();
        mimeMessage.setFrom(sender);
        mimeMessage.setRecipients(Message.RecipientType.TO, recipient);
        mimeMessage.setSubject(subject);
        mimeMessage.saveChanges();
        MailImpl mailImpl = MailImpl.builder().name((String)auto$.MODULE$.autoUnwrap((Object)new Refined((Object)MDNId$.MODULE$.generate().value()), RefType$.MODULE$.refinedRefType())).sender(sender).addRecipient(recipient).mimeMessage(mimeMessage).addAttribute(new Attribute(EmailSubmissionSetMethod$.MODULE$.MAIL_METADATA_USERNAME_ATTRIBUTE(), AttributeValue.of((String)mailboxSession.getUser().asString()))).build();
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mailImpl), (Object)mimeMessage);
    }

    private Either<MDNSendNotFoundException, String> getMailRecipient(Message originalMessage) {
        return CollectionConverters$.MODULE$.ListHasAsScala(originalMessage.getHeader().getFields(MDN$.MODULE$.DISPOSITION_NOTIFICATION_TO())).asScala().headOption().map((Function1 & Serializable)field -> (AddressListField)AddressListFieldLenientImpl.PARSER.parse(field, new DecodeMonitor())).map((Function1 & Serializable)addressListField -> addressListField.getAddressList()).map((Function1 & Serializable)addressList -> addressList.flatten()).flatMap((Function1 & Serializable)mailboxList -> OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(mailboxList.stream().findAny()))).map((Function1 & Serializable)mailbox -> mailbox.getAddress()).toRight((Function0 & Serializable)() -> new MDNSendNotFoundException("Invalid \"Disposition-Notification-To\" header field."));
    }

    private Either<Throwable, FinalRecipient> getMDNFinalRecipient(MDNSendCreateRequest requestEntry, Identity identity) {
        return (Either)requestEntry.finalRecipient().map((Function1 & Serializable)finalRecipient -> MDNSendMethod.$anonfun$getMDNFinalRecipient$1(((FinalRecipientField)finalRecipient).value())).map((Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            Right right = null;
            Either either = x0$1;
            if (either instanceof Right) {
                bl = true;
                right = (Right)either;
                MailAddress mailAddress = (MailAddress)right.value();
                if (mailAddress.equals((Object)identity.email())) {
                    return new Right(FinalRecipientField$.MODULE$.asJava$extension(((FinalRecipientField)requestEntry.finalRecipient().get()).value()).get());
                }
            }
            if (bl) {
                return new Left((Object)new MDNSendForbiddenFromException("The user is not allowed to use the given \"finalRecipient\" property"));
            }
            if (either instanceof Left) {
                Left left = (Left)either;
                Throwable error = (Throwable)left.value();
                return new Left((Object)error);
            }
            throw new MatchError((Object)either);
        }).getOrElse((Function0 & Serializable)() -> new Right((Object)FinalRecipient.builder().finalRecipient(Text.fromRawText((String)identity.email().asString())).build()));
    }

    private MDN buildMDN(MDNSendCreateRequest requestEntry, Message originalMessage, FinalRecipient finalRecipient, OriginalRecipient originalRecipient) {
        MDNReport.Builder reportBuilder = MDNReport.builder().dispositionField((Disposition)requestEntry.disposition().asJava().get()).finalRecipientField(finalRecipient).originalRecipientField(originalRecipient);
        CollectionConverters$.MODULE$.ListHasAsScala(originalMessage.getHeader().getFields("Message-ID")).asScala().map((Function1 & Serializable)field -> reportBuilder.originalMessageIdField(field.getBody()));
        requestEntry.reportingUA().map((Function1 & Serializable)uaField -> MDNSendMethod.$anonfun$buildMDN$2(reportBuilder, ((ReportUAField)uaField).value()));
        requestEntry.extensionFields().map((Function1 & Serializable)extensions -> (Iterable)extensions.map((Function1 & Serializable)extension2 -> reportBuilder.withExtensionField(ExtensionField.builder().fieldName(((ExtensionFieldName)extension2._1()).value()).rawValue(((ExtensionFieldValue)extension2._2()).value()).build())));
        CollectionConverters$.MODULE$.ListHasAsScala(originalMessage.getHeader().getFields(EmailHeaderName$.MODULE$.MESSAGE_ID())).asScala().headOption().map((Function1 & Serializable)messageIdHeader -> reportBuilder.originalMessageIdField(TextHeaderValue$.MODULE$.from((Field)messageIdHeader).value()));
        return MDN.builder().report(reportBuilder.build()).humanReadableText(this.buildMDNHumanReadableText(requestEntry)).message(OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(requestEntry.includeOriginalMessage().filter((Function1 & Serializable)isInclude -> BoxesRunTime.boxToBoolean((boolean)((IncludeOriginalMessageField)isInclude).value())).map((Function1 & Serializable)x$9 -> originalMessage)))).build();
    }

    private String buildMDNHumanReadableText(MDNSendCreateRequest requestEntry) {
        return (String)requestEntry.textBody().map((Function1 & Serializable)textBody -> ((TextBodyField)textBody).value()).getOrElse((Function0 & Serializable)() -> "The email has been " + requestEntry.disposition().type() + " on your recipient's computer");
    }

    private String buildMessageSubject(MDNSendCreateRequest requestEntry, Message originalMessage) {
        return (String)requestEntry.subject().map((Function1 & Serializable)subject -> ((SubjectField)subject).value()).getOrElse((Function0 & Serializable)() -> "[Received] " + originalMessage.getSubject());
    }

    private MDNSendCreateResponse buildMDNSendCreateResponse(MDNSendCreateRequest requestEntry, MDN mdn, MimeMessage mimeMessage) {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        None$ none$5;
        Option<SubjectField> option = requestEntry.subject();
        if (option instanceof Some) {
            none$5 = None$.MODULE$;
        } else if (None$.MODULE$.equals(option)) {
            none$5 = new Some((Object)new SubjectField(mimeMessage.getSubject()));
        } else {
            throw new MatchError(option);
        }
        None$ x$1 = none$5;
        Option<TextBodyField> option2 = requestEntry.textBody();
        if (option2 instanceof Some) {
            none$4 = None$.MODULE$;
        } else if (None$.MODULE$.equals(option2)) {
            none$4 = new Some((Object)new TextBodyField(mdn.getHumanReadableText()));
        } else {
            throw new MatchError(option2);
        }
        None$ x$2 = none$4;
        Option<ReportUAField> option3 = requestEntry.reportingUA();
        if (option3 instanceof Some) {
            none$3 = None$.MODULE$;
        } else if (None$.MODULE$.equals(option3)) {
            none$3 = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(mdn.getReport().getReportingUserAgentField().map(ua -> new ReportUAField(ua.fieldValue()))));
        } else {
            throw new MatchError(option3);
        }
        None$ x$3 = none$3;
        Option x$4 = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(mdn.getReport().getGatewayField().map(gateway -> new MDNGatewayField(gateway.fieldValue()))));
        Option x$5 = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(mdn.getReport().getOriginalRecipientField().map(originalRecipient -> new OriginalRecipientField(originalRecipient.fieldValue()))));
        Option<IncludeOriginalMessageField> option4 = requestEntry.includeOriginalMessage();
        if (option4 instanceof Some) {
            none$2 = None$.MODULE$;
        } else if (None$.MODULE$.equals(option4)) {
            none$2 = new Some((Object)new IncludeOriginalMessageField(mdn.getOriginalMessage().isPresent()));
        } else {
            throw new MatchError(option4);
        }
        None$ x$6 = none$2;
        Option x$7 = Option$.MODULE$.apply((Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(mdn.getReport().getErrorFields()).asScala().map((Function1 & Serializable)error -> new ErrorField(MDNSendMethod.$anonfun$buildMDNSendCreateResponse$4(error)))).toSeq()).filter((Function1 & Serializable)error -> BoxesRunTime.boxToBoolean((boolean)error.nonEmpty()));
        Option<FinalRecipientField> option5 = requestEntry.finalRecipient();
        if (option5 instanceof Some) {
            none$ = None$.MODULE$;
        } else if (None$.MODULE$.equals(option5)) {
            none$ = new Some((Object)new FinalRecipientField(mdn.getReport().getFinalRecipientField().fieldValue()));
        } else {
            throw new MatchError(option5);
        }
        None$ x$8 = none$;
        Option x$9 = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(mdn.getReport().getOriginalMessageIdField().map(originalMessageId -> new OriginalMessageIdField(originalMessageId.getOriginalMessageId()))));
        return new MDNSendCreateResponse((Option<SubjectField>)x$1, (Option<TextBodyField>)x$2, (Option<ReportUAField>)x$3, (Option<MDNGatewayField>)x$4, (Option<OriginalRecipientField>)x$5, (Option<FinalRecipientField>)x$8, (Option<IncludeOriginalMessageField>)x$6, (Option<OriginalMessageIdField>)x$9, (Option<scala.collection.immutable.Seq<ErrorField>>)x$7);
    }

    private Message parseAsMessage(MessageResult messageRelated) {
        DefaultMessageBuilder messageBuilder = new DefaultMessageBuilder();
        messageBuilder.setMimeEntityConfig(MimeConfig.PERMISSIVE);
        messageBuilder.setDecodeMonitor(DecodeMonitor.SILENT);
        return messageBuilder.parseMessage(messageRelated.getFullContent().getInputStream());
    }

    public static final /* synthetic */ void $anonfun$enqueue$1(MailImpl mail$1, SignalType x$5) {
        LifecycleUtil.dispose((Object)mail$1);
    }

    public static final /* synthetic */ Either $anonfun$getMDNFinalRecipient$1(String finalRecipient) {
        return FinalRecipientField$.MODULE$.getMailAddress$extension(finalRecipient).toEither();
    }

    public static final /* synthetic */ Try $anonfun$buildMDN$2(MDNReport.Builder reportBuilder$1, String uaField) {
        return ReportUAField$.MODULE$.asJava$extension(uaField).map((Function1 & Serializable)reportingUserAgent -> reportBuilder$1.reportingUserAgentField(reportingUserAgent));
    }

    public static final /* synthetic */ String $anonfun$buildMDNSendCreateResponse$4(Error error) {
        return error.getText().formatted();
    }

    @Inject
    public MDNSendMethod(MDNSerializer serializer, MailQueueFactory<? extends MailQueue> mailQueueFactory, MessageIdManager messageIdManager, EmailSetMethod emailSetMethod, JmapRfc8621Configuration configuration, IdentityResolver identityResolver, MetricFactory metricFactory, SessionSupplier sessionSupplier, SessionTranslator sessionTranslator) {
        this.serializer = serializer;
        this.mailQueueFactory = mailQueueFactory;
        this.messageIdManager = messageIdManager;
        this.emailSetMethod = emailSetMethod;
        this.configuration = configuration;
        this.identityResolver = identityResolver;
        this.metricFactory = metricFactory;
        this.sessionSupplier = sessionSupplier;
        this.sessionTranslator = sessionTranslator;
        Method.$init$(this);
        MethodRequiringAccountId.$init$(this);
        this.methodName = new Invocation.MethodName((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"MDN/send")).value());
        this.requiredCapabilities = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_MDN()), new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_MAIL()), new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_CORE())}));
        Statics.releaseFence();
    }
}

