/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.mdc;

import java.io.Closeable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Filter;
import spark.Request;
import spark.Response;

public class MDCCleanupFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MDCCleanupFilter.class);

    public void handle(Request request, Response response) throws Exception {
        Object attribute = request.attribute("MDCCloseable");
        if (attribute instanceof Closeable) {
            Closeable closeable = (Closeable)attribute;
            closeable.close();
        } else {
            LOGGER.error("Invalid MDC closeable {} of class {}", attribute, attribute.getClass());
        }
    }
}

