/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.postgres.utils;

import com.google.common.annotations.VisibleForTesting;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.R2dbcBadGrammarException;
import jakarta.inject.Inject;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.james.backends.postgres.PostgresConfiguration;
import org.apache.james.backends.postgres.utils.JamesPostgresConnectionFactory;
import org.apache.james.core.Domain;
import org.apache.james.metrics.api.MetricFactory;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.DeleteResultStep;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.conf.Settings;
import org.jooq.conf.StatementType;
import org.jooq.impl.DSL;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

public class PostgresExecutor {
    public static final String DEFAULT_INJECT = "default";
    public static final String BY_PASS_RLS_INJECT = "by_pass_rls";
    public static final int MAX_RETRY_ATTEMPTS = 5;
    public static final Duration MIN_BACKOFF = Duration.ofMillis(1L);
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresExecutor.class);
    private static final String JOOQ_TIMEOUT_ERROR_LOG = "Time out executing Postgres query. May need to check either jOOQ reactive issue or Postgres DB performance.";
    public static final boolean EAGER_FETCH = true;
    private static final SQLDialect PGSQL_DIALECT = SQLDialect.POSTGRES;
    private static final Settings SETTINGS = new Settings().withRenderFormatted(Boolean.valueOf(true)).withStatementType(StatementType.PREPARED_STATEMENT);
    private final Optional<Domain> domain;
    private final JamesPostgresConnectionFactory jamesPostgresConnectionFactory;
    private final PostgresConfiguration postgresConfiguration;
    private final MetricFactory metricFactory;

    private PostgresExecutor(Optional<Domain> domain, JamesPostgresConnectionFactory jamesPostgresConnectionFactory, PostgresConfiguration postgresConfiguration, MetricFactory metricFactory) {
        this.domain = domain;
        this.jamesPostgresConnectionFactory = jamesPostgresConnectionFactory;
        this.postgresConfiguration = postgresConfiguration;
        this.metricFactory = metricFactory;
    }

    public Mono<DSLContext> dslContext(Connection connection) {
        return Mono.fromCallable(() -> DSL.using((Connection)connection, (SQLDialect)PGSQL_DIALECT, (Settings)SETTINGS));
    }

    public Mono<Void> executeVoid(Function<DSLContext, Mono<?>> queryFunction) {
        return Mono.from((Publisher)this.metricFactory.decoratePublisherWithTimerMetric("postgres-execution", (Publisher)Mono.usingWhen(this.getConnection(this.domain), connection -> this.dslContext((Connection)connection).flatMap(queryFunction).timeout(this.postgresConfiguration.getJooqReactiveTimeout()).doOnError(TimeoutException.class, e -> LOGGER.error(JOOQ_TIMEOUT_ERROR_LOG, (Throwable)e)).retryWhen((Retry)Retry.backoff((long)5L, (Duration)MIN_BACKOFF).filter(this.preparedStatementConflictException())).then(), this.jamesPostgresConnectionFactory::closeConnection)));
    }

    public Flux<Record> executeRows(Function<DSLContext, Flux<Record>> queryFunction) {
        return this.executeRows(queryFunction, false);
    }

    public Flux<Record> executeRows(Function<DSLContext, Flux<Record>> queryFunction, boolean isEagerFetch) {
        return Flux.from((Publisher)this.metricFactory.decoratePublisherWithTimerMetric("postgres-execution", (Publisher)Flux.usingWhen(this.getConnection(this.domain), connection -> {
            Flux recordFlux = this.dslContext((Connection)connection).flatMapMany(queryFunction).timeout(this.postgresConfiguration.getJooqReactiveTimeout()).doOnError(TimeoutException.class, e -> LOGGER.error(JOOQ_TIMEOUT_ERROR_LOG, (Throwable)e)).retryWhen((Retry)Retry.backoff((long)5L, (Duration)MIN_BACKOFF).filter(this.preparedStatementConflictException()));
            if (isEagerFetch) {
                return recordFlux.collectList().flatMapIterable(list -> list);
            }
            return recordFlux;
        }, this.jamesPostgresConnectionFactory::closeConnection)));
    }

    public Flux<Record> executeDeleteAndReturnList(Function<DSLContext, DeleteResultStep<Record>> queryFunction) {
        return Flux.from((Publisher)this.metricFactory.decoratePublisherWithTimerMetric("postgres-execution", (Publisher)Flux.usingWhen(this.getConnection(this.domain), connection -> this.dslContext((Connection)connection).flatMapMany(queryFunction).timeout(this.postgresConfiguration.getJooqReactiveTimeout()).doOnError(TimeoutException.class, e -> LOGGER.error(JOOQ_TIMEOUT_ERROR_LOG, (Throwable)e)).retryWhen((Retry)Retry.backoff((long)5L, (Duration)MIN_BACKOFF).filter(this.preparedStatementConflictException())), this.jamesPostgresConnectionFactory::closeConnection)));
    }

    public Mono<Record> executeRow(Function<DSLContext, Publisher<Record>> queryFunction) {
        return Mono.from((Publisher)this.metricFactory.decoratePublisherWithTimerMetric("postgres-execution", (Publisher)Mono.usingWhen(this.getConnection(this.domain), connection -> this.dslContext((Connection)connection).flatMap(queryFunction.andThen(Mono::from)).timeout(this.postgresConfiguration.getJooqReactiveTimeout()).doOnError(TimeoutException.class, e -> LOGGER.error(JOOQ_TIMEOUT_ERROR_LOG, (Throwable)e)).retryWhen((Retry)Retry.backoff((long)5L, (Duration)MIN_BACKOFF).filter(this.preparedStatementConflictException())), this.jamesPostgresConnectionFactory::closeConnection)));
    }

    public Mono<Optional<Record>> executeSingleRowOptional(Function<DSLContext, Publisher<Record>> queryFunction) {
        return this.executeRow(queryFunction).map(Optional::ofNullable).switchIfEmpty(Mono.just(Optional.empty()));
    }

    public Mono<Integer> executeCount(Function<DSLContext, Mono<Record1<Integer>>> queryFunction) {
        return Mono.from((Publisher)this.metricFactory.decoratePublisherWithTimerMetric("postgres-execution", (Publisher)Mono.usingWhen(this.getConnection(this.domain), connection -> this.dslContext((Connection)connection).flatMap(queryFunction).timeout(this.postgresConfiguration.getJooqReactiveTimeout()).doOnError(TimeoutException.class, e -> LOGGER.error(JOOQ_TIMEOUT_ERROR_LOG, (Throwable)e)).retryWhen((Retry)Retry.backoff((long)5L, (Duration)MIN_BACKOFF).filter(this.preparedStatementConflictException())).map(Record1::value1), this.jamesPostgresConnectionFactory::closeConnection)));
    }

    public Mono<Boolean> executeExists(Function<DSLContext, SelectConditionStep<?>> queryFunction) {
        return this.executeRow(dslContext -> Mono.from((Publisher)dslContext.select((SelectField)DSL.field((Condition)DSL.exists((Select)((Select)queryFunction.apply((DSLContext)dslContext))))))).map(record -> (Boolean)record.get(0, Boolean.class));
    }

    public Mono<Integer> executeReturnAffectedRowsCount(Function<DSLContext, Mono<Integer>> queryFunction) {
        return Mono.from((Publisher)this.metricFactory.decoratePublisherWithTimerMetric("postgres-execution", (Publisher)Mono.usingWhen(this.getConnection(this.domain), connection -> this.dslContext((Connection)connection).flatMap(queryFunction).timeout(this.postgresConfiguration.getJooqReactiveTimeout()).doOnError(TimeoutException.class, e -> LOGGER.error(JOOQ_TIMEOUT_ERROR_LOG, (Throwable)e)).retryWhen((Retry)Retry.backoff((long)5L, (Duration)MIN_BACKOFF).filter(this.preparedStatementConflictException())), this.jamesPostgresConnectionFactory::closeConnection)));
    }

    public JamesPostgresConnectionFactory connectionFactory() {
        return this.jamesPostgresConnectionFactory;
    }

    @VisibleForTesting
    public void dispose() {
        this.jamesPostgresConnectionFactory.close().block();
    }

    private Predicate<Throwable> preparedStatementConflictException() {
        return throwable -> throwable.getCause() instanceof R2dbcBadGrammarException && throwable.getMessage().contains("prepared statement") && throwable.getMessage().contains("already exists");
    }

    private Mono<Connection> getConnection(Optional<Domain> maybeDomain) {
        return maybeDomain.map(this.jamesPostgresConnectionFactory::getConnection).orElseGet(this.jamesPostgresConnectionFactory::getConnection);
    }

    public static class Factory {
        private final JamesPostgresConnectionFactory jamesPostgresConnectionFactory;
        private final PostgresConfiguration postgresConfiguration;
        private final MetricFactory metricFactory;

        @Inject
        public Factory(JamesPostgresConnectionFactory jamesPostgresConnectionFactory, PostgresConfiguration postgresConfiguration, MetricFactory metricFactory) {
            this.jamesPostgresConnectionFactory = jamesPostgresConnectionFactory;
            this.postgresConfiguration = postgresConfiguration;
            this.metricFactory = metricFactory;
        }

        public PostgresExecutor create(Optional<Domain> domain) {
            return new PostgresExecutor(domain, this.jamesPostgresConnectionFactory, this.postgresConfiguration, this.metricFactory);
        }

        public PostgresExecutor create() {
            return this.create(Optional.empty());
        }
    }
}

