/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail.model;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.mail.model.impl.Properties;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public interface Message {
    public MessageId getMessageId();

    public Date getInternalDate();

    public InputStream getBodyContent() throws IOException;

    default public Optional<byte[][]> getBodyBytes() {
        return Optional.empty();
    }

    default public Publisher<ByteBuffer> getBodyContentReactive() {
        try {
            return ReactorUtils.toChunks((InputStream)this.getBodyContent(), (int)16384).subscribeOn(Schedulers.boundedElastic());
        }
        catch (IOException e) {
            return Flux.error((Throwable)e);
        }
    }

    public String getMediaType();

    public String getSubType();

    public long getBodyOctets();

    public long getFullContentOctets();

    public long getHeaderOctets();

    public Long getTextualLineCount();

    public InputStream getHeaderContent() throws IOException;

    default public Optional<byte[][]> getHeadersBytes() {
        return Optional.empty();
    }

    default public Publisher<ByteBuffer> getHeaderContentReactive() {
        try {
            return ReactorUtils.toChunks((InputStream)this.getHeaderContent(), (int)16384).subscribeOn(Schedulers.boundedElastic());
        }
        catch (IOException e) {
            return Flux.error((Throwable)e);
        }
    }

    public InputStream getFullContent() throws IOException;

    default public Optional<byte[][]> getFullBytes() {
        return Optional.empty();
    }

    default public Publisher<ByteBuffer> getFullContentReactive() {
        try {
            return ReactorUtils.toChunks((InputStream)this.getFullContent(), (int)16384).subscribeOn(Schedulers.boundedElastic());
        }
        catch (IOException e) {
            return Flux.error((Throwable)e);
        }
    }

    public Properties getProperties();

    public List<MessageAttachmentMetadata> getAttachments();
}

