/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.json;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.internal.WitnessAs$;
import eu.timepit.refined.numeric;
import java.io.Serializable;
import org.apache.james.jmap.core.AccountId;
import org.apache.james.jmap.core.CanCalculateChanges;
import org.apache.james.jmap.core.Id$;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.QueryState;
import org.apache.james.jmap.core.UuidState;
import org.apache.james.jmap.json.package$;
import org.apache.james.jmap.mail.AccountScope$;
import org.apache.james.jmap.mail.CountResourceType$;
import org.apache.james.jmap.mail.DataType;
import org.apache.james.jmap.mail.HasMoreChanges;
import org.apache.james.jmap.mail.JmapQuota;
import org.apache.james.jmap.mail.JmapQuota$;
import org.apache.james.jmap.mail.MailDataType$;
import org.apache.james.jmap.mail.OctetsResourceType$;
import org.apache.james.jmap.mail.QuotaChangesRequest;
import org.apache.james.jmap.mail.QuotaChangesResponse;
import org.apache.james.jmap.mail.QuotaDescription;
import org.apache.james.jmap.mail.QuotaGetRequest;
import org.apache.james.jmap.mail.QuotaGetResponse;
import org.apache.james.jmap.mail.QuotaGetResponse$;
import org.apache.james.jmap.mail.QuotaIds;
import org.apache.james.jmap.mail.QuotaName;
import org.apache.james.jmap.mail.QuotaNotFound;
import org.apache.james.jmap.mail.QuotaQueryFilter;
import org.apache.james.jmap.mail.QuotaQueryFilter$;
import org.apache.james.jmap.mail.QuotaQueryRequest;
import org.apache.james.jmap.mail.QuotaQueryResponse;
import org.apache.james.jmap.mail.QuotaQueryResponse$;
import org.apache.james.jmap.mail.ResourceType;
import org.apache.james.jmap.mail.Scope;
import org.apache.james.jmap.mail.UnparsedQuotaId;
import play.api.libs.functional.ContravariantFunctor;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.json.JsArray;
import play.api.libs.json.JsArray$;
import play.api.libs.json.JsError;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsString;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsSuccess$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json;
import play.api.libs.json.Json$;
import play.api.libs.json.JsonConfiguration;
import play.api.libs.json.JsonConfiguration$;
import play.api.libs.json.JsonValidationError;
import play.api.libs.json.OWrites;
import play.api.libs.json.OWrites$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import shapeless.Witness$;
import shapeless._0;
import shapeless.ops.nat;

public final class QuotaSerializer$ {
    public static final QuotaSerializer$ MODULE$ = new QuotaSerializer$();
    private static final Writes<UnparsedQuotaId> unparsedQuotaIdWrites;
    private static final Reads<UnparsedQuotaId> unparsedQuotaIdReads;
    private static final Reads<QuotaIds> quotaIdsReads;
    private static final Reads<QuotaGetRequest> quotaGetRequestReads;
    private static final Writes<UuidState> stateWrites;
    private static final Writes<ResourceType> resourceTypeWrite;
    private static final Reads<Scope> scopeReads;
    private static final Reads<QuotaName> optionReads;
    private static final Reads<ResourceType> resourceTypeReads;
    private static final Reads<DataType> dataTypeReads;
    private static final Writes<Scope> scopeWrites;
    private static final Writes<DataType> dataTypeWrites;
    private static final Writes<QuotaName> quotaNameWrites;
    private static final Writes<QuotaDescription> quotaDescriptionWrites;
    private static final Writes<JmapQuota> jmapQuotaWrites;
    private static final Writes<QuotaNotFound> quotaNotFoundWrites;
    private static final Writes<QuotaGetResponse> quotaGetResponseWrites;
    private static final Reads<QuotaChangesRequest> quotaChangesRequestReads;
    private static final Writes<QuotaChangesResponse> quotaChangesResponseWrites;
    private static final Reads<QuotaQueryFilter> filterReads;
    private static final Reads<QuotaQueryRequest> quotaQueryRequestReads;
    private static final Writes<CanCalculateChanges> canCalculateChangesWrites;
    private static final Writes<QueryState> queryStateWrites;
    private static final OWrites<QuotaQueryResponse> quotaQueryResponseWrites;

    static {
        ContravariantFunctor fn = (ContravariantFunctor)Predef$.MODULE$.implicitly((Object)Writes$.MODULE$.contravariantfunctorWrites());
        Writes w = (Writes)Predef$.MODULE$.implicitly(package$.MODULE$.writeRefined(Writes$.MODULE$.StringWrites(), RefType$.MODULE$.refinedRefType()));
        unparsedQuotaIdWrites = (Writes)fn.contramap((Object)w, (Function1 & Serializable)x$1 -> new Refined((Object)x$1.id()));
        unparsedQuotaIdReads = new Reads<UnparsedQuotaId>(){

            public <B> Reads<B> map(Function1<UnparsedQuotaId, B> f) {
                return Reads.map$((Reads)this, f);
            }

            public <B> Reads<B> flatMap(Function1<UnparsedQuotaId, Reads<B>> f) {
                return Reads.flatMap$((Reads)this, f);
            }

            public Reads<UnparsedQuotaId> filter(Function1<UnparsedQuotaId, Object> f) {
                return Reads.filter$((Reads)this, f);
            }

            public Reads<UnparsedQuotaId> filter(JsonValidationError error, Function1<UnparsedQuotaId, Object> f) {
                return Reads.filter$((Reads)this, (JsonValidationError)error, f);
            }

            public Reads<UnparsedQuotaId> filterNot(Function1<UnparsedQuotaId, Object> f) {
                return Reads.filterNot$((Reads)this, f);
            }

            public Reads<UnparsedQuotaId> filterNot(JsonValidationError error, Function1<UnparsedQuotaId, Object> f) {
                return Reads.filterNot$((Reads)this, (JsonValidationError)error, f);
            }

            public <B> Reads<B> collect(JsonValidationError error, PartialFunction<UnparsedQuotaId, B> f) {
                return Reads.collect$((Reads)this, (JsonValidationError)error, f);
            }

            public Reads<UnparsedQuotaId> orElse(Reads<UnparsedQuotaId> v) {
                return Reads.orElse$((Reads)this, v);
            }

            public <B extends JsValue> Reads<UnparsedQuotaId> compose(Reads<B> rb) {
                return Reads.compose$((Reads)this, rb);
            }

            public <B extends JsValue> Reads<UnparsedQuotaId> composeWith(Reads<B> rb) {
                return Reads.composeWith$((Reads)this, rb);
            }

            public Reads<UnparsedQuotaId> preprocess(PartialFunction<JsValue, JsValue> f) {
                return Reads.preprocess$((Reads)this, f);
            }

            public <B> Reads<B> flatMapResult(Function1<UnparsedQuotaId, JsResult<B>> f) {
                return Reads.flatMapResult$((Reads)this, f);
            }

            public <B> Reads<B> andThen(Reads<B> rb, .less.colon.less<UnparsedQuotaId, JsValue> witness) {
                return Reads.andThen$((Reads)this, rb, witness);
            }

            public <B> Reads<B> widen() {
                return Reads.widen$((Reads)this);
            }

            public final JsResult<UnparsedQuotaId> reads(JsValue json) {
                return QuotaSerializer$.org$apache$james$jmap$json$QuotaSerializer$$$anonfun$unparsedQuotaIdReads$1(json);
            }
            {
                Reads.$init$((Reads)this);
            }
        };
        quotaIdsReads = ((Reads)Predef$.MODULE$.implicitly((Object)Reads$.MODULE$.traversableReads(List$.MODULE$.iterableFactory(), MODULE$.unparsedQuotaIdReads()))).map((Function1 & Serializable)v -> new QuotaIds((List<UnparsedQuotaId>)v));
        JsonConfiguration config$macro$2 = JsonConfiguration$.MODULE$.default((Json.MacroOptions$.Default)Json.MacroOptions$.Default$.macroOptionsDefault$.MODULE$);
        Reads underlying = (Reads)play.api.libs.functional.syntax.package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash(config$macro$2.naming().apply("accountId")).read(package$.MODULE$.accountIdWrites()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)config$macro$2.optionHandlers().readHandler(JsPath$.MODULE$.$bslash(config$macro$2.naming().apply("ids")), MODULE$.quotaIdsReads())).and((Object)config$macro$2.optionHandlers().readHandler(JsPath$.MODULE$.$bslash(config$macro$2.naming().apply("properties")), package$.MODULE$.propertiesFormat())).apply((Function3 & Serializable)(accountId, ids, properties) -> new QuotaGetRequest((AccountId)accountId, (Option<QuotaIds>)ids, (Option<Properties>)properties), Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult())));
        quotaGetRequestReads = Reads$.MODULE$.apply((Function1 & Serializable)x0$2 -> {
            JsValue jsValue = x0$2;
            if (jsValue instanceof JsObject) {
                JsObject jsObject = (JsObject)jsValue;
                return underlying.reads((JsValue)jsObject);
            }
            return JsError$.MODULE$.apply("error.expected.jsobject");
        });
        ContravariantFunctor fn2 = (ContravariantFunctor)Predef$.MODULE$.implicitly((Object)Writes$.MODULE$.contravariantfunctorWrites());
        Writes w2 = (Writes)Predef$.MODULE$.implicitly((Object)Writes$.MODULE$.UuidWrites());
        stateWrites = (Writes)fn2.contramap((Object)w2, (Function1 & Serializable)x$2 -> x$2.value());
        resourceTypeWrite = new Writes<ResourceType>(){

            public <B> Writes<B> contramap(Function1<B, ResourceType> f) {
                return Writes.contramap$((Writes)this, f);
            }

            public <B extends ResourceType> Writes<B> narrow() {
                return Writes.narrow$((Writes)this);
            }

            public Writes<ResourceType> transform(Function1<JsValue, JsValue> transformer) {
                return Writes.transform$((Writes)this, transformer);
            }

            public Writes<ResourceType> transform(Writes<JsValue> transformer) {
                return Writes.transform$((Writes)this, transformer);
            }

            public final JsValue writes(ResourceType o) {
                return QuotaSerializer$.org$apache$james$jmap$json$QuotaSerializer$$$anonfun$resourceTypeWrite$1(o);
            }
            {
                Writes.$init$((Writes)this);
            }
        };
        scopeReads = new Reads<Scope>(){

            public <B> Reads<B> map(Function1<Scope, B> f) {
                return Reads.map$((Reads)this, f);
            }

            public <B> Reads<B> flatMap(Function1<Scope, Reads<B>> f) {
                return Reads.flatMap$((Reads)this, f);
            }

            public Reads<Scope> filter(Function1<Scope, Object> f) {
                return Reads.filter$((Reads)this, f);
            }

            public Reads<Scope> filter(JsonValidationError error, Function1<Scope, Object> f) {
                return Reads.filter$((Reads)this, (JsonValidationError)error, f);
            }

            public Reads<Scope> filterNot(Function1<Scope, Object> f) {
                return Reads.filterNot$((Reads)this, f);
            }

            public Reads<Scope> filterNot(JsonValidationError error, Function1<Scope, Object> f) {
                return Reads.filterNot$((Reads)this, (JsonValidationError)error, f);
            }

            public <B> Reads<B> collect(JsonValidationError error, PartialFunction<Scope, B> f) {
                return Reads.collect$((Reads)this, (JsonValidationError)error, f);
            }

            public Reads<Scope> orElse(Reads<Scope> v) {
                return Reads.orElse$((Reads)this, v);
            }

            public <B extends JsValue> Reads<Scope> compose(Reads<B> rb) {
                return Reads.compose$((Reads)this, rb);
            }

            public <B extends JsValue> Reads<Scope> composeWith(Reads<B> rb) {
                return Reads.composeWith$((Reads)this, rb);
            }

            public Reads<Scope> preprocess(PartialFunction<JsValue, JsValue> f) {
                return Reads.preprocess$((Reads)this, f);
            }

            public <B> Reads<B> flatMapResult(Function1<Scope, JsResult<B>> f) {
                return Reads.flatMapResult$((Reads)this, f);
            }

            public <B> Reads<B> andThen(Reads<B> rb, .less.colon.less<Scope, JsValue> witness) {
                return Reads.andThen$((Reads)this, rb, witness);
            }

            public <B> Reads<B> widen() {
                return Reads.widen$((Reads)this);
            }

            public final JsResult<Scope> reads(JsValue json) {
                return QuotaSerializer$.org$apache$james$jmap$json$QuotaSerializer$$$anonfun$scopeReads$1(json);
            }
            {
                Reads.$init$((Reads)this);
            }
        };
        optionReads = ((Reads)Predef$.MODULE$.implicitly((Object)Reads$.MODULE$.StringReads())).map((Function1 & Serializable)v -> new QuotaName((String)v));
        resourceTypeReads = new Reads<ResourceType>(){

            public <B> Reads<B> map(Function1<ResourceType, B> f) {
                return Reads.map$((Reads)this, f);
            }

            public <B> Reads<B> flatMap(Function1<ResourceType, Reads<B>> f) {
                return Reads.flatMap$((Reads)this, f);
            }

            public Reads<ResourceType> filter(Function1<ResourceType, Object> f) {
                return Reads.filter$((Reads)this, f);
            }

            public Reads<ResourceType> filter(JsonValidationError error, Function1<ResourceType, Object> f) {
                return Reads.filter$((Reads)this, (JsonValidationError)error, f);
            }

            public Reads<ResourceType> filterNot(Function1<ResourceType, Object> f) {
                return Reads.filterNot$((Reads)this, f);
            }

            public Reads<ResourceType> filterNot(JsonValidationError error, Function1<ResourceType, Object> f) {
                return Reads.filterNot$((Reads)this, (JsonValidationError)error, f);
            }

            public <B> Reads<B> collect(JsonValidationError error, PartialFunction<ResourceType, B> f) {
                return Reads.collect$((Reads)this, (JsonValidationError)error, f);
            }

            public Reads<ResourceType> orElse(Reads<ResourceType> v) {
                return Reads.orElse$((Reads)this, v);
            }

            public <B extends JsValue> Reads<ResourceType> compose(Reads<B> rb) {
                return Reads.compose$((Reads)this, rb);
            }

            public <B extends JsValue> Reads<ResourceType> composeWith(Reads<B> rb) {
                return Reads.composeWith$((Reads)this, rb);
            }

            public Reads<ResourceType> preprocess(PartialFunction<JsValue, JsValue> f) {
                return Reads.preprocess$((Reads)this, f);
            }

            public <B> Reads<B> flatMapResult(Function1<ResourceType, JsResult<B>> f) {
                return Reads.flatMapResult$((Reads)this, f);
            }

            public <B> Reads<B> andThen(Reads<B> rb, .less.colon.less<ResourceType, JsValue> witness) {
                return Reads.andThen$((Reads)this, rb, witness);
            }

            public <B> Reads<B> widen() {
                return Reads.widen$((Reads)this);
            }

            public final JsResult<ResourceType> reads(JsValue json) {
                return QuotaSerializer$.org$apache$james$jmap$json$QuotaSerializer$$$anonfun$resourceTypeReads$1(json);
            }
            {
                Reads.$init$((Reads)this);
            }
        };
        dataTypeReads = new Reads<DataType>(){

            public <B> Reads<B> map(Function1<DataType, B> f) {
                return Reads.map$((Reads)this, f);
            }

            public <B> Reads<B> flatMap(Function1<DataType, Reads<B>> f) {
                return Reads.flatMap$((Reads)this, f);
            }

            public Reads<DataType> filter(Function1<DataType, Object> f) {
                return Reads.filter$((Reads)this, f);
            }

            public Reads<DataType> filter(JsonValidationError error, Function1<DataType, Object> f) {
                return Reads.filter$((Reads)this, (JsonValidationError)error, f);
            }

            public Reads<DataType> filterNot(Function1<DataType, Object> f) {
                return Reads.filterNot$((Reads)this, f);
            }

            public Reads<DataType> filterNot(JsonValidationError error, Function1<DataType, Object> f) {
                return Reads.filterNot$((Reads)this, (JsonValidationError)error, f);
            }

            public <B> Reads<B> collect(JsonValidationError error, PartialFunction<DataType, B> f) {
                return Reads.collect$((Reads)this, (JsonValidationError)error, f);
            }

            public Reads<DataType> orElse(Reads<DataType> v) {
                return Reads.orElse$((Reads)this, v);
            }

            public <B extends JsValue> Reads<DataType> compose(Reads<B> rb) {
                return Reads.compose$((Reads)this, rb);
            }

            public <B extends JsValue> Reads<DataType> composeWith(Reads<B> rb) {
                return Reads.composeWith$((Reads)this, rb);
            }

            public Reads<DataType> preprocess(PartialFunction<JsValue, JsValue> f) {
                return Reads.preprocess$((Reads)this, f);
            }

            public <B> Reads<B> flatMapResult(Function1<DataType, JsResult<B>> f) {
                return Reads.flatMapResult$((Reads)this, f);
            }

            public <B> Reads<B> andThen(Reads<B> rb, .less.colon.less<DataType, JsValue> witness) {
                return Reads.andThen$((Reads)this, rb, witness);
            }

            public <B> Reads<B> widen() {
                return Reads.widen$((Reads)this);
            }

            public final JsResult<DataType> reads(JsValue json) {
                return QuotaSerializer$.org$apache$james$jmap$json$QuotaSerializer$$$anonfun$dataTypeReads$1(json);
            }
            {
                Reads.$init$((Reads)this);
            }
        };
        scopeWrites = new Writes<Scope>(){

            public <B> Writes<B> contramap(Function1<B, Scope> f) {
                return Writes.contramap$((Writes)this, f);
            }

            public <B extends Scope> Writes<B> narrow() {
                return Writes.narrow$((Writes)this);
            }

            public Writes<Scope> transform(Function1<JsValue, JsValue> transformer) {
                return Writes.transform$((Writes)this, transformer);
            }

            public Writes<Scope> transform(Writes<JsValue> transformer) {
                return Writes.transform$((Writes)this, transformer);
            }

            public final JsValue writes(Scope o) {
                return QuotaSerializer$.org$apache$james$jmap$json$QuotaSerializer$$$anonfun$scopeWrites$1(o);
            }
            {
                Writes.$init$((Writes)this);
            }
        };
        dataTypeWrites = new Writes<DataType>(){

            public <B> Writes<B> contramap(Function1<B, DataType> f) {
                return Writes.contramap$((Writes)this, f);
            }

            public <B extends DataType> Writes<B> narrow() {
                return Writes.narrow$((Writes)this);
            }

            public Writes<DataType> transform(Function1<JsValue, JsValue> transformer) {
                return Writes.transform$((Writes)this, transformer);
            }

            public Writes<DataType> transform(Writes<JsValue> transformer) {
                return Writes.transform$((Writes)this, transformer);
            }

            public final JsValue writes(DataType o) {
                return QuotaSerializer$.org$apache$james$jmap$json$QuotaSerializer$$$anonfun$dataTypeWrites$1(o);
            }
            {
                Writes.$init$((Writes)this);
            }
        };
        ContravariantFunctor fn3 = (ContravariantFunctor)Predef$.MODULE$.implicitly((Object)Writes$.MODULE$.contravariantfunctorWrites());
        Writes w3 = (Writes)Predef$.MODULE$.implicitly((Object)Writes$.MODULE$.StringWrites());
        quotaNameWrites = (Writes)fn3.contramap((Object)w3, (Function1 & Serializable)x$3 -> x$3.string());
        ContravariantFunctor fn4 = (ContravariantFunctor)Predef$.MODULE$.implicitly((Object)Writes$.MODULE$.contravariantfunctorWrites());
        Writes w4 = (Writes)Predef$.MODULE$.implicitly((Object)Writes$.MODULE$.StringWrites());
        quotaDescriptionWrites = (Writes)fn4.contramap((Object)w4, (Function1 & Serializable)x$4 -> x$4.string());
        JsonConfiguration config$macro$4 = JsonConfiguration$.MODULE$.default((Json.MacroOptions$.Default)Json.MacroOptions$.Default$.macroOptionsDefault$.MODULE$);
        jmapQuotaWrites = (OWrites)play.api.libs.functional.syntax.package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash(config$macro$4.naming().apply("id")).write(package$.MODULE$.writeRefined(Writes$.MODULE$.StringWrites(), RefType$.MODULE$.refinedRefType())), OWrites$.MODULE$.functionalCanBuildOWrites()).and((Object)JsPath$.MODULE$.$bslash(config$macro$4.naming().apply("resourceType")).write(MODULE$.resourceTypeWrite())).and((Object)JsPath$.MODULE$.$bslash(config$macro$4.naming().apply("used")).write(package$.MODULE$.writeRefined(Writes$.MODULE$.LongWrites(), RefType$.MODULE$.refinedRefType()))).and((Object)JsPath$.MODULE$.$bslash(config$macro$4.naming().apply("hardLimit")).write(package$.MODULE$.writeRefined(Writes$.MODULE$.LongWrites(), RefType$.MODULE$.refinedRefType()))).and((Object)config$macro$4.optionHandlers().writeHandler(JsPath$.MODULE$.$bslash(config$macro$4.naming().apply("limit")), package$.MODULE$.writeRefined(Writes$.MODULE$.LongWrites(), RefType$.MODULE$.refinedRefType()))).and((Object)JsPath$.MODULE$.$bslash(config$macro$4.naming().apply("scope")).write(MODULE$.scopeWrites())).and((Object)JsPath$.MODULE$.$bslash(config$macro$4.naming().apply("name")).write(MODULE$.quotaNameWrites())).and((Object)JsPath$.MODULE$.$bslash(config$macro$4.naming().apply("types")).write(Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), MODULE$.dataTypeWrites()))).and((Object)config$macro$4.optionHandlers().writeHandler(JsPath$.MODULE$.$bslash(config$macro$4.naming().apply("dataTypes")), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), MODULE$.dataTypeWrites()))).and((Object)config$macro$4.optionHandlers().writeHandler(JsPath$.MODULE$.$bslash(config$macro$4.naming().apply("warnLimit")), package$.MODULE$.writeRefined(Writes$.MODULE$.LongWrites(), RefType$.MODULE$.refinedRefType()))).and((Object)config$macro$4.optionHandlers().writeHandler(JsPath$.MODULE$.$bslash(config$macro$4.naming().apply("softLimit")), package$.MODULE$.writeRefined(Writes$.MODULE$.LongWrites(), RefType$.MODULE$.refinedRefType()))).and((Object)config$macro$4.optionHandlers().writeHandler(JsPath$.MODULE$.$bslash(config$macro$4.naming().apply("description")), MODULE$.quotaDescriptionWrites())).apply(play.api.libs.functional.syntax.package$.MODULE$.unlift((Function1 & Serializable)x$0 -> JmapQuota$.MODULE$.unapply((JmapQuota)x$0)), OWrites$.MODULE$.contravariantfunctorOWrites());
        quotaNotFoundWrites = new Writes<QuotaNotFound>(){

            public <B> Writes<B> contramap(Function1<B, QuotaNotFound> f) {
                return Writes.contramap$((Writes)this, f);
            }

            public <B extends QuotaNotFound> Writes<B> narrow() {
                return Writes.narrow$((Writes)this);
            }

            public Writes<QuotaNotFound> transform(Function1<JsValue, JsValue> transformer) {
                return Writes.transform$((Writes)this, transformer);
            }

            public Writes<QuotaNotFound> transform(Writes<JsValue> transformer) {
                return Writes.transform$((Writes)this, transformer);
            }

            public final JsValue writes(QuotaNotFound o) {
                return QuotaSerializer$.org$apache$james$jmap$json$QuotaSerializer$$$anonfun$quotaNotFoundWrites$1(o);
            }
            {
                Writes.$init$((Writes)this);
            }
        };
        JsonConfiguration config$macro$6 = JsonConfiguration$.MODULE$.default((Json.MacroOptions$.Default)Json.MacroOptions$.Default$.macroOptionsDefault$.MODULE$);
        quotaGetResponseWrites = (OWrites)play.api.libs.functional.syntax.package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash(config$macro$6.naming().apply("accountId")).write(package$.MODULE$.accountIdWrites()), OWrites$.MODULE$.functionalCanBuildOWrites()).and((Object)JsPath$.MODULE$.$bslash(config$macro$6.naming().apply("state")).write(MODULE$.stateWrites())).and((Object)JsPath$.MODULE$.$bslash(config$macro$6.naming().apply("list")).write(Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), MODULE$.jmapQuotaWrites()))).and((Object)JsPath$.MODULE$.$bslash(config$macro$6.naming().apply("notFound")).write(MODULE$.quotaNotFoundWrites())).apply(play.api.libs.functional.syntax.package$.MODULE$.unlift((Function1 & Serializable)x$0 -> QuotaGetResponse$.MODULE$.unapply((QuotaGetResponse)x$0)), OWrites$.MODULE$.contravariantfunctorOWrites());
        JsonConfiguration config$macro$8 = JsonConfiguration$.MODULE$.default((Json.MacroOptions$.Default)Json.MacroOptions$.Default$.macroOptionsDefault$.MODULE$);
        Reads underlying2 = (Reads)play.api.libs.functional.syntax.package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash(config$macro$8.naming().apply("accountId")).read(package$.MODULE$.accountIdWrites()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash(config$macro$8.naming().apply("sinceState")).read(package$.MODULE$.stateReads())).and((Object)config$macro$8.optionHandlers().readHandler(JsPath$.MODULE$.$bslash(config$macro$8.naming().apply("maxChanges")), package$.MODULE$.readRefined(Reads$.MODULE$.IntReads(), RefType$.MODULE$.refinedRefType(), numeric.Greater$.MODULE$.greaterValidate(WitnessAs$.MODULE$.natWitnessAs(Witness$.MODULE$.witness0(), nat.ToInt$.MODULE$.toInt0(), (Numeric)Numeric.IntIsIntegral$.MODULE$), (Numeric)Numeric.IntIsIntegral$.MODULE$)))).apply((Function3 & Serializable)(accountId, sinceState, maxChanges) -> new QuotaChangesRequest((AccountId)accountId, (UuidState)sinceState, (Option<Refined<Object, numeric.Greater<_0>>>)maxChanges), Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult())));
        quotaChangesRequestReads = Reads$.MODULE$.apply((Function1 & Serializable)x0$6 -> {
            JsValue jsValue = x0$6;
            if (jsValue instanceof JsObject) {
                JsObject jsObject = (JsObject)jsValue;
                return underlying2.reads((JsValue)jsObject);
            }
            return JsError$.MODULE$.apply("error.expected.jsobject");
        });
        quotaChangesResponseWrites = new Writes<QuotaChangesResponse>(){

            public <B> Writes<B> contramap(Function1<B, QuotaChangesResponse> f) {
                return Writes.contramap$((Writes)this, f);
            }

            public <B extends QuotaChangesResponse> Writes<B> narrow() {
                return Writes.narrow$((Writes)this);
            }

            public Writes<QuotaChangesResponse> transform(Function1<JsValue, JsValue> transformer) {
                return Writes.transform$((Writes)this, transformer);
            }

            public Writes<QuotaChangesResponse> transform(Writes<JsValue> transformer) {
                return Writes.transform$((Writes)this, transformer);
            }

            public final JsValue writes(QuotaChangesResponse o) {
                return QuotaSerializer$.org$apache$james$jmap$json$QuotaSerializer$$$anonfun$quotaChangesResponseWrites$1(o);
            }
            {
                Writes.$init$((Writes)this);
            }
        };
        filterReads = new Reads<QuotaQueryFilter>(){

            public <B> Reads<B> map(Function1<QuotaQueryFilter, B> f) {
                return Reads.map$((Reads)this, f);
            }

            public <B> Reads<B> flatMap(Function1<QuotaQueryFilter, Reads<B>> f) {
                return Reads.flatMap$((Reads)this, f);
            }

            public Reads<QuotaQueryFilter> filter(Function1<QuotaQueryFilter, Object> f) {
                return Reads.filter$((Reads)this, f);
            }

            public Reads<QuotaQueryFilter> filter(JsonValidationError error, Function1<QuotaQueryFilter, Object> f) {
                return Reads.filter$((Reads)this, (JsonValidationError)error, f);
            }

            public Reads<QuotaQueryFilter> filterNot(Function1<QuotaQueryFilter, Object> f) {
                return Reads.filterNot$((Reads)this, f);
            }

            public Reads<QuotaQueryFilter> filterNot(JsonValidationError error, Function1<QuotaQueryFilter, Object> f) {
                return Reads.filterNot$((Reads)this, (JsonValidationError)error, f);
            }

            public <B> Reads<B> collect(JsonValidationError error, PartialFunction<QuotaQueryFilter, B> f) {
                return Reads.collect$((Reads)this, (JsonValidationError)error, f);
            }

            public Reads<QuotaQueryFilter> orElse(Reads<QuotaQueryFilter> v) {
                return Reads.orElse$((Reads)this, v);
            }

            public <B extends JsValue> Reads<QuotaQueryFilter> compose(Reads<B> rb) {
                return Reads.compose$((Reads)this, rb);
            }

            public <B extends JsValue> Reads<QuotaQueryFilter> composeWith(Reads<B> rb) {
                return Reads.composeWith$((Reads)this, rb);
            }

            public Reads<QuotaQueryFilter> preprocess(PartialFunction<JsValue, JsValue> f) {
                return Reads.preprocess$((Reads)this, f);
            }

            public <B> Reads<B> flatMapResult(Function1<QuotaQueryFilter, JsResult<B>> f) {
                return Reads.flatMapResult$((Reads)this, f);
            }

            public <B> Reads<B> andThen(Reads<B> rb, .less.colon.less<QuotaQueryFilter, JsValue> witness) {
                return Reads.andThen$((Reads)this, rb, witness);
            }

            public <B> Reads<B> widen() {
                return Reads.widen$((Reads)this);
            }

            public final JsResult<QuotaQueryFilter> reads(JsValue json) {
                return QuotaSerializer$.org$apache$james$jmap$json$QuotaSerializer$$$anonfun$filterReads$1(json);
            }
            {
                Reads.$init$((Reads)this);
            }
        };
        JsonConfiguration config$macro$14 = JsonConfiguration$.MODULE$.default((Json.MacroOptions$.Default)Json.MacroOptions$.Default$.macroOptionsDefault$.MODULE$);
        Reads underlying3 = (Reads)play.api.libs.functional.syntax.package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash(config$macro$14.naming().apply("accountId")).read(package$.MODULE$.accountIdWrites()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash(config$macro$14.naming().apply("filter")).read(MODULE$.filterReads())).apply((Function2 & Serializable)(accountId, filter) -> new QuotaQueryRequest((AccountId)accountId, (QuotaQueryFilter)filter), Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult())));
        quotaQueryRequestReads = Reads$.MODULE$.apply((Function1 & Serializable)x0$10 -> {
            JsValue jsValue = x0$10;
            if (jsValue instanceof JsObject) {
                JsObject jsObject = (JsObject)jsValue;
                return underlying3.reads((JsValue)jsObject);
            }
            return JsError$.MODULE$.apply("error.expected.jsobject");
        });
        ContravariantFunctor fn5 = (ContravariantFunctor)Predef$.MODULE$.implicitly((Object)Writes$.MODULE$.contravariantfunctorWrites());
        Writes w5 = (Writes)Predef$.MODULE$.implicitly((Object)Writes$.MODULE$.BooleanWrites());
        canCalculateChangesWrites = (Writes)fn5.contramap((Object)w5, (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)((CanCalculateChanges)x$5).value()));
        ContravariantFunctor fn6 = (ContravariantFunctor)Predef$.MODULE$.implicitly((Object)Writes$.MODULE$.contravariantfunctorWrites());
        Writes w6 = (Writes)Predef$.MODULE$.implicitly((Object)Writes$.MODULE$.StringWrites());
        queryStateWrites = (Writes)fn6.contramap((Object)w6, (Function1 & Serializable)x$6 -> ((QueryState)x$6).value());
        JsonConfiguration config$macro$16 = JsonConfiguration$.MODULE$.default((Json.MacroOptions$.Default)Json.MacroOptions$.Default$.macroOptionsDefault$.MODULE$);
        quotaQueryResponseWrites = (OWrites)play.api.libs.functional.syntax.package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash(config$macro$16.naming().apply("accountId")).write(package$.MODULE$.accountIdWrites()), OWrites$.MODULE$.functionalCanBuildOWrites()).and((Object)JsPath$.MODULE$.$bslash(config$macro$16.naming().apply("queryState")).write(MODULE$.queryStateWrites())).and((Object)JsPath$.MODULE$.$bslash(config$macro$16.naming().apply("canCalculateChanges")).write(MODULE$.canCalculateChangesWrites())).and((Object)JsPath$.MODULE$.$bslash(config$macro$16.naming().apply("ids")).write(Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), package$.MODULE$.writeRefined(Writes$.MODULE$.StringWrites(), RefType$.MODULE$.refinedRefType())))).and((Object)JsPath$.MODULE$.$bslash(config$macro$16.naming().apply("position")).write(package$.MODULE$.writeRefined(Writes$.MODULE$.IntWrites(), RefType$.MODULE$.refinedRefType()))).and((Object)config$macro$16.optionHandlers().writeHandler(JsPath$.MODULE$.$bslash(config$macro$16.naming().apply("limit")), package$.MODULE$.writeRefined(Writes$.MODULE$.IntWrites(), RefType$.MODULE$.refinedRefType()))).apply(play.api.libs.functional.syntax.package$.MODULE$.unlift((Function1 & Serializable)x$0 -> QuotaQueryResponse$.MODULE$.unapply((QuotaQueryResponse)x$0)), OWrites$.MODULE$.contravariantfunctorOWrites());
    }

    private Writes<UnparsedQuotaId> unparsedQuotaIdWrites() {
        return unparsedQuotaIdWrites;
    }

    private Reads<UnparsedQuotaId> unparsedQuotaIdReads() {
        return unparsedQuotaIdReads;
    }

    private Reads<QuotaIds> quotaIdsReads() {
        return quotaIdsReads;
    }

    private Reads<QuotaGetRequest> quotaGetRequestReads() {
        return quotaGetRequestReads;
    }

    private Writes<UuidState> stateWrites() {
        return stateWrites;
    }

    private Writes<ResourceType> resourceTypeWrite() {
        return resourceTypeWrite;
    }

    private Reads<Scope> scopeReads() {
        return scopeReads;
    }

    private Reads<QuotaName> optionReads() {
        return optionReads;
    }

    private Reads<ResourceType> resourceTypeReads() {
        return resourceTypeReads;
    }

    private Reads<DataType> dataTypeReads() {
        return dataTypeReads;
    }

    private Writes<Scope> scopeWrites() {
        return scopeWrites;
    }

    private Writes<DataType> dataTypeWrites() {
        return dataTypeWrites;
    }

    private Writes<QuotaName> quotaNameWrites() {
        return quotaNameWrites;
    }

    private Writes<QuotaDescription> quotaDescriptionWrites() {
        return quotaDescriptionWrites;
    }

    private Writes<JmapQuota> jmapQuotaWrites() {
        return jmapQuotaWrites;
    }

    private Writes<QuotaNotFound> quotaNotFoundWrites() {
        return quotaNotFoundWrites;
    }

    private Writes<QuotaGetResponse> quotaGetResponseWrites() {
        return quotaGetResponseWrites;
    }

    private Reads<QuotaChangesRequest> quotaChangesRequestReads() {
        return quotaChangesRequestReads;
    }

    private Writes<QuotaChangesResponse> quotaChangesResponseWrites() {
        return quotaChangesResponseWrites;
    }

    private Reads<QuotaQueryFilter> filterReads() {
        return filterReads;
    }

    private Reads<QuotaQueryRequest> quotaQueryRequestReads() {
        return quotaQueryRequestReads;
    }

    private Writes<CanCalculateChanges> canCalculateChangesWrites() {
        return canCalculateChangesWrites;
    }

    private Writes<QueryState> queryStateWrites() {
        return queryStateWrites;
    }

    private OWrites<QuotaQueryResponse> quotaQueryResponseWrites() {
        return quotaQueryResponseWrites;
    }

    public JsResult<QuotaGetRequest> deserializeQuotaGetRequest(String input) {
        return Json$.MODULE$.parse(input).validate(this.quotaGetRequestReads());
    }

    public JsResult<QuotaGetRequest> deserializeQuotaGetRequest(JsValue input) {
        return Json$.MODULE$.fromJson(input, this.quotaGetRequestReads());
    }

    public JsResult<QuotaChangesRequest> deserializeQuotaChangesRequest(JsValue input) {
        return Json$.MODULE$.fromJson(input, this.quotaChangesRequestReads());
    }

    public JsResult<QuotaQueryRequest> deserializeQuotaQueryRequest(JsValue input) {
        return Json$.MODULE$.fromJson(input, this.quotaQueryRequestReads());
    }

    public JsValue serialize(QuotaGetResponse quotaGetResponse, Properties properties) {
        return (JsValue)Json$.MODULE$.toJson((Object)quotaGetResponse, this.quotaGetResponseWrites()).transform(play.api.libs.json.package$.MODULE$.__().$bslash("list").json().update((Reads)new Reads<JsArray>(properties){
            private final Properties properties$1;

            public <B> Reads<B> map(Function1<JsArray, B> f) {
                return Reads.map$((Reads)this, f);
            }

            public <B> Reads<B> flatMap(Function1<JsArray, Reads<B>> f) {
                return Reads.flatMap$((Reads)this, f);
            }

            public Reads<JsArray> filter(Function1<JsArray, Object> f) {
                return Reads.filter$((Reads)this, f);
            }

            public Reads<JsArray> filter(JsonValidationError error, Function1<JsArray, Object> f) {
                return Reads.filter$((Reads)this, (JsonValidationError)error, f);
            }

            public Reads<JsArray> filterNot(Function1<JsArray, Object> f) {
                return Reads.filterNot$((Reads)this, f);
            }

            public Reads<JsArray> filterNot(JsonValidationError error, Function1<JsArray, Object> f) {
                return Reads.filterNot$((Reads)this, (JsonValidationError)error, f);
            }

            public <B> Reads<B> collect(JsonValidationError error, PartialFunction<JsArray, B> f) {
                return Reads.collect$((Reads)this, (JsonValidationError)error, f);
            }

            public Reads<JsArray> orElse(Reads<JsArray> v) {
                return Reads.orElse$((Reads)this, v);
            }

            public <B extends JsValue> Reads<JsArray> compose(Reads<B> rb) {
                return Reads.compose$((Reads)this, rb);
            }

            public <B extends JsValue> Reads<JsArray> composeWith(Reads<B> rb) {
                return Reads.composeWith$((Reads)this, rb);
            }

            public Reads<JsArray> preprocess(PartialFunction<JsValue, JsValue> f) {
                return Reads.preprocess$((Reads)this, f);
            }

            public <B> Reads<B> flatMapResult(Function1<JsArray, JsResult<B>> f) {
                return Reads.flatMapResult$((Reads)this, f);
            }

            public <B> Reads<B> andThen(Reads<B> rb, .less.colon.less<JsArray, JsValue> witness) {
                return Reads.andThen$((Reads)this, rb, witness);
            }

            public <B> Reads<B> widen() {
                return Reads.widen$((Reads)this);
            }

            public final JsResult<JsArray> reads(JsValue json) {
                return QuotaSerializer$.org$apache$james$jmap$json$QuotaSerializer$$$anonfun$serialize$1(json, this.properties$1);
            }
            {
                this.properties$1 = properties$1;
                Reads.$init$((Reads)this);
            }
        })).get();
    }

    public JsValue serialize(QuotaGetResponse response) {
        return Json$.MODULE$.toJson((Object)response, this.quotaGetResponseWrites());
    }

    public JsObject serializeChanges(QuotaChangesResponse changesResponse) {
        return (JsObject)Json$.MODULE$.toJson((Object)changesResponse, this.quotaChangesResponseWrites()).as(package$.MODULE$.jsObjectReads());
    }

    public JsObject serializeQuery(QuotaQueryResponse quotaQueryResponse) {
        return Json$.MODULE$.toJsObject((Object)quotaQueryResponse, this.quotaQueryResponseWrites());
    }

    public static final /* synthetic */ JsSuccess $anonfun$unparsedQuotaIdReads$3(String id) {
        return new JsSuccess((Object)new UnparsedQuotaId(id), JsSuccess$.MODULE$.apply$default$2());
    }

    public static final /* synthetic */ JsResult org$apache$james$jmap$json$QuotaSerializer$$$anonfun$unparsedQuotaIdReads$1(JsValue x0$1) {
        JsValue jsValue = x0$1;
        if (jsValue instanceof JsString) {
            JsString jsString = (JsString)jsValue;
            String string2 = jsString.value();
            return (JsResult)eu.timepit.refined.package$.MODULE$.refineV().apply((Object)string2, Id$.MODULE$.validateId()).fold((Function1 & Serializable)e -> JsError$.MODULE$.apply("vacation response id does not match Id constraints: " + e), (Function1 & Serializable)id -> QuotaSerializer$.$anonfun$unparsedQuotaIdReads$3((String)((Refined)id).value()));
        }
        return JsError$.MODULE$.apply("vacation response id needs to be represented by a JsString");
    }

    public static final /* synthetic */ JsValue org$apache$james$jmap$json$QuotaSerializer$$$anonfun$resourceTypeWrite$1(ResourceType resourceType) {
        return new JsString(resourceType.asString());
    }

    public static final /* synthetic */ JsResult org$apache$james$jmap$json$QuotaSerializer$$$anonfun$scopeReads$1(JsValue x0$3) {
        boolean bl = false;
        JsString jsString = null;
        JsValue jsValue = x0$3;
        if (jsValue instanceof JsString) {
            bl = true;
            jsString = (JsString)jsValue;
            String string2 = jsString.value();
            if ("account".equals(string2)) {
                return new JsSuccess((Object)AccountScope$.MODULE$, JsSuccess$.MODULE$.apply$default$2());
            }
        }
        if (bl) {
            String any = jsString.value();
            return JsError$.MODULE$.apply("Unexpected value " + any + ", only 'account' is managed");
        }
        return JsError$.MODULE$.apply("Expecting a JsString to represent a scope property");
    }

    public static final /* synthetic */ JsResult org$apache$james$jmap$json$QuotaSerializer$$$anonfun$resourceTypeReads$1(JsValue x0$4) {
        String string2;
        boolean bl = false;
        JsString jsString = null;
        JsValue jsValue = x0$4;
        if (jsValue instanceof JsString) {
            bl = true;
            jsString = (JsString)jsValue;
            String string3 = jsString.value();
            if ("count".equals(string3)) {
                return new JsSuccess((Object)CountResourceType$.MODULE$, JsSuccess$.MODULE$.apply$default$2());
            }
        }
        if (bl && "octets".equals(string2 = jsString.value())) {
            return new JsSuccess((Object)OctetsResourceType$.MODULE$, JsSuccess$.MODULE$.apply$default$2());
        }
        if (bl) {
            String any = jsString.value();
            return JsError$.MODULE$.apply("Unexpected value " + any + ", only 'count' and 'octets' are managed");
        }
        return JsError$.MODULE$.apply("Expecting a JsString to represent a resourceType property");
    }

    public static final /* synthetic */ JsResult org$apache$james$jmap$json$QuotaSerializer$$$anonfun$dataTypeReads$1(JsValue x0$5) {
        boolean bl = false;
        JsString jsString = null;
        JsValue jsValue = x0$5;
        if (jsValue instanceof JsString) {
            bl = true;
            jsString = (JsString)jsValue;
            String string2 = jsString.value();
            if ("Mail".equals(string2)) {
                return new JsSuccess((Object)MailDataType$.MODULE$, JsSuccess$.MODULE$.apply$default$2());
            }
        }
        if (bl) {
            String any = jsString.value();
            return JsError$.MODULE$.apply("Unexpected value " + any + ", only 'Mail' are managed");
        }
        return JsError$.MODULE$.apply("Expecting a JsString to represent a dataType property");
    }

    public static final /* synthetic */ JsValue org$apache$james$jmap$json$QuotaSerializer$$$anonfun$scopeWrites$1(Scope scope) {
        return new JsString(scope.asString());
    }

    public static final /* synthetic */ JsValue org$apache$james$jmap$json$QuotaSerializer$$$anonfun$dataTypeWrites$1(DataType dataType) {
        return new JsString(dataType.asString());
    }

    public static final /* synthetic */ JsValue org$apache$james$jmap$json$QuotaSerializer$$$anonfun$quotaNotFoundWrites$1(QuotaNotFound notFound) {
        return JsArray$.MODULE$.apply((Seq)notFound.value().toList().map((Function1 & Serializable)id -> new JsString(id.id())));
    }

    public static final /* synthetic */ JsValue org$apache$james$jmap$json$QuotaSerializer$$$anonfun$quotaChangesResponseWrites$1(QuotaChangesResponse response) {
        return Json$.MODULE$.obj((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"accountId"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)response.accountId(), package$.MODULE$.accountIdWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oldState"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)response.oldState(), MODULE$.stateWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"newState"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)response.newState(), MODULE$.stateWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hasMoreChanges"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)new HasMoreChanges(response.hasMoreChanges()), package$.MODULE$.hasMoreChangesWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"updatedProperties"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper(response.updatedProperties(), Writes$.MODULE$.OptionWrites(package$.MODULE$.propertiesFormat()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"created"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper(response.created(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), package$.MODULE$.writeRefined(Writes$.MODULE$.StringWrites(), RefType$.MODULE$.refinedRefType())))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"updated"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper(response.updated(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), package$.MODULE$.writeRefined(Writes$.MODULE$.StringWrites(), RefType$.MODULE$.refinedRefType())))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"destroyed"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper(response.destroyed(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), package$.MODULE$.writeRefined(Writes$.MODULE$.StringWrites(), RefType$.MODULE$.refinedRefType()))))}));
    }

    public static final /* synthetic */ JsResult org$apache$james$jmap$json$QuotaSerializer$$$anonfun$filterReads$1(JsValue x0$7) {
        JsValue jsValue = x0$7;
        if (jsValue instanceof JsObject) {
            JsObject jsObject = (JsObject)jsValue;
            Set unsupported = (Set)jsObject.keys().diff(QuotaQueryFilter$.MODULE$.SUPPORTED());
            if (unsupported.nonEmpty()) {
                return JsError$.MODULE$.apply("These '" + unsupported.mkString("[", ", ", "]") + "' was unsupported filter options");
            }
            JsonConfiguration config$macro$10 = JsonConfiguration$.MODULE$.default((Json.MacroOptions$.Default)Json.MacroOptions$.Default$.macroOptionsDefault$.MODULE$);
            Reads underlying = (Reads)play.api.libs.functional.syntax.package$.MODULE$.toFunctionalBuilderOps((Object)config$macro$10.optionHandlers().readHandler(JsPath$.MODULE$.$bslash(config$macro$10.naming().apply("scope")), MODULE$.scopeReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)config$macro$10.optionHandlers().readHandler(JsPath$.MODULE$.$bslash(config$macro$10.naming().apply("name")), MODULE$.optionReads())).and((Object)config$macro$10.optionHandlers().readHandler(JsPath$.MODULE$.$bslash(config$macro$10.naming().apply("resourceType")), MODULE$.resourceTypeReads())).and((Object)config$macro$10.optionHandlers().readHandler(JsPath$.MODULE$.$bslash(config$macro$10.naming().apply("type")), MODULE$.dataTypeReads())).apply((Function4 & Serializable)(scope, name, resourceType, type) -> new QuotaQueryFilter((Option<Scope>)scope, (Option<QuotaName>)name, (Option<ResourceType>)resourceType, (Option<DataType>)type), Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult())));
            return Reads$.MODULE$.apply((Function1 & Serializable)x0$8 -> {
                JsValue jsValue = x0$8;
                if (jsValue instanceof JsObject) {
                    JsObject jsObject = (JsObject)jsValue;
                    return underlying.reads((JsValue)jsObject);
                }
                return JsError$.MODULE$.apply("error.expected.jsobject");
            }).reads((JsValue)jsObject);
        }
        if (jsValue != null) {
            JsValue jsValue2 = jsValue;
            JsonConfiguration config$macro$12 = JsonConfiguration$.MODULE$.default((Json.MacroOptions$.Default)Json.MacroOptions$.Default$.macroOptionsDefault$.MODULE$);
            Reads underlying = (Reads)play.api.libs.functional.syntax.package$.MODULE$.toFunctionalBuilderOps((Object)config$macro$12.optionHandlers().readHandler(JsPath$.MODULE$.$bslash(config$macro$12.naming().apply("scope")), MODULE$.scopeReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)config$macro$12.optionHandlers().readHandler(JsPath$.MODULE$.$bslash(config$macro$12.naming().apply("name")), MODULE$.optionReads())).and((Object)config$macro$12.optionHandlers().readHandler(JsPath$.MODULE$.$bslash(config$macro$12.naming().apply("resourceType")), MODULE$.resourceTypeReads())).and((Object)config$macro$12.optionHandlers().readHandler(JsPath$.MODULE$.$bslash(config$macro$12.naming().apply("type")), MODULE$.dataTypeReads())).apply((Function4 & Serializable)(scope, name, resourceType, type) -> new QuotaQueryFilter((Option<Scope>)scope, (Option<QuotaName>)name, (Option<ResourceType>)resourceType, (Option<DataType>)type), Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult())));
            return Reads$.MODULE$.apply((Function1 & Serializable)x0$9 -> {
                JsValue jsValue = x0$9;
                if (jsValue instanceof JsObject) {
                    JsObject jsObject = (JsObject)jsValue;
                    return underlying.reads((JsValue)jsObject);
                }
                return JsError$.MODULE$.apply("error.expected.jsobject");
            }).reads(jsValue2);
        }
        throw new MatchError((Object)jsValue);
    }

    public static final /* synthetic */ JsResult org$apache$james$jmap$json$QuotaSerializer$$$anonfun$serialize$1(JsValue x0$1, Properties properties$1) {
        JsError jsError;
        JsValue jsValue = x0$1;
        if (jsValue instanceof JsArray) {
            JsArray jsArray = (JsArray)jsValue;
            IndexedSeq underlying = jsArray.value();
            jsError = new JsSuccess((Object)new JsArray((IndexedSeq)underlying.map((Function1 & Serializable)x0$2 -> {
                JsValue jsValue = x0$2;
                if (jsValue instanceof JsObject) {
                    JsObject jsObject = (JsObject)jsValue;
                    return JmapQuota$.MODULE$.propertiesFiltered(properties$1).filter(jsObject);
                }
                return jsValue;
            })), JsSuccess$.MODULE$.apply$default$2());
        } else {
            jsError = JsError$.MODULE$.apply("expected JsArray, got " + jsValue);
        }
        return (JsResult)jsError;
    }

    private QuotaSerializer$() {
    }
}

