/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.generator;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.FrameType;
import org.eclipse.jetty.http2.frames.WindowUpdateFrame;
import org.eclipse.jetty.http2.generator.FrameGenerator;
import org.eclipse.jetty.http2.generator.HeaderGenerator;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;

public class WindowUpdateGenerator
extends FrameGenerator {
    public WindowUpdateGenerator(HeaderGenerator headerGenerator) {
        super(headerGenerator);
    }

    @Override
    public int generate(ByteBufferPool.Accumulator accumulator, Frame frame) {
        WindowUpdateFrame windowUpdateFrame = (WindowUpdateFrame)frame;
        return this.generateWindowUpdate(accumulator, windowUpdateFrame.getStreamId(), windowUpdateFrame.getWindowDelta());
    }

    public int generateWindowUpdate(ByteBufferPool.Accumulator accumulator, int streamId, int windowUpdate) {
        if (windowUpdate < 0) {
            throw new IllegalArgumentException("Invalid window update: " + windowUpdate);
        }
        RetainableByteBuffer header = this.generateHeader(FrameType.WINDOW_UPDATE, 4, 0, streamId);
        ByteBuffer byteBuffer = header.getByteBuffer();
        byteBuffer.putInt(windowUpdate);
        BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)0);
        accumulator.append(header);
        return 13;
    }
}

