/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.adminrequest;

import com.datastax.oss.driver.api.core.DriverTimeoutException;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.connection.BusyConnectionException;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.internal.core.adminrequest.AdminResult;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.adminrequest.UnexpectedResponseException;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.channel.ResponseCallback;
import com.datastax.oss.driver.internal.core.util.concurrent.UncaughtExceptions;
import com.datastax.oss.driver.shaded.guava.common.collect.Maps;
import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.request.Query;
import com.datastax.oss.protocol.internal.request.query.QueryOptions;
import com.datastax.oss.protocol.internal.response.Result;
import com.datastax.oss.protocol.internal.response.result.Prepared;
import com.datastax.oss.protocol.internal.response.result.Rows;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class AdminRequestHandler<ResultT>
implements ResponseCallback {
    private static final Logger LOG = LoggerFactory.getLogger(AdminRequestHandler.class);
    private final DriverChannel channel;
    private final boolean shouldPreAcquireId;
    private final Message message;
    private final Map<String, ByteBuffer> customPayload;
    private final Duration timeout;
    private final String logPrefix;
    private final String debugString;
    private final Class<? extends Result> expectedResponseType;
    protected final CompletableFuture<ResultT> result = new CompletableFuture();
    private ScheduledFuture<?> timeoutFuture;

    public static AdminRequestHandler<Void> call(DriverChannel channel, Query query, Duration timeout, String logPrefix) {
        return new AdminRequestHandler<Void>(channel, true, (Message)query, Frame.NO_PAYLOAD, timeout, logPrefix, "call '" + query.query + "'", com.datastax.oss.protocol.internal.response.result.Void.class);
    }

    public static AdminRequestHandler<AdminResult> query(DriverChannel channel, String query, Map<String, Object> parameters, Duration timeout, int pageSize, String logPrefix) {
        Query message = new Query(query, AdminRequestHandler.buildQueryOptions(pageSize, AdminRequestHandler.serialize(parameters, channel.protocolVersion()), null));
        String debugString = "query '" + message.query + "'";
        if (!parameters.isEmpty()) {
            debugString = debugString + " with parameters " + parameters;
        }
        return new AdminRequestHandler<AdminResult>(channel, true, (Message)message, Frame.NO_PAYLOAD, timeout, logPrefix, debugString, Rows.class);
    }

    public static AdminRequestHandler<AdminResult> query(DriverChannel channel, String query, Duration timeout, int pageSize, String logPrefix) {
        return AdminRequestHandler.query(channel, query, Collections.emptyMap(), timeout, pageSize, logPrefix);
    }

    protected AdminRequestHandler(DriverChannel channel, boolean shouldPreAcquireId, Message message, Map<String, ByteBuffer> customPayload, Duration timeout, String logPrefix, String debugString, Class<? extends Result> expectedResponseType) {
        this.channel = channel;
        this.shouldPreAcquireId = shouldPreAcquireId;
        this.message = message;
        this.customPayload = customPayload;
        this.timeout = timeout;
        this.logPrefix = logPrefix;
        this.debugString = debugString;
        this.expectedResponseType = expectedResponseType;
    }

    public CompletionStage<ResultT> start() {
        LOG.debug("[{}] Executing {}", (Object)this.logPrefix, (Object)this);
        if (this.shouldPreAcquireId && !this.channel.preAcquireId()) {
            this.setFinalError(new BusyConnectionException(String.format("%s has reached its maximum number of simultaneous requests", this.channel)));
        } else {
            this.channel.write(this.message, false, this.customPayload, this).addListener(this::onWriteComplete);
        }
        return this.result;
    }

    private void onWriteComplete(Future<? super Void> future) {
        if (future.isSuccess()) {
            LOG.debug("[{}] Successfully wrote {}, waiting for response", (Object)this.logPrefix, (Object)this);
            if (this.timeout.toNanos() > 0L) {
                this.timeoutFuture = this.channel.eventLoop().schedule(this::fireTimeout, this.timeout.toNanos(), TimeUnit.NANOSECONDS);
                this.timeoutFuture.addListener(UncaughtExceptions::log);
            }
        } else {
            this.setFinalError(future.cause());
        }
    }

    private void fireTimeout() {
        this.setFinalError(new DriverTimeoutException(String.format("%s timed out after %s", this.debugString, this.timeout)));
        if (!this.channel.closeFuture().isDone()) {
            this.channel.cancel(this);
        }
    }

    @Override
    public void onFailure(Throwable error) {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(true);
        }
        this.setFinalError(error);
    }

    @Override
    public void onResponse(Frame responseFrame) {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(true);
        }
        Message message = responseFrame.message;
        LOG.debug("[{}] Got response {}", (Object)this.logPrefix, (Object)responseFrame.message);
        if (!this.expectedResponseType.isInstance(message)) {
            this.setFinalError(new UnexpectedResponseException(this.debugString, message));
        } else if (this.expectedResponseType == Rows.class) {
            Rows rows = (Rows)message;
            ByteBuffer pagingState = rows.getMetadata().pagingState;
            AdminRequestHandler<AdminResult> nextHandler = pagingState == null ? null : this.copy(pagingState);
            AdminResult result = new AdminResult(rows, nextHandler, this.channel.protocolVersion());
            this.setFinalResult(result);
        } else if (this.expectedResponseType == Prepared.class) {
            Prepared prepared = (Prepared)message;
            ByteBuffer result = ByteBuffer.wrap(prepared.preparedQueryId);
            this.setFinalResult(result);
        } else if (this.expectedResponseType == com.datastax.oss.protocol.internal.response.result.Void.class) {
            this.setFinalResult(null);
        } else {
            this.setFinalError((Throwable)((Object)new AssertionError((Object)("Unhandled response type" + this.expectedResponseType))));
        }
    }

    protected boolean setFinalResult(ResultT result) {
        return this.result.complete(result);
    }

    protected boolean setFinalError(Throwable error) {
        return this.result.completeExceptionally(error);
    }

    private AdminRequestHandler<ResultT> copy(ByteBuffer pagingState) {
        assert (this.message instanceof Query);
        Query current = (Query)this.message;
        QueryOptions currentOptions = current.options;
        QueryOptions newOptions = AdminRequestHandler.buildQueryOptions(currentOptions.pageSize, currentOptions.namedValues, pagingState);
        return new AdminRequestHandler<ResultT>(this.channel, true, (Message)new Query(current.query, newOptions), this.customPayload, this.timeout, this.logPrefix, this.debugString, this.expectedResponseType);
    }

    private static QueryOptions buildQueryOptions(int pageSize, Map<String, ByteBuffer> serialize, ByteBuffer pagingState) {
        return new QueryOptions(1, Collections.emptyList(), serialize, false, pageSize, pagingState, 8, Long.MIN_VALUE, null, Integer.MIN_VALUE);
    }

    private static Map<String, ByteBuffer> serialize(Map<String, Object> parameters, ProtocolVersion protocolVersion) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)parameters.size());
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            result.put(entry.getKey(), AdminRequestHandler.serialize(entry.getValue(), protocolVersion));
        }
        return result;
    }

    private static ByteBuffer serialize(Object parameter, ProtocolVersion protocolVersion) {
        if (parameter instanceof String) {
            return TypeCodecs.TEXT.encode((String)parameter, protocolVersion);
        }
        if (parameter instanceof InetAddress) {
            return TypeCodecs.INET.encode((InetAddress)parameter, protocolVersion);
        }
        if (parameter instanceof List && ((List)parameter).get(0) instanceof String) {
            List l = (List)parameter;
            return AdminRow.LIST_OF_TEXT.encode(l, protocolVersion);
        }
        if (parameter instanceof Integer) {
            return TypeCodecs.INT.encode((Integer)parameter, protocolVersion);
        }
        throw new IllegalArgumentException("Unsupported variable type for admin query: " + parameter.getClass());
    }

    public String toString() {
        return this.debugString;
    }
}

