/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.task.builder;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.pipe.agent.task.PipeTaskAgent;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeType;
import org.apache.iotdb.db.pipe.agent.task.PipeDataNodeTask;
import org.apache.iotdb.db.pipe.agent.task.execution.PipeProcessorSubtaskExecutor;
import org.apache.iotdb.db.pipe.agent.task.execution.PipeSubtaskExecutorManager;
import org.apache.iotdb.db.pipe.agent.task.stage.PipeTaskProcessorStage;
import org.apache.iotdb.db.pipe.agent.task.stage.PipeTaskSinkStage;
import org.apache.iotdb.db.pipe.agent.task.stage.PipeTaskSourceStage;
import org.apache.iotdb.db.pipe.source.dataregion.DataRegionListeningFilter;
import org.apache.iotdb.db.subscription.task.stage.SubscriptionTaskSinkStage;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeDataNodeTaskBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeDataNodeTaskBuilder.class);
    private final PipeStaticMeta pipeStaticMeta;
    private final int regionId;
    private final PipeTaskMeta pipeTaskMeta;
    private static final PipeProcessorSubtaskExecutor PROCESSOR_EXECUTOR = PipeSubtaskExecutorManager.getInstance().getProcessorExecutor();
    protected final Map<String, String> systemParameters = new HashMap<String, String>();

    public PipeDataNodeTaskBuilder(PipeStaticMeta pipeStaticMeta, int regionId, PipeTaskMeta pipeTaskMeta) {
        this.pipeStaticMeta = pipeStaticMeta;
        this.regionId = regionId;
        this.pipeTaskMeta = pipeTaskMeta;
        this.generateSystemParameters();
    }

    public PipeDataNodeTask build() {
        PipeParameters sourceParameters = this.blendUserAndSystemParameters(this.pipeStaticMeta.getExtractorParameters());
        PipeParameters sinkParameters = this.blendUserAndSystemParameters(this.pipeStaticMeta.getConnectorParameters());
        this.checkConflict(sourceParameters, sinkParameters);
        PipeTaskSourceStage sourceStage = new PipeTaskSourceStage(this.pipeStaticMeta.getPipeName(), this.pipeStaticMeta.getCreationTime(), sourceParameters, this.regionId, this.pipeTaskMeta);
        PipeType pipeType = this.pipeStaticMeta.getPipeType();
        PipeTaskSinkStage sinkStage = PipeType.SUBSCRIPTION.equals((Object)pipeType) ? new SubscriptionTaskSinkStage(this.pipeStaticMeta.getPipeName(), this.pipeStaticMeta.getCreationTime(), sinkParameters, this.regionId, PipeSubtaskExecutorManager.getInstance().getSubscriptionExecutor()) : new PipeTaskSinkStage(this.pipeStaticMeta.getPipeName(), this.pipeStaticMeta.getCreationTime(), sinkParameters, this.regionId, pipeType.equals((Object)PipeType.USER) ? PipeSubtaskExecutorManager.getInstance().getConnectorExecutorSupplier() : PipeSubtaskExecutorManager.getInstance().getConsensusExecutorSupplier());
        PipeTaskProcessorStage processorStage = new PipeTaskProcessorStage(this.pipeStaticMeta.getPipeName(), this.pipeStaticMeta.getCreationTime(), this.blendUserAndSystemParameters(this.pipeStaticMeta.getProcessorParameters()), this.regionId, sourceStage.getEventSupplier(), sinkStage.getPipeConnectorPendingQueue(), PROCESSOR_EXECUTOR, this.pipeTaskMeta, this.pipeStaticMeta.getConnectorParameters().getStringOrDefault(Arrays.asList("connector.format", "sink.format"), "hybrid").equals("tablet"), PipeType.SUBSCRIPTION.equals((Object)pipeType));
        return new PipeDataNodeTask(this.pipeStaticMeta.getPipeName(), this.regionId, sourceStage, processorStage, sinkStage);
    }

    private void generateSystemParameters() {
        if (!(this.pipeTaskMeta.getProgressIndex() instanceof MinimumProgressIndex) || this.pipeTaskMeta.isNewlyAdded()) {
            this.systemParameters.put("__system.restart_or_newly_added", Boolean.TRUE.toString());
        }
    }

    private PipeParameters blendUserAndSystemParameters(PipeParameters userParameters) {
        HashMap<String, String> blendedParameters = new HashMap<String, String>(userParameters.getAttribute());
        blendedParameters.putAll(this.systemParameters);
        return new PipeParameters(blendedParameters);
    }

    private void checkConflict(PipeParameters sourceParameters, PipeParameters sinkParameters) {
        boolean isRealtimeEnabled;
        boolean shouldTerminatePipeOnAllHistoricalEventsConsumed;
        Pair<Boolean, Boolean> insertionDeletionListeningOptionPair;
        try {
            insertionDeletionListeningOptionPair = DataRegionListeningFilter.parseInsertionDeletionListeningOptionPair(sourceParameters);
            shouldTerminatePipeOnAllHistoricalEventsConsumed = PipeTaskAgent.isSnapshotMode((PipeParameters)sourceParameters);
        }
        catch (IllegalPathException e) {
            LOGGER.warn("PipeDataNodeTaskBuilder failed to parse 'inclusion' and 'exclusion' parameters: {}", (Object)e.getMessage(), (Object)e);
            return;
        }
        if (((Boolean)insertionDeletionListeningOptionPair.right).booleanValue() || shouldTerminatePipeOnAllHistoricalEventsConsumed) {
            Boolean isRealtime = sinkParameters.getBooleanByKeys(new String[]{"connector.realtime-first", "sink.realtime-first"});
            if (isRealtime == null) {
                sinkParameters.addAttribute("connector.realtime-first", "false");
                if (((Boolean)insertionDeletionListeningOptionPair.right).booleanValue()) {
                    LOGGER.info("PipeDataNodeTaskBuilder: When 'inclusion' contains 'data.delete', 'realtime-first' is defaulted to 'false' to prevent sync issues after deletion.");
                } else {
                    LOGGER.info("PipeDataNodeTaskBuilder: When source uses snapshot model, 'realtime-first' is defaulted to 'false' to prevent premature halt before transfer completion.");
                }
            } else if (isRealtime.booleanValue()) {
                if (((Boolean)insertionDeletionListeningOptionPair.right).booleanValue()) {
                    LOGGER.warn("PipeDataNodeTaskBuilder: When 'inclusion' includes 'data.delete', 'realtime-first' set to 'true' may result in data synchronization issues after deletion.");
                } else {
                    LOGGER.warn("PipeDataNodeTaskBuilder: When source uses snapshot model, 'realtime-first' set to 'true' may cause prevent premature halt before transfer completion.");
                }
            }
        }
        if ((isRealtimeEnabled = sourceParameters.getBooleanOrDefault(Arrays.asList("extractor.realtime.enable", "source.realtime.enable"), true)) && !shouldTerminatePipeOnAllHistoricalEventsConsumed) {
            Boolean enableSendTsFileLimit = sinkParameters.getBooleanByKeys(new String[]{"sink.enable-send-tsfile-limit", "connector.enable-send-tsfile-limit"});
            if (enableSendTsFileLimit == null) {
                sinkParameters.addAttribute("sink.enable-send-tsfile-limit", "true");
                LOGGER.info("PipeDataNodeTaskBuilder: When the realtime sync is enabled, we enable rate limiter in sending tsfile by default to reserve disk and network IO for realtime sending.");
            } else if (!enableSendTsFileLimit.booleanValue()) {
                LOGGER.warn("PipeDataNodeTaskBuilder: When the realtime sync is enabled, not enabling the rate limiter in sending tsfile may introduce delay for realtime sending.");
            }
        }
    }
}

