/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.services.helpers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.api.AccessContext;
import org.eclipse.milo.opcua.sdk.server.api.services.AttributeServices;
import org.eclipse.milo.opcua.sdk.server.api.services.ViewServices;
import org.eclipse.milo.opcua.sdk.server.services.ServiceAttributes;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePath;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePathResult;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePathTarget;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.RelativePath;
import org.eclipse.milo.opcua.stack.core.types.structured.RelativePathElement;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.TranslateBrowsePathsToNodeIdsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.TranslateBrowsePathsToNodeIdsResponse;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.server.services.ServiceRequest;

public class BrowsePathsHelper {
    private final AccessContext context;
    private final OpcUaServer server;

    public BrowsePathsHelper(AccessContext context, OpcUaServer server) {
        this.context = context;
        this.server = server;
    }

    public void onTranslateBrowsePaths(ServiceRequest service) {
        TranslateBrowsePathsToNodeIdsRequest request = (TranslateBrowsePathsToNodeIdsRequest)service.getRequest();
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        List browsePaths = ConversionUtil.l((Object[])request.getBrowsePaths());
        if (browsePaths.isEmpty()) {
            service.setServiceFault(0x800F0000L);
            return;
        }
        if (browsePaths.size() > server.getConfig().getLimits().getMaxNodesPerTranslateBrowsePathsToNodeIds().intValue()) {
            service.setServiceFault(0x80100000L);
            return;
        }
        ArrayList futures = Lists.newArrayListWithCapacity((int)browsePaths.size());
        for (BrowsePath browsePath : browsePaths) {
            futures.add(this.translate(browsePath));
        }
        FutureUtils.sequence((List)futures).thenAcceptAsync(results -> {
            ResponseHeader header = service.createResponseHeader();
            TranslateBrowsePathsToNodeIdsResponse response = new TranslateBrowsePathsToNodeIdsResponse(header, (BrowsePathResult[])ConversionUtil.a((List)results, BrowsePathResult.class), new DiagnosticInfo[0]);
            service.setResponse((UaResponseMessage)response);
        }, (Executor)server.getExecutorService());
    }

    private CompletableFuture<BrowsePathResult> translate(BrowsePath browsePath) {
        CompletableFuture<BrowsePathResult> future = new CompletableFuture<BrowsePathResult>();
        NodeId startingNode = browsePath.getStartingNode();
        RelativePath relativePath = browsePath.getRelativePath();
        if (startingNode.isNull()) {
            future.complete(new BrowsePathResult(new StatusCode(0x80330000L), new BrowsePathTarget[0]));
            return future;
        }
        List relativePathElements = ConversionUtil.l((Object[])relativePath.getElements());
        if (relativePathElements.isEmpty()) {
            future.complete(new BrowsePathResult(new StatusCode(0x800F0000L), new BrowsePathTarget[0]));
            return future;
        }
        this.follow(startingNode, relativePathElements).whenComplete((targets, ex) -> {
            if (targets != null) {
                BrowsePathResult result = !targets.isEmpty() ? new BrowsePathResult(StatusCode.GOOD, (BrowsePathTarget[])ConversionUtil.a((List)targets, BrowsePathTarget.class)) : new BrowsePathResult(new StatusCode(2154758144L), new BrowsePathTarget[0]);
                future.complete(result);
            } else {
                StatusCode statusCode = UaException.extractStatusCode((Throwable)ex).orElse(new StatusCode(2154758144L));
                BrowsePathResult result = new BrowsePathResult(statusCode, new BrowsePathTarget[0]);
                future.complete(result);
            }
        });
        return future;
    }

    private CompletableFuture<List<BrowsePathTarget>> follow(NodeId nodeId, List<RelativePathElement> elements) {
        if (elements.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        if (elements.size() == 1) {
            return this.target(nodeId, elements.get(0)).thenApply(targets -> targets.stream().map(n -> new BrowsePathTarget(n, UInteger.MAX)).collect(Collectors.toList()));
        }
        RelativePathElement e = elements.get(0);
        return this.next(nodeId, e).thenCompose(nextExId -> {
            if (nextExId.isNull()) {
                return FutureUtils.failedUaFuture((long)2154758144L);
            }
            List<RelativePathElement> nextElements = elements.subList(1, elements.size());
            Optional nextId = nextExId.toNodeId(this.server.getNamespaceTable());
            if (nextId.isPresent()) {
                return this.follow((NodeId)nextId.get(), nextElements);
            }
            UInteger remaining = nextElements.isEmpty() ? UInteger.MAX : Unsigned.uint((int)nextElements.size());
            ArrayList targets = Lists.newArrayList((Object[])new BrowsePathTarget[]{new BrowsePathTarget(nextExId, remaining)});
            return CompletableFuture.completedFuture(targets);
        });
    }

    private CompletableFuture<ExpandedNodeId> next(NodeId nodeId, RelativePathElement element) {
        NodeId referenceTypeId = element.getReferenceTypeId();
        boolean includeSubtypes = element.getIncludeSubtypes();
        QualifiedName targetName = element.getTargetName();
        if (targetName.isNull()) {
            return FutureUtils.failedUaFuture((long)0x80600000L);
        }
        ViewServices.BrowseContext browseContext = new ViewServices.BrowseContext(this.server, this.context.getSession().orElse(null));
        this.server.getAddressSpaceManager().browse(browseContext, nodeId);
        CompletableFuture future = browseContext.getFuture();
        return future.thenCompose(references -> {
            List<ExpandedNodeId> targetNodeIds = references.stream().filter(r -> referenceTypeId.isNull() || r.getReferenceTypeId().equals((Object)referenceTypeId) || includeSubtypes && r.subtypeOf(referenceTypeId, this.server.getReferenceTypes())).filter(r -> r.isInverse() == element.getIsInverse().booleanValue()).map(Reference::getTargetNodeId).collect(Collectors.toList());
            if (targetNodeIds.isEmpty()) {
                return FutureUtils.failedUaFuture((long)2154758144L);
            }
            return this.readTargetBrowseNames(targetNodeIds).thenApply(browseNames -> {
                for (int i = 0; i < targetNodeIds.size(); ++i) {
                    ExpandedNodeId targetNodeId = (ExpandedNodeId)targetNodeIds.get(i);
                    QualifiedName browseName = (QualifiedName)browseNames.get(i);
                    if (!browseName.equals((Object)targetName)) continue;
                    return targetNodeId;
                }
                return ExpandedNodeId.NULL_VALUE;
            });
        });
    }

    private CompletableFuture<List<ExpandedNodeId>> target(NodeId nodeId, RelativePathElement element) {
        NodeId referenceTypeId = element.getReferenceTypeId();
        boolean includeSubtypes = element.getIncludeSubtypes();
        QualifiedName targetName = element.getTargetName();
        if (targetName.isNull()) {
            return FutureUtils.failedUaFuture((long)0x80600000L);
        }
        ViewServices.BrowseContext browseContext = new ViewServices.BrowseContext(this.server, this.context.getSession().orElse(null));
        this.server.getAddressSpaceManager().browse(browseContext, nodeId);
        CompletableFuture future = browseContext.getFuture();
        return future.thenCompose(references -> {
            List<ExpandedNodeId> targetNodeIds = references.stream().filter(r -> referenceTypeId.isNull() || r.getReferenceTypeId().equals((Object)referenceTypeId) || includeSubtypes && r.subtypeOf(referenceTypeId, this.server.getReferenceTypes())).filter(r -> r.isInverse() == element.getIsInverse().booleanValue()).map(Reference::getTargetNodeId).collect(Collectors.toList());
            if (targetNodeIds.isEmpty()) {
                return FutureUtils.failedUaFuture((long)2154758144L);
            }
            return this.readTargetBrowseNames(targetNodeIds).thenApply(browseNames -> {
                ArrayList targets = Lists.newArrayList();
                for (int i = 0; i < targetNodeIds.size(); ++i) {
                    ExpandedNodeId targetNodeId = (ExpandedNodeId)targetNodeIds.get(i);
                    QualifiedName browseName = (QualifiedName)browseNames.get(i);
                    if (!this.matchesTarget(browseName, targetName)) continue;
                    targets.add(targetNodeId);
                }
                return targets;
            });
        });
    }

    private CompletableFuture<List<QualifiedName>> readTargetBrowseNames(List<ExpandedNodeId> targetNodeIds) {
        ArrayList futures = Lists.newArrayListWithCapacity((int)targetNodeIds.size());
        for (ExpandedNodeId xni : targetNodeIds) {
            CompletableFuture<ArrayList> future = xni.toNodeId(this.server.getNamespaceTable()).map(nodeId -> {
                ReadValueId readValueId = new ReadValueId(nodeId, AttributeId.BrowseName.uid(), null, QualifiedName.NULL_VALUE);
                AttributeServices.ReadContext context = new AttributeServices.ReadContext(this.server, null);
                this.server.getAddressSpaceManager().read(context, 0.0, TimestampsToReturn.Neither, Lists.newArrayList((Object[])new ReadValueId[]{readValueId}));
                return context.getFuture();
            }).orElse(CompletableFuture.completedFuture(Lists.newArrayList((Object[])new DataValue[]{new DataValue(2150891520L)})));
            futures.add(future);
        }
        return FutureUtils.sequence((List)futures).thenApply(values -> values.stream().map(l -> {
            DataValue v = (DataValue)l.get(0);
            return (QualifiedName)v.getValue().getValue();
        }).collect(Collectors.toList()));
    }

    private boolean matchesTarget(QualifiedName browseName, QualifiedName targetName) {
        return targetName == null || targetName.equals((Object)QualifiedName.NULL_VALUE) || targetName.equals((Object)browseName);
    }
}

