/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilterResult;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringFilterResult;

public class EventFilterResult
extends MonitoringFilterResult
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=734");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=736");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=735");
    private final StatusCode[] selectClauseResults;
    private final DiagnosticInfo[] selectClauseDiagnosticInfos;
    private final ContentFilterResult whereClauseResult;

    public EventFilterResult(StatusCode[] selectClauseResults, DiagnosticInfo[] selectClauseDiagnosticInfos, ContentFilterResult whereClauseResult) {
        this.selectClauseResults = selectClauseResults;
        this.selectClauseDiagnosticInfos = selectClauseDiagnosticInfos;
        this.whereClauseResult = whereClauseResult;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public StatusCode[] getSelectClauseResults() {
        return this.selectClauseResults;
    }

    public DiagnosticInfo[] getSelectClauseDiagnosticInfos() {
        return this.selectClauseDiagnosticInfos;
    }

    public ContentFilterResult getWhereClauseResult() {
        return this.whereClauseResult;
    }

    protected EventFilterResult(EventFilterResultBuilder<?, ?> b) {
        super((MonitoringFilterResult.MonitoringFilterResultBuilder<?, ?>)b);
        this.selectClauseResults = ((EventFilterResultBuilder)b).selectClauseResults;
        this.selectClauseDiagnosticInfos = ((EventFilterResultBuilder)b).selectClauseDiagnosticInfos;
        this.whereClauseResult = ((EventFilterResultBuilder)b).whereClauseResult;
    }

    public static EventFilterResultBuilder<?, ?> builder() {
        return new EventFilterResultBuilderImpl();
    }

    public EventFilterResultBuilder<?, ?> toBuilder() {
        return new EventFilterResultBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventFilterResult)) {
            return false;
        }
        EventFilterResult other = (EventFilterResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSelectClauseResults(), other.getSelectClauseResults())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSelectClauseDiagnosticInfos(), other.getSelectClauseDiagnosticInfos())) {
            return false;
        }
        ContentFilterResult this$whereClauseResult = this.getWhereClauseResult();
        ContentFilterResult other$whereClauseResult = other.getWhereClauseResult();
        return !(this$whereClauseResult == null ? other$whereClauseResult != null : !((Object)this$whereClauseResult).equals(other$whereClauseResult));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EventFilterResult;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getSelectClauseResults());
        result = result * 59 + Arrays.deepHashCode(this.getSelectClauseDiagnosticInfos());
        ContentFilterResult $whereClauseResult = this.getWhereClauseResult();
        result = result * 59 + ($whereClauseResult == null ? 43 : ((Object)$whereClauseResult).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "EventFilterResult(selectClauseResults=" + Arrays.deepToString(this.getSelectClauseResults()) + ", selectClauseDiagnosticInfos=" + Arrays.deepToString(this.getSelectClauseDiagnosticInfos()) + ", whereClauseResult=" + this.getWhereClauseResult() + ")";
    }

    private static final class EventFilterResultBuilderImpl
    extends EventFilterResultBuilder<EventFilterResult, EventFilterResultBuilderImpl> {
        private EventFilterResultBuilderImpl() {
        }

        @Override
        protected EventFilterResultBuilderImpl self() {
            return this;
        }

        @Override
        public EventFilterResult build() {
            return new EventFilterResult(this);
        }
    }

    public static abstract class EventFilterResultBuilder<C extends EventFilterResult, B extends EventFilterResultBuilder<C, B>>
    extends MonitoringFilterResult.MonitoringFilterResultBuilder<C, B> {
        private StatusCode[] selectClauseResults;
        private DiagnosticInfo[] selectClauseDiagnosticInfos;
        private ContentFilterResult whereClauseResult;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            EventFilterResultBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(EventFilterResult instance, EventFilterResultBuilder<?, ?> b) {
            b.selectClauseResults(instance.selectClauseResults);
            b.selectClauseDiagnosticInfos(instance.selectClauseDiagnosticInfos);
            b.whereClauseResult(instance.whereClauseResult);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B selectClauseResults(StatusCode[] selectClauseResults) {
            this.selectClauseResults = selectClauseResults;
            return (B)this.self();
        }

        public B selectClauseDiagnosticInfos(DiagnosticInfo[] selectClauseDiagnosticInfos) {
            this.selectClauseDiagnosticInfos = selectClauseDiagnosticInfos;
            return (B)this.self();
        }

        public B whereClauseResult(ContentFilterResult whereClauseResult) {
            this.whereClauseResult = whereClauseResult;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "EventFilterResult.EventFilterResultBuilder(super=" + super.toString() + ", selectClauseResults=" + Arrays.deepToString(this.selectClauseResults) + ", selectClauseDiagnosticInfos=" + Arrays.deepToString(this.selectClauseDiagnosticInfos) + ", whereClauseResult=" + this.whereClauseResult + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<EventFilterResult> {
        @Override
        public Class<EventFilterResult> getType() {
            return EventFilterResult.class;
        }

        @Override
        public EventFilterResult decode(SerializationContext context, UaDecoder decoder) {
            StatusCode[] selectClauseResults = decoder.readStatusCodeArray("SelectClauseResults");
            DiagnosticInfo[] selectClauseDiagnosticInfos = decoder.readDiagnosticInfoArray("SelectClauseDiagnosticInfos");
            ContentFilterResult whereClauseResult = (ContentFilterResult)decoder.readStruct("WhereClauseResult", ContentFilterResult.TYPE_ID);
            return new EventFilterResult(selectClauseResults, selectClauseDiagnosticInfos, whereClauseResult);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, EventFilterResult value) {
            encoder.writeStatusCodeArray("SelectClauseResults", value.getSelectClauseResults());
            encoder.writeDiagnosticInfoArray("SelectClauseDiagnosticInfos", value.getSelectClauseDiagnosticInfos());
            encoder.writeStruct("WhereClauseResult", (Object)value.getWhereClauseResult(), ContentFilterResult.TYPE_ID);
        }
    }
}

