/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.event;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.pipe.event.SerializableEvent;
import org.apache.iotdb.confignode.manager.pipe.event.PipeConfigRegionSnapshotEvent;
import org.apache.iotdb.confignode.manager.pipe.event.PipeConfigRegionWritePlanEvent;

public enum PipeConfigSerializableEventType {
    CONFIG_WRITE_PLAN(1),
    CONFIG_SNAPSHOT(2);

    private static final Map<Byte, PipeConfigSerializableEventType> TYPE_EVENT_MAP;
    private final byte type;

    private PipeConfigSerializableEventType(byte type) {
        this.type = type;
    }

    public byte getType() {
        return this.type;
    }

    public static PipeConfigSerializableEventType deserialize(byte type) {
        return TYPE_EVENT_MAP.get(type);
    }

    public static SerializableEvent deserialize(ByteBuffer buffer) throws IOException {
        byte eventType = buffer.get();
        return PipeConfigSerializableEventType.deserialize(buffer, eventType);
    }

    public static SerializableEvent deserialize(ByteBuffer buffer, byte eventType) throws IOException {
        Object event;
        switch (eventType) {
            case 1: {
                event = new PipeConfigRegionWritePlanEvent();
                break;
            }
            case 2: {
                event = new PipeConfigRegionSnapshotEvent();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid event type: " + eventType);
            }
        }
        event.deserializeFromByteBuffer(buffer);
        return event;
    }

    static {
        TYPE_EVENT_MAP = new HashMap<Byte, PipeConfigSerializableEventType>();
        for (PipeConfigSerializableEventType type : PipeConfigSerializableEventType.values()) {
            TYPE_EVENT_MAP.put(type.getType(), type);
        }
    }
}

