/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.leaf;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionType;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.LeafOperand;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ExpressionVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.queryengine.transformation.dag.memory.LayerMemoryAssigner;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.RamUsageEstimator;

public class TimeSeriesOperand
extends LeafOperand {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(TimeSeriesOperand.class);
    private PartialPath path;

    public TimeSeriesOperand(PartialPath path) {
        this.path = path;
    }

    public TimeSeriesOperand(ByteBuffer byteBuffer) {
        this.path = (PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer);
    }

    public static TimeSeriesOperand constructColumnHeaderExpression(String columnName, TSDataType dataType) {
        MeasurementPath measurementPath = new MeasurementPath(new PartialPath(columnName, false), dataType);
        return new TimeSeriesOperand((PartialPath)measurementPath);
    }

    public PartialPath getPath() {
        return this.path;
    }

    public void setPath(PartialPath path) {
        this.path = path;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitTimeSeriesOperand(this, context);
    }

    @Override
    public boolean isConstantOperandInternal() {
        return false;
    }

    @Override
    public void bindInputLayerColumnIndexWithExpression(Map<String, List<InputLocation>> inputLocations) {
        String digest = this.getExpressionString();
        if (inputLocations.containsKey(digest)) {
            this.inputColumnIndex = inputLocations.get(digest).get(0).getValueColumnIndex();
        }
    }

    @Override
    public void updateStatisticsForMemoryAssigner(LayerMemoryAssigner memoryAssigner) {
        memoryAssigner.increaseExpressionReference(this);
    }

    @Override
    public String getExpressionStringInternal() {
        return this.path.isMeasurementAliasExists() ? this.path.getFullPathWithAlias() : this.path.getFullPath();
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.TIMESERIES;
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        this.path.serialize(byteBuffer);
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        this.path.serialize((OutputStream)stream);
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfPartialPath(this.path);
    }
}

