/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.metric.impl;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.ignite.internal.processors.metric.AbstractMetric;
import org.apache.ignite.internal.processors.metric.ConfigurableHistogramMetric;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

public class PeriodicHistogramMetricImpl
extends AbstractMetric
implements ConfigurableHistogramMetric {
    public static final long DFLT_BUCKETS_INTERVAL = 3600000L;
    public static final int DFLT_BUCKETS_CNT = 24;
    private long bucketsInterval;
    private int bucketsCnt;
    private volatile long startTs;
    private volatile long lowerBoundTs;
    private volatile long upperBoundTs;
    private final AtomicLong outOfBoundsBucket = new AtomicLong();
    private final long createTs = U.currentTimeMillis();
    private volatile AtomicLongArray buckets;

    public PeriodicHistogramMetricImpl(String name, @Nullable String desc) {
        this(U.currentTimeMillis(), name, desc);
    }

    public PeriodicHistogramMetricImpl(long startTs, String name, @Nullable String desc) {
        this(startTs, name, desc, 3600000L, 24);
    }

    private PeriodicHistogramMetricImpl(long startTs, String name, @Nullable String desc, long bucketsInterval, int bucketsCnt) {
        super(name, desc);
        this.reinit(bucketsInterval, bucketsCnt);
        this.startTs = startTs;
        this.lowerBoundTs = startTs;
        this.upperBoundTs = startTs + bucketsInterval;
    }

    @Override
    public long[] bounds() {
        long[] boundsIncludingFirst = this.histogram().get1();
        return Arrays.copyOfRange(boundsIncludingFirst, 1, boundsIncludingFirst.length);
    }

    @Override
    public void bounds(long[] bounds) {
        A.notNull(bounds, "bounds");
        A.ensure(bounds.length > 1, "bounds.length > 1");
        A.ensure(bounds[0] < bounds[1], "bounds[0] < bounds[1]");
        this.reinit(bounds[1] - bounds[0], bounds.length);
    }

    @Override
    public long[] value() {
        return this.histogram().get2();
    }

    @Override
    public Class<long[]> type() {
        return long[].class;
    }

    public synchronized void reinit(long bucketsInterval, int bucketsCnt) {
        this.lowerBoundTs = this.startTs = U.currentTimeMillis();
        this.upperBoundTs = this.startTs + bucketsInterval;
        this.bucketsInterval = bucketsInterval;
        this.bucketsCnt = bucketsCnt + 1;
        AtomicLongArray oldBuckets = this.buckets;
        this.buckets = new AtomicLongArray(this.bucketsCnt);
        if (oldBuckets != null) {
            for (int i = 0; i < oldBuckets.length(); ++i) {
                this.outOfBoundsBucket.addAndGet(oldBuckets.getAndSet(i, 0L));
            }
        }
    }

    public synchronized void reset(long itemsCnt) {
        this.reinit(this.bucketsInterval, this.bucketsCnt);
        this.outOfBoundsBucket.set(itemsCnt);
    }

    public void increment(long ts) {
        this.add(ts, 1);
    }

    public void decrement(long ts) {
        this.add(ts, -1);
    }

    public synchronized IgniteBiTuple<long[], long[]> histogram() {
        long curTs = U.currentTimeMillis();
        if (curTs >= this.upperBoundTs) {
            this.shiftBuckets(curTs);
        }
        int cnt = (int)((this.upperBoundTs - this.lowerBoundTs) / this.bucketsInterval) + 1;
        long[] res = new long[cnt];
        long[] bounds = new long[cnt];
        int dummyBucketIdx = this.dummyBucketIdx();
        res[0] = this.outOfBoundsBucket.get() + this.buckets.get(dummyBucketIdx);
        bounds[0] = this.createTs == this.lowerBoundTs ? this.createTs - this.bucketsInterval : this.createTs;
        for (int i = 1; i < cnt; ++i) {
            res[i] = this.buckets.get((dummyBucketIdx + i) % this.bucketsCnt);
            bounds[i] = this.lowerBoundTs + (long)(i - 1) * this.bucketsInterval;
        }
        return new IgniteBiTuple<long[], long[]>(bounds, res);
    }

    public long bucketsInterval() {
        return this.bucketsInterval;
    }

    public int bucketsCount() {
        return this.bucketsCnt;
    }

    public long startTs() {
        return this.startTs;
    }

    private int bucketIdx(long ts) {
        return (int)((ts - this.startTs) / this.bucketsInterval) % this.bucketsCnt;
    }

    private int dummyBucketIdx() {
        return (this.bucketIdx(this.lowerBoundTs) + this.bucketsCnt - 1) % this.bucketsCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(long ts, int val) {
        long curTs = U.currentTimeMillis();
        if (ts > curTs) {
            curTs = ts;
        }
        if (curTs >= this.upperBoundTs) {
            this.shiftBuckets(curTs);
        }
        if (ts < this.lowerBoundTs) {
            this.outOfBoundsBucket.addAndGet(val);
        } else {
            AtomicLongArray buckets = this.buckets;
            int idx = this.bucketIdx(ts);
            if (ts <= this.startTs) {
                if (ts == this.startTs) {
                    PeriodicHistogramMetricImpl periodicHistogramMetricImpl = this;
                    synchronized (periodicHistogramMetricImpl) {
                        this.buckets.addAndGet(0, val);
                    }
                } else {
                    this.outOfBoundsBucket.addAndGet(val);
                }
            } else {
                buckets.addAndGet(idx, val);
                if (buckets != this.buckets) {
                    this.outOfBoundsBucket.addAndGet(buckets.getAndSet(idx, 0L));
                }
            }
        }
    }

    private synchronized void shiftBuckets(long curTs) {
        long oldLowerBoundTs = this.lowerBoundTs;
        long oldUpperBoundTs = this.upperBoundTs;
        if (curTs < oldUpperBoundTs) {
            return;
        }
        int bucketsSinceLastShift = (int)((curTs - oldUpperBoundTs) / this.bucketsInterval) + 1;
        long newUpperBoundTs = oldUpperBoundTs + (long)bucketsSinceLastShift * this.bucketsInterval;
        long newLowerBoundTs = newUpperBoundTs - (long)(this.bucketsCnt - 1) * this.bucketsInterval;
        if (newLowerBoundTs > oldLowerBoundTs) {
            int bucketsToShift = Math.min(this.bucketsCnt, (int)((newLowerBoundTs - oldLowerBoundTs) / this.bucketsInterval));
            int shiftBucketIdx = (this.bucketIdx(oldLowerBoundTs) + this.bucketsCnt - 1) % this.bucketsCnt;
            for (int i = 0; i <= bucketsToShift; ++i) {
                this.outOfBoundsBucket.addAndGet(this.buckets.getAndSet(shiftBucketIdx, 0L));
                shiftBucketIdx = (shiftBucketIdx + 1) % this.bucketsCnt;
            }
            this.lowerBoundTs = newLowerBoundTs;
        }
        this.upperBoundTs = newUpperBoundTs;
    }
}

