/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.file;

import java.nio.file.Path;
import java.util.function.LongConsumer;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStore;
import org.apache.ignite.lang.IgniteOutClosure;

public class FilePageStoreV2
extends FilePageStore {
    public static final int VERSION = 2;

    public FilePageStoreV2(byte type, IgniteOutClosure<Path> pathProvider, FileIOFactory factory, int pageSize, LongConsumer allocatedTracker) {
        super(type, pathProvider, factory, pageSize, allocatedTracker);
    }

    @Override
    public int headerSize() {
        return this.pageSize;
    }

    @Override
    public int version() {
        return 2;
    }

    @Override
    public int getBlockSize() {
        return this.fileIO.getFileSystemBlockSize();
    }

    @Override
    public long getSparseSize() {
        FileIO io = this.fileIO;
        return io == null ? 0L : this.fileIO.getSparseSize();
    }

    @Override
    public void punchHole(long pageId, int usefulBytes) {
        assert (usefulBytes >= 0 && usefulBytes < this.pageSize) : usefulBytes;
        long off = this.pageOffset(pageId);
        this.fileIO.punchHole(off + (long)usefulBytes, this.pageSize - usefulBytes);
    }
}

