/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.baseline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.management.api.CommandUtils;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.baseline.BaselineAutoAdjustSettings;
import org.apache.ignite.internal.management.baseline.BaselineCommand;
import org.apache.ignite.internal.management.baseline.BaselineNode;
import org.apache.ignite.internal.management.baseline.BaselineTask;
import org.apache.ignite.internal.management.baseline.BaselineTaskResult;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;

public abstract class AbstractBaselineCommand
implements ComputeCommand<BaselineCommand.BaselineTaskArg, BaselineTaskResult> {
    @Override
    public Class<BaselineTask> taskClass() {
        return BaselineTask.class;
    }

    @Override
    public Collection<GridClientNode> nodes(Collection<GridClientNode> nodes, BaselineCommand.BaselineTaskArg arg) {
        return CommandUtils.coordinatorOrNull(nodes);
    }

    @Override
    public void printResult(BaselineCommand.BaselineTaskArg arg, BaselineTaskResult res, Consumer<String> printer) {
        printer.accept("Cluster state: " + res.clusterState());
        printer.accept("Current topology version: " + res.getTopologyVersion());
        BaselineAutoAdjustSettings autoAdjustSettings = res.getAutoAdjustSettings();
        if (autoAdjustSettings != null) {
            printer.accept("Baseline auto adjustment " + (Boolean.TRUE.equals(autoAdjustSettings.getEnabled()) ? "enabled" : "disabled") + ": softTimeout=" + autoAdjustSettings.getSoftTimeout());
        }
        if (autoAdjustSettings.enabled.booleanValue()) {
            if (res.isBaselineAdjustInProgress()) {
                printer.accept("Baseline auto-adjust is in progress");
            } else if (res.getRemainingTimeToBaselineAdjust() < 0L) {
                printer.accept("Baseline auto-adjust are not scheduled");
            } else {
                printer.accept("Baseline auto-adjust will happen in '" + res.getRemainingTimeToBaselineAdjust() + "' ms");
            }
        }
        printer.accept("");
        Map<String, BaselineNode> baseline = res.getBaseline();
        Map<String, BaselineNode> srvs = res.getServers();
        Function<BaselineNode, String> extractFormattedAddrs = node -> {
            Stream<String> sortedByIpHosts = ((Collection)Optional.ofNullable(node).map(addrs -> node.getAddrs()).orElse(Collections.emptyList())).stream().sorted(Comparator.comparing(resolvedAddr -> new VisorTaskUtils.SortableAddress(resolvedAddr.address()))).map(resolvedAddr -> {
                if (!resolvedAddr.hostname().equals(resolvedAddr.address())) {
                    return resolvedAddr.hostname() + "/" + resolvedAddr.address();
                }
                return resolvedAddr.address();
            });
            if (arg.verbose()) {
                String hosts = String.join((CharSequence)",", sortedByIpHosts.collect(Collectors.toList()));
                if (!hosts.isEmpty()) {
                    return ", Addresses=" + hosts;
                }
                return "";
            }
            return sortedByIpHosts.findFirst().map(ip -> ", Address=" + ip).orElse("");
        };
        String crdStr = srvs.values().stream().filter(node -> node.getOrder() != null).min(Comparator.comparing(BaselineNode::getOrder)).map(crd -> " (Coordinator: ConsistentId=" + crd.getConsistentId() + (String)extractFormattedAddrs.apply((BaselineNode)crd) + ", Order=" + crd.getOrder() + ")").orElse("");
        printer.accept("Current topology version: " + res.getTopologyVersion() + crdStr);
        printer.accept("");
        if (F.isEmpty(baseline)) {
            printer.accept("Baseline nodes not found.");
        } else {
            printer.accept("Baseline nodes:");
            for (BaselineNode node2 : baseline.values()) {
                BaselineNode srvNode = srvs.get(node2.getConsistentId());
                String state = ", State=" + (srvNode != null ? "ONLINE" : "OFFLINE");
                String order = srvNode != null ? ", Order=" + srvNode.getOrder() : "";
                printer.accept("    ConsistentId=" + node2.getConsistentId() + extractFormattedAddrs.apply(srvNode) + state + order);
            }
            printer.accept("--------------------------------------------------------------------------------");
            printer.accept("Number of baseline nodes: " + baseline.size());
            printer.accept("");
            ArrayList<BaselineNode> others = new ArrayList<BaselineNode>();
            for (BaselineNode node3 : srvs.values()) {
                if (baseline.containsKey(node3.getConsistentId())) continue;
                others.add(node3);
            }
            if (F.isEmpty(others)) {
                printer.accept("Other nodes not found.");
            } else {
                printer.accept("Other nodes:");
                for (BaselineNode node3 : others) {
                    printer.accept("    ConsistentId=" + node3.getConsistentId() + ", Order=" + node3.getOrder());
                }
                printer.accept("Number of other nodes: " + others.size());
            }
        }
    }
}

