/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.mongo;

import com.mongodb.ClientSessionOptions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoDatabase;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.mongo.MongoConnectionDetails;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.gridfs.GridFsOperations;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={MongoDatabaseFactory.class})
class MongoDatabaseFactoryDependentConfiguration {
    MongoDatabaseFactoryDependentConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean(value={MongoOperations.class})
    MongoTemplate mongoTemplate(MongoDatabaseFactory factory, MongoConverter converter) {
        return new MongoTemplate(factory, converter);
    }

    @Bean
    @ConditionalOnMissingBean(value={GridFsOperations.class})
    GridFsTemplate gridFsTemplate(MongoProperties properties, MongoDatabaseFactory factory, MongoTemplate mongoTemplate, MongoConnectionDetails connectionDetails) {
        return new GridFsTemplate((MongoDatabaseFactory)new GridFsMongoDatabaseFactory(factory, connectionDetails), mongoTemplate.getConverter(), connectionDetails.getGridFs() != null ? connectionDetails.getGridFs().getBucket() : null);
    }

    static class GridFsMongoDatabaseFactory
    implements MongoDatabaseFactory {
        private final MongoDatabaseFactory mongoDatabaseFactory;
        private final MongoConnectionDetails connectionDetails;

        GridFsMongoDatabaseFactory(MongoDatabaseFactory mongoDatabaseFactory, MongoConnectionDetails connectionDetails) {
            Assert.notNull((Object)mongoDatabaseFactory, "'mongoDatabaseFactory' must not be null");
            Assert.notNull((Object)connectionDetails, "'connectionDetails' must not be null");
            this.mongoDatabaseFactory = mongoDatabaseFactory;
            this.connectionDetails = connectionDetails;
        }

        public MongoDatabase getMongoDatabase() throws DataAccessException {
            String gridFsDatabase = this.getGridFsDatabase(this.connectionDetails);
            if (StringUtils.hasText(gridFsDatabase)) {
                return this.mongoDatabaseFactory.getMongoDatabase(gridFsDatabase);
            }
            return this.mongoDatabaseFactory.getMongoDatabase();
        }

        public MongoDatabase getMongoDatabase(String dbName) throws DataAccessException {
            return this.mongoDatabaseFactory.getMongoDatabase(dbName);
        }

        public PersistenceExceptionTranslator getExceptionTranslator() {
            return this.mongoDatabaseFactory.getExceptionTranslator();
        }

        public ClientSession getSession(ClientSessionOptions options) {
            return this.mongoDatabaseFactory.getSession(options);
        }

        public MongoDatabaseFactory withSession(ClientSession session) {
            return this.mongoDatabaseFactory.withSession(session);
        }

        private String getGridFsDatabase(MongoConnectionDetails connectionDetails) {
            return connectionDetails.getGridFs() != null ? connectionDetails.getGridFs().getDatabase() : null;
        }
    }
}

