/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.core.grailsversion;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.EqualsAndHashCode;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.MethodHandles;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.util.HashCodeHelper;

@EqualsAndHashCode(includes={"text"})
public class Snapshot
implements Comparable<Snapshot>,
GroovyObject {
    private static final String SNAPSHOT = "SNAPSHOT";
    private static final String RC = "RC";
    private static final String MILESTONE;
    private final String text;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public Snapshot(String text) {
        String string;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.text = string = text;
        if (!text.matches("^(M|RC|Final)\\d*$") && !this.isBuildSnapshot()) {
            throw (Throwable)new IllegalArgumentException("GrailsVersion snapshot is not in the expected format");
        }
    }

    public String toString() {
        return this.text;
    }

    public int getMilestoneVersion() {
        return StringGroovyMethods.toInteger(this.text.replace(MILESTONE, ""));
    }

    public int getReleaseCandidateVersion() {
        return StringGroovyMethods.toInteger(this.text.replace(RC, ""));
    }

    public boolean isBuildSnapshot() {
        return this.text.endsWith(SNAPSHOT);
    }

    public boolean isReleaseCandidate() {
        return this.text.startsWith(RC);
    }

    public boolean isMilestone() {
        return this.text.startsWith(MILESTONE);
    }

    @Override
    public int compareTo(Snapshot o) {
        if (this.isBuildSnapshot() && !o.isBuildSnapshot()) {
            return 1;
        }
        if (!this.isBuildSnapshot() && o.isBuildSnapshot()) {
            return -1;
        }
        if (this.isBuildSnapshot() && o.isBuildSnapshot()) {
            return 0;
        }
        if (this.isReleaseCandidate() && !o.isReleaseCandidate()) {
            return 1;
        }
        if (!this.isReleaseCandidate() && o.isReleaseCandidate()) {
            return -1;
        }
        if (this.isReleaseCandidate() && o.isReleaseCandidate()) {
            return Integer.compare(this.getReleaseCandidateVersion(), o.getReleaseCandidateVersion());
        }
        if (this.isMilestone() && !o.isMilestone()) {
            return 1;
        }
        if (!this.isMilestone() && o.isMilestone()) {
            return -1;
        }
        if (this.isMilestone() && o.isMilestone()) {
            return Integer.compare(this.getMilestoneVersion(), o.getMilestoneVersion());
        }
        return 0;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Snapshot.class) {
            return ScriptBytecodeAdapter.initMetaClass(this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    public int hashCode() {
        int _result = HashCodeHelper.initHash();
        if (this.getText() != this) {
            _result = HashCodeHelper.updateHash(_result, this.getText());
        }
        return _result;
    }

    @Generated
    public boolean canEqual(Object other) {
        return other instanceof Snapshot;
    }

    @Generated
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof Snapshot)) {
            return false;
        }
        Snapshot otherTyped = (Snapshot)other;
        if (!otherTyped.canEqual(this)) {
            return false;
        }
        return !(!ScriptBytecodeAdapter.compareEqual(this.getText(), otherTyped.getText()));
    }

    @Override
    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Override
    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        String string;
        MILESTONE = string = "M";
    }

    @Generated
    public String getText() {
        return this.text;
    }
}

