/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.websocket.jakarta.server.internal;

import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.security.Principal;
import org.eclipse.jetty.ee10.websocket.jakarta.common.UpgradeRequest;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeRequest;

public class JakartaServerUpgradeRequest
implements UpgradeRequest {
    private final HttpServletRequest _servletRequest;
    private final Principal _userPrincipal;

    public JakartaServerUpgradeRequest(ServerUpgradeRequest upgradeRequest) {
        this._servletRequest = (HttpServletRequest)upgradeRequest.getAttribute("org.eclipse.jetty.websocket.wrappedRequest");
        this._userPrincipal = this._servletRequest.getUserPrincipal();
    }

    @Override
    public Principal getUserPrincipal() {
        return this._userPrincipal;
    }

    @Override
    public URI getRequestURI() {
        return HttpURI.build(this._servletRequest.getRequestURI()).path(URIUtil.addEncodedPaths(this._servletRequest.getContextPath(), this.getPathInContext())).query(this._servletRequest.getQueryString()).asImmutable().toURI();
    }

    @Override
    public String getPathInContext() {
        return URIUtil.encodePath(URIUtil.addPaths(this._servletRequest.getServletPath(), this._servletRequest.getPathInfo()));
    }
}

