/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.rest;

import jakarta.annotation.security.RolesAllowed;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import org.apache.directory.fortress.core.model.FortRequest;
import org.apache.directory.fortress.core.model.FortResponse;
import org.apache.directory.fortress.rest.AccessMgrImpl;
import org.apache.directory.fortress.rest.AdminMgrImpl;
import org.apache.directory.fortress.rest.AuditMgrImpl;
import org.apache.directory.fortress.rest.ConfigMgrImpl;
import org.apache.directory.fortress.rest.DelegatedAccessMgrImpl;
import org.apache.directory.fortress.rest.DelegatedAdminMgrImpl;
import org.apache.directory.fortress.rest.DelegatedReviewMgrImpl;
import org.apache.directory.fortress.rest.FortressService;
import org.apache.directory.fortress.rest.GroupMgrImpl;
import org.apache.directory.fortress.rest.PswdPolicyMgrImpl;
import org.apache.directory.fortress.rest.ReviewMgrImpl;
import org.apache.directory.fortress.rest.SecUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="fortressService")
public class FortressServiceImpl
implements FortressService {
    private static final Logger LOG = LoggerFactory.getLogger((String)FortressServiceImpl.class.getName());
    private final ReviewMgrImpl reviewMgrImpl = new ReviewMgrImpl();
    private final AdminMgrImpl adminMgrImpl = new AdminMgrImpl();
    private final PswdPolicyMgrImpl pswdPolicyMgrImpl = new PswdPolicyMgrImpl();
    private final DelegatedAccessMgrImpl delegatedAccessMgrImpl = new DelegatedAccessMgrImpl();
    private final DelegatedReviewMgrImpl delegatedReviewMgrImpl = new DelegatedReviewMgrImpl();
    private final DelegatedAdminMgrImpl delegatedAdminMgrImpl = new DelegatedAdminMgrImpl();
    private final AccessMgrImpl accessMgrImpl = new AccessMgrImpl();
    private final AuditMgrImpl auditMgrImpl = new AuditMgrImpl();
    private final ConfigMgrImpl configMgrImpl = new ConfigMgrImpl();
    private final GroupMgrImpl groupMgrImpl = new GroupMgrImpl();
    private static final String SUPER_USER = "fortress-rest-super-user";
    private static final String ACCESS_MGR_USER = "fortress-rest-access-user";
    private static final String ADMIN_MGR_USER = "fortress-rest-admin-user";
    private static final String REVIEW_MGR_USER = "fortress-rest-review-user";
    private static final String DELEGATED_ACCESS_MGR_USER = "fortress-rest-delaccess-user";
    private static final String DELEGATED_ADMIN_MGR_USER = "fortress-rest-deladmin-user";
    private static final String DELEGATED_REVIEW_MGR_USER = "fortress-rest-delreview-user";
    private static final String PASSWORD_MGR_USER = "fortress-rest-pwmgr-user";
    private static final String AUDIT_MGR_USER = "fortress-rest-audit-user";
    private static final String CONFIG_MGR_USER = "fortress-rest-config-user";
    @Context
    private HttpServletRequest httpRequest;

    @POST
    @Path(value="/userAdd/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse addUser(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.addUser(request);
        }
        return response;
    }

    @POST
    @Path(value="/userDelete/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse deleteUser(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.deleteUser(request);
        }
        return response;
    }

    @POST
    @Path(value="/userDisable/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse disableUser(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.disableUser(request);
        }
        return response;
    }

    @POST
    @Path(value="/userUpdate/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse updateUser(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.updateUser(request);
        }
        return response;
    }

    @POST
    @Path(value="/userChange/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse changePassword(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.changePassword(request);
        }
        return response;
    }

    @POST
    @Path(value="/userLock/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse lockUserAccount(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.lockUserAccount(request);
        }
        return response;
    }

    @POST
    @Path(value="/userUnlock/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse unlockUserAccount(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.unlockUserAccount(request);
        }
        return response;
    }

    @POST
    @Path(value="/userReset/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse resetPassword(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.resetPassword(request);
        }
        return response;
    }

    @POST
    @Path(value="/roleAdd/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse addRole(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.addRole(request);
        }
        return response;
    }

    @POST
    @Path(value="/roleDelete/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse deleteRole(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.deleteRole(request);
        }
        return response;
    }

    @POST
    @Path(value="/roleUpdate/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse updateRole(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.updateRole(request);
        }
        return response;
    }

    @POST
    @Path(value="/roleAsgn/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse assignUser(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.assignUser(request);
        }
        return response;
    }

    @POST
    @Path(value="/roleDeasgn/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse deassignUser(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.deassignUser(request);
        }
        return response;
    }

    @POST
    @Path(value="/permAdd/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse addPermission(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.addPermission(request);
        }
        return response;
    }

    @POST
    @Path(value="/permUpdate/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse updatePermission(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.updatePermission(request);
        }
        return response;
    }

    @POST
    @Path(value="/permDelete/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse deletePermission(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.deletePermission(request);
        }
        return response;
    }

    @POST
    @Path(value="/objAdd/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse addPermObj(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.addPermObj(request);
        }
        return response;
    }

    @POST
    @Path(value="/objUpdate/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse updatePermObj(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.updatePermObj(request);
        }
        return response;
    }

    @POST
    @Path(value="/objDelete/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse deletePermObj(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.deletePermObj(request);
        }
        return response;
    }

    @POST
    @Path(value="/roleGrant/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse grant(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.grant(request, this);
        }
        return response;
    }

    @POST
    @Path(value="/roleRevoke/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse revoke(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.revoke(request, this);
        }
        return response;
    }

    @POST
    @Path(value="/userGrant/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse grantUser(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.grantUser(request, this);
        }
        return response;
    }

    @POST
    @Path(value="/userRevoke/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse revokeUser(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.revokeUser(request, this);
        }
        return response;
    }

    @POST
    @Path(value="/roleDescendant/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse addDescendant(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.addDescendant(request);
        }
        return response;
    }

    @POST
    @Path(value="/roleAscendent/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse addAscendant(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.addAscendant(request);
        }
        return response;
    }

    @POST
    @Path(value="/roleAddinherit/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse addInheritance(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.addInheritance(request);
        }
        return response;
    }

    @POST
    @Path(value="/roleDelinherit/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse deleteInheritance(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.deleteInheritance(request);
        }
        return response;
    }

    @POST
    @Path(value="/ssdAdd/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse createSsdSet(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.createSsdSet(request);
        }
        return response;
    }

    @POST
    @Path(value="/ssdUpdate/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse updateSsdSet(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.updateSsdSet(request);
        }
        return response;
    }

    @POST
    @Path(value="/ssdAddMember/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse addSsdRoleMember(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.addSsdRoleMember(request);
        }
        return response;
    }

    @POST
    @Path(value="/ssdDelMember/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse deleteSsdRoleMember(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.deleteSsdRoleMember(request);
        }
        return response;
    }

    @POST
    @Path(value="/ssdDelete/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse deleteSsdSet(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.deleteSsdSet(request);
        }
        return response;
    }

    @POST
    @Path(value="/ssdCardUpdate/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse setSsdSetCardinality(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.setSsdSetCardinality(request);
        }
        return response;
    }

    @POST
    @Path(value="/dsdAdd/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse createDsdSet(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.createDsdSet(request);
        }
        return response;
    }

    @POST
    @Path(value="/dsdUpdate/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse updateDsdSet(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.updateDsdSet(request);
        }
        return response;
    }

    @POST
    @Path(value="/dsdAddMember/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse addDsdRoleMember(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.addDsdRoleMember(request);
        }
        return response;
    }

    @POST
    @Path(value="/dsdDelMember/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse deleteDsdRoleMember(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.deleteDsdRoleMember(request);
        }
        return response;
    }

    @POST
    @Path(value="/dsdDelete/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse deleteDsdSet(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.deleteDsdSet(request);
        }
        return response;
    }

    @POST
    @Path(value="/dsdCardUpdate/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse setDsdSetCardinality(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.setDsdSetCardinality(request);
        }
        return response;
    }

    @POST
    @Path(value="/addRoleConstraint/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse addRoleConstraint(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.addRoleConstraint(request);
        }
        return response;
    }

    @POST
    @Path(value="/removeRoleConstraint/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse removeRoleConstraint(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.removeRoleConstraint(request);
        }
        return response;
    }

    @POST
    @Path(value="/removeRoleConstraintId/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse removeRoleConstraintWid(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.removeRoleConstraintWid(request);
        }
        return response;
    }

    @POST
    @Path(value="/addPermissionAttributeSet/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse addPermissionAttributeSet(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.addPermissionAttributeSet(request);
        }
        return response;
    }

    @POST
    @Path(value="/deletePermissionAttributeSet/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse deletePermissionAttributeSet(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.deletePermissionAttributeSet(request);
        }
        return response;
    }

    @POST
    @Path(value="/addPermissionAttributeToSet/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse addPermissionAttributeToSet(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.addPermissionAttributeToSet(request);
        }
        return response;
    }

    @POST
    @Path(value="/removePermissionAttributeFromSet/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse removePermissionAttributeFromSet(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.removePermissionAttributeFromSet(request);
        }
        return response;
    }

    @POST
    @Path(value="/updatePermissionAttributeInSet/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse updatePermissionAttributeInSet(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.updatePermissionAttributeInSet(request);
        }
        return response;
    }

    @POST
    @Path(value="/roleEnableConstraint/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse enableRoleConstraint(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.enableRoleConstraint(request);
        }
        return response;
    }

    @POST
    @Path(value="/roleDisableConstraint/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse disableRoleConstraint(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.adminMgrImpl.disableRoleConstraint(request);
        }
        return response;
    }

    @POST
    @Path(value="/permRead/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse readPermission(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.readPermission(request);
        }
        return response;
    }

    @POST
    @Path(value="/objRead/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse readPermObj(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.readPermObj(request);
        }
        return response;
    }

    @POST
    @Path(value="/permSearch/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse findPermissions(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.findPermissions(request);
        }
        return response;
    }

    @POST
    @Path(value="/permObjSearch/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse findPermsByObj(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.findObjPermissions(request);
        }
        return response;
    }

    @POST
    @Path(value="/permSearchAny/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse findAnyPermissions(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.findAnyPermissions(request);
        }
        return response;
    }

    @POST
    @Path(value="/objSearch/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse findPermObjs(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.findPermObjs(request);
        }
        return response;
    }

    @POST
    @Path(value="/roleRead/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse readRole(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.readRole(request);
        }
        return response;
    }

    @POST
    @Path(value="/roleSearch/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse findRoles(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.findRoles(request);
        }
        return response;
    }

    @POST
    @Path(value="/userRead/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse readUser(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.readUserM(request);
        }
        return response;
    }

    @POST
    @Path(value="/userSearch/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse findUsers(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.findUsersM(request);
        }
        return response;
    }

    @POST
    @Path(value="/userAsigned/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse assignedUsers(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.assignedUsersM(request);
        }
        return response;
    }

    @POST
    @Path(value="/userAsignedConstraints/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse assignedUsersConstraints(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.assignedUsersConstraints(request);
        }
        return response;
    }

    @POST
    @Path(value="/userAsignedConstraintsKey/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse assignedUsersConstraintsKey(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.assignedUsersConstraintsKey(request);
        }
        return response;
    }

    @POST
    @Path(value="/roleAsigned/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse assignedRoles(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.assignedRolesM(request);
        }
        return response;
    }

    @POST
    @Path(value="/userAuthzed/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse authorizedUsers(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.authorizedUsersM(request);
        }
        return response;
    }

    @POST
    @Path(value="/roleAuthzed/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse authorizedRoles(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.authorizedRoleM(request);
        }
        return response;
    }

    @POST
    @Path(value="/permRoles/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse permissionRoles(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.permissionRolesM(request);
        }
        return response;
    }

    @POST
    @Path(value="/findRoleConstraints/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse findRoleConstraints(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.findRoleConstraintsM(request);
        }
        return response;
    }

    @POST
    @Path(value="/rolePerms/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse rolePermissions(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.rolePermissionsM(request);
        }
        return response;
    }

    @POST
    @Path(value="/userPerms/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse userPermissions(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.userPermissionsM(request);
        }
        return response;
    }

    @POST
    @Path(value="/permRolesAuthzed/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse authorizedPermissionRoles(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.authorizedPermissionRolesM(request);
        }
        return response;
    }

    @POST
    @Path(value="/permUsers/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse permissionUsers(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.permissionUsersM(request);
        }
        return response;
    }

    @POST
    @Path(value="/permUsersAuthzed/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse authorizedPermissionUsers(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.authorizedPermissionUsersM(request);
        }
        return response;
    }

    @POST
    @Path(value="/readPermAttributeSet/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse readPermAttributeSet(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.readPermAttributeSetM(request);
        }
        return response;
    }

    @POST
    @Path(value="/rolePermAttrSets/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse rolePermissionAttributeSets(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.rolePermissionAttributeSetsM(request);
        }
        return response;
    }

    @POST
    @Path(value="/ssdRoleSets/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse ssdRoleSets(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.ssdRoleSetsM(request);
        }
        return response;
    }

    @POST
    @Path(value="/ssdRead/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse ssdRoleSet(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.ssdRoleSetM(request);
        }
        return response;
    }

    @POST
    @Path(value="/ssdRoles/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse ssdRoleSetRoles(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.ssdRoleSetRolesM(request);
        }
        return response;
    }

    @POST
    @Path(value="/ssdCard/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse ssdRoleSetCardinality(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.ssdRoleSetCardinalityM(request);
        }
        return response;
    }

    @POST
    @Path(value="/ssdSets/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse ssdSets(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.ssdSetsM(request);
        }
        return response;
    }

    @POST
    @Path(value="/dsdRoleSets/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse dsdRoleSets(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.dsdRoleSetsM(request);
        }
        return response;
    }

    @POST
    @Path(value="/dsdRead/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse dsdRoleSet(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.dsdRoleSetM(request);
        }
        return response;
    }

    @POST
    @Path(value="/dsdRoles/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse dsdRoleSetRoles(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.dsdRoleSetRolesM(request);
        }
        return response;
    }

    @POST
    @Path(value="/dsdCard/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse dsdRoleSetCardinality(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.dsdRoleSetCardinalityM(request);
        }
        return response;
    }

    @POST
    @Path(value="/dsdSets/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse dsdSets(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.reviewMgrImpl.dsdSetsM(request);
        }
        return response;
    }

    @POST
    @Path(value="/rbacAuthN/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-access-user"})
    public FortResponse authenticate(FortRequest request) {
        return this.accessMgrImpl.authenticate(request);
    }

    @POST
    @Path(value="/rbacCreate/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-access-user"})
    public FortResponse createSession(FortRequest request) {
        return this.accessMgrImpl.createSession(request);
    }

    @POST
    @Path(value="/rbacCreateT/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-access-user"})
    public FortResponse createSessionTrusted(FortRequest request) {
        return this.accessMgrImpl.createSessionTrusted(request);
    }

    @POST
    @Path(value="/rbacCreateGroup/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-access-user"})
    public FortResponse createGroupSession(FortRequest request) {
        return this.accessMgrImpl.createGroupSession(request);
    }

    @POST
    @Path(value="/rbacAuthZ/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-access-user"})
    public FortResponse checkAccess(FortRequest request) {
        return this.accessMgrImpl.checkAccess(request);
    }

    @POST
    @Path(value="/rbacCheck/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-access-user"})
    public FortResponse createSessionCheckAccess(FortRequest request) {
        return this.accessMgrImpl.createSessionCheckAccess(request);
    }

    @POST
    @Path(value="/rbacCheckRole/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-access-user"})
    public FortResponse isUserInRole(FortRequest request) {
        return this.accessMgrImpl.isUserInRole(request);
    }

    @POST
    @Path(value="/rbacPerms/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-access-user"})
    public FortResponse sessionPermissions(FortRequest request) {
        return this.accessMgrImpl.sessionPermissions(request);
    }

    @POST
    @Path(value="/rbacRoles/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-access-user"})
    public FortResponse sessionRoles(FortRequest request) {
        return this.accessMgrImpl.sessionRoles(request);
    }

    @POST
    @Path(value="/rbacAuthzRoles/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-access-user"})
    public FortResponse authorizedSessionRoles(FortRequest request) {
        return this.accessMgrImpl.authorizedSessionRoles(request);
    }

    @POST
    @Path(value="/rbacAdd/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-access-user"})
    public FortResponse addActiveRole(FortRequest request) {
        return this.accessMgrImpl.addActiveRole(request);
    }

    @POST
    @Path(value="/rbacDrop/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-access-user"})
    public FortResponse dropActiveRole(FortRequest request) {
        return this.accessMgrImpl.dropActiveRole(request);
    }

    @POST
    @Path(value="/rbacUserId/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-access-user"})
    public FortResponse getUserId(FortRequest request) {
        return this.accessMgrImpl.getUserId(request);
    }

    @POST
    @Path(value="/rbacUser/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-access-user"})
    public FortResponse getUser(FortRequest request) {
        return this.accessMgrImpl.getUser(request);
    }

    @POST
    @Path(value="/arleAdd/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-deladmin-user"})
    public FortResponse addAdminRole(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.delegatedAdminMgrImpl.addAdminRole(request);
        }
        return response;
    }

    @POST
    @Path(value="/arleDelete/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-deladmin-user"})
    public FortResponse deleteAdminRole(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.delegatedAdminMgrImpl.deleteAdminRole(request);
        }
        return response;
    }

    @POST
    @Path(value="/arleUpdate/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-deladmin-user"})
    public FortResponse updateAdminRole(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.delegatedAdminMgrImpl.updateAdminRole(request);
        }
        return response;
    }

    @POST
    @Path(value="/arleAsgn/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-deladmin-user"})
    public FortResponse assignAdminUser(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.delegatedAdminMgrImpl.assignAdminUser(request);
        }
        return response;
    }

    @POST
    @Path(value="/arleDeasgn/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-deladmin-user"})
    public FortResponse deassignAdminUser(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.delegatedAdminMgrImpl.deassignAdminUser(request);
        }
        return response;
    }

    @POST
    @Path(value="/arleDescendant/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-deladmin-user"})
    public FortResponse addAdminDescendant(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.delegatedAdminMgrImpl.addAdminDescendant(request);
        }
        return response;
    }

    @POST
    @Path(value="/arleAscendent/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-deladmin-user"})
    public FortResponse addAdminAscendant(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.delegatedAdminMgrImpl.addAdminAscendant(request);
        }
        return response;
    }

    @POST
    @Path(value="/arleAddinherit/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-deladmin-user"})
    public FortResponse addAdminInheritance(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.delegatedAdminMgrImpl.addAdminInheritance(request);
        }
        return response;
    }

    @POST
    @Path(value="/arleDelinherit/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-deladmin-user"})
    public FortResponse deleteAdminInheritance(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.delegatedAdminMgrImpl.deleteAdminInheritance(request);
        }
        return response;
    }

    @POST
    @Path(value="/orgAdd/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-deladmin-user"})
    public FortResponse addOrg(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.delegatedAdminMgrImpl.addOrg(request);
        }
        return response;
    }

    @POST
    @Path(value="/orgUpdate/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-deladmin-user"})
    public FortResponse updateOrg(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.delegatedAdminMgrImpl.updateOrg(request);
        }
        return response;
    }

    @POST
    @Path(value="/orgDelete/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-deladmin-user"})
    public FortResponse deleteOrg(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.delegatedAdminMgrImpl.deleteOrg(request);
        }
        return response;
    }

    @POST
    @Path(value="/orgDescendant/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-deladmin-user"})
    public FortResponse addOrgDescendant(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.delegatedAdminMgrImpl.addOrgDescendant(request);
        }
        return response;
    }

    @POST
    @Path(value="/orgAscendent/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-deladmin-user"})
    public FortResponse addOrgAscendant(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.delegatedAdminMgrImpl.addOrgAscendant(request);
        }
        return response;
    }

    @POST
    @Path(value="/orgAddinherit/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-deladmin-user"})
    public FortResponse addOrgInheritance(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.delegatedAdminMgrImpl.addOrgInheritance(request);
        }
        return response;
    }

    @POST
    @Path(value="/orgDelinherit/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-deladmin-user"})
    public FortResponse deleteOrgInheritance(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.delegatedAdminMgrImpl.deleteOrgInheritance(request);
        }
        return response;
    }

    @POST
    @Path(value="/arleRead/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-delreview-user"})
    public FortResponse readAdminRole(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.delegatedReviewMgrImpl.readAdminRole(request);
        }
        return response;
    }

    @POST
    @Path(value="/arleSearch/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-delreview-user"})
    public FortResponse findAdminRoles(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.delegatedReviewMgrImpl.findAdminRoles(request);
        }
        return response;
    }

    @POST
    @Path(value="/arleAsigned/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-delreview-user"})
    public FortResponse assignedAdminRoles(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.delegatedReviewMgrImpl.assignedAdminRoles(request);
        }
        return response;
    }

    @POST
    @Path(value="/userAsignedAdmin/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-delreview-user"})
    public FortResponse assignedAdminUsers(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.delegatedReviewMgrImpl.assignedAdminUsers(request);
        }
        return response;
    }

    @POST
    @Path(value="/orgRead/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-delreview-user"})
    public FortResponse readOrg(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.delegatedReviewMgrImpl.readOrg(request);
        }
        return response;
    }

    @POST
    @Path(value="/orgSearch/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-delreview-user"})
    public FortResponse searchOrg(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.delegatedReviewMgrImpl.searchOrg(request);
        }
        return response;
    }

    @POST
    @Path(value="/adminAssign/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-delaccess-user"})
    public FortResponse canAssign(FortRequest request) {
        return this.delegatedAccessMgrImpl.canAssign(request);
    }

    @POST
    @Path(value="/adminDeassign/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-delaccess-user"})
    public FortResponse canDeassign(FortRequest request) {
        return this.delegatedAccessMgrImpl.canDeassign(request);
    }

    @POST
    @Path(value="/adminGrant/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-delaccess-user"})
    public FortResponse canGrant(FortRequest request) {
        return this.delegatedAccessMgrImpl.canGrant(request);
    }

    @POST
    @Path(value="/adminRevoke/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-delaccess-user"})
    public FortResponse canRevoke(FortRequest request) {
        return this.delegatedAccessMgrImpl.canRevoke(request);
    }

    @POST
    @Path(value="/adminAuthZ/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-delaccess-user"})
    public FortResponse checkAdminAccess(FortRequest request) {
        return this.delegatedAccessMgrImpl.checkAdminAccess(request);
    }

    @POST
    @Path(value="/adminAdd/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-delaccess-user"})
    public FortResponse addActiveAdminRole(FortRequest request) {
        return this.delegatedAccessMgrImpl.addActiveAdminRole(request);
    }

    @POST
    @Path(value="/adminDrop/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-delaccess-user"})
    public FortResponse dropActiveAdminRole(FortRequest request) {
        return this.delegatedAccessMgrImpl.dropActiveAdminRole(request);
    }

    @POST
    @Path(value="/adminRoles/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-delaccess-user"})
    public FortResponse sessionAdminRoles(FortRequest request) {
        return this.delegatedAccessMgrImpl.sessionAdminRoles(request);
    }

    @POST
    @Path(value="/adminPerms/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-delaccess-user"})
    public FortResponse sessionAdminPermissions(FortRequest request) {
        return this.delegatedAccessMgrImpl.sessionAdminPermissions(request);
    }

    @POST
    @Path(value="/adminAuthzRoles/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-delaccess-user"})
    public FortResponse authorizedSessionAdminRoles(FortRequest request) {
        return this.delegatedAccessMgrImpl.authorizedSessionRoles(request);
    }

    @POST
    @Path(value="/pswdAdd/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-pwmgr-user"})
    public FortResponse addPolicy(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.pswdPolicyMgrImpl.addPolicy(request);
        }
        return response;
    }

    @POST
    @Path(value="/pswdUpdate/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-pwmgr-user"})
    public FortResponse updatePolicy(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.pswdPolicyMgrImpl.updatePolicy(request);
        }
        return response;
    }

    @POST
    @Path(value="/pswdDelete/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-pwmgr-user"})
    public FortResponse deletePolicy(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.pswdPolicyMgrImpl.deletePolicy(request);
        }
        return response;
    }

    @POST
    @Path(value="/pswdRead/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-pwmgr-user"})
    public FortResponse readPolicy(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.pswdPolicyMgrImpl.readPolicy(request);
        }
        return response;
    }

    @POST
    @Path(value="/pswdSearch/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-pwmgr-user"})
    public FortResponse searchPolicy(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.pswdPolicyMgrImpl.searchPolicy(request);
        }
        return response;
    }

    @POST
    @Path(value="/pswdUserAdd/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-pwmgr-user"})
    public FortResponse updateUserPolicy(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.pswdPolicyMgrImpl.updateUserPolicy(request);
        }
        return response;
    }

    @POST
    @Path(value="/pswdUserDelete/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-pwmgr-user"})
    public FortResponse deleteUserPolicy(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.pswdPolicyMgrImpl.deleteUserPolicy(request);
        }
        return response;
    }

    @POST
    @Path(value="/auditBinds/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-audit-user"})
    public FortResponse searchBinds(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.auditMgrImpl.searchBinds(request);
        }
        return response;
    }

    @POST
    @Path(value="/auditUserAuthzs/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-audit-user"})
    public FortResponse getUserAuthZs(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.auditMgrImpl.getUserAuthZs(request);
        }
        return response;
    }

    @POST
    @Path(value="/auditAuthzs/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-audit-user"})
    public FortResponse searchAuthZs(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.auditMgrImpl.searchAuthZs(request);
        }
        return response;
    }

    @POST
    @Path(value="/auditSessions/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-audit-user"})
    public FortResponse searchUserSessions(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.auditMgrImpl.searchUserSessions(request);
        }
        return response;
    }

    @POST
    @Path(value="/auditMods/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-audit-user"})
    public FortResponse searchAdminMods(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.auditMgrImpl.searchAdminMods(request);
        }
        return response;
    }

    @POST
    @Path(value="/auditInvld/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-audit-user"})
    public FortResponse searchInvalidUsers(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.auditMgrImpl.searchInvalidUsers(request);
        }
        return response;
    }

    @POST
    @Path(value="/cfgAdd/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-config-user"})
    public FortResponse addConfig(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.configMgrImpl.addConfig(request);
        }
        return response;
    }

    @POST
    @Path(value="/cfgUpdate/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-config-user"})
    public FortResponse updateConfig(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.configMgrImpl.updateConfig(request);
        }
        return response;
    }

    @POST
    @Path(value="/cfgDelete/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-config-user"})
    public FortResponse deleteConfig(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.configMgrImpl.deleteConfig(request);
        }
        return response;
    }

    @POST
    @Path(value="/cfgRead/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-config-user"})
    public FortResponse readConfig(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.configMgrImpl.readConfig(request);
        }
        return response;
    }

    @POST
    @Path(value="/groupRead/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse readGroup(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.groupMgrImpl.readGroup(request);
        }
        return response;
    }

    @POST
    @Path(value="/groupAdd/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse addGroup(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.groupMgrImpl.addGroup(request);
        }
        return response;
    }

    @POST
    @Path(value="/groupDelete/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse deleteGroup(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.groupMgrImpl.deleteGroup(request);
        }
        return response;
    }

    @POST
    @Path(value="/groupUpdate/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-admin-user"})
    public FortResponse updateGroup(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.groupMgrImpl.updateGroup(request);
        }
        return response;
    }

    @POST
    @Path(value="/roleGroupAsigned/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse assignedGroupRoles(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.groupMgrImpl.assignedRoles(request);
        }
        return response;
    }

    @POST
    @Path(value="/groupAsigned/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse assignedGroups(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.groupMgrImpl.assignedGroups(request);
        }
        return response;
    }

    @POST
    @Path(value="/groupAsgn/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse assignGroup(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.groupMgrImpl.assignGroup(request);
        }
        return response;
    }

    @POST
    @Path(value="/groupDeasgn/")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-review-user"})
    public FortResponse deassignGroup(FortRequest request) {
        FortResponse response = SecUtils.initializeSession((FortRequest)request, (HttpServletRequest)this.httpRequest);
        if (response == null) {
            response = this.groupMgrImpl.deassignGroup(request);
        }
        return response;
    }

    @POST
    @Path(value="/{any : .*}")
    @RolesAllowed(value={"fortress-rest-super-user", "fortress-rest-access-user", "fortress-rest-admin-user", "fortress-rest-review-user", "fortress-rest-delaccess-user", "fortress-rest-deladmin-user", "fortress-rest-delreview-user", "fortress-rest-pwmgr-user", "fortress-rest-audit-user", "fortress-rest-config-user"})
    public FortResponse invalid(FortRequest request) {
        String szError = "Could not find a matching service. HTTP request URI:" + this.httpRequest.getRequestURI() + ". User: " + this.httpRequest.getRemoteUser();
        LOG.warn(szError);
        FortResponse response = new FortResponse();
        response.setErrorCode(10106);
        response.setErrorMessage(szError);
        return response;
    }
}

