/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.ant;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.fortress.core.AdminMgr;
import org.apache.directory.fortress.core.AdminMgrFactory;
import org.apache.directory.fortress.core.CfgException;
import org.apache.directory.fortress.core.ConfigMgr;
import org.apache.directory.fortress.core.ConfigMgrFactory;
import org.apache.directory.fortress.core.DelAdminMgr;
import org.apache.directory.fortress.core.DelAdminMgrFactory;
import org.apache.directory.fortress.core.GroupMgr;
import org.apache.directory.fortress.core.GroupMgrFactory;
import org.apache.directory.fortress.core.PwPolicyMgr;
import org.apache.directory.fortress.core.PwPolicyMgrFactory;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.ant.Addadminrole;
import org.apache.directory.fortress.core.ant.Addadminroleinheritance;
import org.apache.directory.fortress.core.ant.Addconfig;
import org.apache.directory.fortress.core.ant.Addcontainer;
import org.apache.directory.fortress.core.ant.Addcontext;
import org.apache.directory.fortress.core.ant.Addgroup;
import org.apache.directory.fortress.core.ant.Addgroupmember;
import org.apache.directory.fortress.core.ant.Addgroupproperty;
import org.apache.directory.fortress.core.ant.Addorgunit;
import org.apache.directory.fortress.core.ant.AddpermGrant;
import org.apache.directory.fortress.core.ant.AddpermObj;
import org.apache.directory.fortress.core.ant.AddpermOp;
import org.apache.directory.fortress.core.ant.Addpermorgunitinheritance;
import org.apache.directory.fortress.core.ant.Addpwpolicy;
import org.apache.directory.fortress.core.ant.Addrole;
import org.apache.directory.fortress.core.ant.Addroleconstraint;
import org.apache.directory.fortress.core.ant.Addroleinheritance;
import org.apache.directory.fortress.core.ant.Addsdset;
import org.apache.directory.fortress.core.ant.Addsuffix;
import org.apache.directory.fortress.core.ant.Adduser;
import org.apache.directory.fortress.core.ant.Adduseradminrole;
import org.apache.directory.fortress.core.ant.Adduserorgunitinheritance;
import org.apache.directory.fortress.core.ant.Adduserrole;
import org.apache.directory.fortress.core.ant.AdminRoleAnt;
import org.apache.directory.fortress.core.ant.ConfigAnt;
import org.apache.directory.fortress.core.ant.Deladminrole;
import org.apache.directory.fortress.core.ant.Deladminroleinheritance;
import org.apache.directory.fortress.core.ant.Delconfig;
import org.apache.directory.fortress.core.ant.Delcontainer;
import org.apache.directory.fortress.core.ant.Delgroup;
import org.apache.directory.fortress.core.ant.Delgroupmember;
import org.apache.directory.fortress.core.ant.Delgroupproperty;
import org.apache.directory.fortress.core.ant.Delorgunit;
import org.apache.directory.fortress.core.ant.DelpermGrant;
import org.apache.directory.fortress.core.ant.DelpermObj;
import org.apache.directory.fortress.core.ant.DelpermOp;
import org.apache.directory.fortress.core.ant.Delpermorgunitinheritance;
import org.apache.directory.fortress.core.ant.Delpwpolicy;
import org.apache.directory.fortress.core.ant.Delrole;
import org.apache.directory.fortress.core.ant.Delroleconstraint;
import org.apache.directory.fortress.core.ant.Delroleinheritance;
import org.apache.directory.fortress.core.ant.Delsdset;
import org.apache.directory.fortress.core.ant.Delsuffix;
import org.apache.directory.fortress.core.ant.Deluser;
import org.apache.directory.fortress.core.ant.Deluseradminrole;
import org.apache.directory.fortress.core.ant.Deluserorgunitinheritance;
import org.apache.directory.fortress.core.ant.Deluserrole;
import org.apache.directory.fortress.core.ant.OrgUnitAnt;
import org.apache.directory.fortress.core.ant.PermAnt;
import org.apache.directory.fortress.core.ant.RoleConstraintAnt;
import org.apache.directory.fortress.core.ant.SDSetAnt;
import org.apache.directory.fortress.core.ant.Updconfig;
import org.apache.directory.fortress.core.ant.UserAnt;
import org.apache.directory.fortress.core.impl.OrganizationalUnitP;
import org.apache.directory.fortress.core.impl.SuffixP;
import org.apache.directory.fortress.core.model.AdminRole;
import org.apache.directory.fortress.core.model.Configuration;
import org.apache.directory.fortress.core.model.Context;
import org.apache.directory.fortress.core.model.Group;
import org.apache.directory.fortress.core.model.OrgUnit;
import org.apache.directory.fortress.core.model.OrganizationalUnit;
import org.apache.directory.fortress.core.model.PermGrant;
import org.apache.directory.fortress.core.model.PermObj;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.PwPolicy;
import org.apache.directory.fortress.core.model.Relationship;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.RoleConstraint;
import org.apache.directory.fortress.core.model.SDSet;
import org.apache.directory.fortress.core.model.Suffix;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.model.UserAdminRole;
import org.apache.directory.fortress.core.model.UserRole;
import org.apache.directory.fortress.core.util.ClassUtil;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.PropUtil;
import org.apache.directory.fortress.core.util.Testable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.input.InputRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FortressAntTask
extends Task
implements InputHandler {
    public static final boolean DEBUG = System.getProperty("debug.admin") != null && System.getProperty("debug.admin").equalsIgnoreCase("true");
    private static final String SEMICOLON = ";";
    private final List<Addconfig> addconfig = new ArrayList<Addconfig>();
    private final List<Updconfig> updconfig = new ArrayList<Updconfig>();
    private final List<Delconfig> delconfig = new ArrayList<Delconfig>();
    private final List<Adduser> addusers = new ArrayList<Adduser>();
    private final List<Deluser> delusers = new ArrayList<Deluser>();
    private final List<Adduserrole> adduserroles = new ArrayList<Adduserrole>();
    private final List<Deluserrole> deluserroles = new ArrayList<Deluserrole>();
    private final List<Addrole> addroles = new ArrayList<Addrole>();
    private final List<Delrole> delroles = new ArrayList<Delrole>();
    private final List<Addsdset> addsdsets = new ArrayList<Addsdset>();
    private final List<Addroleinheritance> addroleinheritances = new ArrayList<Addroleinheritance>();
    private final List<Delroleinheritance> delroleinheritances = new ArrayList<Delroleinheritance>();
    private final List<Delsdset> delsdsets = new ArrayList<Delsdset>();
    private final List<AddpermOp> addpermOps = new ArrayList<AddpermOp>();
    private final List<DelpermOp> delpermOps = new ArrayList<DelpermOp>();
    private final List<AddpermObj> addpermObjs = new ArrayList<AddpermObj>();
    private final List<DelpermObj> delpermObjs = new ArrayList<DelpermObj>();
    private final List<AddpermGrant> addpermGrants = new ArrayList<AddpermGrant>();
    private final List<DelpermGrant> delpermGrants = new ArrayList<DelpermGrant>();
    private final List<Addpwpolicy> addpolicies = new ArrayList<Addpwpolicy>();
    private final List<Delpwpolicy> delpolicies = new ArrayList<Delpwpolicy>();
    private final List<Addcontainer> addcontainers = new ArrayList<Addcontainer>();
    private final List<Delcontainer> delcontainers = new ArrayList<Delcontainer>();
    private final List<Addsuffix> addsuffixes = new ArrayList<Addsuffix>();
    private final List<Delsuffix> delsuffixes = new ArrayList<Delsuffix>();
    private final List<Addorgunit> addorgunits = new ArrayList<Addorgunit>();
    private final List<Delorgunit> delorgunits = new ArrayList<Delorgunit>();
    private final List<Adduserorgunitinheritance> adduserorgunitinheritances = new ArrayList<Adduserorgunitinheritance>();
    private final List<Deluserorgunitinheritance> deluserorgunitinheritances = new ArrayList<Deluserorgunitinheritance>();
    private final List<Addpermorgunitinheritance> addpermorgunitinheritances = new ArrayList<Addpermorgunitinheritance>();
    private final List<Delpermorgunitinheritance> delpermorgunitinheritances = new ArrayList<Delpermorgunitinheritance>();
    private final List<Addadminrole> addadminroles = new ArrayList<Addadminrole>();
    private final List<Deladminrole> deladminroles = new ArrayList<Deladminrole>();
    private final List<Adduseradminrole> adduseradminroles = new ArrayList<Adduseradminrole>();
    private final List<Addadminroleinheritance> addadminroleinheritances = new ArrayList<Addadminroleinheritance>();
    private final List<Deladminroleinheritance> deladminroleinheritances = new ArrayList<Deladminroleinheritance>();
    private final List<Deluseradminrole> deluseradminroles = new ArrayList<Deluseradminrole>();
    private final List<Addcontext> addcontexts = new ArrayList<Addcontext>();
    private final List<Addgroup> addgroups = new ArrayList<Addgroup>();
    private final List<Delgroup> delgroups = new ArrayList<Delgroup>();
    private final List<Addgroupmember> addgroupmembers = new ArrayList<Addgroupmember>();
    private final List<Delgroupmember> delgroupmembers = new ArrayList<Delgroupmember>();
    private final List<Addgroupproperty> addgroupproperties = new ArrayList<Addgroupproperty>();
    private final List<Delgroupproperty> delgroupproperties = new ArrayList<Delgroupproperty>();
    private final List<Addroleconstraint> addroleconstraints = new ArrayList<Addroleconstraint>();
    private final List<Delroleconstraint> delroleconstraints = new ArrayList<Delroleconstraint>();
    private ConfigMgr cfgMgr = null;
    private AdminMgr adminMgr = null;
    private DelAdminMgr dAdminMgr = null;
    private PwPolicyMgr policyMgr = null;
    private GroupMgr groupMgr = null;
    private static final String CLS_NM = FortressAntTask.class.getName();
    protected static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);
    private Context context;
    private static final String TENANT = System.getProperty("tenant");
    private String tenant;

    public String getTenant() {
        return this.tenant;
    }

    public void addAddcontext(Addcontext addcontext) {
        this.addcontexts.add(addcontext);
    }

    public void setContext(Context context) {
        System.out.println(CLS_NM + ".setContext name: " + context.getName());
        this.context = context;
        try {
            this.adminMgr = AdminMgrFactory.createInstance(context.getName());
            this.dAdminMgr = DelAdminMgrFactory.createInstance(context.getName());
            this.policyMgr = PwPolicyMgrFactory.createInstance(context.getName());
            this.groupMgr = GroupMgrFactory.createInstance(context.getName());
        }
        catch (SecurityException se) {
            LOG.warn(" FortressAntTask setContext caught SecurityException={}", (Throwable)se);
        }
    }

    public FortressAntTask() {
        try {
            if (StringUtils.isEmpty((CharSequence)TENANT) || TENANT.equals("${tenant}")) {
                this.tenant = "HOME";
            } else {
                this.tenant = TENANT;
                LOG.info("FortressAntTask constructor using tenant={}", (Object)this.tenant);
            }
            this.cfgMgr = ConfigMgrFactory.createInstance();
            this.adminMgr = AdminMgrFactory.createInstance(this.tenant);
            this.dAdminMgr = DelAdminMgrFactory.createInstance(this.tenant);
            this.policyMgr = PwPolicyMgrFactory.createInstance(this.tenant);
            this.groupMgr = GroupMgrFactory.createInstance(this.tenant);
        }
        catch (SecurityException se) {
            LOG.warn(" FortressAntTask constructor tenant={}, caught SecurityException={}", (Object)this.tenant, (Object)se);
        }
    }

    public void handleInput(InputRequest request) {
        LOG.info("handleInput request={}", (Object)request);
    }

    public void addAddconfig(Addconfig addcfg) {
        this.addconfig.add(addcfg);
    }

    public void addUpdconfig(Updconfig updcfg) {
        this.updconfig.add(updcfg);
    }

    public void addDelconfig(Delconfig delcfg) {
        this.delconfig.add(delcfg);
    }

    public void addAdduser(Adduser adduser) {
        this.addusers.add(adduser);
    }

    public void addDeluser(Deluser deluser) {
        this.delusers.add(deluser);
    }

    public void addAdduserrole(Adduserrole adduserrole) {
        this.adduserroles.add(adduserrole);
    }

    public void addDeluserrole(Deluserrole deluserrole) {
        this.deluserroles.add(deluserrole);
    }

    public void addAddrole(Addrole addrole) {
        this.addroles.add(addrole);
    }

    public void addDelrole(Delrole delrole) {
        this.delroles.add(delrole);
    }

    public void addAddroleinheritance(Addroleinheritance addroleinheritance) {
        this.addroleinheritances.add(addroleinheritance);
    }

    public void addDelroleinheritance(Delroleinheritance delroleinheritance) {
        this.delroleinheritances.add(delroleinheritance);
    }

    public void addAddsdset(Addsdset addsd) {
        this.addsdsets.add(addsd);
    }

    public void addDelsdset(Delsdset delsd) {
        this.delsdsets.add(delsd);
    }

    public void addAddpermOp(AddpermOp addpermOp) {
        this.addpermOps.add(addpermOp);
    }

    public void addDelpermOp(DelpermOp delpermOp) {
        this.delpermOps.add(delpermOp);
    }

    public void addAddpermObj(AddpermObj addpermObj) {
        this.addpermObjs.add(addpermObj);
    }

    public void addDelpermObj(DelpermObj delpermObj) {
        this.delpermObjs.add(delpermObj);
    }

    public void addAddpermGrant(AddpermGrant addpermGrant) {
        this.addpermGrants.add(addpermGrant);
    }

    public void addDelpermGrant(DelpermGrant delpermGrant) {
        this.delpermGrants.add(delpermGrant);
    }

    public void addAddpwpolicy(Addpwpolicy addpwpolicy) {
        this.addpolicies.add(addpwpolicy);
    }

    public void addDelpwpolicy(Delpwpolicy delpwpolicy) {
        this.delpolicies.add(delpwpolicy);
    }

    public void addAddcontainer(Addcontainer addcontainer) {
        this.addcontainers.add(addcontainer);
    }

    public void addDelcontainer(Delcontainer delcontainer) {
        this.delcontainers.add(delcontainer);
    }

    public void addAddsuffix(Addsuffix addsuffix) {
        this.addsuffixes.add(addsuffix);
    }

    public void addDelsuffix(Delsuffix delsuffix) {
        this.delsuffixes.add(delsuffix);
    }

    public void addAddorgunit(Addorgunit addorgunit) {
        this.addorgunits.add(addorgunit);
    }

    public void addDelorgunit(Delorgunit delorgunit) {
        this.delorgunits.add(delorgunit);
    }

    public void addAdduserorgunitinheritance(Adduserorgunitinheritance addinheritance) {
        this.adduserorgunitinheritances.add(addinheritance);
    }

    public void addDeluserorgunitinheritance(Deluserorgunitinheritance delinheritance) {
        this.deluserorgunitinheritances.add(delinheritance);
    }

    public void addAddpermorgunitinheritance(Addpermorgunitinheritance addinheritance) {
        this.addpermorgunitinheritances.add(addinheritance);
    }

    public void addDelpermorgunitinheritance(Delpermorgunitinheritance delinheritance) {
        this.delpermorgunitinheritances.add(delinheritance);
    }

    public void addAddadminrole(Addadminrole addrole) {
        this.addadminroles.add(addrole);
    }

    public void addDeladminrole(Deladminrole delrole) {
        this.deladminroles.add(delrole);
    }

    public void addAddadminroleinheritance(Addadminroleinheritance addadminroleinheritance) {
        this.addadminroleinheritances.add(addadminroleinheritance);
    }

    public void addDeladminroleinheritance(Deladminroleinheritance deladminroleinheritance) {
        this.deladminroleinheritances.add(deladminroleinheritance);
    }

    public void addAdduseradminrole(Adduseradminrole adduserrole) {
        this.adduseradminroles.add(adduserrole);
    }

    public void addDeluseradminrole(Deluseradminrole deluserrole) {
        this.deluseradminroles.add(deluserrole);
    }

    public void addAddgroup(Addgroup addgroup) {
        this.addgroups.add(addgroup);
    }

    public void addDelgroup(Delgroup delgroup) {
        this.delgroups.add(delgroup);
    }

    public void addAddgroupmember(Addgroupmember addgroupmember) {
        this.addgroupmembers.add(addgroupmember);
    }

    public void addDelgroupmember(Delgroupmember delgroupmember) {
        this.delgroupmembers.add(delgroupmember);
    }

    public void addAddgroupproperty(Addgroupproperty addgroupproperty) {
        this.addgroupproperties.add(addgroupproperty);
    }

    public void addDelgroupproperty(Delgroupproperty delgroupproperty) {
        this.delgroupproperties.add(delgroupproperty);
    }

    public void addAddroleconstraint(Addroleconstraint addroleconstraint) {
        this.addroleconstraints.add(addroleconstraint);
    }

    public void addDelroleconstraint(Delroleconstraint delroleconstraint) {
        this.delroleconstraints.add(delroleconstraint);
    }

    private boolean isListNotNull(List<?> list) {
        return list != null && list.size() > 0;
    }

    public void execute() throws BuildException {
        LOG.info("FORTRESS ANT TASK NAME : {}", (Object)this.getTaskName());
        if (this.isListNotNull(this.addcontexts)) {
            this.setContext(this.addcontexts.get(0).getContexts().get(0));
        }
        this.delRoleConstraints();
        this.delUserRoles();
        this.delUserAdminRoles();
        this.deletePermGrants();
        this.deleteGroupProperties();
        this.deleteGroupMembers();
        this.deleteGroups();
        this.deleteUsers();
        this.deletePolicies();
        this.deletePermOps();
        this.deletePermObjs();
        this.deleteSdsets();
        this.deleteRoleInheritances();
        this.deleteRoles();
        this.deleteAdminRoleInheritances();
        this.deleteAdminRoles();
        this.deleteUserOrgunitInheritances();
        this.deletePermOrgunitInheritances();
        this.delOrgunits();
        this.deleteConfig();
        this.deleteContainers();
        this.deleteSuffixes();
        this.addSuffixes();
        this.addContainers();
        this.addConfig();
        this.updConfig();
        this.addOrgunits();
        this.addUserOrgunitInheritances();
        this.addPermOrgunitInheritances();
        this.addAdminRoles();
        this.addAdminRoleInheritances();
        this.addRoles();
        this.addRoleInheritances();
        this.addSdsets();
        this.addPermObjs();
        this.addPermOps();
        this.addPolicies();
        this.addUsers();
        this.addGroups();
        this.addGroupMembers();
        this.addGroupProperties();
        this.addPermGrants();
        this.addUserAdminRoles();
        this.addUserRoles();
        this.addRoleConstraints();
        this.testResults();
        System.exit(0);
    }

    private void testResults() throws BuildException {
        if (DEBUG) {
            LOG.info("DEBUG MODE");
            try {
                String testClassName = Config.getInstance().getProperty(this.getTaskName());
                if (StringUtils.isEmpty((CharSequence)testClassName)) {
                    testClassName = "org.apache.directory.fortress.core.impl.FortressAntLoadTest";
                }
                Testable tester = (Testable)ClassUtil.createInstance(testClassName);
                tester.execute(this);
            }
            catch (CfgException ce) {
                String error = "Error executing tests, errCode=" + ce.getErrorId() + " msg=" + ce;
                LOG.warn(error);
            }
        }
    }

    private void addUsers() throws BuildException {
        if (this.addusers == null) {
            return;
        }
        for (Adduser adduser : this.addusers) {
            List<UserAnt> users = adduser.getUsers();
            for (UserAnt user : users) {
                LOG.info("addUsers tenant={} userid={} description={} orgUnit={}", new Object[]{this.getTenant(), user.getUserId(), user.getDescription(), user.getOu()});
                try {
                    this.addUser(user);
                }
                catch (SecurityException se) {
                    LOG.warn("addUsers userId [{}] caught SecurityException={}", (Object)user.getUserId(), (Object)se);
                }
            }
        }
    }

    private void addUser(User user) throws SecurityException {
        try {
            this.adminMgr.addUser(user);
            this.assignUser(user);
        }
        catch (SecurityException se) {
            if (se.getErrorId() == 1007) {
                this.adminMgr.updateUser(user);
                this.assignUser(user);
                LOG.info("addUsers tenant={} Update entity - userId={}", (Object)this.getTenant(), (Object)user.getUserId());
            }
            throw se;
        }
    }

    private void assignUser(User user) throws SecurityException {
        if (CollectionUtils.isNotEmpty(user.getRoles())) {
            for (UserRole uRole : user.getRoles()) {
                this.adminMgr.assignUser(uRole);
            }
        }
        if (CollectionUtils.isNotEmpty(user.getAdminRoles())) {
            for (UserAdminRole uAdminRoleRole : user.getAdminRoles()) {
                this.dAdminMgr.assignUser(uAdminRoleRole);
            }
        }
    }

    private void deleteUsers() throws BuildException {
        if (this.delusers == null) {
            return;
        }
        for (Deluser deluser : this.delusers) {
            List<UserAnt> users = deluser.getUsers();
            for (UserAnt user : users) {
                LOG.info("deleteUsers tenant={} userid={}", (Object)this.getTenant(), (Object)user.getUserId());
                try {
                    this.adminMgr.deleteUser(user);
                }
                catch (SecurityException se) {
                    LOG.warn("deleteUsers userId [{}] caught SecurityException={}", (Object)user.getUserId(), (Object)se);
                }
            }
        }
    }

    private void addGroups() throws BuildException {
        if (this.addgroups == null) {
            return;
        }
        for (Addgroup addgroup : this.addgroups) {
            List<Group> groups = addgroup.getGroups();
            for (Group group : groups) {
                LOG.info("addGroups tenant={} name={} description={}", new Object[]{this.getTenant(), group.getName(), group.getDescription()});
                try {
                    this.groupMgr.add(group);
                }
                catch (SecurityException se) {
                    LOG.warn("addGroups name [{}] caught SecurityException={}", (Object)group.getName(), (Object)se);
                }
            }
        }
    }

    private void deleteGroups() throws BuildException {
        if (this.delgroups == null) {
            return;
        }
        for (Delgroup delgroup : this.delgroups) {
            List<Group> groups = delgroup.getGroups();
            for (Group group : groups) {
                LOG.info("deleteGroups tenant={} name={}", (Object)this.getTenant(), (Object)group.getName());
                try {
                    this.groupMgr.delete(group);
                }
                catch (SecurityException se) {
                    LOG.warn("deleteGroups name [{}] caught SecurityException={}", (Object)group.getName(), (Object)se);
                }
            }
        }
    }

    private void addGroupMembers() throws BuildException {
        if (this.addgroupmembers == null) {
            return;
        }
        for (Addgroupmember addgroupmember : this.addgroupmembers) {
            List<Group> groups = addgroupmember.getGroups();
            for (Group group : groups) {
                List<String> members = group.getMembers();
                if (CollectionUtils.isNotEmpty(members)) {
                    for (String member : members) {
                        LOG.info("addGroupMembers tenant={} name={}, member={}", new Object[]{this.getTenant(), group.getName(), member});
                        try {
                            this.groupMgr.assign(group, member);
                        }
                        catch (SecurityException se) {
                            LOG.warn("addGroupMembers tenant={} name [{}], member [{}] caught SecurityException={}", new Object[]{this.getTenant(), group.getName(), member, se});
                        }
                    }
                    continue;
                }
                LOG.info("addGroupMembers name={}, no member found", (Object)group.getName());
            }
        }
    }

    private void deleteGroupMembers() throws BuildException {
        if (this.delgroupmembers == null) {
            return;
        }
        for (Delgroupmember delgroupmember : this.delgroupmembers) {
            List<Group> groups = delgroupmember.getGroups();
            for (Group group : groups) {
                if (CollectionUtils.isNotEmpty(group.getMembers())) {
                    for (String member : group.getMembers()) {
                        LOG.info("deleteGroupMembers tenant={} name={}, member={}", new Object[]{this.getTenant(), group.getName(), member});
                        try {
                            this.groupMgr.deassign(group, member);
                        }
                        catch (SecurityException se) {
                            LOG.warn("deleteGroupMembers tenant={} name [{}], member [{}] caught SecurityException={}", new Object[]{this.getTenant(), group.getName(), member, se});
                        }
                    }
                    continue;
                }
                LOG.info("deleteGroupMembers tenant={} name={}, no member found", (Object)this.getTenant(), (Object)group.getName());
            }
        }
    }

    private void addGroupProperties() {
        if (this.addgroupproperties == null) {
            return;
        }
        for (Addgroupproperty addgroupproperty : this.addgroupproperties) {
            List<Group> groups = addgroupproperty.getGroups();
            for (Group group : groups) {
                if (PropUtil.isNotEmpty(group.getProperties())) {
                    Enumeration<?> e = group.getProperties().propertyNames();
                    while (e.hasMoreElements()) {
                        String key = (String)e.nextElement();
                        String val = group.getProperties().getProperty(key);
                        try {
                            this.groupMgr.add(group, key, val);
                        }
                        catch (SecurityException se) {
                            LOG.warn("addGroupProperties tenant={} name [{}], key [{}], value [{}] caught SecurityException={}", new Object[]{this.getTenant(), group.getName(), key, val, se});
                        }
                    }
                    continue;
                }
                LOG.info("addGroupProperties tenant={} name={}, no properties found", (Object)this.getTenant(), (Object)group.getName());
            }
        }
    }

    private void deleteGroupProperties() throws BuildException {
        if (this.delgroupproperties == null) {
            return;
        }
        for (Delgroupproperty delgroupproperty : this.delgroupproperties) {
            List<Group> groups = delgroupproperty.getGroups();
            for (Group group : groups) {
                if (PropUtil.isNotEmpty(group.getProperties())) {
                    Enumeration<?> e = group.getProperties().propertyNames();
                    while (e.hasMoreElements()) {
                        String key = (String)e.nextElement();
                        String val = group.getProperties().getProperty(key);
                        try {
                            this.groupMgr.delete(group, key, val);
                        }
                        catch (SecurityException se) {
                            LOG.warn("deleteGroupProperties tenant={} name [{}], key [{}], value [{}] caught SecurityException={}", new Object[]{this.getTenant(), group.getName(), key, val, se});
                        }
                    }
                    continue;
                }
                LOG.info("deleteGroupProperties tenant={} name={}, no properties found", (Object)this.getTenant(), (Object)group.getName());
            }
        }
    }

    private void addUserRoles() throws BuildException {
        if (this.adduserroles == null) {
            return;
        }
        for (Adduserrole adduserrole : this.adduserroles) {
            List<UserRole> userroles = adduserrole.getUserRoles();
            for (UserRole userRole : userroles) {
                LOG.info("addUserRoles tenant={} userid={} role name={}", new Object[]{this.getTenant(), userRole.getUserId(), userRole.getName()});
                try {
                    this.adminMgr.assignUser(userRole);
                }
                catch (SecurityException se) {
                    LOG.warn("addUserRoles tenant={} userId={} roleName={} caught SecurityException={}", new Object[]{this.getTenant(), userRole.getUserId(), userRole.getName(), se});
                }
            }
        }
    }

    private void delUserRoles() throws BuildException {
        if (this.deluserroles == null) {
            return;
        }
        for (Deluserrole deluserrole : this.deluserroles) {
            List<UserRole> userroles = deluserrole.getUserRoles();
            for (UserRole userRole : userroles) {
                LOG.info("delUserRoles tenant={} userid={} role name={}", new Object[]{this.getTenant(), userRole.getUserId(), userRole.getName()});
                try {
                    this.adminMgr.deassignUser(userRole);
                }
                catch (SecurityException se) {
                    LOG.warn("delUserRoles tenant={} userId={} roleName={} caught SecurityException={}", new Object[]{this.getTenant(), userRole.getUserId(), userRole.getName(), se});
                }
            }
        }
    }

    private void addRoleConstraints() throws BuildException {
        if (this.addroleconstraints == null) {
            return;
        }
        for (Addroleconstraint addroleconstraint : this.addroleconstraints) {
            List<RoleConstraintAnt> roleconstraints = addroleconstraint.getRoleConstraints();
            for (RoleConstraintAnt roleConstraint : roleconstraints) {
                try {
                    if (StringUtils.isEmpty((CharSequence)roleConstraint.getUserId()) && roleConstraint.getType() == RoleConstraint.RCType.USER) {
                        this.adminMgr.enableRoleConstraint(new Role(roleConstraint.getRole()), roleConstraint);
                        LOG.info("enableRoleConstraint successfully enabled: tenant={} type={} role={} key={}", new Object[]{this.getTenant(), roleConstraint.getType(), roleConstraint.getRole(), roleConstraint.getKey()});
                        continue;
                    }
                    this.adminMgr.addRoleConstraint(new UserRole(roleConstraint.getUserId(), roleConstraint.getRole()), roleConstraint);
                    LOG.info("addRoleConstraint successfully added: tenant={} type={} userid={} role={} key={} value={}", new Object[]{this.getTenant(), roleConstraint.getType(), roleConstraint.getUserId(), roleConstraint.getRole(), roleConstraint.getKey(), roleConstraint.getValue()});
                }
                catch (SecurityException se) {
                    LOG.warn("addRoleConstraints tenant={} userId={} roleName={} caught SecurityException={}", new Object[]{this.getTenant(), roleConstraint.getUserId(), roleConstraint.getRole(), se});
                }
            }
        }
    }

    private void delRoleConstraints() throws BuildException {
        if (this.addroleconstraints == null) {
            return;
        }
        for (Delroleconstraint delroleconstraint : this.delroleconstraints) {
            List<RoleConstraintAnt> roleconstraints = delroleconstraint.getRoleConstraints();
            for (RoleConstraintAnt roleConstraint : roleconstraints) {
                try {
                    if (StringUtils.isEmpty((CharSequence)roleConstraint.getUserId()) && roleConstraint.getType() == RoleConstraint.RCType.USER) {
                        this.adminMgr.disableRoleConstraint(new Role(roleConstraint.getRole()), roleConstraint);
                        LOG.info("disableRoleConstraint successfully disabled: tenant={} type={} role={} key={}", new Object[]{this.getTenant(), roleConstraint.getType(), roleConstraint.getRole(), roleConstraint.getKey()});
                        continue;
                    }
                    this.adminMgr.removeRoleConstraint(new UserRole(roleConstraint.getUserId(), roleConstraint.getRole()), roleConstraint);
                    LOG.info("removeRoleConstraint success: tenant={} type={} userid={} role={} key={} value={}", new Object[]{this.getTenant(), roleConstraint.getType(), roleConstraint.getUserId(), roleConstraint.getRole(), roleConstraint.getKey(), roleConstraint.getValue()});
                }
                catch (SecurityException se) {
                    LOG.warn("delRoleConstraints tenant={} userId={} roleName={} caught SecurityException={}", new Object[]{this.getTenant(), roleConstraint.getUserId(), roleConstraint.getRole(), se});
                }
            }
        }
    }

    private void addRoles() throws BuildException {
        if (this.addroles == null) {
            return;
        }
        for (Addrole addrole : this.addroles) {
            List<Role> roles = addrole.getRoles();
            for (Role role : roles) {
                LOG.info("addRoles tenant={} name={} description={}", new Object[]{this.getTenant(), role.getName(), role.getDescription()});
                try {
                    this.adminMgr.addRole(role);
                }
                catch (SecurityException se) {
                    LOG.warn("addRoles tenant={} name [{}] caught SecurityException={}", new Object[]{this.getTenant(), role.getName(), se});
                }
            }
        }
    }

    private void deleteRoles() throws BuildException {
        if (this.delroles == null) {
            return;
        }
        for (Delrole delrole : this.delroles) {
            List<Role> roles = delrole.getRoles();
            for (Role role : roles) {
                LOG.info("deleteRoles tenant={} name={}", (Object)this.getTenant(), (Object)role.getName());
                try {
                    this.adminMgr.deleteRole(role);
                }
                catch (SecurityException se) {
                    LOG.warn("deleteRoles tenant={} name [{}] caught SecurityException={}", new Object[]{this.getTenant(), role.getName(), se});
                }
            }
        }
    }

    private void addRoleInheritances() throws BuildException {
        if (this.addroleinheritances == null) {
            return;
        }
        for (Addroleinheritance addroleinheritance : this.addroleinheritances) {
            List<Relationship> roles = addroleinheritance.getRelationships();
            for (Relationship relationship : roles) {
                LOG.info("addRoleInheritances tenant={} parent={} child={}", new Object[]{this.getTenant(), relationship.getParent(), relationship.getChild()});
                try {
                    this.adminMgr.addInheritance(new Role(relationship.getParent()), new Role(relationship.getChild()));
                }
                catch (SecurityException se) {
                    LOG.warn("addRoleInheritances tenant={} parent [{}] child [{}] caught SecurityException={}", new Object[]{this.getTenant(), relationship.getParent(), relationship.getChild(), se});
                }
            }
        }
    }

    private void deleteRoleInheritances() throws BuildException {
        if (this.delroleinheritances == null) {
            return;
        }
        for (Delroleinheritance delroleinheritance : this.delroleinheritances) {
            List<Relationship> roles = delroleinheritance.getRelationships();
            for (Relationship relationship : roles) {
                LOG.info("deleteRoleInheritances tenant={} parent={} child={}", new Object[]{this.getTenant(), relationship.getParent(), relationship.getChild()});
                try {
                    this.adminMgr.deleteInheritance(new Role(relationship.getParent()), new Role(relationship.getChild()));
                }
                catch (SecurityException se) {
                    LOG.warn("deleteRoleInheritances tenant={} parent [{}] child [{}] caught SecurityException={}", new Object[]{this.getTenant(), relationship.getParent(), relationship.getChild(), se});
                }
            }
        }
    }

    private void addSdsets() throws BuildException {
        if (this.addsdsets == null) {
            return;
        }
        for (Addsdset addsdset : this.addsdsets) {
            List<SDSetAnt> sds = addsdset.getSdset();
            for (SDSetAnt sd : sds) {
                LOG.info("addSdsets tenant={} name={} description={}", new Object[]{this.getTenant(), sd.getName(), sd.getDescription()});
                try {
                    if (sd.getType() == SDSet.SDType.STATIC) {
                        this.adminMgr.createSsdSet(sd);
                        continue;
                    }
                    this.adminMgr.createDsdSet(sd);
                }
                catch (SecurityException se) {
                    LOG.warn("addSdsets tenant={} name [{}] caught SecurityException={}", (Object)this.getTenant(), (Object)(sd.getName() + se));
                }
            }
        }
    }

    private void deleteSdsets() throws BuildException {
        if (this.delsdsets == null) {
            return;
        }
        for (Delsdset delsdset : this.delsdsets) {
            List<SDSetAnt> sds = delsdset.getSdset();
            for (SDSetAnt sd : sds) {
                LOG.info("deleteSdsets tenant={} name={}", (Object)this.getTenant(), (Object)sd.getName());
                try {
                    if (sd.getSetType().equals("STATIC")) {
                        sd.setType(SDSet.SDType.STATIC);
                    } else {
                        sd.setType(SDSet.SDType.DYNAMIC);
                    }
                    this.adminMgr.deleteSsdSet(sd);
                }
                catch (SecurityException se) {
                    LOG.warn("deleteSdsets tenant={} name [{}] caught SecurityException={}", new Object[]{this.getTenant(), sd.getName(), se});
                }
            }
        }
    }

    private void addPermObjs() throws BuildException {
        if (this.addpermObjs == null) {
            return;
        }
        for (AddpermObj addpermObj : this.addpermObjs) {
            List<PermObj> permObjs = addpermObj.getPermObjs();
            for (PermObj permObj : permObjs) {
                LOG.info("addPermObjs tenant={} objName={} description={} orgUnit={} type={}", new Object[]{this.getTenant(), permObj.getObjName(), permObj.getDescription(), permObj.getOu(), permObj.getType()});
                try {
                    try {
                        this.adminMgr.addPermObj(permObj);
                    }
                    catch (SecurityException se) {
                        if (se.getErrorId() == 3011) {
                            this.adminMgr.updatePermObj(permObj);
                            LOG.info("addPermObjs tenant={} update entity objName={} description={} orgUnit={} type={}", new Object[]{this.getTenant(), permObj.getObjName(), permObj.getDescription(), permObj.getOu(), permObj.getType()});
                            continue;
                        }
                        throw se;
                    }
                }
                catch (SecurityException se) {
                    LOG.warn("addPermObjs tenant={} objName [{}] caught SecurityException={}", new Object[]{this.getTenant(), permObj.getObjName(), se});
                }
            }
        }
    }

    private void deletePermObjs() throws BuildException {
        if (this.delpermObjs == null) {
            return;
        }
        for (DelpermObj delpermObj : this.delpermObjs) {
            List<PermObj> permObjs = delpermObj.getObjs();
            for (PermObj permObj : permObjs) {
                LOG.info("deletePermObjs tenant={} objName={} description={}", new Object[]{this.getTenant(), permObj.getObjName(), permObj.getDescription()});
                try {
                    this.adminMgr.deletePermObj(permObj);
                }
                catch (SecurityException se) {
                    LOG.warn("deletePermObjs tenant={} name [{}] caught SecurityException={}", new Object[]{this.getTenant(), permObj.getObjName(), se});
                }
            }
        }
    }

    private void addPermOps() throws BuildException {
        if (this.addpermOps == null) {
            return;
        }
        for (AddpermOp addpermOp : this.addpermOps) {
            List<PermAnt> permissions = addpermOp.getPermOps();
            for (PermAnt permission : permissions) {
                LOG.info("addPermOps tenant={} name={} objName={}", new Object[]{this.getTenant(), permission.getOpName(), permission.getObjName()});
                try {
                    try {
                        this.adminMgr.addPermission(permission);
                    }
                    catch (SecurityException se) {
                        if (se.getErrorId() == 3011) {
                            this.adminMgr.updatePermission(permission);
                            LOG.info("addPermOps tenant={} - update entity - name={} objName={}", new Object[]{this.getTenant(), permission.getOpName(), permission.getObjName()});
                            continue;
                        }
                        throw se;
                    }
                }
                catch (SecurityException se) {
                    LOG.warn("addPermOps tenant={} name [{}] objName [{}] caught SecurityException={}", new Object[]{this.getTenant(), permission.getOpName(), permission.getObjName(), se});
                }
            }
        }
    }

    private void deletePermOps() throws BuildException {
        if (this.delpermOps == null) {
            return;
        }
        for (DelpermOp delpermOp : this.delpermOps) {
            List<PermAnt> permissions = delpermOp.getPermOps();
            for (Permission permission : permissions) {
                LOG.info("deletePermOps tenant={} name={} objName={}", new Object[]{this.getTenant(), permission.getOpName(), permission.getObjName()});
                try {
                    this.adminMgr.deletePermission(permission);
                }
                catch (SecurityException se) {
                    LOG.warn("deletePermOps tenant={} name [{}] objName[{}] caught SecurityException={}", new Object[]{this.getTenant(), permission.getOpName(), permission.getObjName(), se});
                }
            }
        }
    }

    private void addPermGrants() throws BuildException {
        if (this.addpermGrants == null) {
            return;
        }
        for (AddpermGrant addpermGrant : this.addpermGrants) {
            List<PermGrant> permGrants = addpermGrant.getPermGrants();
            for (PermGrant permGrant : permGrants) {
                try {
                    Permission perm = new Permission(permGrant.getObjName(), permGrant.getOpName(), permGrant.isAdmin());
                    perm.setOpName(permGrant.getOpName());
                    perm.setObjId(permGrant.getObjId());
                    if (permGrant.getRoleNm() != null && permGrant.getRoleNm().length() > 0) {
                        LOG.info("addPermGrants tenant={} roleName={} objName={} opName={} objId={}", new Object[]{this.getTenant(), permGrant.getRoleNm(), permGrant.getObjName(), permGrant.getOpName(), permGrant.getObjId()});
                        this.adminMgr.grantPermission(perm, new Role(permGrant.getRoleNm()));
                        continue;
                    }
                    if (permGrant.getUserId() != null && permGrant.getUserId().length() > 0) {
                        LOG.info("addPermGrants tenant={} userId={} objName={} opName={} objId={}", new Object[]{this.getTenant(), permGrant.getUserId(), permGrant.getObjName(), permGrant.getOpName(), permGrant.getObjId()});
                        this.adminMgr.grantPermission(perm, new User(permGrant.getUserId()));
                        continue;
                    }
                    String warning = "addPermGrants called without user or role set in xml";
                    LOG.warn(warning);
                }
                catch (SecurityException se) {
                    LOG.warn("addPermGrants tenant={} roleName={} objName={} opName={} objId={} caught SecurityException={}", new Object[]{this.getTenant(), permGrant.getRoleNm(), permGrant.getObjName(), permGrant.getOpName(), permGrant.getObjId(), se});
                }
            }
        }
    }

    private void deletePermGrants() throws BuildException {
        if (this.delpermGrants == null) {
            return;
        }
        for (DelpermGrant delpermGrant : this.delpermGrants) {
            List<PermGrant> permGrants = delpermGrant.getPermGrants();
            for (PermGrant permGrant : permGrants) {
                try {
                    Permission perm = new Permission(permGrant.getObjName(), permGrant.getOpName(), permGrant.isAdmin());
                    perm.setOpName(permGrant.getOpName());
                    perm.setObjId(permGrant.getObjId());
                    if (permGrant.getRoleNm() != null && permGrant.getRoleNm().length() > 0) {
                        LOG.info("deletePermGrants tenant={} roleName={} objName={} opName={} objId={}", new Object[]{this.getTenant(), permGrant.getRoleNm(), permGrant.getObjName(), permGrant.getOpName(), permGrant.getObjId()});
                        this.adminMgr.revokePermission(perm, new Role(permGrant.getRoleNm()));
                        continue;
                    }
                    if (permGrant.getUserId() != null && permGrant.getUserId().length() > 0) {
                        LOG.info("deletePermGrants tenant={} userId={} objName={} opName={} objId={}", new Object[]{this.getTenant(), permGrant.getUserId(), permGrant.getObjName(), permGrant.getOpName(), permGrant.getObjId()});
                        this.adminMgr.revokePermission(perm, new User(permGrant.getUserId()));
                        continue;
                    }
                    String warning = "deletePermGrants called without user or role set in xml";
                    LOG.warn(warning);
                }
                catch (SecurityException se) {
                    LOG.warn("deletePermGrants tenant={} roleName={} objName={} opName={} objId={} caught SecurityException={}", new Object[]{this.getTenant(), permGrant.getRoleNm(), permGrant.getObjName(), permGrant.getOpName(), permGrant.getObjId(), se});
                }
            }
        }
    }

    private void addPolicies() throws BuildException {
        if (this.addpolicies == null) {
            return;
        }
        for (Addpwpolicy addpwpolicy : this.addpolicies) {
            List<PwPolicy> policies = addpwpolicy.getPolicies();
            for (PwPolicy policy : policies) {
                LOG.info("addPolicies tenant={} name={}", (Object)this.getTenant(), (Object)policy.getName());
                try {
                    this.policyMgr.add(policy);
                }
                catch (SecurityException se) {
                    LOG.warn("addPolicies tenant={} name [{}] caught SecurityException={}", new Object[]{this.getTenant(), policy.getName(), se});
                }
            }
        }
    }

    private void deletePolicies() throws BuildException {
        if (this.delpolicies == null) {
            return;
        }
        for (Delpwpolicy delpwpolicy : this.delpolicies) {
            List<PwPolicy> policies = delpwpolicy.getPolicies();
            for (PwPolicy policy : policies) {
                LOG.info("deletePolicies tenant={} name={}", (Object)this.getTenant(), (Object)policy.getName());
                try {
                    this.policyMgr.delete(policy);
                }
                catch (SecurityException se) {
                    LOG.warn("deletePolicies tenant={} name [{}] caught SecurityException={}", new Object[]{this.getTenant(), policy.getName(), se});
                }
            }
        }
    }

    private void addContainers() throws BuildException {
        if (this.addcontainers == null) {
            return;
        }
        for (Addcontainer addcontainer : this.addcontainers) {
            List<OrganizationalUnit> containers = addcontainer.getContainers();
            for (OrganizationalUnit ou : containers) {
                LOG.info("addContainers tenant={} name={} description={}", new Object[]{this.getTenant(), ou.getName(), ou.getDescription()});
                try {
                    OrganizationalUnitP op = new OrganizationalUnitP();
                    if (!StringUtils.isEmpty((CharSequence)TENANT) && !TENANT.equals("${tenant}")) {
                        ou.setContextId(TENANT);
                    }
                    op.add(ou);
                }
                catch (SecurityException se) {
                    LOG.warn("addContainers tenant={} name [{}] caught SecurityException={}", new Object[]{this.getTenant(), ou.getName(), se.getMessage()});
                }
            }
        }
    }

    private void deleteContainers() throws BuildException {
        if (this.delcontainers == null) {
            return;
        }
        for (Delcontainer delcontainer : this.delcontainers) {
            List<OrganizationalUnit> containers = delcontainer.getContainers();
            for (OrganizationalUnit ou : containers) {
                LOG.info("deleteContainers tenant={} name={}", (Object)this.getTenant(), (Object)ou.getName());
                try {
                    OrganizationalUnitP op = new OrganizationalUnitP();
                    if (!StringUtils.isEmpty((CharSequence)TENANT) && !TENANT.equals("${tenant}")) {
                        ou.setContextId(TENANT);
                    }
                    op.delete(ou);
                }
                catch (SecurityException se) {
                    LOG.warn("deleteContainers tenant={} name [{}] caught SecurityException={}", new Object[]{this.getTenant(), ou.getName(), se});
                }
            }
        }
    }

    private void addSuffixes() throws BuildException {
        if (this.addsuffixes == null) {
            return;
        }
        for (Addsuffix addsuffix : this.addsuffixes) {
            List<Suffix> suffixes = addsuffix.getSuffixes();
            for (Suffix suffix : suffixes) {
                LOG.info("addSuffixes tenant={} name={} description={}", new Object[]{this.getTenant(), suffix.getName(), suffix.getDescription()});
                try {
                    SuffixP sp = new SuffixP();
                    sp.add(suffix);
                }
                catch (SecurityException se) {
                    LOG.warn("addSuffixes tenant={} name [{}] caught SecurityException={}", new Object[]{this.getTenant(), suffix.getName(), se});
                }
            }
        }
    }

    private void deleteSuffixes() throws BuildException {
        if (this.delsuffixes == null) {
            return;
        }
        for (Delsuffix delsuffix : this.delsuffixes) {
            List<Suffix> suffixes = delsuffix.getSuffixes();
            for (Suffix suffix : suffixes) {
                LOG.info("deleteSuffixes tenant={} name={}", (Object)this.getTenant(), (Object)suffix.getName());
                try {
                    SuffixP sp = new SuffixP();
                    sp.delete(suffix);
                }
                catch (SecurityException se) {
                    LOG.warn("deleteSuffixes tenant={} name={} caught SecurityException={}", new Object[]{this.getTenant(), suffix.getName(), se});
                }
            }
        }
    }

    private void addOrgunits() throws BuildException {
        if (this.addorgunits == null) {
            return;
        }
        for (Addorgunit addorgunit : this.addorgunits) {
            List<OrgUnitAnt> ous = addorgunit.getOrgUnits();
            for (OrgUnitAnt ou : ous) {
                LOG.info("addOrgunits tenant={} name={} typeName={} description={}", new Object[]{this.getTenant(), ou.getName(), ou.getTypeName(), ou.getDescription()});
                try {
                    this.dAdminMgr.add(ou);
                }
                catch (SecurityException se) {
                    LOG.warn("addOrgunits tenant={} name={} caught SecurityException={}", new Object[]{this.getTenant(), ou.getName(), se});
                }
            }
        }
    }

    private void delOrgunits() throws BuildException {
        if (this.delorgunits == null) {
            return;
        }
        for (Delorgunit delorgunit : this.delorgunits) {
            List<OrgUnitAnt> ous = delorgunit.getOrgUnits();
            for (OrgUnitAnt ou : ous) {
                LOG.info("deleteOrgunits tenant={} name={} typeName={}", new Object[]{this.getTenant(), ou.getName(), ou.getTypeName()});
                try {
                    this.dAdminMgr.delete(ou);
                }
                catch (SecurityException se) {
                    LOG.warn("deleteOrgunits tenant={} name={} caught SecurityException={}", new Object[]{this.getTenant(), ou.getName(), se});
                }
            }
        }
    }

    private void addUserOrgunitInheritances() throws BuildException {
        if (this.adduserorgunitinheritances == null) {
            return;
        }
        for (Adduserorgunitinheritance adduserorgunitinheritance : this.adduserorgunitinheritances) {
            List<Relationship> orgs = adduserorgunitinheritance.getRelationships();
            for (Relationship relationship : orgs) {
                LOG.info("addUserOrgunitInheritances tenant={} parent={} child={}", new Object[]{this.getTenant(), relationship.getParent(), relationship.getChild()});
                try {
                    this.dAdminMgr.addInheritance(new OrgUnit(relationship.getParent(), OrgUnit.Type.USER), new OrgUnit(relationship.getChild(), OrgUnit.Type.USER));
                }
                catch (SecurityException se) {
                    LOG.warn("addUserOrgunitInheritances tenant={} parent={} child={} caught SecurityException={}", new Object[]{this.getTenant(), relationship.getParent(), relationship.getChild(), se});
                }
            }
        }
    }

    private void deleteUserOrgunitInheritances() throws BuildException {
        if (this.deluserorgunitinheritances == null) {
            return;
        }
        for (Deluserorgunitinheritance deluserorgunitinheritance : this.deluserorgunitinheritances) {
            List<Relationship> orgs = deluserorgunitinheritance.getRelationships();
            for (Relationship relationship : orgs) {
                LOG.info("deleteUserOrgunitInheritances tenant={} parent={} child={}" + this.getTenant(), (Object)relationship.getParent(), (Object)relationship.getChild());
                try {
                    this.dAdminMgr.deleteInheritance(new OrgUnit(relationship.getParent(), OrgUnit.Type.USER), new OrgUnit(relationship.getChild(), OrgUnit.Type.USER));
                }
                catch (SecurityException se) {
                    LOG.warn("deleteUserOrgunitInheritances tenant={} parent={} child={} caught SecurityException={}", new Object[]{this.getTenant(), relationship.getParent(), relationship.getChild(), se});
                }
            }
        }
    }

    private void addPermOrgunitInheritances() throws BuildException {
        if (this.addpermorgunitinheritances == null) {
            return;
        }
        for (Addpermorgunitinheritance addpermorgunitinheritance : this.addpermorgunitinheritances) {
            List<Relationship> orgs = addpermorgunitinheritance.getRelationships();
            for (Relationship relationship : orgs) {
                LOG.info("addPermOrgunitInheritances tenant={} parent={} child={}", new Object[]{this.getTenant(), relationship.getParent(), relationship.getChild()});
                try {
                    this.dAdminMgr.addInheritance(new OrgUnit(relationship.getParent(), OrgUnit.Type.PERM), new OrgUnit(relationship.getChild(), OrgUnit.Type.PERM));
                }
                catch (SecurityException se) {
                    LOG.warn("addPermOrgunitInheritances tenant={} parent={} child={} caught SecurityException={}", new Object[]{this.getTenant(), relationship.getParent(), relationship.getChild(), se});
                }
            }
        }
    }

    private void deletePermOrgunitInheritances() throws BuildException {
        if (this.delpermorgunitinheritances == null) {
            return;
        }
        for (Delpermorgunitinheritance delpermorgunitinheritance : this.delpermorgunitinheritances) {
            List<Relationship> orgs = delpermorgunitinheritance.getRelationships();
            for (Relationship relationship : orgs) {
                LOG.info("deletePermOrgunitInheritances tenant={} parent={} child={}", new Object[]{this.getTenant(), relationship.getParent(), relationship.getChild()});
                try {
                    this.dAdminMgr.deleteInheritance(new OrgUnit(relationship.getParent(), OrgUnit.Type.PERM), new OrgUnit(relationship.getChild(), OrgUnit.Type.PERM));
                }
                catch (SecurityException se) {
                    LOG.warn("deletePermOrgunitInheritances tenant={} parent={} child={} caught SecurityException={}", new Object[]{this.getTenant(), relationship.getParent(), relationship.getChild(), se});
                }
            }
        }
    }

    private void addAdminRoles() throws BuildException {
        if (this.addadminroles == null) {
            return;
        }
        for (Addadminrole addrole : this.addadminroles) {
            List<AdminRoleAnt> roles = addrole.getRoles();
            for (AdminRoleAnt role : roles) {
                LOG.info("addAdminRoles tenant={} name={} description={}", new Object[]{this.getTenant(), role.getName(), role.getDescription()});
                try {
                    this.dAdminMgr.addRole(role);
                }
                catch (SecurityException se) {
                    LOG.warn("addAdminRoles tenant={} name={} caught SecurityException={}", new Object[]{this.getTenant(), role.getName(), se});
                }
            }
        }
    }

    private void deleteAdminRoles() throws BuildException {
        if (this.deladminroles == null) {
            return;
        }
        for (Deladminrole delrole : this.deladminroles) {
            List<AdminRoleAnt> roles = delrole.getRoles();
            for (AdminRoleAnt role : roles) {
                LOG.info("deleteAdminRoles tenant={} name={}", (Object)this.getTenant(), (Object)role.getName());
                try {
                    this.dAdminMgr.deleteRole(role);
                }
                catch (SecurityException se) {
                    LOG.warn("deleteAdminRoles tenant={} name={} caught SecurityException={}", new Object[]{this.getTenant(), role.getName(), se});
                }
            }
        }
    }

    private void addAdminRoleInheritances() throws BuildException {
        if (this.addadminroleinheritances == null) {
            return;
        }
        for (Addadminroleinheritance addadminroleinheritance : this.addadminroleinheritances) {
            List<Relationship> roles = addadminroleinheritance.getRelationships();
            for (Relationship relationship : roles) {
                LOG.info("addAdminRoleInheritances tenant={} parent={} child={}", new Object[]{this.getTenant(), relationship.getParent(), relationship.getChild()});
                try {
                    this.dAdminMgr.addInheritance(new AdminRole(relationship.getParent()), new AdminRole(relationship.getChild()));
                }
                catch (SecurityException se) {
                    LOG.warn("addAdminRoleInheritances tenant={} parent={} child={} caught SecurityException={}", new Object[]{this.getTenant(), relationship.getParent(), relationship.getChild(), se});
                }
            }
        }
    }

    private void deleteAdminRoleInheritances() throws BuildException {
        if (this.deladminroleinheritances == null) {
            return;
        }
        for (Deladminroleinheritance deladminroleinheritance : this.deladminroleinheritances) {
            List<Relationship> roles = deladminroleinheritance.getRelationships();
            for (Relationship relationship : roles) {
                LOG.info("deleteAdminRoleInheritances tenant={} parent={} child={}", new Object[]{this.getTenant(), relationship.getParent(), relationship.getChild()});
                try {
                    this.dAdminMgr.deleteInheritance(new AdminRole(relationship.getParent()), new AdminRole(relationship.getChild()));
                }
                catch (SecurityException se) {
                    LOG.warn("deleteAdminRoleInheritances tenant={} parent={} child={} caught SecurityException={}", new Object[]{this.getTenant(), relationship.getParent(), relationship.getChild(), se});
                }
            }
        }
    }

    private void addUserAdminRoles() throws BuildException {
        if (this.adduseradminroles == null) {
            return;
        }
        for (Adduseradminrole adduserrole : this.adduseradminroles) {
            List<UserAdminRole> userroles = adduserrole.getUserRoles();
            for (UserAdminRole userRole : userroles) {
                LOG.info("addUserAdminRoles tenant={} userid={} role name={}", new Object[]{this.getTenant(), userRole.getUserId(), userRole.getName()});
                try {
                    this.dAdminMgr.assignUser(userRole);
                }
                catch (SecurityException se) {
                    LOG.warn("addUserAdminRoles tenant={} userId={} role name={} caught SecurityException={}", new Object[]{this.getTenant(), userRole.getUserId(), userRole.getName(), se});
                }
            }
        }
    }

    private void delUserAdminRoles() throws BuildException {
        if (this.deluseradminroles == null) {
            return;
        }
        for (Deluseradminrole deluserrole : this.deluseradminroles) {
            List<UserAdminRole> userroles = deluserrole.getUserRoles();
            for (UserAdminRole userRole : userroles) {
                LOG.info("delUserAdminRoles tenant={} userid={} role name={}", new Object[]{this.getTenant(), userRole.getUserId(), userRole.getName()});
                try {
                    this.dAdminMgr.deassignUser(userRole);
                }
                catch (SecurityException se) {
                    LOG.warn("delUserAdminRoles tenant={} userId={} role name={} caught SecurityException={}", new Object[]{this.getTenant(), userRole.getUserId(), userRole.getName(), se});
                }
            }
        }
    }

    private void addConfig() throws BuildException {
        LOG.info("addConfig");
        if (this.addconfig == null) {
            return;
        }
        for (Addconfig addcfg : this.addconfig) {
            Properties props = new Properties();
            Configuration configuration = new Configuration();
            try {
                List<ConfigAnt> cfgs = addcfg.getConfig();
                for (ConfigAnt cfg : cfgs) {
                    String val = cfg.getProps();
                    int indx = val.indexOf(58);
                    if (indx < 1) continue;
                    String name = val.substring(0, indx);
                    String value = val.substring(indx + 1);
                    if (name.equalsIgnoreCase("config.realm")) {
                        configuration.setName(value);
                        continue;
                    }
                    if (name.equalsIgnoreCase("config.uid.number")) {
                        configuration.setUidNumber(value);
                        continue;
                    }
                    if (name.equalsIgnoreCase("config.gid.number")) {
                        configuration.setGidNumber(value);
                        continue;
                    }
                    props.setProperty(name, value);
                    LOG.info("addConfig name [{}] value [{}]", (Object)name, (Object)value);
                }
                configuration.addProperties(props);
                LOG.info("addConfig realm name [{}]", (Object)configuration.getName());
                LOG.info("addConfig gid.number [{}]", (Object)configuration.getGidNumber());
                LOG.info("addConfig uid.number [{}]", (Object)configuration.getUidNumber());
                this.cfgMgr.add(configuration);
            }
            catch (SecurityException se) {
                if (se.getErrorId() == 125) {
                    try {
                        LOG.info("addConfig realm name={} entry already exists, attempt to update", (Object)configuration.getName());
                        this.cfgMgr.update(configuration);
                        LOG.info("addConfig realm name={} update [{}] successful", (Object)configuration.getName(), (Object)configuration.getName());
                    }
                    catch (SecurityException se2) {
                        LOG.warn("addConfig realm name={] update failed SecurityException={}", (Object)configuration.getName(), (Object)se2);
                    }
                    continue;
                }
                LOG.warn("addConfig realm name={} failed SecurityException={}", (Object)configuration.getName(), (Object)se);
            }
        }
    }

    private void updConfig() throws BuildException {
        LOG.info("updateConfig");
        if (this.updconfig == null) {
            return;
        }
        for (Updconfig updcfg : this.updconfig) {
            Properties props = new Properties();
            Configuration configuration = new Configuration();
            String configNodeName = "";
            List<ConfigAnt> cfgs = updcfg.getConfig();
            for (ConfigAnt cfg : cfgs) {
                LOG.info("updateConfig");
                String val = cfg.getProps();
                int indx = val.indexOf(58);
                if (indx < 1) continue;
                String name = val.substring(0, indx);
                String value = val.substring(indx + 1);
                if (name.equalsIgnoreCase("config.realm")) {
                    configuration.setName(value);
                    continue;
                }
                if (name.equalsIgnoreCase("config.uid.number")) {
                    configuration.setUidNumber(value);
                    continue;
                }
                if (name.equalsIgnoreCase("config.gid.number")) {
                    configuration.setGidNumber(value);
                    continue;
                }
                props.setProperty(name, value);
                LOG.info("updateConfig name [{}] value [{}]", (Object)name, (Object)value);
            }
            if (StringUtils.isEmpty((CharSequence)configuration.getName())) {
                LOG.warn("updConfig realm name not specified, operation aborted.");
                LOG.warn("Add entry like this  to input xml: <config props=\"config.realm:DEFAULT\"/>");
                continue;
            }
            configuration.addProperties(props);
            LOG.info("updConfig realm name [{}]", (Object)configuration.getName());
            LOG.info("updConfig gid.number [{}]", (Object)configuration.getGidNumber());
            LOG.info("updConfig uid.number [{}]", (Object)configuration.getUidNumber());
            try {
                this.cfgMgr.update(configuration);
            }
            catch (SecurityException se) {
                LOG.warn("updConfig realm name={} failed SecurityException={}", (Object)configNodeName, (Object)se);
                LOG.warn("Verify that config realm name={} exists", (Object)configNodeName);
            }
        }
    }

    private void deleteConfig() throws BuildException {
        if (this.delconfig == null) {
            return;
        }
        Properties props = new Properties();
        String configNodeName = "";
        for (Delconfig delcfg : this.delconfig) {
            try {
                List<ConfigAnt> cfgs = delcfg.getConfig();
                for (ConfigAnt cfg : cfgs) {
                    String val = cfg.getProps();
                    int indx = val.indexOf(58);
                    if (indx < 1) continue;
                    String name = val.substring(0, indx);
                    String value = val.substring(indx + 1);
                    props.setProperty(name, value);
                }
                configNodeName = props.getProperty("config.realm");
                LOG.info("delConfig realm name [{}]", (Object)configNodeName);
                props.remove("config.realm");
                this.cfgMgr.delete(configNodeName, props);
            }
            catch (SecurityException se) {
                String warning = "deleteConfig [" + configNodeName + "] caught SecurityException=" + se;
                LOG.warn(warning);
            }
        }
    }

    public static Properties getProperties(String inputString) {
        StringTokenizer maxTkn;
        Properties props = new Properties();
        if (inputString != null && inputString.length() > 0 && (maxTkn = new StringTokenizer(inputString, SEMICOLON)).countTokens() > 0) {
            while (maxTkn.hasMoreTokens()) {
                String val = maxTkn.nextToken();
                int indx = val.indexOf(58);
                if (indx < 1) continue;
                String name = val.substring(0, indx);
                String value = val.substring(indx + 1);
                props.setProperty(name, value);
            }
        }
        return props;
    }

    public List<AddpermOp> getAddpermOps() {
        return this.addpermOps;
    }

    public List<AddpermObj> getAddpermObjs() {
        return this.addpermObjs;
    }

    public List<Adduser> getAddusers() {
        return this.addusers;
    }

    public List<Adduserrole> getAdduserroles() {
        return this.adduserroles;
    }

    public List<Addrole> getAddroles() {
        return this.addroles;
    }

    public List<Addsdset> getAddsdsets() {
        return this.addsdsets;
    }

    public List<Addroleinheritance> getAddroleinheritances() {
        return this.addroleinheritances;
    }

    public List<AddpermGrant> getAddpermGrants() {
        return this.addpermGrants;
    }

    public List<Addgroup> getAddgroups() {
        return this.addgroups;
    }
}

