/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hllmap;

import java.nio.charset.StandardCharsets;
import org.apache.datasketches.hllmap.Map;
import org.apache.datasketches.hllmap.SingleCouponMap;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SingleCouponMapTest {
    @Test
    public void getEstimateNoEntry() {
        SingleCouponMap map = SingleCouponMap.getInstance((int)1000, (int)4);
        byte[] key = new byte[]{0, 0, 0, 1};
        Assert.assertEquals((double)map.getEstimate(key), (double)0.0);
        Assert.assertEquals((double)map.getUpperBound(key), (double)0.0);
        Assert.assertEquals((double)map.getLowerBound(key), (double)0.0);
    }

    @Test
    public void oneKeyOneEntry() {
        int entries = 16;
        int keySizeBytes = 4;
        SingleCouponMap map = SingleCouponMap.getInstance((int)entries, (int)keySizeBytes);
        byte[] key = new byte[]{0, 0, 0, 0};
        byte[] id = new byte[]{1, 0, 0, 0};
        short coupon = (short)Map.coupon16((byte[])id);
        double estimate = map.update(key, coupon);
        Assert.assertEquals((double)estimate, (double)1.0);
        Assert.assertEquals((double)map.getEstimate(key), (double)1.0);
        Assert.assertTrue((map.getUpperBound(key) >= 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((map.getLowerBound(key) <= 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void resize() {
        byte[] key;
        int i;
        int entries = 17;
        int numKeys = 1000;
        int keySizeBytes = 4;
        SingleCouponMap map = SingleCouponMap.getInstance((int)entries, (int)keySizeBytes);
        for (i = 0; i < numKeys; ++i) {
            key = String.format("%4s", i).getBytes(StandardCharsets.UTF_8);
            byte[] id = new byte[]{1, 0, 0, 0};
            short coupon = (short)Map.coupon16((byte[])id);
            double estimate = map.update(key, coupon);
            Assert.assertEquals((double)estimate, (double)1.0);
            Assert.assertEquals((double)map.getEstimate(key), (double)1.0);
            Assert.assertTrue((map.getUpperBound(key) >= 1.0 ? 1 : 0) != 0);
            Assert.assertTrue((map.getLowerBound(key) <= 1.0 ? 1 : 0) != 0);
        }
        for (i = 0; i < numKeys; ++i) {
            key = String.format("%4s", i).getBytes(StandardCharsets.UTF_8);
            Assert.assertEquals((double)map.getEstimate(key), (double)1.0);
            Assert.assertTrue((map.getUpperBound(key) >= 1.0 ? 1 : 0) != 0);
            Assert.assertTrue((map.getLowerBound(key) <= 1.0 ? 1 : 0) != 0);
        }
        SingleCouponMapTest.println(map.toString());
        Assert.assertEquals((int)map.getCurrentCountEntries(), (int)numKeys);
    }

    @Test
    public void manyKeys() {
        double estimate;
        byte[] key;
        int i;
        SingleCouponMap map = SingleCouponMap.getInstance((int)2000, (int)4);
        for (i = 1; i <= 1000; ++i) {
            key = String.format("%4s", i).getBytes(StandardCharsets.UTF_8);
            estimate = map.update(key, (short)1);
            Assert.assertEquals((double)estimate, (double)1.0);
            Assert.assertEquals((double)map.getEstimate(key), (double)1.0);
            Assert.assertTrue((map.getUpperBound(key) >= 1.0 ? 1 : 0) != 0);
            Assert.assertTrue((map.getLowerBound(key) <= 1.0 ? 1 : 0) != 0);
        }
        for (i = 1; i <= 1000; ++i) {
            key = String.format("%4s", i).getBytes(StandardCharsets.UTF_8);
            estimate = map.update(key, (short)2);
            Assert.assertEquals((double)estimate, (double)0.0);
        }
        Assert.assertEquals((int)map.getCurrentCountEntries(), (int)1000);
    }

    @Test
    public void printlnTest() {
        SingleCouponMapTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

