/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.cli;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.WritableByteChannel;
import org.apache.daffodil.api.DaffodilParseXMLReader;
import org.apache.daffodil.api.DaffodilUnparseContentHandler;
import org.apache.daffodil.api.DataProcessor;
import org.apache.daffodil.api.ParseResult;
import org.apache.daffodil.api.UnparseResult;
import org.apache.daffodil.api.infoset.InfosetInputter;
import org.apache.daffodil.api.infoset.InfosetOutputter;
import org.apache.daffodil.cli.InfosetParseResult;
import org.apache.daffodil.cli.Main$;
import org.apache.daffodil.io.InputSourceDataInputStream;
import org.apache.daffodil.lib.xml.XMLUtils$;
import org.apache.daffodil.runtime1.iapi.DFDL;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public interface InfosetHandler {
    public InfosetParseResult parse(InputSourceDataInputStream var1, OutputStream var2);

    public Object dataToInfoset(byte[] var1);

    public Object dataToInfoset(InputStream var1);

    public UnparseResult unparse(Object var1, WritableByteChannel var2);

    public DataProcessor dataProcessor();

    public static ParseResult parseWithInfosetOutputter$(InfosetHandler $this, InputSourceDataInputStream input, InfosetOutputter output) {
        return $this.parseWithInfosetOutputter(input, output);
    }

    default public ParseResult parseWithInfosetOutputter(InputSourceDataInputStream input, InfosetOutputter output) {
        output.setBlobAttributes(Main$.MODULE$.blobDir(), null, Main$.MODULE$.blobSuffix());
        ParseResult pr = this.dataProcessor().parse((org.apache.daffodil.api.InputSourceDataInputStream)input, output);
        return pr;
    }

    public static UnparseResult unparseWithInfosetInputter$(InfosetHandler $this, InfosetInputter input, WritableByteChannel output) {
        return $this.unparseWithInfosetInputter(input, output);
    }

    default public UnparseResult unparseWithInfosetInputter(InfosetInputter input, WritableByteChannel output) {
        UnparseResult ur = this.dataProcessor().unparse(input, output);
        return ur;
    }

    public static ParseResult parseWithSax$(InfosetHandler $this, InputSourceDataInputStream input, ContentHandler contentHandler) {
        return $this.parseWithSax(input, contentHandler);
    }

    default public ParseResult parseWithSax(InputSourceDataInputStream input, ContentHandler contentHandler) {
        DaffodilParseXMLReader xmlReader = this.dataProcessor().newXMLReaderInstance();
        xmlReader.setFeature(XMLUtils$.MODULE$.SAX_NAMESPACE_PREFIXES_FEATURE(), true);
        xmlReader.setProperty(XMLUtils$.MODULE$.DAFFODIL_SAX_URN_BLOBDIRECTORY(), (Object)Main$.MODULE$.blobDir());
        xmlReader.setProperty(XMLUtils$.MODULE$.DAFFODIL_SAX_URN_BLOBSUFFIX(), (Object)Main$.MODULE$.blobSuffix());
        xmlReader.setContentHandler(contentHandler);
        xmlReader.parse((org.apache.daffodil.api.InputSourceDataInputStream)input);
        ParseResult pr = (ParseResult)xmlReader.getProperty(XMLUtils$.MODULE$.DAFFODIL_SAX_URN_PARSERESULT());
        return pr;
    }

    public static UnparseResult unparseWithSax$(InfosetHandler $this, XMLReader xmlReader, InputStream input, WritableByteChannel output) {
        return $this.unparseWithSax(xmlReader, input, output);
    }

    default public UnparseResult unparseWithSax(XMLReader xmlReader, InputStream input, WritableByteChannel output) {
        DaffodilUnparseContentHandler contentHandler = this.dataProcessor().newContentHandlerInstance(output);
        xmlReader.setContentHandler((ContentHandler)contentHandler);
        xmlReader.setFeature(XMLUtils$.MODULE$.SAX_NAMESPACES_FEATURE(), true);
        xmlReader.setFeature(XMLUtils$.MODULE$.SAX_NAMESPACE_PREFIXES_FEATURE(), true);
        try {
            xmlReader.parse(new InputSource(input));
        }
        catch (DFDL.DaffodilUnparseErrorSAXException daffodilUnparseErrorSAXException) {}
        UnparseResult ur = contentHandler.getUnparseResult();
        return ur;
    }
}

